

function shootArrow(player, variance, arrow_type) {
    let arrow = player.level.createEntity(arrow_type);
    arrow.tags.add(`Owner:${player.username}`);
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let dirV = {
        x: -Math.sin(y_rad+variance) * Math.cos(x_rad+variance),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad+variance) * Math.cos(x_rad+variance)
    }
    arrow.addMotion(dirV.x * 3, dirV.y * 3, dirV.z * 3)
    let crossbowOffset = 0.5; // This value may need to be adjusted
    let heightOffset = -0.2; // Adjusted value for slight lowering
    let crossbowPos = {
        x: player.x - Math.sin(y_rad) * crossbowOffset,
        y: player.y + player.getEyeHeight() + heightOffset,
        z: player.z + Math.cos(y_rad) * crossbowOffset
    };
    arrow.setPosition(crossbowPos.x, crossbowPos.y, crossbowPos.z);
    arrow.spawn()
    arrow.playSound('minecraft:item.crossbow.shoot', 1, 1)
    Utils.server.scheduleInTicks(100, () => {
        arrow.kill()
    })
}





function burstArrows(player, num_arrows, variance, arrow_type) {
    for (let i = 0; i < num_arrows; i++) {
        Utils.server.scheduleInTicks(3*i, () => {
            shootArrow(player, variance, arrow_type)
        })
    }
}




