


/**
 * Distant Gift: Drops a random item when hitting an entity with a crossbow arrow. 3% chance
 * §aLevel 1: 3% chance to drop and 1 item
 * §aLevel 2: 6% chance to drop and 2 items
 * §aLevel 3: 9% chance to drop and 3 items
 * §aLevel 4: 12% chance to drop and 4 items
 * §aLevel 5: 15% chance to drop and 5 items
 * 
 * 
 * 
 */
let distant_gift = {
    'irons_spellbooks:acid_orb': {
        nbt: {
            RendLevel:2,
            RendDuration:200,
        }
    },
    'irons_spellbooks:comet': {
        nbt: {
            Damage: 20,
            ExplosionRadius:5
        }
    },
    'irons_spellbooks:fireball': {
        nbt: {
            Damage:5,
            ExplosionRadius:15
        }
    }
}


function singleDrop (target, item, nbt, player, count) {
    // loop through the count
    for (let i = 0; i < count; i++) {
            Utils.server.scheduleInTicks(5*i, () => {

            if (!target.alive) return
            let entity = target.level.createEntity(item)
            let randomX = Math.floor(Math.random() * 2) - 1
            let randomZ = Math.floor(Math.random() * 2) - 1

            entity.x = target.x+randomX
            entity.y = target.y+10
            entity.z = target.z+randomZ
            entity.mergeNbt(nbt)
            entity.mergeNbt({
                Owner: player.username,
                LeftOwner:true,
                Motion: [0, -1.0, 0]
            })
            entity.spawn()
        })
    }
}

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (event.source.immediate == null) return
    let check = arrowCheck(event.source)
    if (!check) return
    if (!player.persistentData.get('distant_gift')) return
    let level = player.persistentData.distant_gift
    let target = event.entity
    let randomNumber = Math.random()
    if (randomNumber > 0.03*level) return
    let keys = Object.keys(distant_gift)
    let randomItem = keys[Math.floor(Math.random() * keys.length)]
    //Utils.server.tell(randomItem)   
    let nbt = distant_gift[randomItem].nbt
    let count = level
    singleDrop(target, randomItem, nbt, player, count)
})
