/**
 * Crossbow Mastery Abilities
 *  1.) Shoot 3 arrows.
 *  Two Paths: Elemental and Physical. Elemental makes it so you can shoot a number of arrow bursts. Elemental lets you shoot one burst but with special arrow types. The cooldown for elemental is longer than physical
 *  1.) Shoot multiple arrows: Turn this into a function that can be called. Make the inputs the number of arrows and the number of bursts.
 *   - §aLevel 1: Shoot 2 arrows. One by one but in a fast burst
 *   - §aLevel 2: Shoot 3 arrows. One by one but in a fast burst
 *   - §aLevel 3: Shoot 4 arrows. Two at a time but in two fast bursts
 *   - §aLevel 4: Shoot 5 arrows. 2, 2, 1 but in three fast bursts
 *   - §aLevel 5: Shoot 6 arrows. 2, 2, 2 but in three fast bursts
 *   - §aLevel 6: Shoot 7 arrows. 3, 2, 2 but in three fast bursts
 *   - §aLevel 7: Shoot 8 arrows. 3, 3, 2 but in three fast bursts
 *   - §aLevel 8: Shoot 9 arrows. 3, 3, 3 but in three fast bursts
 *  2.) Let the player choose what arrow type they want. Explosive, Frost, Lightning, Vexing, and Slime
 *   - Each Arrow is used for different things and has different cooldowns. 
 *  
 * 
 * 
 * 
 */
function shootArrow(player, variance, arrow_type) {
    let arrow = player.level.createEntity(arrow_type);
    arrow.tags.add(`Owner:${player.username}`);
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let dirV = {
        x: -Math.sin(y_rad+variance) * Math.cos(x_rad+variance),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad+variance) * Math.cos(x_rad+variance)
    }
    arrow.addMotion(dirV.x * 3, dirV.y * 3, dirV.z * 3)
    let crossbowOffset = 0.5; // This value may need to be adjusted
    let heightOffset = -0.2; // Adjusted value for slight lowering
    let crossbowPos = {
        x: player.x - Math.sin(y_rad) * crossbowOffset,
        y: player.y + player.getEyeHeight() + heightOffset,
        z: player.z + Math.cos(y_rad) * crossbowOffset
    };
    arrow.setPosition(crossbowPos.x, crossbowPos.y, crossbowPos.z);
    arrow.spawn()
    arrow.playSound('minecraft:item.crossbow.shoot', 1, 1)
    Utils.server.scheduleInTicks(100, () => {
        arrow.kill()
    })
}


function burstArrows(player, num_arrows, variance, arrow_type) {
    for (let i = 0; i < num_arrows; i++) {
        Utils.server.scheduleInTicks(3*i, () => {
            shootArrow(player, variance, arrow_type)
        })
    }
}


ItemEvents.firstLeftClicked(event => {
    if (!event.item.id.includes('crossbow')) return
    if (!event.player.persistentData.get('marksman_mastery')) return
    if (event.player.cooldowns.isOnCooldown(event.item)) return
    if (event.item.nbt.get('Charged').toString() != '1b') return
    let player = event.player
   if (marksman == 1) {
        burstArrows(player, 2, 0, 'minecraft:arrow')
    } else if (marksman == 2) {
        burstArrows(player, 3, 0, 'minecraft:arrow')
    } else if (marksman == 3) {
        burstArrows(player, 2, 3, 'minecraft:arrow')
        burstArrows(player, 2, -3, 'minecraft:arrow')
    } else if (marksman == 4) {
        burstArrows(player, 2, 3, 'minecraft:arrow')
        burstArrows(player, 2, -3, 'minecraft:arrow')
        shootArrow(player, 0, 'minecraft:arrow')
    } else if (marksman == 5) {
        burstArrows(player, 2, 3, 'minecraft:arrow')
        burstArrows(player, 2, -3, 'minecraft:arrow')
        burstArrows(player, 2, 0, 'minecraft:arrow')
    } else if (marksman == 6) {
        burstArrows(player, 3, 3, 'minecraft:arrow')
        burstArrows(player, 2, -3, 'minecraft:arrow')
        burstArrows(player, 2, 0, 'minecraft:arrow')
    } else if (marksman == 7) {
        burstArrows(player, 3, 3, 'minecraft:arrow')
        burstArrows(player, 3, -3, 'minecraft:arrow')
        burstArrows(player, 2, 0, 'minecraft:arrow')
    } else if (marksman == 8) {
        burstArrows(player, 3, 3, 'minecraft:arrow')
        burstArrows(player, 3, -3, 'minecraft:arrow')
        burstArrows(player, 3, 0, 'minecraft:arrow')
    } else if (marksman == 9) {
        burstArrows(player, 3, 3, 'minecraft:arrow')
        burstArrows(player, 3, -3, 'minecraft:arrow')
        burstArrows(player, 3, 0, 'minecraft:arrow')
        //10% chance to shoot explosive arrow
        let chance = Math.random() * 100
        if (chance > 10) return
        shootArrow(player, 0, 'xtraarrows:flint_explosive_arrow')
    } else if (marksman == 10) {
        // 10% chance for a burst of explosive arrows
        let chance = Math.random() * 100
        if (chance > 10) {
            burstArrows(player, 3, 3, 'minecraft:arrow')
            burstArrows(player, 3, -3, 'minecraft:arrow')
            burstArrows(player, 3, 0, 'minecraft:arrow')
        } else {
            burstArrows(player, 2, 3, 'minecraft:arrow')
            burstArrows(player, 2, -3, 'minecraft:arrow')
            burstArrows(player, 2, 0, 'minecraft:arrow')
            shootArrow(player, 0, 'xtraarrows:flint_explosive_arrow')
            shootArrow(player, -3, 'xtraarrows:flint_explosive_arrow')
            shootArrow(player, 3, 'xtraarrows:flint_explosive_arrow')
        }

    }     

   
})



