EntityEvents.spawned('miapi:thrown_item', event => {
    //tell(event.entity.nbt)
    let nbt = event.entity.nbt['Owner'].toString()
    let username = getUsernameFromAltUUID(nbt, event.entity.server)
    let player = event.entity.server.getPlayer(username)
    let curio = skillTotemCheck(player, 'bottomless_quiver')
    let valid = true
    if (event.entity.nbt.toString().includes('miapi:modular_arrow')) {
        if (!curio) {
            valid = false
        }
    }
    if (!valid) return        
    event.entity.glowing = true

    Utils.server.scheduleInTicks(60, e => {
        if (event.entity.alive) {
            e.repeating = true
            if (event.entity.distanceToEntity(player) > 5) {
                Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run execute at ${event.entity.uuid} run particle alexscaves:amber_monolith ~ ~ ~ 0.01 0.01 0.01 50000000 10`)
                event.entity.setMotion(0, 0, 0)
                event.entity.teleportTo(player.x, player.y, player.z)
                //Utils.server.runCommandSilent(`/execute in ${event.entity.level.dimension} run tp ${event.entity.uuid} ${player.x} ${player.y} ${player.z}`)
                Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} minecraft:glowing infinite 0 false`)
                event.entity.setMotion(0, 0, 0)
            }
        } else {
            e.repeating = false
        }
    })
})


EntityEvents.hurt(event => {
    if (!event.source.player) return;
    if (event.source.immediate == null) return;
    if (event.source.immediate.type != 'miapi:thrown_item') return;
    let nbt = event.source.immediate.nbt['Owner'].toString()
    let username = getUsernameFromAltUUID(nbt, event.source.immediate.server)
    let player = event.source.immediate.server.getPlayer(username);
    if (!player) return;
    event.source.immediate.setMotion(0, 0, 0)
    Utils.server.scheduleInTicks(1, () => {
        if (!event.source.immediate.isAlive()) return
        event.source.immediate.teleportTo(player.x, player.y, player.z)
        //Utils.server.runCommand(`/execute in ${player.level.dimension} run tp ${event.source.immediate.uuid} ${player.x} ${player.y} ${player.z}`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle alexscaves:amber_monolith ${event.source.immediate.x} ${event.source.immediate.y} ${event.source.immediate.z} 0.01 0.01 0.01 50000000 10`)
        event.source.immediate.glowing = true
    })
})



