ServerEvents.tags('item', event => {
    event.remove('twilightforest:portal/activator', 'minecraft:diamond')
    event.add('twilightforest:portal/activator', 'kubejs:demonic_runestone')
    event.add('forge:via_romana_path_block', '#kubejs:paths')

})

let skill_gems = global.skill_gems
// Add all items and tags to an object
skill_gems.forEach(skill_gem => {
    ServerEvents.tags('item', event => {
        event.add('kubejs:skill_gems', 'kubejs:'+skill_gem)
    })
})


let tags = {
    'curios:hands': [
        'confluence:feral_claws', 'confluence:climbing_claws', 'confluence:flesh_knuckles', 'confluence:titan_glove', 'confluence:power_glove', 'confluence:mechanical_glove', 'confluence:fire_gauntlet', 'confluence:berserkers_glove', 
        'confluence:hand_drill', 'confluence:hand_of_creation','confluence:extendo_grip', 'confluence:hand_warmer'
    ],
    'curios:necklace': ['confluence:sun_stone', 'confluence:moon_stone', 'confluence:cross_necklace', 'confluence:shark_tooth_necklace', 'confluence:stinger_necklace', 'confluence:panic_necklace', 'confluence:sweetheart_necklace', 'confluence:shackle', 'confluence:lava_charm', 'confluence:anklet_of_the_wind', 'confluence:molten_charm', 'confluence:cloud_in_a_bottle', 'confluence:blizzard_in_a_bottle', 'confluence:sandstorm_in_a_bottle', 'confluence:fart_in_a_jar', 'confluence:star_veil', 'traveloptics:aqua_echo', 'traveloptics:blood_echo', 'traveloptics:eldritch_echo', 'traveloptics:ender_echo', 'traveloptics:evocation_echo', 'traveloptics:fire_echo', 'traveloptics:holy_echo', 'traveloptics:ice_echo', 'traveloptics:lightning_echo', 'traveloptics:nature_echo'],

    'curios:belt': ['confluence:magic_quiver', 'confluence:molten_quiver', 'confluence:stalkers_quiver', 'confluence:band_of_regeneration', 'confluence:band_of_regeneration'],
    
    'curios:feet': ['confluence:climbing_claws', 'confluence:shoe_spikes', 'confluence:tabi', 'confluence:ice_skates', 'confluence:hermes_boots', 'confluence:flurry_boots', 'confluence:sailfish_boots', 'confluence:dunerider_boots', 'confluence:rocket_boots', 'confluence:spectre_boots', 'confluence:fairy_boots', 'confluence:lightning_boots', 'confluence:frostspark_boots', 'confluence:water_walking_boots', 'confluence:obsidian_water_walking_boots', 'confluence:lava_waders', 'confluence:terraspark_boots', 'confluence:frog_flipper', 'confluence:ambhipian_boots', 'confluence:flower_boots'],

    'kubejs:ender_blood_bucket_recipe': ['kubejs:blood_bucket', 'kubejs:mutant_enderman_heart', 'summoningrituals:altar'],
    
    'kubejs:affinity_gems': [
        'kubejs:blood_affinity_gem',
        'kubejs:superior_blood_affinity_gem',
        'kubejs:exalted_blood_affinity_gem',

        'kubejs:ender_affinity_gem',
        'kubejs:superior_ender_affinity_gem',
        'kubejs:exalted_ender_affinity_gem',

        'kubejs:fire_affinity_gem',
        'kubejs:superior_fire_affinity_gem',
        'kubejs:exalted_fire_affinity_gem',

        'kubejs:ice_affinity_gem',
        'kubejs:superior_ice_affinity_gem',
        'kubejs:exalted_ice_affinity_gem',

        'kubejs:lightning_affinity_gem',
        'kubejs:superior_lightning_affinity_gem',
        'kubejs:exalted_lightning_affinity_gem',

        'kubejs:nature_affinity_gem',
        'kubejs:superior_nature_affinity_gem',
        'kubejs:exalted_nature_affinity_gem',

        'kubejs:holy_affinity_gem',
        'kubejs:superior_holy_affinity_gem',
        'kubejs:exalted_holy_affinity_gem',

        'kubejs:evocation_affinity_gem',
        'kubejs:superior_evocation_affinity_gem',
        'kubejs:exalted_evocation_affinity_gem',

        'kubejs:aqua_affinity_gem',
        'kubejs:superior_aqua_affinity_gem',
        'kubejs:exalted_aqua_affinity_gem',
    ],
    'kubejs:base_affinity_gems': ['kubejs:blood_affinity_gem', 'kubejs:ender_affinity_gem', 'kubejs:fire_affinity_gem', 'kubejs:ice_affinity_gem', 'kubejs:lightning_affinity_gem', 'kubejs:nature_affinity_gem', 'kubejs:holy_affinity_gem', 'kubejs:evocation_affinity_gem', 'kubejs:aqua_affinity_gem'],
    'kubejs:superior_affinity_gems': ['kubejs:superior_blood_affinity_gem', 'kubejs:superior_ender_affinity_gem', 'kubejs:superior_fire_affinity_gem', 'kubejs:superior_ice_affinity_gem', 'kubejs:superior_lightning_affinity_gem', 'kubejs:superior_nature_affinity_gem', 'kubejs:superior_holy_affinity_gem', 'kubejs:superior_evocation_affinity_gem', 'kubejs:superior_aqua_affinity_gem'],
    'kubejs:exalted_affinity_gems': ['kubejs:exalted_blood_affinity_gem', 'kubejs:exalted_ender_affinity_gem', 'kubejs:exalted_fire_affinity_gem', 'kubejs:exalted_ice_affinity_gem', 'kubejs:exalted_lightning_affinity_gem', 'kubejs:exalted_nature_affinity_gem', 'kubejs:exalted_holy_affinity_gem', 'kubejs:exalted_evocation_affinity_gem', 'kubejs:exalted_aqua_affinity_gem'],

    'kubejs:mythic_items': ['kubejs:celestial_glass', 'kubejs:dragons_wisdom', 'kubejs:heart_of_darkness', 'kubejs:specters_boon', 'kubejs:pearls_of_the_moon', 'kubejs:twilight_codex', 'kubejs:widows_blood', 'kubejs:abyssal_wayfinder', 'kubejs:whispers_of_the_elderwood', 'kubejs:windwalkers_talisman', 'kubejs:imprisoned_embers', 'kubejs:bloody_inferno', 'kubejs:electric_inferno', 'kubejs:eldritch_inferno', 'kubejs:nebulous_flux', 'kubejs:frozen_memory', 'kubejs:tears_of_the_aether', 'kubejs:phantoms_twilight', 'kubejs:enslaved_celestial_hammer','kubejs:cultists_gauntlet', 'kubejs:indistinguishable_magic', 'kubejs:corrupted_gemstone', 'kubejs:tears_of_creation', 'kubejs:eternal_flame', 'kubejs:purification_totem', 'kubejs:aethereal_gemstone', 'kubejs:remains_of_the_elderwood', 'kubejs:elderwood_heart', 'kubejs:enslavement_elixir', 'kubejs:phalanx_ring', 'kubejs:sufficiently_advanced_technology', 'kubejs:imprisoned_star', 'kubejs:blaze_core', 'kubejs:charged_crystal'],
    'kubejs:wayfinders': ['kubejs:abyssal_wayfinder', 'kubejs:toxic_wayfinder', 'kubejs:primordial_wayfinder', 'kubejs:magnetic_wayfinder', 'kubejs:forlorn_wayfinder'],
    'kubejs:parcool_skill_tokens': ['kubejs:breakfall', 'kubejs:catleap', 'kubejs:vertical_wallrun', 'kubejs:horizontal_wallrun', 'kubejs:crawl', 'kubejs:ledgegrab'],
    'kubejs:curios_slot_expansions': [
        'kubejs:ring_slot_expansion', 
        'kubejs:necklace_slot_expansion', 
        'kubejs:belt_slot_expansion', 
        'kubejs:charm_slot_expansion', 
        'kubejs:talent_slot_expansion',
        //'kubejs:augment_slot_expansion',
        //'kubejs:accessory_slot_expansion',
        'kubejs:scroll_slot_expansion',
        ],
    'kubejs:attribute_gemstones': ['kubejs:vanguard_gemstone', 'kubejs:marksman_gemstone', 'kubejs:warlock_gemstone'],
    
    'curios:talent': [
        '#kubejs:affinity_gems',
    ],
    //'kubejs:mythic_upgrade_ingots': ['mythicupgrades:sapphire_ingot', 'mythicupgrades:jade_ingot', 'mythicupgrades:aquamarine_ingot', 'mythicupgrades:ametrine_ingot', 'mythicupgrades:ruby_ingot', 'mythicupgrades:topaz_ingot', 'mythicupgrades:peridot_ingot'],
    'kubejs:cataclysm_boss_drops_for_ingots': ['cataclysm:essence_of_the_storm', 'cataclysm:ignitium_ingot', 'cataclysm:cursium_ingot', 'cataclysm:sandstorm_in_a_bottle', 'cataclysm:witherite_ingot', 'traveloptics:withered_excrucis'],
    'kubejs:mythic_upgrade_dusts': ['kubejs:sapphire_dust', 'kubejs:jade_dust', 'kubejs:aquamarine_dust', 'kubejs:ametrine_dust', 'kubejs:ruby_dust', 'kubejs:topaz_dust', 'kubejs:peridot_dust'],
    'kubejs:snow_queen_bows': ['twilightforest:triple_bow', 'twilightforest:seeker_bow'],
    'curios:charm': [
        'kubejs:indistinguishable_magic',
        'kubejs:sufficiently_advanced_technology',
        'kubejs:effigy_of_the_undying',
        'kubejs:empyrean_scarab',
        'kubejs:specters_boon',

        'kubejs:bloodlust',
        'kubejs:frozen_prison',
        'kubejs:reaper',
        'kubejs:lich',
        'kubejs:zephyr',
        'kubejs:skybound',
        '#kubejs:skill_gems',
        'kubejs:lesser_skill_totem',
        'kubejs:greater_skill_totem',
        'kubejs:exalted_skill_totem',

        // Elixirs
        'kubejs:firewyrm_flask',
        'kubejs:firewyrm_flask',
        'kubejs:dragons_breath',
        'kubejs:raging_tempest',
        'kubejs:dark_winds',//
        'kubejs:frostfire_dew',//
        'kubejs:serpents_tears',//
        'kubejs:stormheart_lullaby',//
        'kubejs:moonlit_mist',//
        'kubejs:captains_elixir',//
        'kubejs:elderwood_sap',
        'kubejs:valkyries_blood',//
        'kubejs:forgotten_divinity',//

        // Essences
        'kubejs:essence_of_frost',
        'kubejs:essence_of_darkness',
        'kubejs:essence_of_cinders',
        'kubejs:essence_of_earth',
        'kubejs:essence_of_light',
        'kubejs:essence_of_storms',
        'kubejs:essence_of_life',
        'kubejs:essence_of_sorrow',
        'kubejs:essence_of_aether',
        'kubejs:essence_of_whispers',
        'kubejs:essence_of_giants',
        'kubejs:essence_of_the_void',
        'kubejs:essence_of_eternity',
    ],
    'kubejs:tutorial_runes': [
        'kubejs:rune_of_the_guardian_tutorial', 
        'kubejs:rune_of_the_battlemage_tutorial',
        'kubejs:rune_of_the_conjurer_tutorial',
        'kubejs:rune_of_the_disciple_tutorial',
        'kubejs:rune_of_the_kensei_tutorial',
        'kubejs:rune_of_the_berserker_tutorial',
        'kubejs:rune_of_the_dragonlord_tutorial',
        'kubejs:rune_of_the_plague_doctor_tutorial',
        'kubejs:rune_of_the_druid_tutorial',
        'kubejs:rune_of_the_mercenary_tutorial',
        'kubejs:rune_of_the_mystic_tutorial',
        'kubejs:rune_of_the_frostpiercer_tutorial',
        'kubejs:rune_of_the_bloodripper_tutorial',
        'kubejs:rune_of_the_shinobi_tutorial',
        'kubejs:rune_of_the_nomad_tutorial',
    ],
    'kubejs:essences': [
        'kubejs:essence_of_frost',
        'kubejs:essence_of_darkness',
        'kubejs:essence_of_cinders',
        'kubejs:essence_of_earth',
        'kubejs:essence_of_light',
        'kubejs:essence_of_storms',
        'kubejs:essence_of_life',
        'kubejs:essence_of_sorrow',
        'kubejs:essence_of_aether',
        'kubejs:essence_of_whispers',
        'kubejs:essence_of_giants',
        'kubejs:essence_of_the_void',
        'kubejs:essence_of_eternity',

    ],
    'curios:necklace': [
        'kubejs:cursed_necklace',
        'kubejs:windwalkers_talisman',
    ],
    'curios:ring': [
        'kubejs:nebulous_flux',
        'kubejs:phalanx_ring',
        'kubejs:banished_immortal',
        'kubejs:frozen_memory',
        'kubejs:tears_of_the_aether',
        'kubejs:phantoms_twilight',
    ],

    'forge:food': [
        '#croptopia:advancements_food_crafted',
        '#forge:crops'
    ],
    'forge:tools': [
        '#forge:axes',
        '#blue_skies:tools',
        '#forge:swords',
        '#forge:pickaxes',
        '#forge:hoes',
        '#forge:shovels',
        'tetra:modular_bow',
        'tetra:modular_sword',
        'tetra:modular_double',
        'tetra:modular_single',
        'tetra:modular_shield'
    ],
    'forge:tools/wooden': [
        'dixtas_armory:wooden_longsword',
        'dixtas_armory:wooden_twinblade',
        'dixtas_armory:wooden_rapier',
        'dixtas_armory:wooden_katana_two_handed',
        'dixtas_armory:wooden_dagger',
        'dixtas_armory:wooden_spear_two_handed',
        'dixtas_armory:wooden_glaive',
        'dixtas_armory:wooden_battle_axe_two_handed',
        'dixtas_armory:wooden_halberd',
        'dixtas_armory:wooden_zweihander',
        'dixtas_armory:wooden_shortsword',
        'dixtas_armory:wooden_stiletto',
        'dixtas_armory:wooden_pike'
    ],
    'forge:tools/stone': [
        'dixtas_armory:stone_longsword'
    ],
    'kubejs:flintlock': [
        'musketmod:pistol'
    ],
    'kubejs:main_classes': [
        'kubejs:warlock',
        'kubejs:vanguard',
        'kubejs:ranger',
        'kubejs:shaman',
        'kubejs:beastmaster',
    ],
    'kubejs:melee_weapons': [
        '#forge:tools'
    ],
    'kubejs:ranged': [
        'tetra:modular_bow',
        'minecraft:bow'
    ],
    'kubejs:subclasses': [
        'kubejs:rune_of_the_guardian',
        'kubejs:rune_of_the_battlemage',
        'kubejs:rune_of_the_conjurer',

        'kubejs:rune_of_the_disciple',
        'kubejs:rune_of_the_kensei',
        'kubejs:rune_of_the_berserker',

        'kubejs:rune_of_the_dragonlord',
        'kubejs:rune_of_the_plague_doctor',
        'kubejs:rune_of_the_druid',

        'kubejs:rune_of_the_mercenary',
        'kubejs:rune_of_the_mystic',
        'kubejs:rune_of_the_frostpiercer',

        'kubejs:rune_of_the_bloodripper',
        'kubejs:rune_of_the_shinobi',
        'kubejs:rune_of_the_nomad',
        
    ],
    'kubejs:enchanted_books': [
        'minecraft:enchanted_book'
    ],
    'kubejs:hammers': [
        'justhammers:stone_hammer',
        'justhammers:iron_hammer',
        'justhammers:gold_hammer',
        'justhammers:diamond_hammer',
        'justhammers:netherite_hammer',
        'justhammers:stone_impact_hammer',
        'justhammers:iron_impact_hammer',
        'justhammers:gold_impact_hammer',
        'justhammers:diamond_impact_hammer',
        'justhammers:netherite_impact_hammer',
        'justhammers:stone_reinforced_hammer',
        'justhammers:iron_reinforced_hammer',
        'justhammers:gold_reinforced_hammer',
        'justhammers:diamond_reinforced_hammer',
        'justhammers:netherite_reinforced_hammer',
        'justhammers:stone_reinforced_impact_hammer',
        'justhammers:iron_reinforced_impact_hammer',
        'justhammers:gold_reinforced_impact_hammer',
        'justhammers:diamond_reinforced_impact_hammer',
        'justhammers:netherite_reinforced_impact_hammer',
        'justhammers:stone_destructor_hammer',
        'justhammers:iron_destructor_hammer',
        'justhammers:gold_destructor_hammer',
        'justhammers:diamond_destructor_hammer',
        'justhammers:netherite_destructor_hammer'
    ],
    'kubejs:magic_item': [
        'irons_spellbooks:netherite_spell_book',
        'irons_spellbooks:diamond_spell_book',
        'irons_spellbooks:iron_spell_book',
        'irons_spellbooks:gold_spell_book',
        'irons_spellbooks:evoker_spell_book',
        'irons_spellbooks:rotten_spell_book',
        'irons_spellbooks:blaze_spell_book',
        'irons_spellbooks:copper_spell_book',
        'irons_spellbooks:dragonskin_spell_book',
        'irons_spellbooks:villager_spell_book',
        'irons_spellbooks:blood_staff',
        'irons_spellbooks:scroll',
        'irons_spellbooks:epic_ink',
        'irons_spellbooks:common_ink',
        'irons_spellbooks:uncommon_ink',
        'irons_spellbooks:rare_ink',
        'irons_spellbooks:legendary_ink',
        'irons_spellbooks:arcane_essence',
        'irons_spellbooks:divine_pearl',
        'irons_spellbooks:arcane_essence'
    ],
    'kubejs:scroll': [
        'irons_spellbooks:scroll'
    ],

    'skillslots:skill': [
        'minecraft:goat_horn',
        'kubejs:bloodripper_grim',
        'kubejs:testing',
        'kubejs:essence_of_frost',
        'kubejs:essence_of_darkness',
        'kubejs:essence_of_cinders',
        'kubejs:essence_of_earth',
        'kubejs:essence_of_light',
        'kubejs:essence_of_storms',
        'kubejs:essence_of_life',
        'kubejs:essence_of_sorrow',
        'kubejs:essence_of_aether',
        'kubejs:essence_of_whispers',
        'kubejs:essence_of_giants',
        'kubejs:essence_of_the_void',
        'kubejs:essence_of_eternity',
        'kubejs:return_home',
        'kubejs:celestial_glass',
        'kubejs:dragons_wisdom',
        'kubejs:dreamweavers_orb',
        'kubejs:effigy_of_the_undying',
        'kubejs:heart_of_darkness',
        'kubejs:specters_boon',
        'kubejs:tears_of_the_moon',
        'kubejs:twilight_codex',
        'kubejs:widows_blood',
        'kubejs:whispers_of_the_elderwood',
        'kubejs:windwalkers_talisman',
        'kubejs:common_druid_totem',
        'kubejs:uncommon_druid_totem',
        'kubejs:rare_druid_totem',
        'kubejs:epic_druid_totem',
        'kubejs:unstable_summoning_stone',
        'kubejs:empyrean_scarab',
        'kubejs:lich',
        'kubejs:zephyr',
        'kubejs:skybound',

        'kubejs:grizzly_bear_summoning_stone',
        'kubejs:gorilla_summoning_stone',
        'kubejs:crocodile_summoning_stone',
        'kubejs:elephant_summoning_stone',
        'kubejs:capuchin_monkey_summoning_stone',
        'kubejs:kangaroo_summoning_stone',
        'kubejs:tarantula_hawk_summoning_stone',
        'kubejs:komodo_dragon_summoning_stone',
        'kubejs:bald_eagle_summoning_stone',
        'kubejs:crow_summoning_stone',

        'kubejs:mammoth_summoning_stone',

        'kubejs:hippogryph_summoning_stone',
        'kubejs:stymphalian_bird_summoning_stone',
        'kubejs:cockatrice_summoning_stone',

        'kubejs:lesser_health_elixir',
        'kubejs:greater_health_elixir',
        'kubejs:exalted_health_elixir',
        'kubejs:lesser_mana_elixir',
        'kubejs:greater_mana_elixir',
        'kubejs:exalted_mana_elixir',

        'kubejs:home_waystone',
        'kubejs:journey_waystone',

        
    ],
    'wrd:magic_cauldron': [
        'wrd:magic_cauldron_desert',
        'wrd:magic_cauldron_ice',
        'wrd:magic_cauldron_jungle',
        'wrd:magic_cauldron_nether'
    ],
    'minecraft:swords': [
        'kubejs:bloodletter',
        'call_of_yucutan:fist_of_doom',
        'kubejs:throwing_knife'
    ],
    'kubejs:summoning_stones': [
        'kubejs:gorilla_summoning_stone',
        'kubejs:grizzly_bear_summoning_stone',
        'kubejs:crocodile_summoning_stone',
        'kubejs:elephant_summoning_stone',
        'kubejs:capuchin_monkey_summoning_stone',
        'kubejs:kangaroo_summoning_stone',
        'kubejs:tarantula_hawk_summoning_stone',
        'kubejs:komodo_dragon_summoning_stone',
        'kubejs:bald_eagle_summoning_stone',
        'kubejs:crow_summoning_stone'
    ],
    'kubejs:skill_slots': ['kubejs:lesser_health_elixir', 'kubejs:greater_health_elixir', 'kubejs:exalted_health_elixir', 'kubejs:lesser_mana_elixir', 'kubejs:greater_mana_elixir', 'kubejs:exalted_mana_elixir', 'kubejs:home_waystone', 'kubejs:journey_waystone'],
    'kubejs:gear_modifiers': ['kubejs:common_socketing_chip', 'kubejs:uncommon_socketing_chip', 'kubejs:rare_socketing_chip', 'kubejs:common_sentient_stone', 'kubejs:uncommon_sentient_stone', 'kubejs:rare_sentient_stone'],
    'kubejs:ciphers': ['kubejs:sunstrike', 'kubejs:echoing_strike', 'kubejs:berserk', 'kubejs:blazing', 'kubejs:thorns', 'kubejs:adrenaline', 'kubejs:glacial_grasp', 'kubejs:gusting', 'kubejs:soulsteal', 'kubejs:thunderstorm', 'kubejs:strength', 'kubejs:resistance', 'kubejs:charged'],
    'kubejs:grimoires': ['kubejs:armored1', 'kubejs:armored2', 'kubejs:demonic1', 'kubejs:demonic2', 'kubejs:blessed1', 'kubejs:blessed2', 'kubejs:focused1', 'kubejs:focused2', 'kubejs:gifted1', 'kubejs:gifted2', 'kubejs:swift1', 'kubejs:swift2'],
    'kubejs:boss_power_modifiers': ['fantasy_armor:moon_crystal', 'aquamirae:abyssal_amethyst'],
    'kubejs:boss_summon_modifiers': ['iceandfire:fire_dragon_blood', 'iceandfire:ice_dragon_blood', 'iceandfire:lightning_dragon_blood'],
    'kubejs:boss_burst_modifiers': ['minecells:monster_cell', 'minecells:cell_infused_steel'],

    'kubejs:gameplay_modifiers': [
        'kubejs:beastriders', // Monsters spawn on mounts (Mounts are Grizzly Bears, Komodo Dragons, Tarantula Hawks, Soul Vultures, Ampitheres, Cockatrises, Stymphalian Birds, and Hippogryphs) //
        'kubejs:arcane_ascension',  // Monsters always spawn as spellcasters and a 2x higher chance to cast spells //
        'kubejs:ironclad', // Gives mobs better weapons and armor
        'kubejs:arachnophobia', // Spiders spawn small and fast cave spiders on death // 
        'kubejs:monstrosities', // Mutants spawn with more life and potion effects //
        'kubejs:undead_feast', // Zombies spawn with life steal //
        'kubejs:ravenous_horde', // Hitting a zombie empowers all nearby zombies
        'kubejs:icebound', // Strays have a high chance to freeze you //
        'kubejs:death_snare', // Arrows shot by skeletons pull you towards them on hit and apply slow //
        'kubejs:piglin_rage', // Nearby Zombified Piglins gain a speed buff when you attack one of them //
        'kubejs:brute_force', // Piglin Brutes deal more damage and knock you back further //
        'kubejs:tempestborn', // All Creeper types spawn charged //
        'kubejs:vexsplosion', // Vexs drop lit tnt on death //
        'kubejs:shroudwalkers', // Endermen give you darkness when they hit you, strength when you hit them, and teleport around you more frequently //
        'kubejs:corrupted_kin', // Mutants spawn in place of their normal counterparts 50% of the time //
        'kubejs:veiled_broodlings', // Cave spiders spawn with invisibility. It is removed upon attacking a player //
        'kubejs:deep_abyss', // Drowned spawn with Tridents. Tridents pull you towards them on hit //
        'kubejs:mob_menagerie', // Monster spawns are randomized and include a much wider variety of mobs, including ones from other dimensions
        'kubejs:eyes_within_the_stone', // mining too much will spawn a cave dweller nearby //
        'kubejs:screeching_shadows', // phantoms are smaller, faster, and multiply on hit //
        'kubejs:event_horizon', // When a mob dies, it has a 10% chance to leave behind a blackhole that is alive for 3 seconds (shrink the black holes) //
        'kubejs:weeping_fate', // Ghasts have a chance to teleport away when hit, taking no damage //
        'kubejs:unending_horde', // All monsters have a high chance to cast a summon spell when they are low health//
        'kubejs:critical_mass', // When a creeper dies, there is a 0.1% chance it will spawn a nuke //
        'kubejs:bone_brigade', // Skeletons have a chance to not spawn and instead spawn 5 "special" skeletons instead. 
        'kubejs:blood_moon', // At night, monsters spawn with Speed, Strength, and Regeneration. // 
        'kubejs:glass_bones', // Fall damage is increased by 3x // 
        'kubejs:pyromania', // You are ignited when you are hit for 3 seconds // 
    ],


    'kubejs:apoth_sigils': ['apotheosis:sigil_of_socketing', 'apotheosis:sigil_of_withdrawal', 'apotheosis:sigil_of_rebirth', 'apotheosis:sigil_of_enhancement'],
    'kubejs:apoth_crafting_items': ['apotheosis:common_material', 'apotheosis:uncommon_material', 'apotheosis:rare_material', 'apotheosis:epic_material', 'apotheosis:mythic_material'],
    
}
ServerEvents.tags('item', event => {
    Object.entries(tags).forEach(([tag, items]) => {
        items.forEach(item => {
            event.add(tag, item)
        })
    })
})


/**
 * ServerEvents.tags('item', event => {
    event.add('forge:tools/bows', 'tetra:modular_bow')
    event.add('forge:tools/swords', 'tetra:modular_sword')
    event.add('forge:tools/axes', '#tetra:axes')
    event.add('forge:tools/axes', 'tetra:modular_double')
    event.add('forge:tools/swords', 'tetra:modular_single')
    event.add('forge:shields', 'tetra:modular_shield')

    
    event.add('kubejs:main_classes', 'kubejs:warlock')
    event.add('kubejs:main_classes', 'kubejs:blacksmith')
    event.add('kubejs:main_classes', 'kubejs:warden')
    event.add('kubejs:main_classes', 'kubejs:ranger')
    event.add('kubejs:main_classes', 'kubejs:rogue')


    event.add('kubejs:subclasses', 'kubejs:rune_of_the_guardian')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_battlemage')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_conjurer')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_disciple')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_kensei')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_dragonlord')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_plague_doctor')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_mercenary')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_mystic')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_frostpiercer')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_nomad')
    event.add('kubejs:subclasses', 'kubejs:rune_of_the_berserker')












    event.add('kubejs:melee_weapons', '#forge:tools')
    event.add('kubejs:flintlock', 'musketmod:pistol')


    event.add('kubejs:enchanted_books', 'minecraft:enchanted_book')


    event.add('forge:tools', '#forge:axes')
    event.add('forge:tools', '#blue_skies:tools')
    event.add('forge:tools', '#forge:swords')
    event.add('forge:tools', '#forge:pickaxes')
    event.add('forge:tools', '#forge:hoes')
    event.add('forge:tools', '#forge:shovels')
    event.add('forge:tools', 'tetra:modular_bow')
    event.add('forge:tools', 'tetra:modular_sword')
    event.add('forge:tools', 'tetra:modular_double')
    event.add('forge:tools', 'tetra:modular_single')
    event.add('forge:tools', 'tetra:modular_shield')

    event.add('forge:armor', 'blue_skies:pyrope_helmet')
    event.add('forge:armor', 'blue_skies:pyrope_chestplate')
    event.add('forge:armor', 'blue_skies:pyrope_leggings')
    event.add('forge:armor', 'blue_skies:pyrope_boots')

    event.add('forge:armor', 'blue_skies:diopside_helmet')
    event.add('forge:armor', 'blue_skies:diopside_chestplate')
    event.add('forge:armor', 'blue_skies:diopside_leggings')
    event.add('forge:armor', 'blue_skies:diopside_boots')

    event.add('forge:armor', 'blue_skies:charoite_helmet')
    event.add('forge:armor', 'blue_skies:charoite_chestplate')
    event.add('forge:armor', 'blue_skies:charoite_leggings')
    event.add('forge:armor', 'blue_skies:charoite_boots')

    event.add('forge:armor', 'blue_skies:horizonite_helmet')
    event.add('forge:armor', 'blue_skies:horizonite_chestplate')
    event.add('forge:armor', 'blue_skies:horizonite_leggings')
    event.add('forge:armor', 'blue_skies:horizonite_boots')


    event.add('forge:armor', 'immersive_armors:bone_helmet')
    event.add('forge:armor', 'immersive_armors:bone_chestplate')
    event.add('forge:armor', 'immersive_armors:bone_leggings')
    event.add('forge:armor', 'immersive_armors:bone_boots')

    event.add('forge:armor', 'immersive_armors:warrior_helmet')
    event.add('forge:armor', 'immersive_armors:warrior_chestplate')
    event.add('forge:armor', 'immersive_armors:warrior_leggings')
    event.add('forge:armor', 'immersive_armors:warrior_boots')

    event.add('forge:armor', 'immersive_armors:wither_helmet')
    event.add('forge:armor', 'immersive_armors:wither_chestplate')
    event.add('forge:armor', 'immersive_armors:wither_leggings')
    event.add('forge:armor', 'immersive_armors:wither_boots')

    event.add('forge:armor', 'immersive_armors:heavy_helmet')
    event.add('forge:armor', 'immersive_armors:heavy_chestplate')
    event.add('forge:armor', 'immersive_armors:heavy_leggings')
    event.add('forge:armor', 'immersive_armors:heavy_boots')

    event.add('forge:armor', 'immersive_armors:robe_helmet')
    event.add('forge:armor', 'immersive_armors:robe_chestplate')
    event.add('forge:armor', 'immersive_armors:robe_leggings')
    event.add('forge:armor', 'immersive_armors:robe_boots')

    event.add('forge:armor', 'immersive_armors:slime_helmet')
    event.add('forge:armor', 'immersive_armors:slime_chestplate')
    event.add('forge:armor', 'immersive_armors:slime_leggings')
    event.add('forge:armor', 'immersive_armors:slime_boots')

    event.add('forge:armor', 'immersive_armors:divine_helmet')
    event.add('forge:armor', 'immersive_armors:divine_chestplate')
    event.add('forge:armor', 'immersive_armors:divine_leggings')
    event.add('forge:armor', 'immersive_armors:divine_boots')

    event.add('forge:armor', 'immersive_armors:prismarine_helmet')
    event.add('forge:armor', 'immersive_armors:prismarine_chestplate')
    event.add('forge:armor', 'immersive_armors:prismarine_leggings')
    event.add('forge:armor', 'immersive_armors:prismarine_boots')

    event.add('forge:armor', 'immersive_armors:wooden_helmet')
    event.add('forge:armor', 'immersive_armors:wooden_chestplate')
    event.add('forge:armor', 'immersive_armors:wooden_leggings')
    event.add('forge:armor', 'immersive_armors:wooden_boots')

    event.add('forge:armor', 'immersive_armors:steampunk_helmet')
    event.add('forge:armor', 'immersive_armors:steampunk_chestplate')
    event.add('forge:armor', 'immersive_armors:steampunk_leggings')
    event.add('forge:armor', 'immersive_armors:steampunk_boots')

    event.add('forge:tools/wooden', ['#forge:swords/wooden','#forge:pickaxes/wooden','#forge:shovels/wooden','#forge:axes/wooden','#forge:hoes/wooden'])

    event.add('forge:tools/stone', ['#forge:swords/stone','#forge:pickaxes/stone','#forge:shovels/stone','#forge:axes/stone','#forge:hoes/stone'])




	event.add('curios:body', 'supplementaries:quiver')
    event.remove('curios:back', 'supplementaries:quiver')
    event.remove('forge:swords', 'byg:pendorite_sword')
    event.remove('forge:swords', 'byg:pendorite_battleaxe')
    event.remove('forge:swords', 'deeperdarker:warden_sword')
    event.remove('forge:swords', 'dungeons_plus:leviathan_blade')



    event.add('forge:tools', 'dixtas_armory:wooden_longsword')
    event.add('forge:tools', 'dixtas_armory:wooden_twinblade')
    event.add('forge:tools', 'dixtas_armory:wooden_rapier')
    event.add('forge:tools', 'dixtas_armory:wooden_katana_two_handed')
    event.add('forge:tools', 'dixtas_armory:wooden_dagger')
    event.add('forge:tools', 'dixtas_armory:wooden_spear_two_handed')
    event.add('forge:tools', 'dixtas_armory:wooden_glaive')
    event.add('forge:tools', 'dixtas_armory:wooden_battle_axe_two_handed')
    event.add('forge:tools', 'dixtas_armory:wooden_halberd')
    event.add('forge:tools', 'dixtas_armory:wooden_zweihander')
    event.add('forge:tools', 'dixtas_armory:wooden_shortsword')
    event.add('forge:tools', 'dixtas_armory:wooden_stiletto')
    event.add('forge:tools', 'dixtas_armory:wooden_pike')

    event.add('forge:tools/wooden', 'dixtas_armory:wooden_longsword')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_twinblade')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_rapier')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_katana_two_handed')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_dagger')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_spear_two_handed')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_glaive')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_battle_axe_two_handed')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_halberd')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_zweihander')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_shortsword')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_stiletto')
    event.add('forge:tools/wooden', 'dixtas_armory:wooden_pike')

    event.add('forge:tools', 'dixtas_armory:stone_longsword')
    event.add('forge:tools', 'dixtas_armory:stone_twinblade')
    event.add('forge:tools', 'dixtas_armory:stone_rapier')
    event.add('forge:tools', 'dixtas_armory:stone_katana_two_handed')
    event.add('forge:tools', 'dixtas_armory:stone_dagger')
    event.add('forge:tools', 'dixtas_armory:stone_spear_two_handed')
    event.add('forge:tools', 'dixtas_armory:stone_glaive')
    event.add('forge:tools', 'dixtas_armory:stone_battle_axe_two_handed')
    event.add('forge:tools', 'dixtas_armory:stone_halberd')
    event.add('forge:tools', 'dixtas_armory:stone_zweihander')
    event.add('forge:tools', 'dixtas_armory:stone_shortsword')
    event.add('forge:tools', 'dixtas_armory:stone_stiletto')
    event.add('forge:tools', 'dixtas_armory:stone_pike')

    event.add('forge:tools/stone', 'dixtas_armory:stone_longsword')
    event.add('forge:tools/stone', 'dixtas_armory:stone_twinblade')
    event.add('forge:tools/stone', 'dixtas_armory:stone_rapier')
    event.add('forge:tools/stone', 'dixtas_armory:stone_katana_two_handed')
    event.add('forge:tools/stone', 'dixtas_armory:stone_dagger')
    event.add('forge:tools/stone', 'dixtas_armory:stone_spear_two_handed')
    event.add('forge:tools/stone', 'dixtas_armory:stone_glaive')
    event.add('forge:tools/stone', 'dixtas_armory:stone_battle_axe_two_handed')
    event.add('forge:tools/stone', 'dixtas_armory:stone_halberd')
    event.add('forge:tools/stone', 'dixtas_armory:stone_zweihander')
    event.add('forge:tools/stone', 'dixtas_armory:stone_shortsword')
    event.add('forge:tools/stone', 'dixtas_armory:stone_stiletto')
    event.add('forge:tools/stone', 'dixtas_armory:stone_pike')

    event.add('forge:tools', 'dixtas_armory:golden_longsword')
    event.add('forge:tools', 'dixtas_armory:golden_twinblade')
    event.add('forge:tools', 'dixtas_armory:golden_rapier')
    event.add('forge:tools', 'dixtas_armory:golden_katana_two_handed')
    event.add('forge:tools', 'dixtas_armory:golden_dagger')
    event.add('forge:tools', 'dixtas_armory:golden_spear_two_handed')
    event.add('forge:tools', 'dixtas_armory:golden_glaive')
    event.add('forge:tools', 'dixtas_armory:golden_battle_axe_two_handed')
    event.add('forge:tools', 'dixtas_armory:golden_halberd')
    event.add('forge:tools', 'dixtas_armory:golden_zweihander')
    event.add('forge:tools', 'dixtas_armory:golden_shortsword')
    event.add('forge:tools', 'dixtas_armory:golden_stiletto')
    event.add('forge:tools', 'dixtas_armory:golden_pike')

    event.add('forge:tools', 'dixtas_armory:iron_longsword')
    event.add('forge:tools', 'dixtas_armory:iron_twinblade')
    event.add('forge:tools', 'dixtas_armory:iron_rapier')
    event.add('forge:tools', 'dixtas_armory:iron_katana_two_handed')
    event.add('forge:tools', 'dixtas_armory:iron_dagger')
    event.add('forge:tools', 'dixtas_armory:iron_spear_two_handed')
    event.add('forge:tools', 'dixtas_armory:iron_glaive')
    event.add('forge:tools', 'dixtas_armory:iron_battle_axe_two_handed')
    event.add('forge:tools', 'dixtas_armory:iron_halberd')
    event.add('forge:tools', 'dixtas_armory:iron_zweihander')
    event.add('forge:tools', 'dixtas_armory:iron_shortsword')
    event.add('forge:tools', 'dixtas_armory:iron_stiletto')
    event.add('forge:tools', 'dixtas_armory:iron_pike')


    event.add('forge:tools', 'dixtas_armory:diamond_longsword')
    event.add('forge:tools', 'dixtas_armory:diamond_twinblade')
    event.add('forge:tools', 'dixtas_armory:diamond_rapier')
    event.add('forge:tools', 'dixtas_armory:diamond_katana_two_handed')
    event.add('forge:tools', 'dixtas_armory:diamond_dagger')
    event.add('forge:tools', 'dixtas_armory:diamond_spear_two_handed')
    event.add('forge:tools', 'dixtas_armory:diamond_glaive')
    event.add('forge:tools', 'dixtas_armory:diamond_battle_axe_two_handed')
    event.add('forge:tools', 'dixtas_armory:diamond_halberd')
    event.add('forge:tools', 'dixtas_armory:diamond_zweihander')
    event.add('forge:tools', 'dixtas_armory:diamond_shortsword')
    event.add('forge:tools', 'dixtas_armory:diamond_stiletto')
    event.add('forge:tools', 'dixtas_armory:diamond_pike')

    event.add('forge:tools', 'dixtas_armory:netherite_longsword')
    event.add('forge:tools', 'dixtas_armory:netherite_twinblade')
    event.add('forge:tools', 'dixtas_armory:netherite_rapier')
    event.add('forge:tools', 'dixtas_armory:netherite_katana_two_handed')
    event.add('forge:tools', 'dixtas_armory:netherite_dagger')
    event.add('forge:tools', 'dixtas_armory:netherite_spear_two_handed')
    event.add('forge:tools', 'dixtas_armory:netherite_glaive')
    event.add('forge:tools', 'dixtas_armory:netherite_battle_axe_two_handed')
    event.add('forge:tools', 'dixtas_armory:netherite_halberd')
    event.add('forge:tools', 'dixtas_armory:netherite_zweihander')
    event.add('forge:tools', 'dixtas_armory:netherite_shortsword')
    event.add('forge:tools', 'dixtas_armory:netherite_stiletto')
    event.add('forge:tools', 'dixtas_armory:netherite_pike')

    event.add('forge:tools', 'dixtas_armory:electrum_longsword')
    event.add('forge:tools', 'dixtas_armory:electrum_twinblade')
    event.add('forge:tools', 'dixtas_armory:electrum_rapier')
    event.add('forge:tools', 'dixtas_armory:electrum_katana_two_handed')
    event.add('forge:tools', 'dixtas_armory:electrum_dagger')
    event.add('forge:tools', 'dixtas_armory:electrum_spear_two_handed')
    event.add('forge:tools', 'dixtas_armory:electrum_glaive')
    event.add('forge:tools', 'dixtas_armory:electrum_battle_axe_two_handed')
    event.add('forge:tools', 'dixtas_armory:electrum_halberd')
    event.add('forge:tools', 'dixtas_armory:electrum_zweihander')
    event.add('forge:tools', 'dixtas_armory:electrum_shortsword')
    event.add('forge:tools', 'dixtas_armory:electrum_stiletto')
    event.add('forge:tools', 'dixtas_armory:electrum_pike')

    event.add('forge:tools', 'dixtas_armory:adamantite_longsword')
    event.add('forge:tools', 'dixtas_armory:adamantite_twinblade')
    event.add('forge:tools', 'dixtas_armory:adamantite_rapier')
    event.add('forge:tools', 'dixtas_armory:adamantite_katana_two_handed')
    event.add('forge:tools', 'dixtas_armory:adamantite_dagger')
    event.add('forge:tools', 'dixtas_armory:adamantite_spear_two_handed')
    event.add('forge:tools', 'dixtas_armory:adamantite_glaive')
    event.add('forge:tools', 'dixtas_armory:adamantite_battle_axe_two_handed')
    event.add('forge:tools', 'dixtas_armory:adamantite_halberd')
    event.add('forge:tools', 'dixtas_armory:adamantite_zweihander')
    event.add('forge:tools', 'dixtas_armory:adamantite_shortsword')
    event.add('forge:tools', 'dixtas_armory:adamantite_stiletto')
    event.add('forge:tools', 'dixtas_armory:adamantite_pike')


    event.add('kubejs:exclude', 'kubejs:high_value_target')

    event.add('kubejs:exclude','kubejs:zombie_bounty')
    event.add('kubejs:exclude','kubejs:creeper_bounty')
    event.add('kubejs:exclude','kubejs:skeleton_bounty')
    event.add('kubejs:exclude','kubejs:spider_bounty')
    event.add('kubejs:exclude','kubejs:piglin_bounty')
    event.add('kubejs:exclude','kubejs:enderman_bounty')
    event.add('kubejs:exclude','kubejs:pillager_bounty')
    event.add('kubejs:exclude','kubejs:drowned_bounty')
    event.add('kubejs:exclude','kubejs:high_value_target')
 */

    // Via Romana Paths

// Example usage:

let path_array = [
    'mcwpaths:andesite_windmill_weave',
    'mcwpaths:cobbled_deepslate_crystal_floor_path',
    'mcwpaths:cobblestone_dumble_paving',
    'mcwpaths:deepslate_flagstone',
    'mcwpaths:diorite_running_bond_slab',
    'mcwpaths:red_sandstone_diamond_paving',
    'mcwpaths:oak_planks_path',
    'mcwpaths:mossy_stone_running_bond_slab',
    'mcwpaths:bamboo_planks_path',
    'mcwpaths:cobbled_deepslate_running_bond',
    'mcwpaths:granite_flagstone_path',
    'mcwpaths:sandstone_windmill_weave',
    'mcwpaths:mud_brick_diamond_paving',
    'mcwpaths:deepslate_strewn_rocky_path',
    'mcwpaths:deepslate_diamond_paving',
    'mcwpaths:andesite_square_paving',
    'mcwpaths:andesite_running_bond',
    'mcwpaths:acacia_planks_path',
    'mcwpaths:diorite_running_bond_path',
    'mcwpaths:sandstone_basket_weave_paving',
    'mcwpaths:granite_flagstone',
    'mcwpaths:dark_prismarine_diamond_paving',
    'mcwpaths:dark_prismarine_flagstone_path',
    'mcwpaths:blackstone_windmill_weave',
    'mcwpaths:diorite_diamond_paving',
    'mcwpaths:diorite_flagstone',
    'mcwpaths:granite_square_paving',
    'mcwpaths:andesite_flagstone',
    'mcwpaths:brick_diamond_paving',
    'mcwpaths:brick_honeycomb_paving',
    'mcwpaths:blackstone_crystal_floor_slab',
    'mcwpaths:diorite_crystal_floor',
    'mcwpaths:blackstone_clover_paving',
    'mcwpaths:cobblestone_square_paving',
    'mcwpaths:cobbled_deepslate_basket_weave_paving',
    'mcwpaths:deepslate_square_paving',
    'mcwpaths:andesite_crystal_floor',
    'mcwpaths:red_sandstone_flagstone_path',
    'mcwpaths:diorite_square_paving',
    'mcwpaths:deepslate_windmill_weave_path',
    'mcwpaths:mossy_cobblestone_clover_paving',
    'mcwpaths:red_sandstone_flagstone_slab',
    'mcwpaths:red_sandstone_flagstone',
    'mcwpaths:mossy_stone_crystal_floor_path',
    'mcwpaths:cobbled_deepslate_clover_paving',
    'mcwpaths:sandstone_running_bond_slab',
    'mcwpaths:cobbled_deepslate_windmill_weave',
    'mcwpaths:granite_crystal_floor',
    'mcwpaths:brick_windmill_weave_path',
    'mcwpaths:sandstone_dumble_paving',
    'mcwpaths:mud_brick_strewn_rocky_path',
    'mcwpaths:crimson_planks_path',
    'mcwpaths:andesite_dumble_paving',
    'mcwpaths:sandstone_running_bond_path',
    'mcwpaths:blackstone_strewn_rocky_path',
    'mcwpaths:granite_running_bond',
    'mcwpaths:dark_prismarine_flagstone_slab',
    'mcwpaths:mud_brick_crystal_floor_path',
    'mcwpaths:stone_flagstone_slab',
    'mcwpaths:mossy_cobblestone_basket_weave_paving',
    'mcwpaths:granite_strewn_rocky_path',
    'mcwpaths:red_sandstone_dumble_paving',
    'mcwpaths:mossy_stone_crystal_floor_slab',
    'mcwpaths:stone_flagstone_path',
    'mcwpaths:deepslate_dumble_paving',
    'mcwpaths:brick_clover_paving',
    'mcwpaths:mossy_stone_running_bond_path',
    'mcwpaths:granite_windmill_weave_slab',
    'mcwpaths:andesite_windmill_weave_slab',
    'mcwpaths:mangrove_planks_path',
    'mcwpaths:mud_brick_honeycomb_paving',
    'mcwpaths:sandstone_windmill_weave_path',
    'mcwpaths:granite_honeycomb_paving',
    'mcwpaths:diorite_honeycomb_paving',
    'mcwpaths:granite_windmill_weave_path',
    'mcwpaths:deepslate_running_bond',
    'mcwpaths:diorite_basket_weave_paving',
    'mcwpaths:cobblestone_honeycomb_paving',
    'mcwpaths:dark_prismarine_flagstone',
    'mcwpaths:granite_clover_paving',
    'mcwpaths:deepslate_crystal_floor_slab',
    'mcwpaths:dark_prismarine_running_bond',
    'mcwpaths:mud_brick_running_bond',
    'mcwpaths:dark_prismarine_crystal_floor_path',
    'mcwpaths:diorite_running_bond',
    'mcwpaths:sandstone_crystal_floor',
    'mcwpaths:mud_brick_clover_paving',
    'mcwpaths:cobbled_deepslate_honeycomb_paving',
    'mcwpaths:brick_running_bond_slab',
    'mcwpaths:red_sandstone_honeycomb_paving',
    'mcwpaths:mud_brick_windmill_weave_slab',
    'mcwpaths:deepslate_crystal_floor_path',
    'mcwpaths:mud_brick_windmill_weave_path',
    'mcwpaths:sandstone_square_paving',
    'mcwpaths:mossy_stone_windmill_weave',
    'mcwpaths:brick_running_bond_path',
    'mcwpaths:stone_crystal_floor',
    'mcwpaths:mossy_cobblestone_dumble_paving',
    'mcwpaths:blackstone_square_paving',
    'mcwpaths:red_sandstone_crystal_floor_path',
    'mcwpaths:stone_windmill_weave',
    'mcwpaths:mud_brick_flagstone_slab',
    'mcwpaths:dark_prismarine_crystal_floor_slab',
    'mcwpaths:cobbled_deepslate_flagstone_path',
    'mcwpaths:andesite_diamond_paving',
    'mcwpaths:red_sandstone_crystal_floor_slab',
    'mcwpaths:mud_brick_flagstone',
    'mcwpaths:red_sandstone_clover_paving',
    'mcwpaths:deepslate_clover_paving',
    'mcwpaths:stone_crystal_floor_slab',
    'mcwpaths:mud_brick_flagstone_path',
    'mcwpaths:cobbled_deepslate_flagstone_slab',
    'mcwpaths:sandstone_running_bond',
    'mcwpaths:dark_prismarine_basket_weave_paving',
    'mcwpaths:diorite_crystal_floor_path',
    'mcwpaths:red_sandstone_windmill_weave_slab',
    'mcwpaths:blackstone_crystal_floor',
    'mcwpaths:red_sandstone_windmill_weave',
    'mcwpaths:andesite_windmill_weave_path',
    'mcwpaths:diorite_dumble_paving',
    'mcwpaths:sandstone_flagstone_path',
    'mcwpaths:sandstone_windmill_weave_slab',
    'mcwpaths:brick_strewn_rocky_path',
    'mcwpaths:red_sandstone_running_bond',
    'mcwpaths:red_sandstone_windmill_weave_path',
    'mcwpaths:granite_dumble_paving',
    'mcwpaths:granite_flagstone_slab',
    'mcwpaths:dark_prismarine_dumble_paving',
    'mcwpaths:blackstone_flagstone_slab',
    'mcwpaths:deepslate_running_bond_slab',
    'mcwpaths:mud_brick_basket_weave_paving',
    'mcwpaths:andesite_flagstone_path',
    'mcwpaths:cobblestone_basket_weave_paving',
    'mcwpaths:cobblestone_diamond_paving',
    'mcwpaths:sandstone_flagstone_slab',
    'mcwpaths:dark_prismarine_windmill_weave_slab',
    'mcwpaths:brick_running_bond',
    'mcwpaths:granite_windmill_weave',
    'mcwpaths:blackstone_flagstone_path',
    'mcwpaths:dark_prismarine_windmill_weave',
    'mcwpaths:brick_crystal_floor_path',
    'mcwpaths:diorite_crystal_floor_slab',
    'mcwpaths:dark_oak_planks_path',
    'mcwpaths:diorite_windmill_weave_path',
    'mcwpaths:dark_prismarine_square_paving',
    'mcwpaths:mud_brick_running_bond_path',
    'mcwpaths:mud_brick_dumble_paving',
    'mcwpaths:mossy_cobblestone_diamond_paving',
    'mcwpaths:sandstone_strewn_rocky_path',
    'mcwpaths:brick_crystal_floor_slab',
    'mcwpaths:blackstone_basket_weave_paving',
    'mcwpaths:stone_crystal_floor_path',
    'mcwpaths:brick_crystal_floor',
    'mcwpaths:granite_basket_weave_paving',
    'mcwpaths:mossy_cobblestone_square_paving',
    'mcwpaths:sandstone_flagstone',
    'mcwpaths:mud_brick_running_bond_slab',
    'mcwpaths:deepslate_running_bond_path',
    'mcwpaths:cobbled_deepslate_dumble_paving',
    'mcwpaths:mossy_stone_strewn_rocky_path',
    'mcwpaths:deepslate_honeycomb_paving',
    'mcwpaths:mud_brick_windmill_weave',
    'mcwpaths:mossy_stone_flagstone_slab',
    'mcwpaths:cobbled_deepslate_windmill_weave_path',
    'mcwpaths:blackstone_dumble_paving',
    'mcwpaths:dark_prismarine_crystal_floor',
    'mcwpaths:sandstone_honeycomb_paving',
    'mcwpaths:diorite_clover_paving',
    'mcwpaths:cobbled_deepslate_windmill_weave_slab',
    'mcwpaths:red_sandstone_running_bond_path',
    'mcwpaths:blackstone_running_bond',
    'mcwpaths:cherry_planks_path',
    'mcwpaths:deepslate_windmill_weave',
    'mcwpaths:andesite_basket_weave_paving',
    'mcwpaths:red_sandstone_running_bond_slab',
    'mcwpaths:mossy_stone_running_bond',
    'mcwpaths:diorite_windmill_weave_slab',
    'mcwpaths:brick_flagstone',
    'mcwpaths:brick_windmill_weave',
    'mcwpaths:mossy_stone_flagstone_path',
    'mcwpaths:red_sandstone_basket_weave_paving',
    'mcwpaths:dark_prismarine_windmill_weave_path',
    'mcwpaths:blackstone_honeycomb_paving',
    'mcwpaths:jungle_planks_path',
    'mcwpaths:cobbled_deepslate_running_bond_slab',
    'mcwpaths:granite_running_bond_slab',
    'mcwpaths:dark_prismarine_clover_paving',
    'mcwpaths:andesite_running_bond_slab',
    'mcwpaths:andesite_strewn_rocky_path',
    'mcwpaths:cobblestone_clover_paving',
    'mcwpaths:mossy_stone_windmill_weave_path',
    'mcwpaths:granite_running_bond_path',
    'mcwpaths:brick_flagstone_slab',
    'mcwpaths:dark_prismarine_honeycomb_paving',
    'mcwpaths:mud_brick_crystal_floor_slab',
    'mcwpaths:cobbled_deepslate_flagstone',
    'mcwpaths:blackstone_flagstone',
    'mcwpaths:red_sandstone_crystal_floor',
    'mcwpaths:mossy_stone_windmill_weave_slab',
    'mcwpaths:spruce_planks_path',
    'mcwpaths:brick_flagstone_path',
    'mcwpaths:brick_windmill_weave_slab',
    'mcwpaths:deepslate_crystal_floor',
    'mcwpaths:deepslate_basket_weave_paving',
    'mcwpaths:mossy_stone_crystal_floor',
    'mcwpaths:blackstone_running_bond_path',
    'mcwpaths:blackstone_windmill_weave_path',
    'mcwpaths:deepslate_windmill_weave_slab',
    'mcwpaths:cobbled_deepslate_running_bond_path',
    'mcwpaths:mossy_cobblestone_honeycomb_paving',
    'mcwpaths:andesite_running_bond_path',
    'mcwpaths:blackstone_running_bond_slab',
    'mcwpaths:mossy_stone_flagstone',
    'mcwpaths:dark_prismarine_running_bond_slab',
    'mcwpaths:blackstone_windmill_weave_slab',
    'mcwpaths:blackstone_crystal_floor_path',
    'mcwpaths:brick_square_paving',
    'mcwpaths:diorite_windmill_weave',
    'mcwpaths:stone_running_bond_slab',
    'mcwpaths:stone_windmill_weave_slab',
    'mcwpaths:andesite_crystal_floor_slab',
    'mcwpaths:granite_diamond_paving',
    'mcwpaths:diorite_flagstone_slab',
    'mcwpaths:blackstone_diamond_paving',
    'mcwpaths:red_sandstone_square_paving',
    'mcwpaths:brick_dumble_paving',
    'mcwpaths:granite_crystal_floor_path',
    'mcwpaths:brick_basket_weave_paving',
    'mcwpaths:red_sandstone_strewn_rocky_path',
    'mcwpaths:dark_prismarine_running_bond_path',
    'mcwpaths:stone_running_bond_path',
    'mcwpaths:stone_windmill_weave_path',
    'mcwpaths:andesite_crystal_floor_path',
    'mcwpaths:birch_planks_path',
    'mcwpaths:diorite_flagstone_path',
    'mcwpaths:dark_prismarine_strewn_rocky_path',
    'mcwpaths:stone_strewn_rocky_path',
    'mcwpaths:andesite_honeycomb_paving',
    'mcwpaths:sandstone_clover_paving',
    'mcwpaths:deepslate_flagstone_path',
    'mcwpaths:cobbled_deepslate_diamond_paving',
    'mcwpaths:granite_crystal_floor_slab',
    'mcwpaths:diorite_strewn_rocky_path',
    'mcwpaths:sandstone_crystal_floor_path',
    'mcwpaths:warped_planks_path',
    'mcwpaths:mud_brick_square_paving',
    'mcwpaths:cobbled_deepslate_crystal_floor_slab',
    'mcwpaths:cobbled_deepslate_crystal_floor',
    'mcwpaths:cobbled_deepslate_strewn_rocky_path',
    'mcwpaths:deepslate_flagstone_slab',
    'mcwpaths:andesite_flagstone_slab',
    'mcwpaths:mud_brick_crystal_floor',
    'mcwpaths:sandstone_diamond_paving',
    'mcwpaths:sandstone_crystal_floor_slab',
    'mcwpaths:andesite_clover_paving',
    'mcwpaths:stone_running_bond',
    'mcwpaths:stone_flagstone',
    'mcwpaths:cobbled_deepslate_square_paving',
    'iceandfire:chared_dirt_path',
    'iceandfire:frozen_dirt_path',
    'iceandfire:crackled_dirt_path',
    'regions_unexplored:peat_dirt_path',
    'regions_unexplored:silt_dirt_path',
    'biomeswevegone:sandy_dirt_path',
    'biomeswevegone:lush_dirt_path'
]



path_array.forEach(block => {
    ServerEvents.tags('block', event => {
        event.add('forge:via_romana_path_block', block)
        event.add('blockrunner:very_quick_blocks', block)
    })

    ServerEvents.tags('item', event => {
        event.add('forge:via_romana_path_item', block)
    })
})