const non_key_slot_cap = 20
const key_slot_cap = 20

const gamerules = {
    'showDeathMessages': false,
    'tfEnforcedProgression': false,
    'disableRaids': true,
}






PlayerEvents.loggedIn(event => {
    event.server.gameRules.set('disableRaids', true)
    //Utils.server.runCommandSilent(`/execute as ${event.player.username} run kjs reload startup_scripts`)
    if (event.server.persistentData.getBoolean('server_first_login') != true) {
        //spawnItem('kubejs:inventory_upgrade', 1, event.player)
        event.server.persistentData.putBoolean('server_first_login', true)
        event.server.persistentData.putInt('power_level', 0)
        event.server.gameRules.set('showDeathMessages', false)
        event.server.gameRules.set('tfEnforcedProgression', false)
            // Dimension Locking
        //Utils.server.runCommandSilent(`/dimension aether:the_aether access lock`)
        //Utils.server.runCommandSilent(`/dimension minecraft:the_nether access grant`)
        Utils.server.runCommandSilent(`/dimension minecraft:the_end access lock`)
        Utils.server.runCommandSilent(`/team add Players "Players"`)
        Utils.server.runCommandSilent(`/gamerule tfEnforcedProgression false`)

        Object.entries(global.boss_data).forEach(([entity, data]) => {
            event.server.persistentData.put(data.id+'_dead', false)
        })

    }
    if (event.player.persistentData.get('player_first_login')) return
    event.player.persistentData.putBoolean('player_first_login', true)
    let player = event.player
    let server = event.server
    let player_username = player.username
    let handler = Java.loadClass('snownee.skillslots.SkillSlotsHandler').of(event.player)
    event.server.scheduleInTicks(5, () => {
        Utils.server.runCommandSilent(`/execute at ${player_username} run execute at @p run tabular setNumberOfTabs 1`)
       Utils.server.runCommandSilent(`/execute as ${player_username} run team join Players @s`)
       player.persistentData.putFloat('last_health', player.health)
       player.persistentData.putFloat('last_max_health', player.maxHealth)
       Utils.server.runCommandSilent(`/clear ${player_username} patchouli:guide_book`)
       Utils.server.runCommandSilent(`/clear ${player_username} tide:fishing_journal`)
       Utils.server.runCommandSilent(`/clear ${player_username} alexsmobs:animal_dictionary`)
       Utils.server.runCommandSilent(`/clear ${player_username} enigmaticlegacy:enigmatic_amulet`)
       Utils.server.runCommandSilent(`/clear ${player_username} enigmaticlegacy:cursed_ring`)
       Utils.server.runCommandSilent(`/clear ${player_username} enigmaticdice:enigmatic_die`)
       player.give(Item.of('ftbquests:book').enchant('ensorcellation:soulbound', 1))
       // Parcool Stuff
        Utils.server.runCommandSilent(`/parcool limitation enable ${player_username}`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility BreakfallReady false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility Roll false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility FastRun false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility CatLeap false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility VerticalWallRun false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility HorizontalWallRun false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility ClimbUp false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility ClingToCliff false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility WallSlide false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility WallJump false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility Crawl false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility Slide false`)
        Utils.server.runCommandSilent(`/parcool limitation set individual of ${player_username} possibility Tap false`)
        Utils.server.runCommandSilent(`/parcool limitation enable individual of ${player_username}`)
        //player.modifyAttribute('combat_dash:max_dash_amount', generateUUID(), -3, 'addition')
        let combatroll_count_uuid = generateUUID()
        let modifierName = generateRandomString(16);
        //player.setAttributeBaseValue('combatroll:count', 1)
        Utils.server.runCommandSilent(`/curios set ring ${player_username} 1`)
        Utils.server.runCommandSilent(`/curios set charm ${player_username} 2`)
        Utils.server.runCommandSilent(`/curios set belt ${player_username} 1`)
        Utils.server.runCommandSilent(`/curios set necklace ${player_username} 1`)
        //Utils.server.runCommandSilent(`/curios set talent ${player_username} 0`)
        Utils.server.runCommandSilent(`/curios set augment_slot ${player_username} 0`)
        //Utils.server.runCommandSilent(`/curios set accessory ${player_username} 1`)
        Utils.server.runCommandSilent(`/curios set scroll ${player_username} 0`)




        Utils.server.runCommand(`/execute as ${player_username} run aircombo set 1 ${player_username}`)

        player.persistentData.putInt('nightmare', 0)


        Utils.server.runCommandSilent(`/scale delay set pehkui:height 1 @e`)
        Utils.server.runCommandSilent(`/scale delay set pehkui:width 1 @e`)
        server.persistentData.putInt('bosses_killed', 0)
        server.persistentData.putInt('party_update_counter', 5)
        player.persistentData.putBoolean('in_party', false)
        player.persistentData.putBoolean('tutorial', true)
        player.persistentData.putInt('inventory_slots', 1)
        player.persistentData.putInt('respawn_x', player.x)
        player.persistentData.putInt('respawn_y', player.y)
        player.persistentData.putInt('respawn_z', player.z)
        player.persistentData.putInt('highest_damage', 1)
        player.persistentData.putInt('cipher_difficulty', 0)
        player.persistentData.putInt('order_level', 1)
        player.persistentData.putInt('cs_consumed_health', 0)
        player.persistentData.putInt('eotu_res', 0)
        //player.persistentData.putInt('hvt_complete', 0)

      //  player.level.runCommandSilent(`/team add ${player.username}s_team`)
      //  player.level.runCommandSilent(`/team join ${player.username}s_team ${player.username}`)


        player.persistentData.putInt('vanguard_xp', 0)
        player.persistentData.putInt('vanguard_level', 1)

        player.persistentData.putInt('warlock_xp', 0)
        player.persistentData.putInt('warlock_level', 1)

        player.persistentData.putInt('marksman_xp', 0)
        player.persistentData.putInt('marksman_level', 1)

        player.persistentData.putInt('beastmaster_xp', 0)
        player.persistentData.putInt('beastmaster_level', 1)




        player.persistentData.putInt('crocodile_counter', 0)
        player.persistentData.putInt('anaconda_counter', 0)
        player.persistentData.putInt('murmur_head_counter', 0)
        player.persistentData.putInt('tremorsaurus_counter', 0)
        player.persistentData.putInt('soul_vulture_counter', 0)

        player.persistentData.putInt('acid_counter', 0)
        player.persistentData.putInt('lava_counter', 0)

        player.persistentData.putBoolean('crocodile_counter_complete', false)
        player.persistentData.putBoolean('anaconda_counter_complete', false)
        player.persistentData.putBoolean('murmur_head_counter_complete', false)
        player.persistentData.putBoolean('tremorsaurus_counter_complete', false)
        player.persistentData.putBoolean('soul_vulture_counter_complete', false)

        player.persistentData.putBoolean('acid_counter_complete', false)
        player.persistentData.putBoolean('lava_counter_complete', false)

        player.persistentData.putInt('pet_summoning_challenge', 0)

        player.persistentData.putInt('max_pets', 0)
        player.persistentData.putString('pet_1', 'null')
        player.persistentData.putString('pet_2', 'null')
        player.persistentData.putString('pet_3', 'null')
        player.persistentData.putString('pet_4', 'null')
        player.persistentData.putString('pet_5', 'null')
        player.persistentData.putInt('pet_counter', 0)
        player.persistentData.putInt('money', 0)
        server.persistentData.putInt('y_check', 40)

        player.persistentData.putInt('flame_dashes', 5)

        //loop 20 timees
        for (let i = 1; i <= key_slot_cap; i++) {
            player.persistentData.putString(`key_slot_${i}`, 'null')
        }
        player.persistentData.putInt('key_slot_count', 0)

        for (let i = 0; i <= non_key_slot_cap; i++) {
            player.persistentData.putString(`non_key_slot_${i}`, 'null')
        }
        

        let uuid = player.nbt.get('UUID').toString()
        player.persistentData.putString('player_uuid', uuid)

        Utils.server.runCommandSilent(`/sdmshop set ${player.username} 0`)

        handler.setItem(0, 'kubejs:lesser_health_elixir')
        handler.setItem(1, 'kubejs:home_waystone')
        handler.setItem(2, 'kubejs:lesser_mana_elixir')
        handler.setItem(3, 'kubejs:journey_waystone')

    })
    Utils.server.scheduleInTicks(200, () => {
        Utils.server.runCommandSilent(`/immersivemessages sendcustom ${player.username} {anchor:'CENTER_CENTER', background:1,size: 2.50,y:-120} 5 Open your Questbook to begin`)
    })
})






function nonKeySlots(player, ability) {
    for (let i = 0; i <= non_key_slot_cap; i++) {
        let slotKey = `non_key_slot_${i}`;
        if (player.persistentData[slotKey] == 'null') {
            player.persistentData.putString(slotKey, ability);
            return i;
        }
    }
    return 0; // Return 0 or another value if no slots are available
}

function keySlots(player, ability) {
    let slot = player.persistentData.key_slot_count;
    player.persistentData.putString(`key_slot_${slot}`, ability);

    player.persistentData.putInt(`${ability}_key_slot`, slot);
}

function ability_slot_num (player, ability) {
    if (player.persistentData.get(`${ability}_key_slot`)) {
        return player.persistentData.getInt(`${ability}_key_slot`);
    }
}


/* Return null (not false) when the slot is empty so callers can
   use the existing “== null” checks without blowing up. */
function getAbilityFromNumber(player, slot) {
  const slotKey = `key_slot_${slot}`;
  const ability = player.persistentData[slotKey];

  // Treat undefined, empty string, or literal "null" the same way
  if (!ability || ability === 'null') return null;
  return ability;          // valid ability id
}




function getKeySlot(player, ability) {
    for (let i = 1; i <= key_slot_cap; i++) {
        let slotKey = `key_slot_${i}`;
        if (player.persistentData[slotKey] == ability) {
            return i;
        }
    }
}

function getNonKeySlot(player, ability) {
    for (let i = 0; i <= non_key_slot_cap; i++) {
        let slotKey = `non_key_slot_${i}`;
        if (player.persistentData[slotKey] == ability) {
            return i;
        }
    }
}

function removeAllSlots(player) {
    for (let i = 1; i <= key_slot_cap; i++) {
        let slotKey = `key_slot_${i}`;
        player.persistentData.putString(slotKey, 'null');
    }
    for (let i = 1; i <= non_key_slot_cap; i++) {
        let slotKey = `non_key_slot_${i}`;
        player.persistentData.putString(slotKey, 'null');
    }
}


PlayerEvents.loggedIn(event => {
    let player = event.player;
    let uuid = player.uuid
    let newUUID = NbtUtils.createUUID(uuid);
    newUUID = newUUID.toString();
    let username = player.username;
    event.player.server.persistentData.putString(`${newUUID}`, username)
})

function getUsernameFromUUID(player) {
    let newUUID = NbtUtils.createUUID(player.uuid).toString();
    let playerData = player.server.persistentData.getString(`${newUUID}`);
    if (playerData) {
        return playerData;
    } else {
        return null; // or handle the case where the username is not found
    }
}



function getUsernameFromAltUUID(uuid, server) {
    return server.persistentData.getString(`${uuid}`);
}
    
FTBQuestsEvents.completed('021EB170BC0D703A', event => {
    Utils.server.runCommandSilent(`/dimension minecraft:the_end access grant`)
})

BlockEvents.broken('endrem:ancient_portal_frame', event => {
    event.cancel()
})



/**
 * 
 * 
    let d = event.level.getDifficulty().toString()
    let difficulty = d.toLowerCase()
    event.server.persistentData.putString('difficulty', `${difficulty}`)


})



 * 



 * 
 */

let dim_unlocks = {
    'minecells:insufferable_crypt': 'minecells:vine_rune',
}

Object.entries(dim_unlocks).forEach(([dim, item]) => {
    ItemEvents.pickedUp(item, event => {
        Utils.server.runCommandSilent(`/dimension ${dim} access grant`)
    })
})
    


/**
 * PlayerEvents.loggedIn(event => {
    let player = event.player
    Utils.server.scheduleInTicks(60, () => {
        if (player.persistentData.skills_activation != 1) {
            player.persistentData.putInt('skills_activation', 1)
            let player_username = player.username
            Utils.server.runCommand(`/execute as @p run aircombo set 1 ${player_username}`)
            player.persistentData.putInt('aircombo', 1)
        } else {
            let aircombo_level = player.persistentData.aircombo
            let player_username = player.username
            Utils.server.runCommand(`/execute as @p run aircombo set ${aircombo_level} ${player_username}`)
        }
    })


})
 * 
 * 
 * 
 */


/**
 * PlayerEvents.respawned(event => {
    let player = event.player
    Utils.server.scheduleInTicks(20, () => {
        player.runCommandSilent(`/execute as ${player.username} run kjs reload client_scripts`)
    })
})

PlayerEvents.loggedIn(event => {
    let player = event.player
    Utils.server.scheduleInTicks(20, () => {
        player.runCommandSilent(`/execute as ${player.username} run kjs reload client_scripts`)
    })
})
 * 
 * 
 */





