// Normalize legacy `itemCorrupted` flags into the CompoundTag boolean
// so Orb of Repentance and other systems detect corrupted items reliably.

ServerEvents.loaded(event => {
  let totalScanned = 0
  let totalFixed = 0

  // Helper: normalize one itemstack's NBT in-place
  function normalizeItem(item) {
    if (!item || item.empty || !item.nbt) return false
    // detect legacy plain property or missing CompoundTag boolean
    let legacy = !!item.nbt.itemCorrupted
    let hasCompound = false
    try { hasCompound = (typeof item.nbt.getBoolean === 'function') && !!item.nbt.getBoolean('itemCorrupted') } catch (e) { hasCompound = false }
    if (legacy && !hasCompound) {
      try { if (typeof item.nbt.putBoolean === 'function') item.nbt.putBoolean('itemCorrupted', true) } catch (e) {}
      try { /* keep legacy property for compatibility */ item.nbt.itemCorrupted = true } catch (e) {}
      return true
    }
    return false
  }

  // Scan all online players' inventories
  let players = event.server.players || []
  for (let p of players) {
    try {
      let inv = p.inventory
      for (let i = 0; i < inv.size; i++) {
        let stack = inv.getItem(i)
        totalScanned++
        if (normalizeItem(stack)) totalFixed++
      }
      // hotbar & offhand might be included, but ensure offhand too
      try {
        let off = p.offHandItem
        totalScanned++
        if (normalizeItem(off)) totalFixed++
      } catch (e) {}
    } catch (e) {
      // ignore player iteration errors
    }
  }

  // Log summary
  console.info(`[normalize_corrupted_totems] scanned ${totalScanned} stacks, normalized ${totalFixed} items`)
})
