EntityEvents.hurt('player', event => {
    if (event.source.actual == null) return
    if (!event.source.actual.tags.contains('boss')) return
    let player = event.entity
    global.stopMusic(player)
})


EntityEvents.hurt(event => {
    if (event.source == null) return
    if (!event.source.player) return
    if (!event.entity.tags.contains('boss')) return
    let player = event.source.player
    global.stopMusic(player)
})

global.stopMusic = function (player) {
  if (!player) {
    let CommandSourceStack = Java.loadClass('net.minecraft.commands.CommandSourceStack')
    let ctx = global.event?.server
    if (ctx instanceof CommandSourceStack) {
      player = ctx.getPlayer()
    }
    if (!player) {
      console.warn('[stopMusic] No player context!')
      return
    }
  }

  /* 3) send stop sound packet*/
  try {
    let ServerPlayer                 = Java.loadClass('net.minecraft.server.level.ServerPlayer')
    let ClientboundStopSoundPacket   = Java.loadClass('net.minecraft.network.protocol.game.ClientboundStopSoundPacket')
    let SoundSource                  = Java.loadClass('net.minecraft.sounds.SoundSource')

    if (player instanceof ServerPlayer) {
      
      player.connection.send(new ClientboundStopSoundPacket(null, SoundSource.MUSIC))
    }
  } catch (err) {
    console.log('[stopMusic] Vanilla StopSound failed: ' + err)
  }
}
