// priority: 1000

const MaterialProperty = Java.loadClass('smartin.miapi.modules.material.MaterialProperty') // helper map

const RegistryInventory = Java.loadClass('smartin.miapi.registries.RegistryInventory')

function getMaterial(key) {
    let mat = MaterialProperty.materials.get(key);
    if (mat == null && String(key).includes(":")) mat = MaterialProperty.materials.get(String(key).split(":")[1]); // fallback
    return mat;
}

function getMaterialModuleProp(material, groupKey, modulePropKey) {
    let moduleProp = RegistryInventory.moduleProperties.get(modulePropKey); // e.g. "on_hurt_potion"
    if (moduleProp == null) return null;
    return material.materialProperties(groupKey).get(moduleProp); // JsonElement or null
}


function s(el) {
    return el == null ? "null" : el.toString();
}


function getPrimaryIngredientItemId(material) {
    let json = material.getDebugJson()
    if (json == null) {
        console.log(`Could not get debug json for material ${material.key}`)
        return null
    }
    let id = json.toString().split(`"items":`)[1].split(`"value":`)[0].split(`"item":"`)[1].split(`",`)[0]
    if (id == 'minecraft:gold_nugget') id = 'minecraft:gold_ingot'
    return id
}

    // Helper: safely pull the first quoted string after `"translate":`
function extractTranslateLine(guiStat) {
    if (guiStat == null) return null
    try {
        // your current pipeline + "between quotes"
        return String(guiStat)
        .split(`"description":`)[1]
        .split(`"translate":`)[1]
        .match(/"([^"]+)"/)[1]
    } catch (e) {
        return null
    }
}




PlayerEvents.loggedIn(event => {
    let materials = MaterialProperty.materials.keySet()
    materials.forEach(materialKey => {
        let material
        try {
        material = getMaterial(materialKey)
        } catch (e) {
        // Don’t crash tooltips; just skip this material.
        //console.log(`Could not get material for key ${materialKey}`);
        return;
        }
        if (material == null) {
            //console.log(`Could not find material for key ${materialKey}`);
        }
        //console.log(material.getDebugJson())
        let id
        try {
            id = getPrimaryIngredientItemId(material);
        } catch (e) {
            //console.log(`Error getting primary ingredient for ${materialKey}: ${e}`);
            return;
        }

        if (id == null) { // catches null AND undefined
            //console.log(`Could not get primary ingredient item ID for material ${materialKey}`);
            return;
        }
        if (id.toString().includes('potion')) return
        //console.log(`Pass: ${id}`);

        let armorGuiStat = getMaterialModuleProp(material, "armor", "gui_stat")
        let handheldGuiStat = getMaterialModuleProp(material, "handheld", "gui_stat")

        let armorDesc = extractTranslateLine(armorGuiStat)
        let weaponDesc = extractTranslateLine(handheldGuiStat)

        let hardness = material.getDouble("hardness");
        let density = material.getDouble("density");
        let flexibility = material.getDouble("flexibility");
        let durability = material.getDouble("durability");
        let mining_level = material.getDouble("mining_level");
        let mining_speed = material.getDouble("mining_speed");

        let entry = {
            materialKey: String(materialKey),
            itemId: id,
            hardness: Number.isFinite(hardness) ? hardness : 0,
            density: Number.isFinite(density) ? density : 0,
            flexibility: Number.isFinite(flexibility) ? flexibility : 0,
            durability: Number.isFinite(durability) ? durability : 0,
            mining_level: Number.isFinite(mining_level) ? mining_level : 0,
            mining_speed: Number.isFinite(mining_speed) ? mining_speed : 0
        };
        if (armorDesc) entry.armorDescription = armorDesc;
        if (weaponDesc) entry.weaponDescription = weaponDesc;

        global.ModularTooltips[id] = entry;
        //console.log(global.ModularTooltips[id])
    })
    event.player.sendData('send_tooltips', global.ModularTooltips)
})


