/**
 * 
 * 
 */


let blacklisted_entities_type = [
    'graveyard:acolyte',
    'blue_skies:gatekeeper',
    'alexsmobs:fly',
    'alexsmobs:blobfish',
    'alexsmobs:lobster',
    'rats:ghost_pirat',
    'alexsmobs:sugar_glider',
    'alexsmobs:raccoon',
    'alexsmobs:flying_fish',
    'soulsweapons:big_chungus',
    'iceandfire:pixie',
    'biomeswevegone:oddion',
    'illageandspillage:bone',
    'alexscaves:deep_one_mage',
    'fathomless:explosive_star',
    'mowziesmobs:naga',
    'biomeswevegone:man_o_war',
    'illageandspillage:crocofang',

]
/**
 * 
 * 
 */
blacklisted_entities_type.forEach(entity => {
    EntityEvents.spawned(entity, event => {
        event.cancel()
    })
})


EntityEvents.spawned(`sanitydim:sneaking_terror`, event => {
    let x = event.entity.x
    let y = event.entity.y
    let z = event.entity.z
    Utils.server.runCommandSilent(`/summon sanitydim:rotting_stalker ${x} ${y} ${z}`)
    event.cancel()
})

EntityEvents.spawned('sanitydim:rotting_stalker', event => {
    let entity = event.entity
    Utils.server.runCommandSilent(`/effect give ${entity.uuid} irons_spellbooks:charged infinite 1 true`)
    Utils.server.scheduleInTicks(2, () => {
        applySchool(entity, 'blood')
        exaltedMage(entity)
    })
})

/**
 * EntityEvents.spawned(`cataclysm:ender_golem`, event => {
    if (event.level.dimension == 'minecraft:overworld') {
        let ender_guardian = event.level.createEntity(`cataclysm:ender_guardian`)
        ender_guardian.x = event.entity.x
        ender_guardian.y = event.entity.y
        ender_guardian.z = event.entity.z
        ender_guardian.spawn()
        event.cancel()
    } 
})
 * 
 * 
 */


EntityEvents.spawned('cataclysm:wadjet', event => {
    let newHealth = Number(event.entity.health) * 2
    //Utils.server.tell(newHealth)
    event.entity.maxHealth = newHealth
    event.entity.health = newHealth
    Utils.server.scheduleInTicks(1, () => {
        applyEffect(event.entity, 'minecraft:speed', 'infinite', 3)
        applyEffect(event.entity, 'irons_spellbooks:hastened', 'infinite', 3)
    })
})

EntityEvents.hurt('player', event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.source.actual.type.toString().includes('wadjet')) return
    applyEffect(event.entity, 'runiclib:venom', 100, 2)
})

EntityEvents.hurt('cataclysm:wadjet', event => {
    if (!event.source.player) return
        let chance = Math.random();
        if (chance > 0.25) return
        let spells = []
        // choose a number between 1 and 3
        let num = Math.floor(Math.random() * 3) + 1; // 1 to 3
        // loop 
        for (let i = 0; i < num; i++) {
            spells.push('blood_step') // add blood_step to the list
        }
        spells.push('gust') // add shadow_step to the list

        newCast(event.entity, spells, event.source.player, 1, 'wadjet_shroudwalker')
})


EntityEvents.spawned('minecraft:enderman', event => {
    let x = event.entity.x
    let y = event.entity.y
    let z = event.entity.z
    let level = event.level
    //Utils.server.tell(dim)
    let randomNumber = Math.random();
    if (randomNumber > 0.10) return
    let my_entity = level.createEntity('mutantmonsters:mutant_enderman')
    my_entity.x = x
    my_entity.y = y
    my_entity.z = z
    my_entity.spawn()
    event.cancel()
})



/**
 * EntityEvents.spawned(event => {
    if (!event.entity.type.toString().includes('arrow')) return
    Utils.server.scheduleInTicks(300, () => {
        event.entity.kill()
    })
})
 * 
 */



let day_entities = [
    'minecraft:zombie',
    'minecraft:husk',
    'minecraft:drowned',
    'minecraft:skeleton',
    'minecraft:stray',
    'minecraft:wither_skeleton',
    'minecraft:spider',
    'minecraft:cave_spider',
    'minecraft:witch',
    'minecraft:creeper',
]

/**
 * day_entities.forEach(entity => {
    EntityEvents.spawned(entity, event => {
        if (event.server.persistentData.nightmare_activated == true) {
            Utils.server.scheduleInTicks(1, () => {
                if (event.entity.tags.contains('boss')) return
                if (event.entity.tags.contains('duplicate')) return
                let entity2 = event.level.createEntity(entity)
                entity2.setPosition(event.entity.x, event.entity.y, event.entity.z)
                entity2.tags.add('duplicate')
                entity2.spawn()
            })

        }

    })
})
 * 
 * 
 */


EntityEvents.spawned('minecraft:drowned', event => {
    let randomNumber = Math.random();
    if (randomNumber > 0.50) return
    event.cancel()
})







const static_health_entities = {
    'born_in_chaos_v1:lord_pumpkinhead': 40,
    'born_in_chaos_v1:lord_pumpkinhead_withouta_horse': 50,
}

Object.entries(static_health_entities).forEach(([entityId, health]) => {
    EntityEvents.spawned(entityId, event => {
        event.entity.maxHealth = Number(health)
        event.entity.health = Number(health)
    })
})

