// Consolidated single-entry unified_drops used below
const miscEntityDrops = {
  // Single merged entry per entity
  'born_in_chaos_v1:bonescaller': {
    'graveyard:corruption': 1,
  },
  'born_in_chaos_v1:supreme_bonescaller': {
    'graveyard:corruption': 1,
  },
  'born_in_chaos_v1:supreme_bonescaller_stage_2': {
    'graveyard:corruption': 1,
  },
  'born_in_chaos_v1:dark_vortex': {
    'graveyard:corruption': 1,
  },
  'born_in_chaos_v1:skeleton_thrasher': {
    'graveyard:corruption': 1,
  },
  'mutantmonsters:mutant_creeper': {
    'graveyard:corruption': 1
  },
  'mutantmonsters:mutant_enderman': {
    'graveyard:corruption': 1
  },
  'mutantmonsters:mutant_skeleton': {
    'graveyard:corruption': 1
  },
  'mutantmonsters:mutant_zombie': {
    'graveyard:corruption': 1
  },
  'minecraft:phantom': {
    'graveyard:corruption': 0.25
  }

}

ServerEvents.entityLootTables(event => {
  Object.entries(miscEntityDrops).forEach(([entityId, drops]) => {
    event.modifyEntity(entityId, table => {

      Object.entries(drops).forEach(([itemId, chance]) => {
        table.addPool(pool => {
          // One roll per pool so each item is checked independently
          pool.rolls = 1
          pool.addItem(itemId).randomChance(chance)
        })
      })

    })
  })
})