

/**
 * 







/**
 * 
 * // duel_system.js – KubeJS 1.20.x
// -----------------------------------------------------------
// CONFIG – tweak to taste
let INVITE_TIMEOUT  = 20 * 30;      // 30 s  (20 t = 1 s)
let DUEL_TAG        = 'in_duel';    // scoreboard/nbt tag while duelling
// -----------------------------------------------------------

/*  ──────────────────────────────────────────────────────────
 *  In‑memory records
 *  ────────────────────────────────────────────────────────── 
let pending = {};      // challengeeUUID → { challenger, ticksLeft }
let active  = {};      // key(a,b)      → { A, B, teams:{a,b} }

/*  Helper: consistent 2‑UUID key 
let duelKey = (u1, u2) => [u1, u2].sort().join('_');

 */

/*  Helper: clickable accept / decline tellraw  
function sendInvite(challenger, challengee) {
  let acc = `/kjs duel accept ${challenger.uuid}`;   // runs server command
  let dec = `/kjs duel decline ${challenger.uuid}`;

  challengee.tell([
    Text.of(`${challenger.name.string} has challenged you to a duel!`).gold(),
    Text.of(' [').white(),
    Text.of('ACCEPT').green()
             .clickRunCommand(acc)
             .hover(Text.of('Click to accept')),
    Text.of('] ').white(),
    Text.of('[').white(),
    Text.of('DECLINE').red()
             .clickRunCommand(dec)
             .hover(Text.of('Click to decline')),
    Text.of(']').white()
  ]);

  pending[challengee.uuid] = { challenger: challenger.uuid, ticks: INVITE_TIMEOUT };
}

/*  Helpers: leave / rejoin scoreboard teams silently 
function leaveTeam(p) {
  let t = p.team;
  if (t) p.server.runCommandSilent(`team leave ${p.name.string}`);
  return t?.nameString;            // may be undefined
}
function rejoinTeam(p, team) {
  if (team) p.server.runCommandSilent(`team join ${team} ${p.name.string}`);
}

/*  ──────────────────────────────────────────────────────────
 *  1.  Create invitation when spit hits a player
 *  ────────────────────────────────────────────────────────── 
EntityEvents.hurt(event => {
  if (!event.source.player) return;      // shooter must be player
  //if (!event.entity.player      ) return;      // victim  must be player
  tell(event.source.immediate.type)
  if (event.source.immediate.type != 'spittingimage:spit') return;
  tell(`Spit hit player: `)
  let challenger = event.source.player;
  let challengee = event.source.player;

  // stop duplicate / overlapping invites
  if (pending[challengee.uuid] ||
      Object.values(active).some(d => d.A.uuid === challengee.uuid || d.B.uuid === challengee.uuid)) {
    challenger.tell(Text.red('That player is already busy.'));
    return;
  }

  sendInvite(challenger, challengee);
  challenger.tell(Text.gray(`Duel request sent to ${challengee.name.string}.`));
});

/*  ──────────────────────────────────────────────────────────
 *  2.  /kjs duel accept|decline <challengerUUID>
 *      (generated by clickRunCommand above)
 * 
 * 
 * ServerEvents.commandRegistry(event => {
  // Brigadier helpers that KubeJS injects into this event
  let { commands: C, arguments: A } = event   // C = Commands, A = Arguments

  event.register(
    C.literal('duel')
      .then(
        C.literal('accept')
          .then(
            C.argument('challenger', A.UUID.create(event))
              .executes(ctx => {
                let acceptor   = ctx.source.playerOrException
                let challenger = acceptor.level.getPlayerByUUID(
                                     A.UUID.getResult(ctx, 'challenger'))

                let rec = pending[acceptor.uuid]
                if (!rec || !challenger || rec.challenger !== challenger.uuid) {
                  acceptor.tell(Text.red('No pending duel from that player.'))
                  return 0
                }
                delete pending[acceptor.uuid]
                startDuel(challenger, acceptor)   // ← your helper from earlier
                return 1
              })
          )
      )
      .then(
        C.literal('decline')
          .then(
            C.argument('challenger', A.UUID.create(event))
              .executes(ctx => {
                let decliner   = ctx.source.playerOrException
                let challenger = decliner.level.getPlayerByUUID(
                                     A.UUID.getResult(ctx, 'challenger'))

                let rec = pending[decliner.uuid]
                if (rec && challenger && rec.challenger === challenger.uuid) {
                  delete pending[decliner.uuid]
                  decliner.tell(Text.gray('You declined the duel.'))
                  challenger.tell(Text.red(`${decliner.name.string} declined your duel.`))
                }
                return 1
              })
          )
      )
  )
})
 * 
 *  ────────────────────────────────────────────────────────── */
/* ──────────────────────────────────────────────────────────
 *  Command registration  (/duel accept|decline <challenger>)
 * ────────────────────────────────────────────────────────── */



/*  ──────────────────────────────────────────────────────────
 *  3.  End duel when one kills the other

EntityEvents.death(event => {
  if (!event.entity.player || !event.source.player) return;

  let dead   = event.entity.player;
  let killer = event.source.player;
  let key    = duelKey(dead.uuid, killer.uuid);
  let duel   = active[key];
  if (!duel) return;                       // not a tracked duel

  killer.tell(Text.green('You won the duel!'));
  dead  .tell(Text.red  ('You lost the duel.'));

  // restore teams & clean state
  rejoinTeam(duel.A, duel.teams.a);
  rejoinTeam(duel.B, duel.teams.b);
  duel.A.removeTag(DUEL_TAG);
  duel.B.removeTag(DUEL_TAG);
  delete active[key];
});


 *  ────────────────────────────────────────────────────────── */


/*  ──────────────────────────────────────────────────────────
 *  4.  Tick handler – expire unanswered invites


ServerEvents.tick(e => {
  for (let uuid in pending) {
    let rec = pending[uuid];
    if (--rec.ticks > 0) continue;

    let challengee = event.server.getPlayerList().getPlayer(java.util.UUID.fromString(uuid));
    let challenger = event.server.getPlayerList().getPlayer(java.util.UUID.fromString(rec.challenger));
    challengee?.tell(Text.gray('Duel request expired.'));
    challenger?.tell(Text.gray('Your duel request expired.'));
    delete pending[uuid];
  }
});


 *  ────────────────────────────────────────────────────────── */

// ─────────────────────────────────────────────────────────────
//  Spit‑to‑Duel  •  server_scripts/dueling.js
// ─────────────────────────────────────────────────────────────
//  ▸ Players start a duel by spitting (spittingimage:spit) at
//    another player.
//  ▸ Target gets clickable [ACCEPT] / [DENY] chat buttons.
//  ▸ Deny → 60 s cooldown (requester can’t re‑offer).
//  ▸ Accept → both players are removed from their teams;
//              duel ends on first death and teams are restored.
// ─────────────────────────────────────────────────────────────


/**
 * 
 * const MS  = 1000
const ONE_MIN = 60 * MS

global.duelRequests  = new Map()   // key: target UUID → {requesterUUID, ts}
global.duelCooldowns = new Map()   // key: sorted “A|B” pair  → expiry time
global.activeDuels   = new Map()   // key: sorted “A|B” pair  → {teams:{}, players:[]}

const pair = (a, b) => [a, b].sort().join('|')

// Utility: clickable text component
function duelButtons(attacker, cmdAccept, cmdDeny) {
  return Text.gold(`${attacker.name.string} has challenged you to a duel! `)
      .append(Text.green('[ACCEPT]')
        .bold(true)
        .clickRunCommand(cmdAccept)
        .hover('Start the duel'))
      .append(Text.white(' '))
      .append(Text.red('[DENY]')
        .bold(true)
        .clickRunCommand(cmdDeny)
        .hover('Decline – 60 s cooldown'))
}

// ─────────────────────────────────────────────────────────────
//  1. Detect spit → offer duel
// ─────────────────────────────────────────────────────────────
EntityEvents.hurt(e => {
  //if (!e.source.player || !e.entity.player) return
  if (e.source.immediate.type !== 'spittingimage:spit') return

  const atk = e.source.player
  //const tgt = e.entity.player
  const tgt = e.entity
  const key = pair(atk.uuid, tgt.uuid)
  const now = Date.now()

  // 60 s denial cooldown
  if (global.duelCooldowns.get(key) > now) {
    atk.tell(Text.red('That player recently declined – try again later!'))
    return
  }
  // Already pending request?
  if (global.duelRequests.has(tgt.uuid)) {
    atk.tell(Text.red('That player already has a pending duel request.'))
    return
  }

  global.duelRequests.set(tgt.uuid, { requesterUUID: atk.uuid, ts: now })

  const acceptCmd = `/duel accept ${atk.uuid}`
  const denyCmd   = `/duel deny ${atk.uuid}`

  atk.tell(duelButtons(atk, acceptCmd, denyCmd))
  atk.tell(Text.gray(`Sent a duel request to ${tgt.name.string}.`))
})

// ─────────────────────────────────────────────────────────────
//  2. /duel accept|deny <requester>
// ─────────────────────────────────────────────────────────────
ServerEvents.commandRegistry(ev => {
  const { commands: C, arguments: A } = ev
  const uuidArg = A.UUID.create(ev)

  ev.register(
    C.literal('duel')
      .then(
        C.literal('accept')
          .then(C.argument('requester', uuidArg)
            .executes(ctx => {
              const tgt = ctx.source.playerOrException
              const reqUUID = uuidArg.getUuid(ctx, 'requester').toString()
              const req = global.duelRequests.get(tgt.uuid)
              if (!req || req.requesterUUID !== reqUUID) {
                tgt.tell(Text.red('No matching duel request found.'))
                return 0
              }
              const atk = tgt.level.getPlayerByUUID(reqUUID)
              if (!atk) {
                tgt.tell(Text.red('Requester went offline.'))
                global.duelRequests.delete(tgt.uuid)
                return 0
              }
              startDuel(atk, tgt)
              global.duelRequests.delete(tgt.uuid)
              return 1
            })
          )
      )
      .then(
        C.literal('deny')
          .then(C.argument('requester', uuidArg)
            .executes(ctx => {
              const tgt = ctx.source.playerOrException
              const reqUUID = uuidArg.getUuid(ctx, 'requester').toString()
              const req = global.duelRequests.get(tgt.uuid)
              if (!req || req.requesterUUID !== reqUUID) {
                tgt.tell(Text.red('No matching duel request found.'))
                return 0
              }
              const atk = tgt.level.getPlayerByUUID(reqUUID)
              if (atk) atk.tell(Text.red(`${tgt.name.string} declined your duel.`))
              tgt.tell(Text.gray('You declined the duel.'))
              global.duelRequests.delete(tgt.uuid)
              global.duelCooldowns.set(pair(reqUUID, tgt.uuid), Date.now() + ONE_MIN)
              return 1
            })
          )
      )
  )
})

// ─────────────────────────────────────────────────────────────
//  3. Start & track the duel
// ─────────────────────────────────────────────────────────────
function startDuel(a, b) {
  const id = pair(a.uuid, b.uuid)
  if (global.activeDuels.has(id)) return

  const teams = {}
  ;[a, b].forEach(p => {
    teams[p.uuid] = p.team ? p.team.name : null
    if (p.team) p.server.runCommandSilent(`/team leave "${p.username}"`)
    p.tags.add('in_duel')
  })

  global.activeDuels.set(id, { players: [a.uuid, b.uuid], teams: teams })
  a.tell(Text.gold('Duel started – fight!'))
  b.tell(Text.gold('Duel started – fight!'))
}

// ─────────────────────────────────────────────────────────────
//  4. End duel on first player death
// ─────────────────────────────────────────────────────────────
EntityEvents.death(e => {
  if (!e.entity.player) return
  const loser = e.entity.player
  const loserUUID = loser.uuid

  for (const [id, data] of global.activeDuels) {
    if (!data.players.includes(loserUUID)) continue

    const winnerUUID = data.players.find(u => u !== loserUUID)
    const level = loser.level
    const winner = level.getPlayerByUUID(winnerUUID)

    // Restore teams 1 tick after respawn (so player entity exists)
    loser.server.scheduleInTicks(1, () => {
      [loser, winner].forEach(p => {
        if (!p) return
        const prev = data.teams[p.uuid]
        if (prev) p.server.runCommandSilent(`/team join ${prev} "${p.username}"`)
        p.tags.remove('in_duel')
      })
      if (winner) winner.tell(Text.green('Duel finished!'))
      global.activeDuels.delete(id)
    })
    break
  }
})

// ─────────────────────────────────────────────────────────────
//  5. House‑keeping → purge expired cooldowns every 30 s
// ─────────────────────────────────────────────────────────────
ServerEvents.tick(e => {
  if (e.server.ticks % (20 * 30) !== 0) return
  const now = Date.now()
  for (const [k, expiry] of global.duelCooldowns)
    if (expiry <= now) global.duelCooldowns.delete(k)
})

 * 
 * 
 */
