



/**
 * 
 * @param {*} player Player to add the cooldown to
 * @param {*} skill_id Id of the skill. Ex. flickering_blade
 * @param {*} cooldown Length of the cooldown in TICKS
 */

let press_abilities = global.skillData.paint_key_abilities
let passive_abilities = global.skillData.paint_nonkey_ability
let all_abilities = press_abilities.concat(passive_abilities)


function _keyFor(player) {
    return String(player?.uuid)
}


function addSkillCooldown(player, skill_id, cooldown) {
    player.persistentData.putInt(`skill_cooldown:${skill_id}`, cooldown)
    if (player.persistentData.get('active_skill_cooldowns')) {
        player.persistentData.active_skill_cooldowns += 1
    } else {
        player.persistentData.putInt('active_skill_cooldowns', 1)
    }
    runAbilityAction(player, skill_id, 'hide')
}


function isSkillCoolingDown (player, skill_id) {
    if (!player.persistentData.get(`skill_cooldown:${skill_id}`)) {
        return false
    } else {
        return true
    }
}

ServerEvents.customCommand('all_skill_cooldowns', event => {
    let player = event.player;
    if (!player.persistentData.active_skill_cooldowns) return;
    all_abilities.forEach(ability => {
        if (isSkillCoolingDown(player, ability)) {
            player.tell(ability)
            player.tell(player.persistentData.get(`skill_cooldown:${ability}`))
        }
    })
    if (on_cooldown.length === 0) {
        player.tell('No skill cooldowns found.')
        return
    }
});

PlayerEvents.tick(event => {
    if (event.server.tickCount % 2 != 0) return
    let player = event.player
    if (!player?.persistentData) return
    if (!player.persistentData.active_skill_cooldowns) return
    if (player.persistentData.active_skill_cooldowns == 0) return
    all_abilities.forEach(ability => {
        if (isSkillCoolingDown(player, ability)) {
            if (player.persistentData.get(`skill_cooldown:${ability}`) >= 0) {
                player.persistentData.putInt(`skill_cooldown:${ability}`, player.persistentData.get(`skill_cooldown:${ability}`) - 2)
                //player.tell(`Ability: ${ability} Cooldown: ${player.persistentData.get(`skill_cooldown:${ability}`)}`)
            }
            if (player.persistentData.get(`skill_cooldown:${ability}`) <= 0) {
                removeSkillCooldown(player, ability)
            }
            
        }
    })
})




/**
 * 
 * @param {*} player player you are targeting
 * @param {*} skill_id Id of the skill. Ex. flickering_blade
 */
function removeSkillCooldown(player, skill_id) {
    player.persistentData.remove(`skill_cooldown:${skill_id}`)
    player.persistentData.active_skill_cooldowns -= 1
    if (player.persistentData.active_skill_cooldowns < 0) player.persistentData.active_skill_cooldowns = 0;
    runAbilityAction(player, skill_id, 'paint')
}

function getAbilityType(name) {
    let ks = global.skillData.paint_key_abilities || []
    let nks = global.skillData.paint_nonkey_ability || []
    return ks.includes(name) ? 'paint_key' : (nks.includes(name) ? 'paint_non_key' : 'unknown')
}


function reduceSkillCooldown(player, skill_id, value) {
    player.persistentData[`skill_cooldown:${skill_id}`] -= value
    if (player.persistentData[`skill_cooldown:${skill_id}`] <= 0) removeSkillCooldown(player, skill_id)
}
