let entity_schools = [
    'blood',
    'fire',
    'ice',
    'nature',
    'ender',
    'lightning',
    'holy',
    'evocation',
    'aqua',
    //'geo'
]

function mageChance(powerLevel) {
    let chance = 0.07 + (0.10*parseFloat(powerLevel))
    let roll = Math.random()
    return roll < chance
}

/**
 * Picks a random school that’s not in the 'exclude' list.
 */
function pickRandomSchool(exclude) {
    if (!exclude) exclude = [];
    let school;
    do {
      school = entity_schools[Math.floor(Math.random() * entity_schools.length)];
    } while (exclude.indexOf(school) !== -1);
    return school;
  }

function applySchool(ent, school, hideParticles) {
    if (hideParticles != true) {
        hideParticles = false
    }
    applyEffect(ent, `kubejs:${school}_mage`, 'infinite', 0, null, null, hideParticles)
    ent.tags.add(`${school}_mage`);
}

/**
 * Spawns random mage schools on an entity.
 * 
 * 1) Loop up to N times (maxSchools).
 * 2) Each loop iteration checks a random chance:
 *    - If chance fails, break out (stop).
 *    - If chance succeeds, increment the schoolCount.
 * 3) When done looping, add exactly 'schoolCount' distinct random schools to the entity.
 */
function addRandomSchools(entity, chance, maxSchools) {
  let schoolCount = 0;
  let mod = 1
  if (entity.tags.contains('boss')) {
        mod = 0.75
    }
  // 1) Attempt up to 'maxSchools' times:
  for (let i = 0; i < maxSchools; i++) {
    // 2) If chance fails, stop looping immediately.
    if (Math.random() > parseFloat(chance)*parseFloat(mod)) {
      break;
    }
    // Otherwise, we succeeded this iteration!
    schoolCount++;
  }

  // 3) Add exactly 'schoolCount' distinct schools to the entity.
  if (schoolCount > 0) {
    // Keep track of which schools we’ve already applied so we don’t repeat.
    let usedSchools = [];
    
    for (let i = 0; i < schoolCount; i++) {
      let randomSchool = pickRandomSchool(usedSchools);
      usedSchools.push(randomSchool);
      
      applySchool(entity, randomSchool);
    }
  }
}

EntityEvents.spawned(event => {
    if (!event.entity.isMonster()) return;
    //if (event.entity.type.toString().includes('creeper') && !event.entity.type.toString().includes('mutant')) return
    if (event.entity.tags.contains('boss')) return;
    let check = isMage(event.entity)
    if (check) return
        // Retrieve the global power level from the server's persistent data
    let power_level = event.server.persistentData.power_level
    if(!power_level && !power_level == 0) power_level = 1

    // Delay execution by 5 ticks to ensure entity tags and attributes are fully loaded
    Utils.server.scheduleInTicks(5, () => {
        if (!event.entity.alive) return;
        let mod = 1;
            
        if (event.entity.tags.contains('boss')) {
            mod = 0.75; // Reduce the chance for bosses to get magic abilities
        }

        // Calculate the base chance for this entity to become a magic user
        let chance = 0.07 + (0.10 * power_level * mod);

        if (event.server.persistentData.arcane_ascension == true) {
            chance = 1
        }
        // Generate a random roll (between 0 and 1)
        let roll = Math.random();    

        // If the roll is greater than the chance, the entity does not gain magic abilities
        if (roll > chance) return;
        // Tag the entity as a general mage

        // Select a random magic school for the entity
        let random_school = pickRandomSchool();
        applySchool(event.entity, random_school);

        // Initialize an exclusion list to prevent duplicate schools
        let exclude = [];
        exclude.push(random_school);

        // Determine the maximum number of schools this entity can receive
        let maxSchools = Math.max(1, power_level); // Minimum of 1 school

        // Iterate up to `maxSchools` times to apply additional magic schools
        for (let i = 0; i < maxSchools; i++) {
            let roll = Math.random(); // Generate a new roll for each school
            let chance = Math.min(0.75, 0.07 + (0.10 * power_level * mod)); // Cap chance at 75%

            // Stop adding schools if the roll fails
            if (roll > chance) break;

            // Pick a new magic school, ensuring it's not a duplicate
            let random_school = pickRandomSchool(exclude);
            applySchool(event.entity, random_school);
        }
        if (event.server.persistentData.nightmare_activated != true) {
            if (power_level >= 4 && power_level < 7) {
                superiorMage(event.entity)
            }
            if (power_level >= 7) {
                exaltedMage(event.entity)
            }
        } else {
            exaltedMage(event.entity)
        }

    });

});


function superiorMage (entity) {
    let valid = false
    entity_schools.forEach(school => {
        if (entity.tags.contains(`${school}_mage`)) {
            valid = true
            applySchool(entity, `superior_${school}`)
            entity.tags.add(`superior_mage`)
            Utils.server.runCommandSilent(`/effect clear ${entity.uuid} kubejs:${school}_mage`)
        }
    })
    if (!valid) {
        let exclude = [];
        // run between 1 and 3 times
        let maxSchools = Math.floor(Math.random() * 3) + 1
        //loop equal to the max schools
        for (let i = 0; i < maxSchools; i++) {
            let random_school = pickRandomSchool(exclude);
            exclude.push(random_school);
            applySchool(entity, random_school);
            applySchool(entity, `superior_${random_school}`)
            entity.tags.add(`superior_mage`)
            Utils.server.runCommandSilent(`/effect clear ${entity.uuid} kubejs:${random_school}_mage`)
        }

    }
}

function exaltedMage (entity) {
    let valid = false
    entity_schools.forEach(school => {
        if (entity.tags.contains(`${school}_mage`)) {
            valid = true
            applySchool(entity, `exalted_${school}`)
            entity.tags.add(`exalted_mage`)
            Utils.server.runCommandSilent(`/effect clear ${entity.uuid} kubejs:${school}_mage`)
        }
    })
    if (!valid) {
        let exclude = [];
        // run between 2 and 5 times
        let maxSchools = Math.floor(Math.random() * 5) + 2
        //loop equal to the max schools
        for (let i = 0; i < maxSchools; i++) {
            let random_school = pickRandomSchool(exclude);
            exclude.push(random_school);
            applySchool(entity, random_school);
            applySchool(entity, `exalted_${random_school}`)
            entity.tags.add(`exalted_mage`)
            Utils.server.runCommandSilent(`/effect clear ${entity.uuid} kubejs:${random_school}_mage`)
        }

    }
}





// Blacklisted spells that should not be cast by the AI. Contains summon_multiple spells and summon_once spells that are not intended for combat.
let blacklisted_spells = [
    'nocturnal_swarm',
    'summon_desert_dwellers',
    'mechanized_predator',
    'magnetron_deployment',
    'eternal_sentinel',
    'sword_of_the_ancients',
    'primal_pack'
]


function hasEffect_broad(entity, effect) {
    return entity.activeEffects.toString().includes(effect)
}






function mageCastHandler(caster, target, owner) {
    if (caster.tags.contains('mob_currently_casting')) return
    if (caster.persistentData.cast_cooldown == true) {
        //tell('cast cooldown')
        return
    }
    let type = ''
    if (!owner) {
        type = 'mob'
    } else {
        type = 'pet'
    }

    let chance = 0
    let power_level = Number(caster.server.persistentData.power_level)
    //tell(type)

    if (type == 'mob') {
        let mod = 1
        if (caster.server.persistentData.arcane_ascension == true) {
            mod = 2
        }
        chance = Number(0.05 + (mod * 0.02 * power_level))
        //tell(chance)
        if (caster.tags.contains('superior_mage')) {
            chance = chance*1.50
        } else if (caster.tags.contains('exalted_mage')) {
            chance = chance*2.5
        }


        if (target.rootVehicle) {
            if (target.rootVehicle.type == 'alexscaves:subterranodon') {
                chance = chance * 4
                target = target.rootVehicle
            }
        }
    } else {
        let creatureName = caster.type.split(':')[1]
        //tell(creatureName)
        let level = owner.persistentData[`${creatureName}_level`] + 1 || 1
        //tell(level)

        chance = Number(0.05 + (0.02 * level))
        //tell(`First Chance:${chance}`)
        if (hasEffect_broad(caster, 'mage')) {
            if (hasEffect_broad(caster, 'exalted')) {
                //tell('found exalted')
                chance = Number(chance) * 3.5
            } else if (hasEffect_broad(caster, 'superior')) {
                //tell('found superior')
                chance = Number(chance) * 2.25
            }
            
        }
        //tell(chance)
    }
    //tell(chance)
    let odds = Math.random()
    if (odds > Number(chance)) return;

    newMobRandomCast(caster, target);
}

function isMage(entity) {
    let schools = global.mage_effects
    let valid = false
    if (!entity || !entity.potionEffects) return valid
    schools.forEach(school => {
        if (entity.potionEffects.isActive(`kubejs:${school}_mage`)) {
            valid = true
        }
        spell_rarities.forEach(rarity => {
            if (entity.potionEffects.isActive(`kubejs:${rarity}_${school}_mage`)) {
                valid = true
            }
        })
    })
    return valid
}








PlayerEvents.tick(event => {
    if (event.server.tickCount % 200 != 0) return
    let schools = global.mage_effects
    let player = event.player
    schools.forEach(school => {
        if (player.potionEffects.isActive(`kubejs:${school}_mage`)) {
            Utils.server.runCommandSilent(`/effect clear ${player.username} kubejs:${school}_mage`)
        }
        spell_rarities.forEach(rarity => {
            if (player.potionEffects.isActive(`kubejs:${rarity}_${school}_mage`)) {
                Utils.server.runCommandSilent(`/effect clear ${player.username} kubejs:${rarity}_${school}_mage`)
            }
        })
    })
})




EntityEvents.hurt(event => {
    if (!event.entity) return;
    if (!event.source || !event.source.actual) return;
    let caster = null
    let player = null
    if (event.entity.isMonster() && event.source.player) {
        caster = event.entity
        player = event.source.player
    } else if (event.entity.player && event.source.actual.isMonster()) {
        caster = event.source.actual
        player = event.entity
    } else {
        return;
    }
    if (!isMage(caster)) return
    if (caster.tags.contains('mob_currently_casting')) return
    let target = player
    mageCastHandler(caster, target);
});