
/**
 * ItemEvents.rightClicked('kubejs:testing', event => {
    if (!event.server.persistentData.get('power_level')) {
        event.server.persistentData.putInt('power_level', 1)
    } else {
        event.server.persistentData.power_level += 1
    }
    if (event.server.persistentData.power_level > 10) {
        event.server.persistentData.power_level = 10
    }
    //Utils.server.tell('Power Level:'+event.server.persistentData.power_level)
})

 * 
 * 
 */



/** Spelltypes:
 *  - Short: Spells that are cast instantly
 *  - Long: Spells that have a cast time or are continuous
 * 
 *  'spell name': cast time in seconds
 * 
 */





/**
 * 
 * @param {*} entity entity that is getting the armor
 * @param {*} slot The slot the armor is being applied to. Can be 'head', 'chest', 'legs', or 'feet'
 */
function applyArmor(entity, slot) {
    let p = entity.server.persistentData.power_level
    let stack = global.ArmorPicker.pick(slot, p, { returnStack: true });
    if (stack == null) return
    entity.setItemSlot(slot, Item.of(stack.id))
}


function getArmor(entity, slot, lootboxRarity) {
    let p = entity.server.persistentData.power_level
    if (lootboxRarity) {
        p = lootboxRarity
    }
    let stack = global.ArmorPicker.pick(slot, p, { returnStack: true });
    if (stack == null) return
    return stack
}


/**
 * function valid_armor(entity, level)
 *  - For each slot theres a 5% chance per power level to give the entity a piece of armor 
 * 
 */
function power_level_armor(entity, level) {
    if (!level) level = 1
    let helmet_chance = modifiedChance(5, 7.5, level)
    let chestplate_chance = modifiedChance(5, 7.5, level)
    let leggings_chance = modifiedChance(5, 7.5, level)
    let boots_chance = modifiedChance(5, 7.5, level)

    if (helmet_chance) {
        applyArmor(entity, 'head')
    }
    if (chestplate_chance) {
        applyArmor(entity, 'chest')
    }
    if (leggings_chance) {
        applyArmor(entity, 'legs')
    }
    if (boots_chance) {
        applyArmor(entity, 'feet')
    }

    // 3% base chance + 2.7% per power level to drop armor
    let probability = power_level_probability(3, 2.7, level)/100
    entity.mergeNbt({
        ArmorDropChances: [probability, probability, probability, probability],
    })
}


let possible_entities = {
    gear: {
        'minecraft:zombie': 'melee',
        'minecraft:husk': 'melee',
        'minecraft:drowned': 'melee',
        'minecraft:zombified_piglin': 'melee',
        'minecraft:piglin': 'melee',
        'minecraft:piglin_brute': 'melee',
        'minecraft:skeleton': 'both',
        'minecraft:stray': 'both',
        'minecraft:wither_skeleton': 'both',
    },
    spellcasters: {
        'minecraft:skeleton': 'ranged',
        'minecraft:stray': 'ranged',
        'minecraft:illusioner': 'ranged',
        'minecraft:witch': 'ranged',
        'minecraft:pillager': 'ranged',
        'minecraft:zombie': 'melee',
        'minecraft:husk': 'melee',
        'minecraft:drowned': 'melee',
        'minecraft:evoker': 'melee',
        'minecraft:piglin': 'melee',
        'minecraft:zombified_piglin': 'melee',
        'minecraft:piglin_brute': 'melee',
    }
}



function applyGear(entity, power_level) {
    let valid = false
    Object.keys(possible_entities.gear).forEach(id => {
        if (entity.type === id.toString()) {
            valid = true
        }
    })
    if (!valid) return
    if(power_level == undefined) power_level = 0
    if (power_level > 10) power_level = 10
    
    power_level_armor(entity, Number(power_level))

    let odds = (0.10 * (Number(power_level) + 1))
    if (Math.random() > Number(odds)) return
    let choice = ''
    if (possible_entities.gear[entity.type] == 'ranged') {
        choice = 'bow'
    } 
    if (possible_entities.gear[entity.type] == 'melee') {
        choice = 'melee'
    }
    if (possible_entities.gear[entity.type] == 'both') {
        if (Math.random() > 0.3) {
            choice = 'bow'
        } else {
            choice = 'melee'
        }
    }

    if (choice == 'melee') {
        createRandomMeleeWeapon(entity)
        if (power_level < 5) {
            entity.mergeNbt({
                HandDropChances: [
                    0.0,
                    0.0

                ],
            })
        }
    } else if (choice == 'bow') {
        createRandomModularBow(entity)
        if (power_level < 5) {
            entity.mergeNbt({
                HandDropChances: [
                    0.0,
                    0.0
                ],
            })
        }
    }
}



function healthAdjust(entity) {
    if (entity.tags.contains('healthAdjusted')) return
    entity.tags.add('healthAdjusted')

    let bosses_killed = entity.server.persistentData.bosses_killed || 0
    let healthPerBoss = 5 // 5 health added per enemy, per boss killed
    let gameplay_mod_health = calculateGameplayMultiplierHealth(entity.server)

    //tell(gameplay_mod_health)
    if (!gameplay_mod_health || gameplay_mod_health < 1) gameplay_mod_health = 1
    let modifier = entity.maxHealth + bosses_killed * healthPerBoss
    //tell(modifier)
    modifier *= gameplay_mod_health
    let global_health_multiplier = entity.server.persistentData.global_health_multiplier || 1
    modifier *= global_health_multiplier
    
    Utils.server.runCommandSilent(`/attribute ${entity.uuid} minecraft:generic.attack_damage modifier add ${calculateGameplayMultiplierDamage(entity.server).toFixed(2)} add`)

    //tell(baseValue)
    //tell(value)
    entity.maxHealth = modifier
    entity.health = entity.maxHealth
}
    
 // Spawning the entity
EntityEvents.spawned(event => {
    if (event.entity.type.toString().includes('illageandspillage')) return
    //Utils.server.tell(event.entity.type)
    if (!event.entity.isMonster()) return
    if (!event.entity.pickable) return
    if (event.entity.player) return
    if (event.entity.tags.contains('boss')) return
    let entity = event.entity
    let server = event.server
    Utils.server.scheduleInTicks(1, () => {
        // if the entity is a melee entity OR a ranged entity, apply gear
        applyGear(entity, Number(server.persistentData.power_level))
        healthAdjust(entity)
    })
})


// Left number is the power level, right number is the number of bosses killed needed to reach that power level
let power_level_scale = {
    0: 0,
    1: 1,
    2: 2,
    3: 4,
    4: 8,
    5: 16,
    6: 32,
    7: 40,
    8: 45,
    9: 50,
    10: 55,
}


function calculatePowerLevel(server) {
    let bosses_killed = server.persistentData.bosses_killed || 0
    for (let level in power_level_scale) {
        if (bosses_killed >= power_level_scale[level]) {
            server.persistentData.putInt('power_level', level)
        }
    }
    return server.persistentData.power_level || 0
}



let old = 0
function updPower_Level(event) {
    for (let level in power_level_scale) {
        if (event.server.persistentData.bosses_killed >= power_level_scale[level]) {
            event.server.persistentData.power_level = level
        }
    }

    if(!old == event.server.persistentData.power_level) {
        event.server.players.forEach(player => {
            Utils.server.runCommandSilent(`/immersivemessages sendcustom ${player.username} {anchor:4, background:1, wrap:1, typewriter:1, align:0} 8 Power Level Adjusted: ${old || 0} -> ${event.server.persistentData.power_level}`)
            old = event.server.persistentData.power_level
        })
    }
}





EntityEvents.death(event => {
    if(!event.entity.tags.contains('boss')) return
    if(!event.source.player) return
    //event.source.player.tell(event.server.persistentData.bosses_killed)
    updPower_Level(event)
})




