let specialTameableMobs = [
    "alexsmobs:soul_vulture",
    "alexsmobs:anaconda",
    "alexsmobs:moose",
    "alexsmobs:rattlesnake",
    "alexsmobs:rhinoceros",
    "alexsmobs:tiger",
    "alexsmobs:tusklin",
    "alexsmobs:snow_leopard",
    "alexscaves:teletor",
    "alexsmobs:bone_serpent",
    "alexsmobs:enderiophage",
    "alexsmobs:emu",
    "iceandfire:dread_scuttler",
]


let all_pet_data = {
    tamed_rat: {
        id: 'rats:tamed_rat',
        tier: 1,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
    },
    crow: {//
        id: 'alexsmobs:crow',
        tier: 1,
        class_specialty: 'bloodripper',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'vortex_punch'
    },
    bald_eagle: {//
        id: 'alexsmobs:bald_eagle',
        tier: 1,
        class_specialty: 'none',
        command: 'EagleCommand',
        
        apex_predator_nbt: {
            'HasCap':1
        },
        special_spell: 'aqua_missiles',
        apex_name: 'apex_eagle'
    },
    capuchin_monkey: {//
        id: 'alexsmobs:capuchin_monkey',
        tier: 2,
        class_specialty: 'none',
        nbt: 'HasDart',
        command: 'Command',
        
        apex_predator_nbt: {
            'HasDart':1
        },
        special_spell: 'haste',
        apex_name: 'apex_monkey'
    },
    tarantula_hawk: {//
        id: 'alexsmobs:tarantula_hawk',
        tier: 3,
        class_specialty: 'none',
        command: 'Command',
        apex_predator_nbt: {},
        special_spell: 'poison_splash'
    },
    elephant: {//
        id: 'alexsmobs:elephant',
        tier: 2,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'oakskin'
    },
    komodo_dragon: {//
        id: 'alexsmobs:komodo_dragon',
        tier: 3,
        class_specialty: 'none',
        command: 'KomodoCommand',
        
        apex_predator_nbt: {
            'Saddle':1
        },
        special_spell: 'poison_breath',
        apex_name: 'apex_dragon'
    },
    kangaroo: {//
        id: 'alexsmobs:kangaroo',
        tier: 3,
        class_specialty: 'mercenary',
        NBTItems1: {
            1: 'minecraft:iron_sword',
            2: 'fantasy_weapons:weapon_wandering_wizard_sword',
            3: 'iceandfire:silver_sword',
            4: 'fantasy_weapons:weapon_crucible_greatsword',
            5: 'fantasy_weapons:weapon_royal_greatsword',
        },
        NBTItems2: {
            1: 'minecraft:golden_helmet',
            2: 'immersive_armors:steampunk_helmet',
            3: 'magistuarmory:face_helmet',
            4: 'armoroftheages:iron_plate_armor_head',
            5: 'born_in_chaos_v1:dark_metal_armor_helmet'
        },
        NBTItems3: {
            1: 'minecraft:leather_chestplate',
            2: 'immersive_armors:wooden_chestplate',
            3: 'minecraft:chainmail_chestplate',
            4: 'minecraft:iron_chestplate',
            5: 'born_in_chaos_v1:spiny_shell_armor_chestplate'
            
        },
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'flaming_strike'
    },
    gorilla: {//
        id: 'alexsmobs:gorilla',
        tier: 3,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {
            'Silverback':1
        },
        special_spell: 'stomp'
    },
    crocodile: {//
        id: 'alexsmobs:crocodile',
        tier: 4,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'root'
    },
    grizzly_bear: {//
        id: 'alexsmobs:grizzly_bear',
        tier: 4,
        class_specialty: 'none',
        command: 'BearCommand',
        
        apex_predator_nbt: {},
        special_spell: 'fire_breath'
    },
    caiman: {//
        id: 'alexsmobs:caiman',
        tier: 3,
        class_specialty: 'none',
        command: 'CaimanCommand',
        
        apex_predator_nbt: {},
        special_spell: 'ball_lightning'
        
    },
    soul_vulture: {//
        id: 'alexsmobs:soul_vulture',
        tier: 3,
        class_specialty: 'none',
        command: 'Command',
        apex_predator_nbt: {},
        special_spell: 'soul_siphon'
    },
    anaconda: {//
        id: 'alexsmobs:anaconda',
        tier: 3,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'poison_breath'
    },
    moose: {//
        id: 'alexsmobs:moose',
        tier: 4,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'charge'
    },
    rattlesnake: {//
        id: 'alexsmobs:rattlesnake',
        tier: 2,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'venomous_bite'
    },
    rhinoceros: {//
        id: 'alexsmobs:rhinoceros',
        tier: 4,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'charge'
    },
    tiger: {//
        id: 'alexsmobs:tiger',
        tier: 4,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'blood_step'
    },
    tusklin: {//
        id: 'alexsmobs:tusklin',
        tier: 4,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'charge'
    },
    snow_leopard: {//
        id: 'alexsmobs:snow_leopard',
        tier: 3,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'ice_breath'
    },
    bone_serpent: {//
        id: 'alexsmobs:bone_serpent',
        tier: 5,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'bone_shield'
    },
    enderiophage: {//
        id: 'alexsmobs:enderiophage',
        tier: 2,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'teleport'
    },
    emu: {//
        id: 'alexsmobs:emu',
        tier: 2,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {},
        special_spell: 'haste'
    },
    hippogryph: {//
        id: 'iceandfire:hippogryph',
        tier: 3,
        class_specialty: 'none',
        command: 'Command',
        
        apex_predator_nbt: {
            'Chested':1,
            'Armor':1,
            'Saddled':1
        },
        special_spell: 'fang_ward'
        
    },
    cockatrice: {//
        id: 'iceandfire:cockatrice',
        tier: 4,
        class_specialty: 'none',
        command: 'Command',
        apex_predator_nbt: {},
        special_spell: 'slow'
    },
    dread_scuttler: {//
        id: 'iceandfire:dread_scuttler',
        tier: 5,
        class_specialty: 'none',
        command: 'Command',
        apex_predator_nbt: {},
        special_spell: 'web'
    },
    subterranodon: {
        id: 'alexscaves:subterranodon',
        tier: 1,
        command: 'Command',
        apex_predator_nbt: {
            'AltSkin':2
        },
        special_spell: 'charge' 
    },
    vallumraptor: {
        id: 'alexscaves:vallumraptor',
        tier: 4,
        command: 'Command',
        apex_predator_nbt: {
            'AltSkin':2,
            'Elder':1
        },
        special_spell: 'blood_step',
        apex_name: 'apex_raptor'
    },
    tremorsaurus: {
        id: 'alexscaves:tremorsaurus',
        tier: 5,
        command: 'Command',
        
        apex_predator_nbt: {
            'AltSkin':2
        },
    },
    teletor: {
        id: 'alexscaves:teletor',
        tier: 3,
        command: 'Command',
        apex_predator_nbt: {
            'AltSkin':2
        },
        special_spell: 'teleport'
    }
}




/**
 * Selects the next unlocked pet (wrap-around ↑).
 * @param {Internal.ItemRightClickEvent|Internal.DataReceivedEvent|…} event
 */
function cyclePetsForward(event) {
  let player = event.player;
  let pData = player.persistentData;

  let defeated_pets = Object.keys(all_pet_data).filter(pet =>
    pData.getInt(`unlock_${pet}`) === 1
  );

  if (defeated_pets.length === 0) {
    player.tell("You have not unlocked any Pets yet!");
    return;
  }

  let currentIndex = (pData.current_pet ?? -1) + 1;
  let newIndex = currentIndex % defeated_pets.length;
  let selectedPet = defeated_pets[newIndex];

  updatePetSelection(event, selectedPet, newIndex);

  Utils.server.runCommandSilent(
    `/execute in ${event.level.dimension} run playsound minecraft:ui.loom.select_pattern ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 2`
  );
}

/**
 * Selects the previous unlocked pet (wrap-around ↓).
 * @param {Internal.ItemRightClickEvent|Internal.DataReceivedEvent|…} event
 */
function cyclePetsBack(event) {
  let player = event.player;
  let pData = player.persistentData;
  let defeated_pets = Object.keys(all_pet_data).filter(pet =>
    pData.getInt(`unlock_${pet}`) === 1
  );

  if (defeated_pets.length === 0) {
    player.tell("You have not unlocked any Pets yet!");
    return;
  }

  let currentIndex = (pData.current_pet ?? 0) - 1;
  let newIndex = (currentIndex + defeated_pets.length) % defeated_pets.length;
  let selectedPet = defeated_pets[newIndex];

  updatePetSelection(event, selectedPet, newIndex);

  Utils.server.runCommandSilent(
    `/execute in ${event.level.dimension} run playsound minecraft:ui.loom.select_pattern ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.4`
  );
}


/* ---------------------------------------------------------------------------*/
/* Internal helper – writes NBT, paints icon, plays sound.                    */
/* ---------------------------------------------------------------------------*/
function updatePetSelection(event, selectedPet, index) {
  let player = event.player;

  // Save the index and pet key
  player.persistentData.current_pet = index;
  player.persistentData.putString('chosen_pet', selectedPet);

  // Pretty name for chat/debug (optional)
  let formattedPetName = selectedPet
    .split('_')
    .map(w => w.charAt(0).toUpperCase() + w.slice(1))
    .join(' ');

  // Paint the HUD icon
  player.paint({
    painted_pet: {
      type: 'rectangle',
      x: -128,
      y: -64,
      w: 14,
      h: 14,
      draw: 'ingame',
      visible: true,
      alignX: 'right',
      alignY: 'bottom',
      texture: `kubejs:textures/beastmaster_icons/${selectedPet}.png`,
    },
  });
}

ItemEvents.firstRightClicked('kubejs:beastmaster_totem', event => {
    let player = event.player
    if (player.shiftKeyDown){
        player.swing()
        let hit = player.rayTrace(4, false)
        if(hit && hit.entity) return
        cyclePetsForward(event);
    } else {
        if (player.persistentData.pet_counter >= player.persistentData.max_pets) return;

        let selectedPet = player.persistentData.getString('chosen_pet');
        if (!selectedPet) {
            player.tell("No Pet selected!");
            return;
        }

        let petData = all_pet_data[selectedPet];
        if (!petData) {
            player.tell("Could not find pet data!");
            return;
        }

        //if (selectedPet === 'crow' && player.persistentData.get('symbiotic_ripper')) {
          //  let level = player.persistentData.symbiotic_ripper; //Bloodripper
            //let crowEffects = determineCrowEffects(player, level);
            //summonPetSpecial(player, petData.id, crowEffects, true, level);
       // } else {
            player.swing()
            let pet = summonPet(player, petData, true);
            
        //}
    }
});

ItemEvents.firstLeftClicked('kubejs:beastmaster_totem', event => {
    let player = event.player
    if (!player.shiftKeyDown) {
        let entities = event.server.entities.filter(entity => entity.tags.contains('tamed_beast') && entity.tags.contains(`Owner:${player.username}`))
        if (entities.length === 0) {
            player.tell("You have no pets summoned!");
            return;
        } else {
            for (let i = 1; i <= player.persistentData.max_pets; i++) {
                let check = checkPetSlot(player, i);
                //tell(`check: ${check}  i: ${i}`)
                if (check != 'null') {
                    resolveMissingPet(player, i)
                }
            }
        }

    } else {
        player.swing()
        let hit = player.rayTrace(2, false)
        if(hit && hit.entity){
            if(hit.entity.tags.contains('tamed_beast') && hit.entity.tags.contains(`Owner:${player.username}`)){
                hit.entity.kill()
                return
            }
        }
        
        cyclePetsBack(event);

    }
})

/**
 * PlayerEvents.tick(event => {
    if (event.server.tickCount % 40 !== 0) return;
    let player = event.player
    let data = player.persistentData

    if (data.pet_counter == 0) return;
    for(let i=1; i<=data.max_pets; i++){
        let pet_id = data[`pet_${i}`]
        if (pet_id == 'null' || !pet_id) continue;
        let pet = player.level.getEntity(pet_id)
        if (pet) {
            data.putString(`pet_${i}_dim`, pet.level.dimension)
            data.putInt(`pet_${i}_x`, Math.floor(pet.x))
            data.putInt(`pet_${i}_z`, Math.floor(pet.z))
            data.putInt(`pet_${i}_chunk_x`, Math.floor(pet.x / 16))
            data.putInt(`pet_${i}_chunk_z`, Math.floor(pet.z / 16))
            if (data[`pet_${i}_recovering`]) {
                data.remove(`pet_${i}_recovering`)
            }
        } else {
            if (data[`pet_${i}_recovering`]) continue;
            loadAndTeleportPet(player, i, pet_id)
        }
    }
})
 * 
 * function loadAndTeleportPet(player, petNum, petUUID) {
    let data = player.persistentData
    let dim = data[`pet_${petNum}_dim`]
    let storedX = data[`pet_${petNum}_x`]
    let storedZ = data[`pet_${petNum}_z`]
    let chunkXValue = data[`pet_${petNum}_chunk_x`]
    let chunkZValue = data[`pet_${petNum}_chunk_z`]
    let type = data[`pet_${petNum}_type`]

    data[`pet_${petNum}_recovering`] = true

    let ensureNumber = (value) => {
        if (value === null || value === undefined) return undefined;
        let num = typeof value === 'number' ? value : Number(value);
        return Number.isFinite(num) ? num : undefined;
    }

    let chunkX = ensureNumber(chunkXValue)
    let chunkZ = ensureNumber(chunkZValue)
    let baseX = ensureNumber(storedX)
    let baseZ = ensureNumber(storedZ)

    if (chunkX === undefined && baseX !== undefined) {
        chunkX = Math.floor(baseX / 16)
        data.putInt(`pet_${petNum}_chunk_x`, chunkX)
    }
    if (chunkZ === undefined && baseZ !== undefined) {
        chunkZ = Math.floor(baseZ / 16)
        data.putInt(`pet_${petNum}_chunk_z`, chunkZ)
    }

    let cleanup = () => {
        data.remove(`pet_${petNum}_recovering`)
    }

    let releaseChunk = () => {
        if (!dim || chunkX === undefined || chunkZ === undefined) return;
        Utils.server.scheduleInTicks(5, () => {
            Utils.server.runCommandSilent(`/execute in ${dim} run forceload remove ${chunkX} ${chunkZ}`)
        })
    }

    if (!dim || chunkX === undefined || chunkZ === undefined) {
        cleanup()
        resolveMissingPet(player, petNum, type)
        return;
    }

    Utils.server.runCommandSilent(`/execute in ${dim} run forceload add ${chunkX} ${chunkZ}`)

    if (type == 'alexscaves:subterranodon') {
        Utils.server.scheduleInTicks(10, () => {
            Utils.server.runCommandSilent(`/effect give ${petUUID} cofh_core:true_invisibility infinite 0 true`)
            Utils.server.runCommandSilent(`/kill ${petUUID}`)
            Utils.server.runCommandSilent(`/execute in ${dim} run stopsound ${player.username} * alexscaves:subterranodon_death`)
        })
        Utils.server.scheduleInTicks(20, () => {
            releaseChunk()
            cleanup()
            Utils.server.scheduleInTicks(1, () => {
                if (player.persistentData[`pet_${petNum}`] != 'null') return;
                summonPet(player, all_pet_data['subterranodon'], false);
            })
        })
        return;
    }

    let maxAttempts = 3
    let attemptTeleport = (attempt) => {
        Utils.server.scheduleInTicks(attempt === 0 ? 10 : 20, () => {
            Utils.server.scheduleInTicks(5, () => {
                let pet = player.level.getEntity(petUUID)
                if (pet) {
                    releaseChunk()
                    cleanup()
                    return;
                }
                if (attempt + 1 >= maxAttempts) {
                    releaseChunk()
                    cleanup()
                    resolveMissingPet(player, petNum, type)
                    return;
                }
                attemptTeleport(attempt + 1)
            })
        })
    }

    attemptTeleport(0)
}
 * 
 * 
 * 
 * 
 */


function checkPetSlot(player, slot) {
    return player.persistentData[`pet_${slot}`]
}







EntityEvents.death(event => {
    if (!event.entity.tags.contains('tamed_beast')) return
    if (event.entity.tags.contains('conjured')) return
    if (event.entity.tags.contains('tamed_rat')) return
    //console.log('Pet death detected')
    let player_username = event.entity.persistentData.getString('owner')
    let player = event.server.getPlayer(player_username)
    if (!player) return
    Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} irons_spellbooks:true_invisibility infinite 0 true`);
    let pet_slot = event.entity.persistentData.pet_slot
    player.persistentData[`pet_${pet_slot}`] = 'null'
    player.persistentData.pet_counter -= 1
    //event.entity.persistentData.remove('owner')
})



function petsCheckAndSet(player, creature) {
    for(let i=1; i<=player.persistentData.max_pets; i++) {
        let key = `pet_${i}`
        let old_pet = player.level.getEntity(player.persistentData[key])
        if (!old_pet) {
            player.persistentData[key] = "null"
        }
        if (player.persistentData[key] == 'null' || !player.persistentData[key]) {
            player.persistentData.putString(key, String(creature.uuid))
            player.persistentData.putString(`${key}_type`, creature.type.toString())
            player.tags.add(key)
            break;
        }
    }
}


function slotCheckAndSet(player, creature) {
    let username = player.username
    creature.persistentData.putString('owner', username)
    for (let i=1; i<=player.persistentData.max_pets; i++) {
        if(player.tags.contains(`pet_${i}`)){
            creature.persistentData.putString('pet_slot', `${i}`)
            player.tags.remove(`pet_${i}`)
            break;
        }
    }
}



function summonPet(player, petData, totemSummon) {
    if (player.cooldowns.isOnCooldown('kubejs:beastmaster_totem') && totemSummon) return
    if (player.persistentData.pet_counter >= player.persistentData.max_pets) {
        if (totemSummon) {
            player.tell("You have reached the maximum number of pets!");
        }
        return;
    }
    let creature = player.level.createEntity(petData.id);
    let creatureName = petData.id.split(':')[1];
    let username = player.username;
    let tier = petData.tier;

    let mergedNbt = {
        'Owner': username,
        'Tags': [`Owner:${username}`, `tamed_beast`],
        'DeathLootTable': 'minecraft:empty',
        PersistenceRequired: true
    };
    mergedNbt[petData.command] = 1
    if(player.persistentData.get(`apex_${creatureName}`) || player.persistentData.get(petData.apex_name)){
        Object.entries(petData.apex_predator_nbt).forEach(([key, value]) => {
            mergedNbt[key] = value;
        });
    }
    creature.mergeNbt(mergedNbt)
    petsCheckAndSet(player, creature)

    player.persistentData.pet_counter++
    creature.setPos(player.x, player.y, player.z)
    creature.spawn()

    if (creature.type.toString() == 'alexsmobs:crow' && player.persistentData.get('symbiotic_ripper')) {
        creature = bloodripperCrowInit(player, creature);
    } else {
        creature.setCustomName(`${player.username}'s ${creature.displayName.getString()}`)    
    }
    
    creature.persistentData.putString('owner', username)
    //Utils.server.runCommandSilent(`/effect give ${creature.uuid} runiclib:lava_walking infinite 0 true`); DOESN'T WORK
    Utils.server.runCommandSilent(`/effect give ${creature.uuid} minecraft:fire_resistance infinite 0 true`)
    Utils.server.runCommandSilent(`/effect give ${creature.uuid} kubejs:beast infinite 0 true`)
    Utils.server.scheduleInTicks(1, () => {
        let rand_uuid = generateUUID()
        let value = 0
        if (creature.type.toString() == 'alexscaves:subterranodon') {
            let level = player.persistentData.getInt(`${creatureName}_level`)
            value = (0.035*-1) + (0.005 * level)
        } else {
            value = 0.03
            if (specialTameableMobs.includes(creature.type.toString())) {
                specialMobTame(player, creature)
            }
        }
        Utils.server.runCommandSilent(`/attribute ${creature.uuid} minecraft:generic.movement_speed modifier add ${rand_uuid} "pet_speed" ${value} add`)

        if (player.persistentData.get(`exalted_${creatureName}`)) {
            let schools = global.mage_effects
            let random_school = schools[Math.floor(Math.random() * schools.length)]
            Utils.server.runCommandSilent(`/effect give ${creature.uuid} kubejs:exalted_${random_school}_mage infinite 0 true`)
        }



    })

    if (player.persistentData.get('marsupial_warmachine')) {
        Utils.server.scheduleInTicks(5, () => {
            marsupialWarmachine(player, creature, petData);
            let item = createRandomMeleeWeapon(creature)
        })
    }


    if (totemSummon) {
        let color1 = Math.floor(Math.random() * 10) + 1
        let color2 = Math.floor(Math.random() * 4) + 1
        let color3 = Math.floor(Math.random() * 7) + 1
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:spark ${color1} ${color2} ${color3} ${creature.x} ${creature.y+1} ${creature.z} 0.2 0.2 0.2 0.3 120`)
        creature.playSound('irons_spellbooks:entity.chain_lightning.lightning_chain', 10, 1)
        player.level.spawnLightning(creature.x, creature.y, creature.z, true)
        
        if (!player.isCreative()) {
            player.cooldowns.addCooldown('kubejs:beastmaster_totem', 100);
        }
    }
    
    
    Utils.server.scheduleInTicks(5, () => {
        slotCheckAndSet(player, creature)
    })

    let level = player.persistentData.getInt(`${creatureName}_level`) || 1
    creature.maxHealth = tier * 5 * level
    creature.health = creature.maxHealth

    Utils.server.scheduleInTicks(2, () => {
        handleAffinityGems(player).forEach(school => {
            applySchool(creature, school, true)
        })
    })

    reviseTamedPetGoals(creature)
    return creature
}

function nearestPet(player) {
    let max_pets = player.persistentData.max_pets
    let nearest = {}

    for (let i = max_pets; i > 0; i--) {
        let pet_uuid = player.persistentData[`pet_${i}`]
        if (pet_uuid == 'null' || !pet_uuid) continue
        let pet = player.level.getEntity(pet_uuid)
        if (!pet) continue
        let dist = player.distanceToEntity(pet)
        if (!nearest.distance || dist < nearest.distance) {
            nearest.distance = dist
            nearest.type = pet.type
            nearest.uuid = pet.uuid
        }
    }
    return nearest.uuid
}

function killAllPets(player) {
    let pets = player.level.entities.filter(entity => entity.tags.contains('tamed_beast') && 
    entity.tags.contains(`Owner:${player.username}`))

    pets.forEach(pet => {
        pet.kill()
    })
    for(let i = 1; i<=player.persistentData.max_pets; i++){
        player.persistentData.remove(`pet_${i}`)
    }

    player.persistentData.pet_counter = 0
    player.persistentData.bloodripper_crow_count = 0
}

ItemEvents.firstRightClicked('kubejs:pet_killer', event => {
    let player = event.player;
    killAllPets(player)

    player.tell("Your pets have been reset!");
    event.item.count -= 1;
});






EntityEvents.hurt(event => {
    if (!event.source) return
    if (!event.source.actual) return
    if (!event.entity.isPlayer()) return
    let player = event.entity
    let pets = player.level.entities.filter(ent => ent.persistentData && ent.persistentData.getString('owner') == player.username && ent.persistentData.getBoolean('pet_targeting') != true)
    if (pets.length == 0) return
    pets.forEach(pet => {
        pet.setTarget(event.source.actual)
        pet.persistentData.putBoolean('pet_targeting', true)
        Utils.server.scheduleInTicks(20, e => {
            if (event.source.actual.isAlive()) {
                e.repeating = true
                pet.setTarget(event.source.actual)
            } else {
                e.repeating = false
                pet.persistentData.putBoolean('pet_targeting', false)
                //console.log('pet targeting false')
            }
        })
    })
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let pets = event.source.player.level.entities.filter(ent => ent.persistentData && ent.persistentData.getString('owner') == event.source.player.username && ent.persistentData.getBoolean('pet_targeting') != true)
    if (pets.length == 0) return
    pets.forEach(pet => {
        pet.setTarget(event.entity)
        pet.persistentData.putBoolean('pet_targeting', true)
        Utils.server.scheduleInTicks(20, e => {
            if (event.entity.isAlive()) {
                e.repeating = true
                pet.setTarget(event.entity)
            } else {
                e.repeating = false
                pet.persistentData.putBoolean('pet_targeting', false)
                //console.log('pet targeting false')
            }
        })

    })
})





let spells = [
    'healing_circle',
    'blessing_of_life'
]



EntityEvents.hurt(event => {
    if (!event.entity) return;
    if (!event.source || !event.source.actual) return;
    let target = null
    let player = null
    if (event.entity.isMonster() && event.source.player) {
        target = event.entity
        player = event.source.player
    } else if (event.entity.player && event.source.actual.isMonster()) {
        target = event.source.actual
        player = event.entity
    } else {
        return;
    }


    let pets = event.level.entities.filter(ent => ent.persistentData.owner == player.username)
    pets.forEach(pet => {
        if (pet.tags.contains('mob_currently_casting')) return
        mageCastHandler(pet, target, player);
    })
    

        
    //tell(chance)
    //tell(odds)
    //if (odds > chance) return;
    //tell('Casting spell!')
    // Distance is from the player (event.entity) to the monster (event.source.actual).
    /**
     *     let distance = caster.distanceToEntity(target);
    let dist = '';
    if (distance > 8) {
        dist = 'any';
    } else if (distance > 4) {
        dist = 'close';
    } else {
        dist = 'very_close';
    }
     * 
     * 
     */

    
});

/**
 * EntityEvents.hurt('player', event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    let player = event.entity

    let spell = []
    spell.push(spells[Math.floor(Math.random() * spells.length)])
    event.level.entities.filter(entity => entity.tags.contains('tamed_beast') && entity.tags.contains(`Owner:${player.username}`)).forEach(pet => {
        let valid = false
        let level = 0
        if (pet.tags.contains('holy_mage')) {
            valid = true
            level = 1
        } else if (pet.tags.contains('superior_holy_mage')) {
            valid = true
            level = 2
        } else if (pet.tags.contains('exalted_holy_mage')) {
            valid = true
            level = 3
        }
        if (!valid) return
        let chance = 0.055 * level
        if (player.health < player.maxHealth * 0.25) {
            chance = chance * (1+level)
        }
        if (Math.random() > chance) return
        randomCast(pet, spell, player, level)
    })
})
 * 
 * 
 */



EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.source.actual.tags.contains('tamed_beast')) return
    let chance = 0.40
    if (chance < Math.random()) return
    applyStackingEffect(event.entity, 'kubejs:hexed', 100, 1)
    event.entity.tags.add(`hexer:${event.source.actual.uuid}`) // Add a tag to the entity that was hexed, so we can track who hexed it
})

EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.entity.tags.contains(`hexer:${event.source.actual.uuid}`)) return
    if (!event.entity.potionEffects.isActive('kubejs:hexed')) return
    Utils.server.runCommandSilent(`/effect clear ${event.entity.uuid} kubejs:hexed`)
    event.entity.tags.remove(`hexer:${event.source.actual.uuid}`) // Remove the tag from the entity that was hexed
})



let selectPetsTags = [
    'tamed_beast',
    'specter'
]

function selectAllPets(player) {
    return player.level.entities.filter(entity => entity.tags.contains('tamed_beast') && entity.tags.contains(`Owner:${player.username}`))
}





EntityEvents.spawned('alexsmobs:grizzly_bear', event => {
    change_size(event.entity, 1.25)
})





/**
 * 
 * @param {*} entity Entity that is having its size changed
 * @param {*} size Size multiplier. For example, 1.25 = 25% increase
 * @param {*} duration Optional: duration until the entities size returns to normal. Dont input if permanent size increase
 * @returns 
 */
function change_size (entity, size, duration) {
    if (entity.tags.contains('size_increased')) return
    entity.tags.add('size_increased')
    Utils.server.scheduleInTicks(1, () => {
        Utils.server.runCommandSilent(`/scale delay set pehkui:height 0 ${entity.uuid}`)
        Utils.server.runCommandSilent(`/scale delay set pehkui:width 0 ${entity.uuid}`)
        Utils.server.runCommandSilent(`/scale multiply pehkui:height ${size} ${entity.uuid}`)
        Utils.server.runCommandSilent(`/scale multiply pehkui:width ${size} ${entity.uuid}`)
        if (!duration) return
        Utils.server.scheduleInTicks(duration, () => {
            Utils.server.runCommandSilent(`/scale reset ${entity.uuid}`)
        })
    })

}


// Helper: prefer saved chunk coords; if missing, compute from block coords once and cache.
function getChunkXZ(data, i) {
  let cx = data[`pet_${i}_chunk_x`]
  let cz = data[`pet_${i}_chunk_z`]
  if (typeof cx === 'number' && typeof cz === 'number') return [cx, cz]

  let x = data[`pet_${i}_x`]
  let z = data[`pet_${i}_z`]
  if (typeof x === 'number' && typeof z === 'number') {
    // bitshift handles negatives correctly and is equivalent to Math.floor(x/16)
    cx = x >> 4
    cz = z >> 4
    data.putInt(`pet_${i}_chunk_x`, cx)
    data.putInt(`pet_${i}_chunk_z`, cz)
    return [cx, cz]
  }
  return [undefined, undefined]
}




/**
 * 
 * @param {*} effect The effect is from this: player.activeEffects.forEach(effect => {
 * @returns Returns id, duration (in ticks), amplifier. Get like this: parseEffectLine(effect).id
 */
function parseEffectLine(effect) {
  // remove quotes and trim
  let txt = String(effect).replace(/^['"]|['"]$/g, '').trim()

  // split into "effect.minecraft.slow_falling x 5" and "Duration 131"
  let [left, right] = txt.split(',').map(s => s.trim())

  // extract duration (after "Duration ")
  let duration = right.split(' ')[1]
  

  // remove leading "effect." and split by "."
  let parts = left.replace('effect.', '').split('.')
  let ns = parts[0]
  let rest = parts[1]

  // check if there's an amplifier ("x N")
  let amp = 0
  if (left.includes(' x ')) {
    let splitX = left.split(' x ')
    rest = splitX[0].split('.')[2] // effect.minecraft.<id>
    amp = parseInt(splitX[1].split(' ')[0]) - 1 // convert level to amp
  } else {
    rest = parts[1]
  }
  let id = `${ns}:${rest}`
  //tell(amp)
  //tell(duration)
  //tell(id)
  return {id: id, duration: duration, amplifier: amp}
  /**
   *   return {
    id: `${ns}:${rest}`,
    amplifier: amp,
    duration
  }
   * 
   */

}

function swapEffects(entity, target) {
    entity.activeEffects.forEach(effect => {
        let potionEffect = parseEffectLine(effect)
        //tell(`Applying ${potionEffect.id}`)
        applyEffect(target, potionEffect.id, potionEffect.duration, potionEffect.amplifier)
    })
}





ServerEvents.customCommand('pet_counter', event => {
    tell(event.player.persistentData.pet_counter)

})





PlayerEvents.tick(event => {
  // Run every 40 ticks (~2s)
  if (event.server.tickCount % 100 !== 0) return
  let player = event.player
  let data = player.persistentData

  if (data.pet_counter == 0) return

  // How long to keep the chunk force-loaded before removing (in ticks)


  // Live refs to pets found this tick
  let pets = {}

  for (let i = 1; i <= data.max_pets; i++) {
    let pet_id = data[`pet_${i}`]
    // Fast path: if the pet is already loaded in the player's current dimension
    let pet = player.level.getEntity(pet_id)
    if (pet) {
        //tell(`pet found`)
        //tell(i)
        //tell(`${player.persistentData[`pet_${i}`]}`)

      // Cache last-known info for recovery
      data.putString(`pet_${i}_dim`, pet.level.dimension)
      data.putInt(`pet_${i}_x`, Math.floor(pet.x))
      data.putInt(`pet_${i}_z`, Math.floor(pet.z))
      // Compute chunk coords ONCE here and cache
      data.putInt(`pet_${i}_chunk_x`, (Math.floor(pet.x)) >> 4)
      data.putInt(`pet_${i}_chunk_z`, (Math.floor(pet.z)) >> 4)
      pets[`pet_${i}`] = pet

      if (pet.distanceToEntity(player) >= 100) {
        resolveMissingPet(player, i)
      }
    } else {
        let check = checkPetSlot(player, i)
        if (check != 'null') {
            resolveMissingPet(player, i)
        }
        
    }

  }
})




function resolveMissingPet(player, petNum) {
    let data = player.persistentData
    let i = petNum
    let CLEANUP_TICKS = 80 // ~3s; raise if needed
    //tell(`pet not found`)
        // Missing/unloaded pet: force-load its last-known chunk via commands and try to recover
        let dim_id = String(data[`pet_${i}_dim`])
        //tell(dim_id)
        //tell(dim_id)
        let x = data[`pet_${i}_x`]
        //tell(x)
        let z = data[`pet_${i}_z`]
        //tell(z)
        //if (!dim_id || typeof x !== 'number' || typeof z !== 'number') continue

        // 1) Force-load the chunk in the correct dimension via vanilla commands
        
        Utils.server.runCommandSilent(`/execute in ${dim_id} run forceload add ${x} ${z}`)
        //tell('force loading chunk')
        //tell(i)
        //tell(`${player.persistentData[`pet_${i}`]}`)
        let dim = player.server.getLevel(dim_id)
        if (!dim) return
        let uuid = player.persistentData[`pet_${i}`]
        // 2) Give the server a tick to deserialize entities, then search by UUID
        player.server.scheduleInTicks(1, () => {            
            let ent = dim.getEntity(uuid)
            if (!ent) return
            let entType = ent.type.split(':')[1]
            //tell(entType)
            ent.kill()
            Utils.server.scheduleInTicks(2, () => {
                let petData = all_pet_data[entType];
                summonPet(player, petData, false)

            })
            //tell(`p_test: ${p_test}`)
            // 3) Cleanup: remove the force-load after a short delay
            player.server.scheduleInTicks(CLEANUP_TICKS, () => {
                Utils.server.runCommandSilent(`/execute in ${dim_id} run forceload remove ${x} ${z}`)
                //tell('unloading chunk')
            })
        })
}