
/**
 * Nightmare mode: Doubles or Triples the amount of monsters that spawn 
 * 
 * 
 */




function nightmareCount(server) {
    let counter = 0
    server.players.forEach(player => {
        if (player.persistentData.nightmare == 1) counter++
    })
    if (counter >= server.players.length / 2) {
        server.persistentData.putBoolean('nightmare_activated', true)
        //Utils.server.tell(`§4NIGHTMARE §fmode activated`)
    } else {
        server.persistentData.putBoolean('nightmare_activated', false)
        //Utils.server.tell(`§4NIGHTMARE §fmode deactivated`)
    }
}

ServerEvents.commandRegistry(event => {
    let { commands: Commands } = event;
    
    event.register(
        Commands.literal('nightmare') // The name of the command
            .requires(source => source.hasPermission(2)) // Ensure only players can execute
            .executes(c => {
                let player = c.source.player;
                if (!player) {
                    Utils.server.tell(`§4NIGHTMARE §fThis command can only be run by a player.`);
                    return 0;
                }
                nightmare(player);
                return 1;
            })
    );
    
    // Define the nightmare function after usage to avoid hoisting issues
    function nightmare(player) {
        let current = player.persistentData.getInt("nightmare") || 0;
        if (current === 1) {
            player.persistentData.putInt("nightmare", 0);
        } else {
            player.persistentData.putInt("nightmare", 1);
        }
        nightmareCount(player.server);
    }
});






/**
 * 
 * ServerEvents.customCommand('nightmare', event => {
    if (event.player.persistentData.nightmare == 1) {
        event.player.persistentData.nightmare = 0
    } else {
        event.player.persistentData.nightmare = 1
    }
    // if half or more of the players have nightmare mode on, then add the boolean persistent data "nightmare_activated"
    nightmareCount(event.server)
})
 */


