


const spell_rarities = [
    'superior', 'exalted'
]

function newMobRandomCast(entity, target) {
    let schools = global.mage_effects
    let mage_schools = []
    let mage_schools_rarity = []
    schools.forEach(school => {
        if (entity.potionEffects.isActive(`kubejs:${school}_mage`)) {
            mage_schools.push(school)
            mage_schools_rarity.push(`lesser_${school}`)
        }
        spell_rarities.forEach(rarity => {
            if (entity.potionEffects.isActive(`kubejs:${rarity}_${school}_mage`)) {
                if (!mage_schools.includes(school)) {
                    mage_schools.push(school)
                }
                
                mage_schools_rarity.push(`${rarity}_${school}`)
            }
        })
    })
    //tell(mage_schools)
    //tell(mage_schools_rarity)
    // Build a flat list of spells for all detected schools
    let valid_spells = getSpellsBySchool(mage_schools)
    // Dedupe in case of overlap across schools
    valid_spells = Array.from(new Set(valid_spells))
    //tell(distance)
    let distance = entity.distanceToEntity(target);
    let dist = ''
    if (distance > 8) {
        dist = 'any';
    } else if (distance > 4) {
        dist = 'close';
    } else {
        dist = 'very_close';
    }
    valid_spells = distanceSpells(dist, valid_spells)
    valid_spells = filterSpellsByRarity(valid_spells, mage_schools_rarity)
    
    //valid_spells = spells.filter(spell => (!global.spells[spell].restricted))
    let spells = []
    valid_spells.forEach(spell => {
        if (!global.spells[spell].restricted) spells.push(spell)
    })
    //tell(spells)
    //tell(valid_spells)
    //tell(entity)
    //let spells = global.spells
    //tell(spells)
    let power_level = Utils.server.persistentData.power_level
    if (!power_level)   power_level = 1
    //let 
    //Utils.server.tell(spells)
    let spellcast_cap = power_level
    if (spellcast_cap > 4) {
        spellcast_cap = 4
    }
    
    castSpell(entity, spells, target, power_level, spellcast_cap, `${entity.type} casted a spell with castSpell`)
}



function getSpellsBySchool (schools)  {
    // Iterate over the entries in new_spells and return the object keys
    return Object.entries(global.spells)
        .filter(([key, spell]) => schools.includes(spell.school))
        .map(([key, spell]) => key);
};

function filterSpellsByRarity (spells, mage_schools_rarity) {
    if (!Array.isArray(spells) || spells.length === 0) return []
    if (!Array.isArray(mage_schools_rarity) || mage_schools_rarity.length === 0) return []

    // Define tier caps per rarity
    let rarityCap = {
        lesser: 2,
        superior: 4,
        exalted: Infinity
    }

    // Build the highest tier cap per school from the provided rarity tags
    let maxTierBySchool = {}
    mage_schools_rarity.forEach(tag => {
        // Expect tags like: 'lesser_fire', 'superior_ender', 'exalted_ice'
        // Be defensive in parsing
        if (typeof tag !== 'string') return
        let parts = tag.split('_')
        if (parts.length < 2) return
        let rarity = parts[0].toLowerCase()
        let school = parts.slice(1).join('_').toLowerCase()
        let cap = rarityCap[rarity]
        if (cap === undefined) return

        let prev = maxTierBySchool[school]
        if (prev === undefined || cap > prev) {
            maxTierBySchool[school] = cap
        }
    })

    // Now filter the input spell keys against the computed caps
    let filtered = []
    spells.forEach(spellKey => {
        let data = global.spells[spellKey]
        if (!data) return
        let school = (data.school || '').toLowerCase()
        let cap = maxTierBySchool[school]
        if (cap === undefined) return // pet doesn't have this school
        if (cap === Infinity || (typeof data.tier === 'number' && data.tier <= cap)) {
            filtered.push(spellKey)
        }
    })

    return filtered
}





// Unified caster for spells: takes an array of candidate spells and a count
// of how many unique spells to cast (randomly chosen, no repeats). Instant
// spells still repeat internally but only count as one selection.
function castSpell(caster, spells, target, spell_level, numToCast, logSource) {
    try {
        if (!caster) return
        if (!global || !global.spells) return

        // Always expect an array of spell keys
        let input = Array.isArray(spells) ? spells.slice() : []
        if (input.length === 0) return

        if (logSource) {
            //console.log(`castSpell -> source: ${logSource}, pool: ${JSON.stringify(input)}, picks: ${numToCast}`)
        }

        // Helper: fetch spell data safely
        let getInfo = (key) => {
            let info = global.spells[key]
            return info && typeof info === 'object' ? info : null
        }

        // Helpful spells that should target/assist the pet's owner
        let helpfulSet = new Set(['healing_circle', 'blessing_of_life'])
        let isPet = false
        // Resolve owner target (for pets)
        let resolveOwner = () => {
            let ownerName = caster.persistentData ? caster.persistentData.owner : null
            if (!ownerName && caster.tags) {
                try {
                    let ownerTag = caster.tags.find(t => String(t).startsWith('Owner:'))
                    if (ownerTag) ownerName = String(ownerTag).split(':')[1]; isPet = true
                } catch (e) {}
            }
            return ownerName ? caster.server.getPlayer(ownerName) : null
        }

        // Minimal facing helper (uses repeatFacing if available)
        let faceFor = (c, t, ticks) => {
            if (!t) return
            if (typeof repeatFacing === 'function') {
                repeatFacing(c, t, ticks + 1)
                return
            }
            // one-time face fallback
            try {
                if (typeof Vec3d !== 'undefined') {
                    c.lookAt('eyes', new Vec3d(t.x, t.y + t.eyeHeight - 0.25, t.z))
                }
            } catch (e) {}
        }

        // Ensure a positive spell level and cap later per spell
        let baseLevel = Number(spell_level) || 1

        // Build a unique, valid pool (ignore restricted)
        let poolSet = new Set()
        for (let key of input) {
            let info = getInfo(key)
            if (!info) continue
            if (info.restricted) continue
            poolSet.add(key)
        }
        let pool = Array.from(poolSet)
        if (pool.length === 0) return

        // Decide how many unique spells to cast
        let picks = Math.max(0, Number(numToCast) || 0)
        if (picks > pool.length) picks = pool.length
        if (picks === 0) return

        // Shuffle pool and take first N unique selections
        for (let i = pool.length - 1; i > 0; i--) {
            let j = Math.floor(Math.random() * (i + 1))
            let tmp = pool[i]; pool[i] = pool[j]; pool[j] = tmp
        }
        let selected = pool.slice(0, picks)

        caster.tags.add('mob_currently_casting')
        let cumulative = 0

        // Build the full execution queue, expanding instant spells for internal repeats
        /** @type {Array<{key:string, info:any, repeats:number, instant:boolean}>} */
        let exec = []
        for (let key of selected) {
            let info = getInfo(key)
            if (!info) continue
            //let instant = (Number(info.cast_time) || 0) < 0.20
            //let repeats = instant ? (Math.floor(Math.random() * 3) + 2) : 1 // 2–4 bursts for instant spells
            exec.push({ key: key, info: info, repeats: 1, instant: 0.3 })
        }
        if (exec.length === 0) {
            caster.tags.remove('mob_currently_casting')
            return
        }

        // Schedule each cast in order
        for (let { key, info, repeats, instant } of exec) {
            let baseTicks = Math.max(1, Math.round((Number(info.cast_time) || 0.25) * 30))
            for (let r = 0; r < repeats; r++) {
                let thisStart = cumulative
                let thisTicks = baseTicks

                Utils.server.scheduleInTicks(thisStart, () => {
                    // Determine actual target per cast
                    let t = target
                    let ownerAssist = false
                    if (caster.tags && caster.tags.contains('tamed_beast') && helpfulSet.has(key)) {
                        let owner = resolveOwner()
                        if (owner) {
                            //tell(owner)
                            t = owner
                            ownerAssist = true
                        }
                    }

                    // Face target appropriately for the cast time
                    faceFor(caster, t, thisTicks + 1)

                    // If assisting owner, try to teleport near them (same-dimension only)
                    if (ownerAssist && t && t.level && caster.level && t.level.dimension === caster.level.dimension) {
                        try {
                            // Offset a touch so we don't overlap exactly
                            let ox = (Math.random() - 0.5) * 1.5
                            let oz = (Math.random() - 0.5) * 1.5
                            caster.setPos(t.x + ox, t.y, t.z + oz)
                        } catch (e) {}
                    }

                    // Compute level cap
                    let castLevel = baseLevel
                    if (typeof info.max_level === 'number' && castLevel > info.max_level) {
                        castLevel = info.max_level
                    }
                    if (instant && repeats > 1) {
                        // mimic original randomCast: slight downscale on burst casts
                        castLevel = Math.max(0, castLevel - 1)
                    }

                    // Execute the cast command in the caster's dimension
                    let dim = caster.level ? caster.level.dimension : 'minecraft:overworld'
                    let spellID = info.id
                    Utils.server.scheduleInTicks(2, () => {
                        if (castLevel <= 0) {
                            Utils.server.runCommandSilent(`/execute in ${dim} run cast ${caster.uuid} ${spellID}`)
                        } else {
                            Utils.server.runCommandSilent(`/execute in ${dim} run cast ${caster.uuid} ${spellID} ${castLevel}`)
                        }
                    })
                })

                // Advance timeline; keep instant repeats tight
                cumulative += thisTicks + (instant ? 1 : 2)
            }
        }

        caster.persistentData.putBoolean('cast_cooldown', true)
        //console.log(`Casting spells: ${spells} from source: ${logSource}`)
        let dur = 400
        if (isPet) {
            dur = 200
        }
        // Clear casting tag once all scheduled casts have finished
        Utils.server.scheduleInTicks(cumulative, () => {
            caster.tags.remove('mob_currently_casting')
            Utils.server.scheduleInTicks(dur, () => {
                caster.persistentData.putBoolean('cast_cooldown', false)
            })
        })
    } catch (e) {
        try { console.log(`castSpell error: ${e}`) } catch (_) {}
    }
}


EntityEvents.death(event => {
    if (!event.entity.persistentData.get('cast_cooldown')) return
    event.entity.persistentData.remove('cast_cooldown')
})

/**
 * Makes one entity face another entity by setting its yaw and pitch.
 *
 * @param {Entity} looking - The entity that will face the other entity.
 * @param {Entity} looked_at - The entity to be faced.
 */

function faceEntity(looking, looked_at) {
    let x = looked_at.x
    let y = looked_at.y+looked_at.eyeHeight
    //tell(y)
    let z = looked_at.z
    looking.lookAt("eyes", new Vec3d(x, y, z));
}

function repeatFacing(caster, target, durationTicks) {
    // if target is null or undefined, get the nearest player
    if (!target) {
        target = caster.level.getNearestPlayer(caster, 100)
    }
    faceEntity(caster, target);
    let count = 0;
    Utils.server.scheduleInTicks(1, e => {
        if (count <= durationTicks) {
            faceEntity(caster, target);
            count++;
            e.repeating = true;
        } else {
            e.repeating = false;
        }
    });
}
