let synergy_list = {
    'monstrosities + shroudwalkers': 'Mutant enderman are also shroudwalkers',
    'monstrosities + undead_feast': 'Mutant zombies also have life steal',
    'monstrosities + death_snare': 'Mutant skeletons also pull you towards them',
    'monstrosities + corrupted_kin': 'Mutant mobs have a 75% chance (instead of 50% from corrupted kin) to spawn instead of their normal counterparts',

    'tempestborn + vexsplosion': 'vexs spawn charged creepers instead of TNT',

    'veiled_broodlings + arachnophobia': 'When invisible cave spiders hit you, there is a 50% chance to not remove their invisibility',

    'deep_abyss + undead_feast': 'Drowned gain life steal',
    'deep_abyss + ravenous_horde': 'drowned also gain the effects of ravenous horde',

    'beast_riders + arcane_ascension': 'Mounts spawn as spellcasters',

    'screeching_shadows + shroudwalkers': 'Phantoms have a chance to teleport when hit',
    'shroudwalkers + veiled_broodlings': 'Cave spiders apply blindness when they hit you',

    'icebound + death_snare': 'All arrows have a chance to freeze you. Slowness from Death Snare starts after the freeze effect ends.',
    
    'brute_force + piglin_rage': 'Piglin Rage and Brute Force apply to all piglins',
    
    'arcane_ascension + unending_horde': 'Summon Spells from Unending Horde will be cast 1 - 2 more times',


}



let gameplay_modifiers = {
    'beastriders': {
        multiplier : 1.25,
        synergies : [
            'arcane_ascension', // Mounts spawn as spellcasters // 
        ]
    }, // Vanilla monsters have a chance to spawn with a Mount
    'arcane_ascension': {
        multiplier: 1.20,
        synergies: [
            'unending_horde', // They will cast 1 - 2 more summon spells
        ]
    }, // All mobs spawn as spellcasters and have a higher chance to cast spells
    'ironclad': {
        multiplier : 1.05,
        synergies : []
    }, 
    'arachnophobia': {
        multiplier : 1.15,
        synergies : [
            'veiled_broodlings', //

        ]
    }, // Spiders spawn small and fast cave spiders on death // 

    'monstrosities': {
        multiplier : 1.20,
        synergies : [
            'shroudwalkers', // Mutant enderman are also shroudwalkers
            'undead_feast', // undead feast also applies to mutants
            'death_snare', // Mutant skeletons also pull you towards them
            'corrupted_kin', // Mutant mobs have a 75% chance (instead of 50% from corrupted kin) to spawn instead of their normal counterparts
        ]
    }, // Mutants spawn with more life and special abilities
    'ravenous_horde': {
        multiplier : 1.15,
        synergies : [
            'deep_abyss', // Drowned also get the effects of ravenous horde
        ]
    }, // Hitting a zombie empowers nearby zombies
    'undead_feast': {
        multiplier : 1.25,
        synergies : [
            'deep_abyss', // Drowned gain life steal
        ]
    }, // Zombies spawn with life steal

    'icebound': {
        multiplier : 1.05,
        synergies : [
            'death_snare', // All arrows have a chance to freeze you. Slowness from Death Snare starts after the freeze effect ends.
        ]
    }, // Strays have a high chance to freeze you

    'death_snare': {
        multiplier : 1.15,
        synergies : [
        ]
    }, // Arrows shot by skeletons pull you towards them on hit and apply slow

    'piglin_rage': {
        multiplier : 1.05,
        synergies : [
            'brute_force', //Piglin Rage and Brute Force apply to all piglins
        ]
    }, // Nearby Zombified Piglins gain a speed buff when you attack one of them

    'brute_force': {
        multiplier : 1.05,
        synergies : [
        ]
    }, // Piglin Brutes deal more damage and knock you back further

    'tempestborn': {
        multiplier : 1.30,
        synergies : [
            'vexsplosion',
        ]
    }, // All Creeper types spawn charged

    'vexsplosion': {
        multiplier : 1.10,
        synergies : [
            'tempestborn', // vexs spawn charged creepers instead of TNT
        ]
    }, // Vexs drop lit tnt on death

    'shroudwalkers': {
        multiplier : 1.15,
        synergies : [
            'veiled_broodlings', // Cave spiders apply blindness when they hit you // 
            'screeching_shadows', // Phantoms have a chance to teleport when hit
        ]
    }, // Endermen give you darkness when they hit you, strength when you hit them, and teleport around you more frequently

    'corrupted_kin': {
        multiplier : 1.40,
        synergies : [

        ]
    }, // Mutants spawn in place of their normal counterparts 50% of the time

    'veiled_broodlings': {
        multiplier : 1.20,
        synergies : [
        ]
    }, // Cave spiders spawn with invisibility. It is removed upon attacking a player

    'deep_abyss': {
        multiplier : 1.15,
        synergies : [
        ]
    }, // All Drowned spawn with Tridents. Tridents pull you towards them on hit

    'mob_menagerie': {
        multiplier : 1.15,
        synergies : []
    }, // Monster spawns are randomized and include a much wider variety of mobs, including ones from other dimensions

    'eyes_within_the_stone': {
        multiplier : 1.10,
        synergies : []
    }, // mining too much will spawn a cave dweller nearby 

    'screeching_shadows': {
        multiplier : 1.15,
        synergies : [
        ]
    }, // phantoms are smaller, faster, and will duplicate if they hit you
    
    'event_horizon': {
        multiplier : 1.05,
        synergies : []
    }, // When a mob dies, it has a 3% chance to leave behind a blackhole that is alive for 10 seconds

    'weeping_fate': {
        multiplier : 1.03,
        synergies : []
    }, // Ghasts have a chance to teleport away when hit, taking no damage

    'unending_horde': {
        multiplier : 1.15,
        synergies : [
        ]
    }, // All monsters have a high chance to cast a summon spell when they are low health
    'critical_mass': {
        multiplier : 1.05,
        synergies : []
    }, // When a creeper dies, there is a 0.1% chance it will spawn a nuke
    'bone_brigade': {
        multiplier : 1.10,
        synergies : []
    }, // Skeletons have a chance to not spawn and instead spawn 5 "special" skeletons instead. 

    'blood_moon': {
        multiplier : 1.15,
        synergies : []
    }, // At night, monsters spawn with Speed, Strength, and Regeneration.

    'glass_bones': {
        multiplier : 1.05,
        synergies : []
    }, // Fall damage is increased by 5x

    'pyromania': {
        multiplier : 1.05,
        synergies : []
    }, // You are ignited when you are hit for 3 seconds

}

const entity_money_blacklist = [
    'iceandfire:ghost',
]

function calculateGameplayMultiplierHealth(server) { // Health
    let active = Object.keys(gameplay_modifiers)
  .filter(mod => server.persistentData.get(mod) && server.persistentData.getBoolean(mod));


    let healthMult = 1;

    for (let mod of active) {
      let m = gameplay_modifiers[mod].multiplier;
      healthMult += (m - 1) / 2;
    }
  
    return healthMult;
  }

function calculateGameplayMultiplierDamage(server) { // Damage
    let active = Object.keys(gameplay_modifiers)
  .filter(mod => server.persistentData.get(mod) && server.persistentData.getBoolean(mod));


    let damageMult = 1;

    for (let mod of active) {
      let m = gameplay_modifiers[mod].multiplier;
      damageMult += (m - 1) / 3;
    }
  
    return damageMult;
  }

function calculateGameplayMultiplier(server) { // Coins
    let active = Object.keys(gameplay_modifiers)
  .filter(mod => server.persistentData.get(mod) && server.persistentData.getBoolean(mod));

    
    let remaining = new Set(active);
    let factors = [];
  
    //Check for synergies
    for (let mod of active) {
      if (!remaining.has(mod)) continue;
  
      //Find one other mod it lists in its synergies
      let partner = gameplay_modifiers[mod].synergies.find(
        other => remaining.has(other)
      );
  
      if (partner) {
        //We have a pair → take both out and push their product once
        remaining.delete(mod);
        remaining.delete(partner);
        let m1 = gameplay_modifiers[mod].multiplier;
        let m2 = gameplay_modifiers[partner].multiplier;
        factors.push(m1 * m2);
      }
    }
  
    //Any mods left over get pushed as solo multipliers
    for (let solo of remaining) {
      factors.push(gameplay_modifiers[solo].multiplier);
    }
  
    //Multiply them all together
    return factors.reduce((acc, m) => acc * m, 1);
}

function moneyOnKill(player, entity) {
    let mult = 1;
    if(entity.tags.contains('boss')) {
        mult = 4;
    } else if(entity.animal) {
        mult = 0.25
    }
    let power_level = player.server.persistentData.power_level || 1
    let range = Math.random() * (Number(power_level) - 1.5 + 1) + 1.5
    let random_mod = Math.random() * (1.5 - 0.55 + 1) + 0.55
    let night_mult = player.level.night ? 2 : 1
    let baseReward = Math.max(1, Math.floor((entity.maxHealth - 20) / 4) + 1);

    let total = Math.round(Math.max(baseReward, ((baseReward*0.80) + (range/2)) * night_mult * mult * random_mod) * calculateGameplayMultiplier(player.server))
    let totemCheck = skillTotemCheck(player, 'bounty_hunter')
    if (totemCheck) {
        let level = totemCheck
        // 20% more per level
        total = Math.round(total * (1 + (0.20 * level)))
    }

    addMoney(player, total)
    
    //player.tell(`Total is: ${total}`)
}


function addMoney(player, amount) {
    if (player.potionEffects.isActive('kubejs:plunder')) {
        let chance = 0.5
        if (player.potionEffects.isActive('minecraft:luck')) {
            chance = 0.75
        }
        if (Math.random() < chance) {
            amount = Math.round(amount * 1.5)
        }
    }
    Utils.server.runCommandSilent(`/sdmshop add ${player.username} ${Number(amount)}`)
    Utils.server.runCommandSilent(`/immersivemessages sendcustom ${player.username} {anchor:'CENTER_CENTER', size: 0.75,y:-30} 0.75 §e+${Number(amount)}`)
}





EntityEvents.death(event => {
    if (!event.source.player) return
    if (isAlly(event.source.player, event.entity)) return
    if (event.entity.player) return
    if (entity_money_blacklist.includes(event.entity.type)) return
    moneyOnKill(event.source.player, event.entity)
})

SDMShopEvents.sellEntry(event => {
    let player = event.player
    let curios = skillTotemCheck(player, 'merchant')
    if (!curios) return
    let price = event.getPrice()
    let mult = 0.5
    //Total is price * multiplier rounded up to the nearest integer
    let total = Math.round(price * mult)
    Utils.server.runCommandSilent(`/sdmshop add ${player.username} ${total}`)
})

SDMShopEvents.buyEntry(event => {
    switch(event.getPrice()) {
        case 0: Utils.server.runCommandSilent(`/ftbquests change_progress ${event.player.username} complete 708B4CAC16014507`)
            break;
        case 1000: Utils.server.runCommandSilent(`/ftbquests change_progress ${event.player.username} complete 625553459BCD4D25`)
            break;
    }
})




