﻿
function createRandomMeleeWeapon(entity) {
    let roll = Math.random(); // 0.0–1.0
    let category;

    if (roll < 0.5) {
        category = 'regular';              // 50%
    } else if (roll < 0.8) {
        category = 'two_handed';           // next 30% (0.5–0.8)
    } else {
        category = 'handheld';             // final 20% (0.8–1.0)
    }
    // Choose a weapon type from the selected category
    let weaponTypes = Object.keys(modular_items_loottables[category]);
    let weaponType = weaponTypes[Math.floor(Math.random() * weaponTypes.length)];
    let weaponData = modular_items_loottables[category][weaponType];
    let blueprint = weaponData.blueprint.copy();
    let power_level = entity.server.persistentData.power_level
    
    // build NBT in a local string to avoid repeated toString()/parsing
    let nbt = blueprint.nbt.toString();

    let blade_material = getRandomMaterialForItemModule('blade', power_level);
    let blade_material_id = getMiapiMaterial(Item.of(blade_material));
    nbt = nbt.replace('weapon_material_placeholder', blade_material_id);
    
    if (weaponData.valid_handles) {
        let handle = weaponData.valid_handles[Math.floor(Math.random() * weaponData.valid_handles.length)];
        nbt = nbt.replace('handle_placeholder', handle);

        let handle_material = getRandomMaterialForItemModule('handle', power_level);
        let handle_material_id = getMiapiMaterial(Item.of(handle_material));
        nbt = nbt.replace('handle_material_placeholder', handle_material_id);
    }
    
    if (weaponData.valid_pommels) {
        let pommel = weaponData.valid_pommels[Math.floor(Math.random() * weaponData.valid_pommels.length)];
        nbt = nbt.replace('pommel_placeholder', pommel);

        let pommel_material = getRandomMaterialForItemModule('pommel', power_level);
        let pommel_material_id = getMiapiMaterial(Item.of(pommel_material));
        nbt = nbt.replace('pommel_material_placeholder', pommel_material_id);
    }

    if (weaponData.valid_guards) {
        let guard = weaponData.valid_guards[Math.floor(Math.random() * weaponData.valid_guards.length)];
        nbt = nbt.replace('guard_placeholder', guard);
        let guard_material = getRandomMaterialForItemModule('guard', power_level);
        let guard_material_id = getMiapiMaterial(Item.of(guard_material));
        nbt = nbt.replace('guard_material_placeholder', guard_material_id);
    }
    // assign once after all replacements
    blueprint.nbt = nbt;
    if (!entity.player) {
        if (entity.type != 'alexsmobs:kangaroo') {
            entity.setItemSlot('mainhand', blueprint)
            if (weaponData.canDualWield == 0) {
                return;
            } else if (weaponData.canDualWield == 1) {
                let chance = Math.random();
                let offhanditem = blueprint.copy()
                if (chance < 0.5) {
                    entity.setItemSlot('offhand', offhanditem)
                }
            } else if (weaponData.canDualWield == 2) {
                let offhanditem = blueprint.copy()
                entity.setItemSlot('offhand', offhanditem)
            }
        } else {
            return blueprint
        }
    } else {
        entity.give(blueprint)
        if (weaponData.canDualWield == 2) {
            entity.give(blueprint)
        }
    }
}

ServerEvents.customCommand('give_random_modular_melee', event => {
    if (!event.player) return
    let entity = event.player;
    createRandomMeleeWeapon(entity);
})


let __miapiMaterialCache = new Map()
let __miapiStatsCache = new Map()
let __materialPoolCache = new Map()

function createRandomModularBow(entity) {
  const weaponData = modular_items_loottables.ranged.bow;

  // ⬇️ only change: work on a fresh copy
  let blueprint = weaponData.blueprint.copy();   // <— was weaponData.blueprint

  const power = entity.server.persistentData.power_level;

  // Build NBT with a single conversion to string
  let nbt = blueprint.nbt.toString();
  let bow_handle_material = getRandomMaterialForItemModule('bow_handle', power);
  let bow_handle_material_id = getMiapiMaterial(Item.of(bow_handle_material));
  if (!bow_handle_material || !bow_handle_material_id) return
  nbt = nbt.replace('bow_handle_material_placeholder', bow_handle_material_id);

  let bow_handle = weaponData.valid_bow_handles[Math.floor(Math.random() * weaponData.valid_bow_handles.length)];
  if (!bow_handle) return
  nbt = nbt.replace('bow_handle_placeholder', bow_handle);

  let bow_arms_material = getRandomMaterialForItemModule('bow_arms', power);
  let bow_arms_material_id = getMiapiMaterial(Item.of(bow_arms_material));
  if (!bow_arms_material || !bow_arms_material_id) return
  nbt = nbt.replace('bow_arms_material_placeholder', bow_arms_material_id);
  let bow_arm = weaponData.valid_bow_arms[Math.floor(Math.random() * weaponData.valid_bow_arms.length)];
  nbt = nbt.replace('bow_arms_placeholder', bow_arm);

  let bow_string_material = getRandomMaterialForItemModule('bow_string', power);
  let bow_string_material_id = getMiapiMaterial(Item.of(bow_string_material));
  if (!bow_string_material || !bow_string_material_id) return
  nbt = nbt.replace('bow_string_material_placeholder', bow_string_material_id);
  let bow_string = weaponData.valid_bow_strings[Math.floor(Math.random() * weaponData.valid_bow_strings.length)];
  nbt = nbt.replace('bow_string_placeholder', bow_string);

  // assign once after all replacements
  blueprint.nbt = nbt;

  if (!entity.player) {
    entity.setItemSlot('mainhand', blueprint);
  } else {
    entity.give(blueprint);
  }
}

ServerEvents.customCommand('give_random_modular_bow', event => {
    if (!event.player) return
    let entity = event.player;
    createRandomModularBow(entity);
})


function createRandomModularCrossbow(entity) {
    const weaponData = modular_items_loottables.ranged.crossbow;
    
    // ⬇️ only change: work on a fresh copy
    let blueprint = weaponData.blueprint.copy();   // <— was weaponData.blueprint
    
    const power = entity.server.persistentData.power_level;
    
    // Build NBT with a single conversion to string
    let nbt = blueprint.nbt.toString();
    let crossbow_stock_material = getRandomMaterialForItemModule('crossbow_stock', power);
    let crossbow_stock_material_id = getMiapiMaterial(Item.of(crossbow_stock_material));
    nbt = nbt.replace('crossbow_stock_material_placeholder', crossbow_stock_material_id);
    let crossbow_stock = weaponData.valid_crossbow_stocks[Math.floor(Math.random() * weaponData.valid_crossbow_stocks.length)];
    nbt = nbt.replace('crossbow_stock_placeholder', crossbow_stock);

    let crossbow_arms_material = getRandomMaterialForItemModule('crossbow_arms', power);
    let crossbow_arms_material_id = getMiapiMaterial(Item.of(crossbow_arms_material));
    nbt = nbt.replace('crossbow_arms_material_placeholder', crossbow_arms_material_id);
    
    let crossbow_arm = weaponData.valid_crossbow_arms[Math.floor(Math.random() * weaponData.valid_crossbow_arms.length)];
    nbt = nbt.replace('crossbow_arms_placeholder', crossbow_arm);
    
    let crossbow_string_material = getRandomMaterialForItemModule('crossbow_string', power);
    let crossbow_string_material_id = getMiapiMaterial(Item.of(crossbow_string_material));
    nbt = nbt.replace('crossbow_string_material_placeholder', crossbow_string_material_id);
    let crossbow_string = weaponData.valid_crossbow_strings[Math.floor(Math.random() * weaponData.valid_crossbow_strings.length)];
    nbt = nbt.replace('crossbow_string_placeholder', crossbow_string);
    
    let crossbow_attachments_material = getRandomMaterialForItemModule('crossbow_attachments', power);
    let crossbow_attachments_material_id = getMiapiMaterial(Item.of(crossbow_attachments_material));
    nbt = nbt.replace('crossbow_attachments_material_placeholder', crossbow_attachments_material_id);
    let crossbow_attachment = weaponData.valid_crossbow_attachments[Math.floor(Math.random() * weaponData.valid_crossbow_attachments.length)];
    nbt = nbt.replace('crossbow_attachments_placeholder', crossbow_attachment);

    // assign once after all replacements
    blueprint.nbt = nbt;

    if (!entity.player) {
        entity.setItemSlot('mainhand', blueprint);
    } else {
        entity.give(blueprint);
    }
}

ServerEvents.customCommand('give_random_modular_crossbow', event => {
    if (!event.player) return
    let entity = event.player;
    createRandomModularCrossbow(entity);
})






/**
 * getMiapiMaterial(item | ItemStackJS | string) → String | null
 * Accepts:
 *   - vanilla registry id          → "minecraft:iron_ingot"
 *   - KubeJS ItemStackJS wrapper   → event.item, Item.of(…)
 * Returns:
 *   - "generated_item.many_more_ores_and_crafts.titanium_ingot"
 *   - "website-alexscaves_ferrouslime_ball"
 *   - null  (no material mapped)
 */
function getMiapiMaterial(input) {
  /* 1 ▸ normalise caller input */
  let jsStack = (typeof input === 'string') ? Item.of(input) : input;
  if (!jsStack || jsStack.empty) return null;

  /* 2 ▸ unwrap to the *vanilla* ItemStack MIAPI expects */
  let mcStack = jsStack;        // KubeJS 6 exposes this getter
  if (!mcStack) return null;                // safety on odd wrappers

  let cacheKey = jsStack.id ? jsStack.id : null;
  if (cacheKey && __miapiMaterialCache.has(cacheKey)) return __miapiMaterialCache.get(cacheKey);

  let mat = MaterialProperty.getMaterialFromIngredient(mcStack);
  let out = mat ? mat.getKey() : null;
  if (cacheKey) __miapiMaterialCache.set(cacheKey, out);
  return out;
}






let modular_items_loottables = {
    regular: {
        sword: {
            blueprint: Item.of('miapi:modular_sword', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"guard_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_sword\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"pommel_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.5,\"two_handed\":false,\"category\":\"sword\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:one_handed_rl\",\"swing_sound\":{\"id\":\"bettercombat:sword_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:one_handed_lr\",\"swing_sound\":{\"id\":\"bettercombat:sword_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:one_handed_swipe_horizontal_rl_hori\",\"swing_sound\":{\"id\":\"bettercombat:sword_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:one_handed_lr_rleg_lead\",\"swing_sound\":{\"id\":\"bettercombat:sword_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 1,
            valid_handles: [
                'handle_short',
                'handle_normal',
                'handle_long',
                
            ],
            valid_pommels: [
                'pommel_round',
                'pommel_cross',
                'pommel_socket',
                'pommel_spike',
            ],
            valid_guards: [
                'guard_normal',
                'guard_blocking',
                'guard_slim',
                'guard_socket',
                'guard_dual_socket',
            ]
        },
        longsword: {
            blueprint: Item.of('miapi:modular_longsword', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"guard_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_longsword\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"pommel_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.75,\"pose\":\"malfu_combat_animation:pose_two_handed_sword_fps_hold\",\"two_handed\":true,\"category\":\"claymore\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_slice_rl\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_slice_lr\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_slice_rl\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_up_lr\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_heavy_lr\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_heavy_rl\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 1,
            valid_handles: [
                'handle_short',
                'handle_normal',
                'handle_long',
                
            ],
            valid_pommels: [
                'pommel_round',
                'pommel_cross',
                'pommel_socket',
                'pommel_spike',
            ],
            valid_guards: [
                'guard_normal',
                'guard_blocking',
                'guard_slim',
                'guard_socket',
                'guard_dual_socket',
            ]
        },
        katana: {
            blueprint: Item.of('miapi:modular_katana', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"guard_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_katana\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"pommel_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.625,\"pose\":\"bettercombat:pose_two_handed_katana\",\"two_handed\":true,\"category\":\"katana\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_updown_slash_rl\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_updown_slash_lr\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_updown_slash_rl\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_downup_slash_lr\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_updown_slash_lr\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_downup_slash_rl\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_slash_rl\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_slash_lr\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_slash_rl\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_slash_lr\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"VERTICAL_PLANE\",\"damage_multiplier\":1.1,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_updown_slash_kendo\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"VERTICAL_PLANE\",\"damage_multiplier\":1.1,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_updown_slash_kendo\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_updown_slash_rl\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:katana_updown_slash_lr\",\"swing_sound\":{\"id\":\"bettercombat:katana_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 1,
            valid_handles: [
                'handle_short',
                'handle_normal',
                'handle_long',
                
            ],
            valid_pommels: [
                'pommel_round',
                'pommel_cross',
                'pommel_socket',
                'pommel_spike',
            ],
            valid_guards: [
                'guard_normal',
                'guard_blocking',
                'guard_slim',
                'guard_socket',
                'guard_dual_socket',
            ]
        },
        rapier: {
            blueprint: Item.of('miapi:modular_rapier', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"guard_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_rapier\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"pommel_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.625,\"two_handed\":false,\"category\":\"rapier\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":0.9,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:rapier_rl\",\"swing_sound\":{\"id\":\"bettercombat:rapier_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":0.9,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:rapier_lr\",\"swing_sound\":{\"id\":\"bettercombat:rapier_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":0.9,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:rapier_rl_down\",\"swing_sound\":{\"id\":\"bettercombat:rapier_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.2,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:rapier_lr_stab\",\"swing_sound\":{\"id\":\"bettercombat:rapier_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":0.9,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:rapier_lr\",\"swing_sound\":{\"id\":\"bettercombat:rapier_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 1,
            valid_handles: [
                'handle_short',
                'handle_normal',
                'handle_long',
                
            ],
            valid_pommels: [
                'pommel_round',
                'pommel_cross',
                'pommel_socket',
                'pommel_spike',
            ],
            valid_guards: [
                'guard_normal',
                'guard_blocking',
                'guard_slim',
                'guard_socket',
                'guard_dual_socket',
            ]
        },
        greatsword: {
            blueprint: Item.of('miapi:modular_greatsword', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"guard_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_greatsword\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"pommel_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.625,\"pose\":\"malfu_combat_animation:pose_two_handed_sword_fps_hold\",\"two_handed\":true,\"category\":\"claymore\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_slice_rl\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_slice_lr\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_slice_rl\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_up_lr\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_heavy_lr\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_heavy_rl\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 1,
            valid_handles: [
                'handle_short',
                'handle_normal',
                'handle_long',
                
            ],
            valid_pommels: [
                'pommel_round',
                'pommel_cross',
                'pommel_socket',
                'pommel_spike',
            ],
            valid_guards: [
                'guard_normal',
                'guard_blocking',
                'guard_slim',
                'guard_socket',
                'guard_dual_socket',
            ]
        },
        zweihander: {
            blueprint: Item.of('miapi:modular_greatsword', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"guard_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_zweihaender\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"pommel_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.625,\"pose\":\"malfu_combat_animation:pose_two_handed_sword_fps_hold\",\"two_handed\":true,\"category\":\"claymore\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_slice_rl\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_slice_lr\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_slice_rl\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_up_lr\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_heavy_lr\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:two_handed_heavy_rl\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 0,
            valid_handles: [
                'handle_short',
                'handle_normal',
                'handle_long',
                
            ],
            valid_pommels: [
                'pommel_round',
                'pommel_cross',
                'pommel_socket',
                'pommel_spike',
            ],
            valid_guards: [
                'guard_normal',
                'guard_blocking',
                'guard_slim',
                'guard_socket',
                'guard_dual_socket',
            ]
        },
        dagger: {
            blueprint: Item.of('miapi:modular_dagger', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"guard_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_dagger\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"pommel_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":1.875,\"two_handed\":false,\"category\":\"dagger\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"conditions\":[\"DUAL_WIELDING_SAME_CATEGORY\",\"MAIN_HAND_ONLY\"],\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.4,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:dual_handed_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 2,
            valid_handles: [
                'handle_short',
                'handle_normal',
                'handle_long',
                
            ],
            valid_pommels: [
                'pommel_round',
                'pommel_cross',
                'pommel_socket',
                'pommel_spike',
            ],
            valid_guards: [
                'guard_normal',
                'guard_blocking',
                'guard_slim',
                'guard_socket',
                'guard_dual_socket',
            ]
        },
        sickle: {
            blueprint: Item.of('miapi:modular_sickle', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"guard_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_sickle\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"pommel_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.5,\"two_handed\":false,\"category\":\"sickle\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":0.9,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:sickle_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":0.9,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_horizontal_left\",\"swing_sound\":{\"id\":\"bettercombat:sickle_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"conditions\":[\"DUAL_WIELDING_SAME_CATEGORY\",\"MAIN_HAND_ONLY\"],\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.2,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"bettercombat:dual_handed_slash_cross\",\"swing_sound\":{\"id\":\"bettercombat:sickle_slash\",\"volume\":1.0,\"pitch\":0.8,\"randomness\":0.1}},{\"conditions\":[\"DUAL_WIELDING_SAME_CATEGORY\",\"OFF_HAND_ONLY\"],\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.3,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"bettercombat:dual_handed_slash_uncross\",\"swing_sound\":{\"id\":\"bettercombat:sickle_slash\",\"volume\":1.0,\"pitch\":1.2,\"randomness\":0.1}}]}}'}"),
            canDualWield: 1,
            valid_handles: [
                'handle_short',
                'handle_normal',
                'handle_long',
                
            ],
            valid_pommels: [
                'pommel_round',
                'pommel_cross',
                'pommel_socket',
                'pommel_spike',
            ],
            valid_guards: [
                'guard_normal',
                'guard_blocking',
                'guard_slim',
                'guard_socket',
                'guard_dual_socket',
            ]
        }
    },
    handheld: {
        katar: {
            blueprint: Item.of('miapi:modular_katars', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"handheld_katar\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"iron\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.25,\"two_handed\":false,\"category\":\"dagger\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"conditions\":[\"DUAL_WIELDING_SAME_CATEGORY\",\"MAIN_HAND_ONLY\"],\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.4,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:dual_handed_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 2,
            valid_handles: [
                'handle_handheld',
            ],
        },
        gauntlet: {
            blueprint: Item.of('miapi:modular_gauntlets', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"handheld_gauntlets\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.25,\"two_handed\":false,\"category\":\"fist\",\"attacks\":[{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:fist_punch\",\"swing_sound\":{\"id\":\"bettercombat:fist_punch\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:fist_punch\",\"swing_sound\":{\"id\":\"bettercombat:fist_punch\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:fist_uppercut\",\"swing_sound\":{\"id\":\"bettercombat:fist_punch\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 2,
            valid_handles: [
                'handle_handheld',
            ],
        },
        tonfa: {
            blueprint: Item.of('miapi:modular_tonfa', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"handheld_tonfa\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.25,\"two_handed\":false,\"category\":\"dagger\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":100.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"conditions\":[\"DUAL_WIELDING_SAME_CATEGORY\",\"MAIN_HAND_ONLY\"],\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.4,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:dual_handed_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 2,
            valid_handles: [
                'handle_handheld',
            ],
        },
    },
    two_handed: {
        halberd: {
            blueprint: Item.of('miapi:modular_handle', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_halberd\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"iron\\\\\"}\"},\"subModules\":{}}}}',weapon_attributes:'{\"attributes\":{\"attack_range\":4.0,\"pose\":\"bettercombat:pose_two_handed_heavy\",\"two_handed\":true,\"category\":\"halberd\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":200.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_left\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_slow\",\"volume\":0.5,\"pitch\":1.1,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":200.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_slow\",\"volume\":0.5,\"pitch\":1.3,\"randomness\":0.1}},{\"hitbox\":\"VERTICAL_PLANE\",\"damage_multiplier\":1.6,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slam\",\"swing_sound\":{\"id\":\"bettercombat:claymore_slam\",\"volume\":0.5,\"pitch\":1.2,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":2.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_stab_left\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":0.7,\"pitch\":1.1,\"randomness\":0.1}}]}}'}"),
            canDualWield: 0,
            valid_handles: [
                'handle_polearm',
            ],
        },
        trident: {
            blueprint: Item.of('miapi:modular_trident', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_trident\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":3.375,\"pose\":\"\",\"two_handed\":false,\"category\":\"trident\",\"attacks\":[{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:trident_rl_stab\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:trident_rl_stabup\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:trident_lr_stab\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:trident_rl_stab\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:trident_lr_stab\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:trident_rl_stabup\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:trident_rl_stab\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 0,
            valid_handles: [
                'handle_polearm',
            ],
        },
        staff: {
            blueprint: Item.of('miapi:modular_scythe', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"quarterstaff\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"staff_butt\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":3.75,\"two_handed\":true,\"category\":\"battlestaff\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_rl\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_poke\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_lr\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_rl_style\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_lr\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 0,
            valid_handles: [
                'handle_polearm',
            ],
            valid_handles: [
                'handle_polearm',
            ],
        },
        scythe: {
            blueprint: Item.of('miapi:modular_scythe', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_scythe\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":3.75,\"pose\":\"bettercombat:pose_two_handed_scythe\",\"two_handed\":true,\"category\":\"scythe\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:scythe_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_left\",\"swing_sound\":{\"id\":\"bettercombat:scythe_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 0,
            valid_handles: [
                'handle_polearm',
            ],
        },
        naginata: {
            blueprint: Item.of('miapi:modular_naginata', "{Damage:0,miapi_modules:'{\"module\":\"handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_slim\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"weapon_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_katana\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"iron\\\\\"}\"},\"subModules\":{}}}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":3.625,\"pose\":\"malfu_combat_animation:leftside_polearm_pose\",\"two_handed\":true,\"category\":\"glaive\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:glaive_lr\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_quick\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:glaive_rl\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_quick\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:glaive_downup_lr\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_slow\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:glaive_downup_rl\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_slow\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:glaive_lr\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_quick\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:glaive_rl\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_quick\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:glaive_lr\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_quick\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"VERTICAL_PLANE\",\"damage_multiplier\":1.4,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:glaive_updown\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_slow\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.1,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:halberd_rl_stab\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_quick\",\"volume\":1.0,\"pitch\":1.2,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:glaive_rl\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_quick\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}"),
            canDualWield: 0,
            valid_handles: [
                'handle_polearm',
            ],
        },
    },
    ranged: {
        bow: {
            blueprint: Item.of('miapi:modular_bow', "{Damage:0,miapi_modules:'{\"module\":\"bow_handle_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"bow_handle_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"bow_arms_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"bow_arms_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"bow_string_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"bow_string_material_placeholder\\\\\"}\"},\"subModules\":{}}}}}}',weapon_attributes:'{\"attributes\":{\"attack_range\":1.25,\"two_handed\":true}}'}"),
            valid_bow_handles: [
                'bow_handle_sniper',
                'bow_handle_normal',
                'bow_handle_arrow_holder',
            ],
            valid_bow_arms: [
                'bow_arms_normal',
                'bow_arms_recurve',
                'bow_arms_long',
                'bow_arms_short',
            ],
            valid_bow_strings: [
                'bow_string_normal',
            ],
        },
        crossbow: {
            blueprint: Item.of('miapi:modular_crossbow', "{Damage:0,miapi_modules:'{\"module\":\"crossbow_stock_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"crossbow_stock_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"crossbow_arms_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"crossbow_arms_material_placeholder\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"crossbow_string_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"crossbow_string_material_placeholder\\\\\"}\"},\"subModules\":{}}}},\"-1\":{\"module\":\"crossbow_attachments_placeholder\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"crossbow_attachments_material_placeholder\\\\\"}\"},\"subModules\":{}}}}',weapon_attributes:'{\"attributes\":{\"attack_range\":1.25,\"two_handed\":true}}'}"),
            valid_crossbow_arms: [
                'crossbow_arms_normal',
                'crossbow_arms_short',
                'crossbow_arms_large',
            ],
            valid_crossbow_stocks: [
                'crossbow_stock_normal',
            ],
            valid_crossbow_strings: [
                'crossbow_string_normal',
            ],
            valid_crossbow_attachments: [
                'crossbow_attachments_sights',
            ]
        }
    }
}











let modular_materials = {
    materials: {
        metals: ['iceandfire:shiny_scales', 'twilightforest:knightmetal_ingot', 'iceandfire:silver_ingot', 'mythicupgrades:ruby_ingot', 'mythicupgrades:topaz_ingot', 'mythicupgrades:peridot_ingot', 'mythicupgrades:jade_ingot', 'mythicupgrades:aquamarine_ingot', 'mythicupgrades:sapphire_ingot', 'mythicupgrades:ametrine_ingot', 'create:andesite_alloy', 'create:zinc_ingot', 'eeeabsmobs:immortal_ingot'],
        wood: ['minecraft:oak_planks', 'minecraft:spruce_planks', 'minecraft:birch_planks', 'minecraft:jungle_planks', 'minecraft:acacia_planks', 'minecraft:dark_oak_planks', 'minecraft:mangrove_planks', 'minecraft:cherry_planks', 'minecraft:bamboo_planks', 'minecraft:crimson_planks', 'minecraft:warped_planks', 'blue_skies:bluebright_planks', 'blue_skies:starlit_planks', 'blue_skies:frostbright_planks', 'blue_skies:comet_planks', 'blue_skies:lunar_planks', 'blue_skies:dusk_planks', 'blue_skies:maple_planks', 'biomeswevegone:aspen_planks', 'biomeswevegone:baobab_planks', 'biomeswevegone:blue_enchanted_planks', 'biomeswevegone:cika_planks', 'biomeswevegone:cypress_planks', 'biomeswevegone:ebony_planks', 'biomeswevegone:fir_planks', 'biomeswevegone:florus_planks', 'regions_unexplored:magnolia_planks', 'regions_unexplored:maple_planks', 'regions_unexplored:mauve_planks', 'regions_unexplored:palm_planks', 'regions_unexplored:pine_planks', 'regions_unexplored:green_painted_planks', 'regions_unexplored:cyan_painted_planks', 'regions_unexplored:light_blue_painted_planks', 'regions_unexplored:magenta_painted_planks', 'regions_unexplored:brown_painted_planks'],
        stone: ['minecraft:quartz', 'minecraft:prismarine_shard', 'minecraft:nether_brick', 'alexscaves:galena', 'alexscaves:radrock', 'blue_skies:turquoise_cobblestone', 'blue_skies:lunar_cobblestone', 'minecells:prison_cobblestone', 'minecraft:cobblestone', 'minecraft:granite', 'minecraft:diorite', 'minecraft:andesite', 'minecraft:calcite', 'minecraft:dripstone_block', 'minecraft:deepslate', 'minecraft:cobbled_deepslate', 'minecraft:sandstone', 'minecraft:red_sandstone', 'minecraft:prismarine', 'minecraft:netherrack', 'minecraft:nether_bricks', 'minecraft:blackstone', 'minecraft:end_stone', 'minecraft:purpur_block', 'minecraft:redstone_block', 'minecraft:magma_block', 'minecraft:obsidian', 'minecraft:sculk'],
        crystals: ['minecraft:amethyst_cluster', 'minecraft:quartz', 'minecraft:diamond', 'minecraft:lapis_lazuli', 'minecraft:emerald', 'minecraft:amethyst_shard'],
        glass: ['minecraft:glass', 'minecraft:tinted_glass', 'minecraft:white_stained_glass', 'minecraft:light_gray_stained_glass', 'minecraft:gray_stained_glass', 'minecraft:black_stained_glass', 'minecraft:brown_stained_glass', 'minecraft:red_stained_glass', 'minecraft:orange_stained_glass', 'minecraft:yellow_stained_glass', 'minecraft:lime_stained_glass', 'minecraft:green_stained_glass', 'minecraft:cyan_stained_glass', 'minecraft:light_blue_stained_glass', 'minecraft:blue_stained_glass', 'minecraft:purple_stained_glass', 'minecraft:magenta_stained_glass', 'minecraft:pink_stained_glass'],
        bone: ['minecraft:bone', 'alexsmobs:shark_tooth', 'alexsmobs:serrated_shark_tooth', 'irons_spellbooks:frozen_bone', 'cataclysm:amethyst_crab_shell', 'alexscaves:corrodent_teeth'],
        rods: ['alexscaves:uranium_rod', 'irons_spellbooks:frosted_helve', 'minecraft:blaze_rod', 'minecraft:end_rod', 'born_in_chaos_v1:bone_handle'],
        ropes: ['minecraft:string', 'minecraft:weeping_vines', 'minecraft:twisting_vines', 'minecraft:vine', 'alexscaves:shadow_silk', 'alexscaves:archaic_vine', 'farmersdelight:rope', 'farmersdelight:straw', 'farmersdelight:canvas'],
    },
    valid: {
        handle: [
                'wood',
                'metals',
                'stone',
                'crystals',
                
                'bone',
                'rods',
        ],
        pommel: [
                'wood',
                'metals',
                'stone',
                'crystals',
                'bone',
                'rods',
                
        ],
        guard: [
                'wood',
                'metals',
                'stone',
                'crystals',
                
                'bone',
                
        ],
        blade: [
                'wood',
                'metals',
                'stone',
                'crystals',
                
                'bone',
                'rods',
        ],
        handheld: [
                'wood',
                'metals',
                'bone',
                'stone',
                'crystals',
                
        ],
        quarterstaff: [
                'wood',
                'metals',
                'bone',
                'stone',
                'crystals',
                
        ],
        bow_handle: [
            'wood',
            'metals',
            'bone',
            'stone',
            'crystals',
            
            'rods',
        ],
        bow_arms: [
            'wood',
            'metals',
            'bone',
            'stone',
            'crystals',
            
            'rods',
        ],
        bow_string: [
            'ropes',
            'crystals',
            'bone',
        ],
        crossbow_stock: [
            'wood',
            'metals',
            'bone',
            'stone',
            'crystals',
            
        ],
        crossbow_arms: [
            'wood',
            'metals',
            'bone',
            'stone',
            'crystals',
            
            'rods',
        ],
        crossbow_attachments: [
            'wood',
            'metals',
            'bone',
            'stone',
            'crystals',
            
        ],
        crossbow_string: [
            'ropes',
            
            'crystals',
            'bone',
        ],
    },


    power_level: {
        0: {
            max_stat: 5,
        },
        1: {
            max_stat: 5,
        },
        2: {
            max_stat: 5,
        },
        3: {
            max_stat: 6,
        },
        4: {
            max_stat: 6.5,
        },
        5: {
            max_stat: 7,
        },
        6: {
            max_stat: 7.5,
        },
        7: {
            max_stat: 8,
        },
        8: {
            max_stat: 9,
        },
        9: {
            max_stat: 10,
        },
        10: {
            max_stat: 11,
        }
    }
}


// kubejs/server_scripts/miapi_material_inspector.js
//
// ── Java handles ───────────────────────────────────────────────────────────

let Material         = Java.loadClass('smartin.miapi.modules.material.Material')         // interface

/* The exact field names used by miapi’s built-in materials                   */
let STAT_KEYS = [
  "hardness",
  "flexibility",
  "density",
  "durability",
  "mining_speed",
  "mining_level"
]

/** Returns an object {statName: number} – zeros are filtered out             */
function grabStats(item) {
  let key = item && item.id ? item.id : null
  if (key && __miapiStatsCache.has(key)) return __miapiStatsCache.get(key)
  let material = MaterialProperty.getMaterialFromIngredient(item)
  if (!material) return
  let out = {}
  for (let i = 0; i < STAT_KEYS.length; i++) {
    let k = STAT_KEYS[i]
    if (!k) continue
    let v = material.getDouble(k)
    if (typeof v === "number" && v !== 0) out[k] = v
  }
  if (key) __miapiStatsCache.set(key, out)
  return out
}

function returnStat(item, stat) {
  let material = MaterialProperty.getMaterialFromIngredient(item)
  if (STAT_KEYS.includes(stat) && material) {
    let value = material.getDouble(stat)
    if (material === null || value === undefined) return null
    return value !== 0 ? value : null
  } else {
    return null
  }
}




/**
 * 
 */
function getRandomMaterialForItemModule(itemModule, power_level) {
  /* ── grab the sub-module category ─────────────────────────── */
  let   valid_material_categories = modular_materials.valid[itemModule]
  if (!valid_material_categories) {
    //tell(`No valid material categories for ${itemModule}`)
    return []
  }
  //tell(`Valid material categories for ${itemModule}: ${valid_material_categories}`)
  /* ── make sure we’re working with an *array* ──────────────── */
  if (!Array.isArray(valid_material_categories)) {
    valid_material_categories = valid_material_categories
                                  .split(',')
                                  .map(s => s.trim())
                                  .filter(Boolean)
  }

  /* ── collect all materials from those categories ─────────── */
  if (power_level === undefined || power_level === null) {
    power_level = 0
  }
  let poolCacheKey = itemModule + '|' + power_level
  let cachedPool = __materialPoolCache.get(poolCacheKey)
  if (cachedPool) {
    if (cachedPool.length === 0) return []
    return cachedPool[Math.floor(Math.random() * cachedPool.length)]
  }

  let materials = []
  valid_material_categories.forEach(category => {
    if (modular_materials.materials[category])
      materials = materials.concat(modular_materials.materials[category])
  })
  /* ── power-level limits (unified min / max) ──────────────── */
  let max_stat = modular_materials.power_level[power_level].max_stat
  if (itemModule.toString().includes('bow')) {
    //allow higher stats for bows
    max_stat += 3
}

  /* ── filter out materials outside the allowed band ───────── */
  materials = materials.filter(matId => {
    let stats = grabStats(Item.of(matId))
    if (!stats) return false

    let values = [
      stats.hardness,
      stats.flexibility,
      stats.density
    ].filter(v => typeof v === 'number')
    return values.every(v => v <= max_stat)
  })

  /* ── pick one at random (or return [] if none qualify) ───── */
  if (materials.length === 0) {
    //tell(`No materials fit power level ${power_level}`)
    __materialPoolCache.set(poolCacheKey, [])
    return []
  }
  __materialPoolCache.set(poolCacheKey, materials.slice())
  let material = materials[Math.floor(Math.random() * materials.length)]
  return material
}




function getConnectedModulesForItemModule(itemModule) {
    let itemModuleParts = itemModule.split('_')
    let itemType = itemModuleParts[0]
    let connectedModules = modular_items_rework.melee[itemType][itemModule].connectedModules
    let randomParentModule = connectedModules[Math.floor(Math.random() * connectedModules.length)]
    return randomParentModule
}
