
/**
 * New Spells Explanation
 *  - id: the id used to cast the spell
 *  - cast_time: the time it takes to cast the spell. 0.15 is instant.
 *  - tier: the tier of the spell. Higher tiers are more powerful.
 *  - targeting: who the spell targets. 'enemy' for enemies, 'self' for the caster, 'ally' for allies
 *  - max_level: the maximum level the spell can be upgraded to
 *  - school: the school of magic the spell belongs to
 *  - distance: how far the spell can reach. 'any' for any distance, 'close' for a greater than 3 but less than 8 blocks, 'very_close' for 3 or less blocks
 * - use: what the spell does. 'damage' for dealing damage, 'movement' for moving the caster, 'empower' for empowering the caster, 'followup' for a spell that follows up another spell, 'reflect' for reflecting damage, 'summon_multiple' for summoning multiple entities, 'summon_once' for summoning a single entity, 'control' for controlling entities, 'hinder' for hindering entities, 'kill' for killing entities
 * - type: the type of spell. 'instant' for instant spells, 'charge' for spells that take time to cast, persistent spells for spells that you continuously cast
 * - use_cases: the use cases of the spell. 
 *   -> Offense: Casts at the enemy when the player attacks
 *   -> Defense: Casts at the enemy when the caster is attacked
 *   -> Support: Casts at the ally when the player is attacked
 */

let new_spells = global.spells






/*
PlayerEvents.tick(event => {
    if (event.player.tags.contains('casting')) return
    Object.keys(new_spells).forEach(spell => {
        if (event.player.potionEffects.isActive(`kubejs:${spell}`)) {
            let dur = event.player.potionEffects.getActive(`kubejs:${spell}`).duration;
            //tell(dur)
            let amp = event.player.potionEffects.getActive(`kubejs:${spell}`).amplifier;
            Utils.server.runCommandSilent(`/effect clear ${event.player.username} kubejs:${spell}`);
            let odds = dur / 100; // Convert duration to a percentage chance
            //tell(`Odds: ${odds}`);
            let chance = Math.random();
            //tell(`Chance: ${chance}`);
            if (chance < odds) {
                // Cast the spell
                speedyCast(event.player, spell, amp+1)
            }

        }
    })
})
*/


const speedyCastTrackers = new WeakMap()

function getPotionEffectId(effectInstance) {
    if (!effectInstance) return null
    let rawId = effectInstance.descriptionId || effectInstance.effect?.descriptionId
    if (!rawId || !rawId.startsWith('effect.')) return null
    let trimmed = rawId.substring('effect.'.length)
    let dotIndex = trimmed.indexOf('.')
    if (dotIndex === -1) return null
    let namespace = trimmed.substring(0, dotIndex)
    let path = trimmed.substring(dotIndex + 1).replace(/\./g, '_')
    return `${namespace}:${path}`
}

function queueSpeedyCast(player, effectId) {
    if (!player) return
    let tracker = speedyCastTrackers.get(player)
    if (!tracker) {
        tracker = new Set()
        speedyCastTrackers.set(player, tracker)
    }
    if (tracker.has(effectId)) return
    tracker.add(effectId)
    player.server.scheduleInTicks(1, () => attemptSpeedyCast(player, effectId, 0))
}

function attemptSpeedyCast(player, effectId, retries) {
    let tracker = speedyCastTrackers.get(player)
    const cleanup = () => tracker && tracker.delete(effectId)
    if (!player || !player.isAlive()) {
        cleanup()
        return
    }
    if (player.tags.contains('casting')) {
        if (retries >= 40) {
            cleanup()
            return
        }
        player.server.scheduleInTicks(5, () => attemptSpeedyCast(player, effectId, retries + 1))
        return
    }
    let effect = player.potionEffects.getActive(effectId)
    if (!effect) {
        cleanup()
        return
    }
    Utils.server.runCommandSilent(`/effect clear ${player.username} ${effectId}`)
    let spell = effectId.startsWith('kubejs:') ? effectId.substring('kubejs:'.length) : null
    if (!spell || !new_spells[spell]) {
        cleanup()
        return
    }
    let odds = effect.duration / 100
    if (Math.random() < odds) {
        speedyCast(player, spell, effect.amplifier + 1)
    }
    cleanup()
}

PlayerEvents.tick(event => {
    if (event.server.tickCount % 5 !== 0) return
    let player = event.player
    if (!player || !player.isAlive()) return
    if (!player.potionEffects?.map || player.potionEffects.map.size == 0) return
    //tell('pass1')
    player.potionEffects.map.forEach(effectInstance => {
        let effectId = getPotionEffectId(effectInstance)
        //tell(effectId)
        if (!effectId || !effectId.startsWith('kubejs:')) return
        let spell = effectId.substring('kubejs:'.length)
        if (!new_spells[spell]) return
        queueSpeedyCast(player, effectId)
    })
})




/**
 * 
 * @param {*} caster The entity that will cast the spell
 * @param {*} spells ARRAY: The spells to cast
 * @param {*} target Which entity to target
 * @param {*} spell_level The level of the spells
 */
function newCast(caster, spells, target, spell_level, logSource, ownerBool) {
    if (logSource) {
        //console.log(`Casting spells: ${spells} from source: ${logSource}`);
    }
    caster.tags.add('mob_currently_casting')
    let cumulativeCooldown = 0;
    spells.forEach(spell => {
        let boolean = false
        let spellInfo = {}
        if (new_spells.hasOwnProperty(spell)) {
            boolean = true
            spellInfo = new_spells[spell];
        }
        if (!boolean) return
        let castTime = spellInfo.cast_time*20;
        let spellID = spellInfo.id;
        let cast_level = spell_level;
        let targeting = spellInfo.targeting;
        if (spell_level > spellInfo.max_level) {
            cast_level = spellInfo.max_level;
        }
        Utils.server.scheduleInTicks(cumulativeCooldown, () => {
            switch(targeting){
                case 'enemy': repeatFacing(caster, target, castTime+1); break;
                case 'ally': 
                    Utils.server.scheduleInTicks(2, () => {
                        repeatFacing(caster, target, castTime+1);
                    }); break;
                case 'self': repeatFacing(caster, target, castTime+1); break;
                case 'none': return
            }

            Utils.server.scheduleInTicks(1, () => {
                if (ownerBool) {
                    caster.teleportTo(target.level.dimension, target.x, target.y, target.z, caster.yaw, caster.pitch)
                    tell(`teleported pet`)
                }
                if (cast_level <= 0) {
                    Utils.server.runCommandSilent(`/execute in ${caster.level.dimension} run cast ${caster.uuid} ${spellID}`);
                } else {
                    Utils.server.runCommandSilent(`/execute in ${caster.level.dimension} run cast ${caster.uuid} ${spellID} ${cast_level}`);
                }
                
            })
        })
        cumulativeCooldown += castTime+2;
    })
    Utils.server.scheduleInTicks(cumulativeCooldown, () => {
        caster.tags.remove('mob_currently_casting')
    })
}




function playerCast (player, spell, spell_level) {
    if (spell_level <= 0) {
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run cast ${player.uuid} ${spell}`);
    } else {
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run cast ${player.uuid} ${spell} ${spell_level}`);
    }
}


let helpfulPetSpells = [
    'healing_circle',
    'blessing_of_life',
    'fortify',
    'haste'
]

function randomCast (caster, spells, target, spell_level) {
    let spell = spells[Math.floor(Math.random() * spells.length)];
    let boolean = false
    let spellInfo = {}
    if (new_spells.hasOwnProperty(spell)) {
        boolean = true
        spellInfo = new_spells[spell];
    }
    if (!boolean) return
 
    let ownerBool = false
    if (helpfulPetSpells.includes(spell) && caster.tags.contains('tamed_beast')) {
        let owner_username = caster.persistentData.owner
        let owner = caster.server.getPlayer(owner_username)
        if (!owner) return 
        ownerBool = true
        target = owner
    }
    let castTime = spellInfo.cast_time*20;
    let spellID = spellInfo.id;
    let cast_level = spell_level;
    if (spell_level > spellInfo.max_level) {
        cast_level = spellInfo.max_level;
    }
    //tell(spellID)
    // if the spellinfo.casttime is less than 0.20, loop 2 - 4 times
    let loop_count = 0;
    if (spellInfo.cast_time < 0.20) {
        loop_count = Math.floor(Math.random() * 3) + 2;
        //Utils.server.tell(`Loop count: ${loop_count}`)
        let looped_spells = []
        for (let i = 0; i < loop_count; i++) {
            looped_spells.push(spell)
        }
        newCast(caster, looped_spells, target, cast_level-1, 'randomCast', ownerBool);
    } else {
        caster.tags.add('mob_currently_casting')
        repeatFacing(caster, target, castTime+5);
        Utils.server.scheduleInTicks(1, () => {
            if (ownerBool) {
                caster.teleportTo(target.level.dimension, target.x, target.y, target.z, caster.yaw, caster.pitch)
                tell(`teleported pet`)
            }
            if (cast_level <= 0) {
                Utils.server.runCommandSilent(`/execute in ${caster.level.dimension} run cast ${caster.uuid} ${spellID}`);
            } else {
                Utils.server.runCommandSilent(`/execute in ${caster.level.dimension} run cast ${caster.uuid} ${spellID} ${cast_level}`);
            }
            
        })
        Utils.server.scheduleInTicks(castTime+5, () => {
            caster.tags.remove('mob_currently_casting')
        })
    }

}

/**
 * 
 * @param {*} source event.source of the hurt or death event.
 * @returns Boolean
 */
function isSpellDamageSource(source) {
    if (source.class.toString().includes('SpellDamageSource')) {
        return true
    } else {
        return false
    }
}


let school_effects = [
    'blood_mage',
    'fire_mage',
    'ice_mage',
    'lightning_mage',
    'nature_mage',
    'holy_mage',
    'evocation_mage',
    'ender_mage',
    'aqua_mage',
]
function getSchools(entity) {
    if (!entity) return [];
    return school_effects
        .filter(effect => entity.tags.contains(effect))
        .map(effect => effect.split('_')[0]); // Extract school name
}




let distances = {
    very_close: [
        'very_close', 'close', 'any'
    ],
    close: [
        'close', 'any'
    ],
    any: [
        'any'
    ]
}
function distanceSpells(distance, spells) {
    let filtered_spells = [];
    spells.forEach(spell => {
        let spellData = new_spells[spell];
        if (!spellData) {
            try { console.log(`[distanceSpells] Unknown spell key: ${spell}`) } catch (e) {}
            return
        }
        let allowed = distances[distance];
        if (!allowed) return
        if (allowed.includes(spellData.distance)) {
            filtered_spells.push(spell);
        }
    })
    return filtered_spells;
}

function schoolFunction(entity) {
    let schools = getSchools(entity);
    //Utils.server.tell(`Detected Schools: ${schools.join(', ')}`);

    let spells = getSpellsBySchool(schools);
    //tell(spells)
    //Utils.server.tell(`Spells Matching Schools: ${spells.join(', ')}`);
    
    return spells;
}



function tieredSpells(spells) {
    let power_level = Utils.server.persistentData.power_level
    // Compute the maximum tier from the power level
    // The "5" here ensures you never go above tier 5
    let current_tier = Math.min(5, Math.ceil(power_level / 2));
    if (current_tier < 1) current_tier = 1
    let filtered_spells = [];
    spells.forEach(spell => {
        let spellData = new_spells[spell];
        if (spellData.tier <= current_tier) {
            filtered_spells.push(spell);
        }
    })
    return filtered_spells;
}
        




/**
 * 
 * function tierSpells(spells) {
    let power_level = Utils.server.persistentData['power_level']
    let power_level_mod = parseInt(power_level)/10
    let filtered_spells = []
    spells.forEach(spell => {
        let spellData = new_spells[spell];
        let s_level = parseInt(power_level_mod)*parseInt(spellData.max_level)
        // Spell level is s_level rounded up to the nearest integer
        let spell_level = Math.ceil(s_level);

        
    })
}
 */

// tier < 


function getSpellData(spellName) {
    let spells = new_spells;
    let spelldata = {}
    if (spells.hasOwnProperty(spellName)) {
        spelldata = spells[spellName];
    }
    //Utils.server.tell(spelldata)
  }
  


function mobRandomCast(entity, distance, target) {
    let spells = tieredSpells(distanceSpells(distance, schoolFunction(entity)))
    //tell(spells)
    let power_level = Utils.server.persistentData.power_level
    if (!power_level)   power_level = 1
    let valid_spells = spells.filter(spell => !new_spells[spell].restricted)
    //Utils.server.tell(spells)
    
    randomCast(entity, valid_spells, target, power_level)
}











function randomSpell() {
    let spells = allSpells(); // Get all spells from new_spells
    if (spells.length === 0) {
        return null; // Return null if no spells are found
    }
    let randomIndex = Math.round(Math.random() * spells.length); // Generate a random index
    let randomSpell = spells[randomIndex]; // Get the spell at the random index
    return randomSpell; // Return the randomly selected spell
}

function randomSpellID() {
    let spells = allSpells(); // Get all spells from new_spells
    if (spells.length === 0) {
        return null; // Return null if no spells are found
    }
    let randomIndex = Math.floor(Math.random() * spells.length); // Generate a random index
    let randomSpell = spells[randomIndex]; // Get the spell at the random index
    if (new_spells.hasOwnProperty(randomSpell)) {
        return new_spells[randomSpell].id; // Return the ID of the randomly selected spell
    }
    return null; // Fallback in case of an unexpected error
}


//________________________________________________________________________________________________________________________________________


function randomSpellBySchool(caster, target, school) {
    // Retrieve the array of spell keys
    let distance = caster.distanceToEntity(target);
    let spells = allSpells();
    spells = filterSpellsBySchool(school, spells);
    if (distance > 8) {
        spells = filterSpellsByDistance('far', spells);
    } else if (distance < 8 && distance > 4) {
        spells = filterSpellsByDistance('close', spells);
    } else {
        spells = filterSpellsByDistance('very_close', spells);
    }
    return spells[Math.floor(Math.random() * spells.length)];
    
}
    
function getSpellsByTier(tier) {
    let spells = [];
    for (let spell in new_spells) {
        if (new_spells[spell].tier === tier) {
            spells = spells.concat(spell);
        }
    }
    return spells;
}


function filterSpellsByTier(spells, maxTier) {
    let filtered_spells = [];
    spells.forEach(spell => {
        if (new_spells[spell].tier <= maxTier) {
            filtered_spells = filtered_spells.concat(spell);
        }
    })
    return filtered_spells;
}


function getSpellsBySchool2(school) {
    let spells = [];
    for (let spell in new_spells) {
        if (new_spells[spell].school === school) {
            spells = spells.concat(spell);
        }
    }
    return spells;
}



function filterSpellsBySchool(school, spells) {
    let filtered_spells = [];
    spells.forEach(spell => {
        if (new_spells[spell].school === school) {
            filtered_spells = filtered_spells.concat(spell);
        }
    })
    return filtered_spells;
}

function getSpellsByDistance(distance) {
    let spells = [];
    for (let spell in new_spells) {
        if (new_spells[spell].distance === distance) {
            spells = spells.concat(spell);
        }
    }
    return spells;
}

function filterSpellsByDistance(distance, spells) {
    let filtered_spells = [];
    spells.forEach(spell => {
        if (new_spells[spell].distance == distance) {
            filtered_spells = filtered_spells.concat(spell);
        }
    })
    return filtered_spells;
}

let distancePriority = {
        very_close: 1,
        close: 2,
        any: 3
    };

function filterOutSpellsByDistance(distance, spells) {
    let allowedPriority = distancePriority[distance];

    if (!allowedPriority) {
        //console.log(`Invalid distance: ${distance}`);
        return [];
    }

    // Filter spells based on distance
    let filtered_spells = spells.filter(spell => {
        let spellDistance = new_spells[spell].distance;
        let spellPriority = distancePriority[spellDistance];
        
        // Include spells with equal or higher priority
        return spellPriority >= allowedPriority;
    });

    return filtered_spells;
}

function filterOutSpellsByUse(use, spells) {
    let filtered_spells = [];
    spells.forEach(spell => {
        if (new_spells[spell].use != use) {
            filtered_spells = filtered_spells.concat(spell);
        }
    })
    return filtered_spells;
}


function getSpellsByType(type) {
    let spells = [];
    for (let spell in new_spells) {
        if (new_spells[spell].type === type) {
            spells = spells.concat(spell);
        }
    }
    return spells;
}

function getSpellsByUse(use) {
    let spells = [];
    for (let spell in new_spells) {
        if (new_spells[spell].use === use) {
            spells = spells.concat(spell);
        }
    }
    return spells;
}

function filterSpellsByUse(use, spells) {
    let filtered_spells = [];
    spells.forEach(spell => {
        if (new_spells[spell].use === use) {
            filtered_spells = filtered_spells.concat(spell);
        }
    })
    return filtered_spells;
}


function removeSpellsByUse(use, spells) {
    let filtered_spells = [];
    spells.forEach(spell => {
        if (new_spells[spell].use != use) {
            filtered_spells = filtered_spells.concat(spell);
        }
    })
    return filtered_spells;
}




function filterSpellsByCastTime(cast_time, spells) {
    let filtered_spells = [];
    spells.forEach(spell => {
        if (new_spells[spell].cast_time <= cast_time) {
            filtered_spells = filtered_spells.concat(spell);
        }
    })
    return filtered_spells;
}

function allSpells() {
    let spells = [];
    for (let spell in global.spells) {
        spells = spells.concat(spell);
    }
    let valid_spells = []
    spells.forEach(spell => {
        if (!global.spells[spell].restricted) valid_spells.push(spell);
    })
    return valid_spells;
}



/**
 * 
 * @param {*} use_case Can be Offense, Defense, Support
 * - Offense: Casted at enemy when player attacks 
 * - Defense Casted at enemy when attacked 
 * - Support Casted when ally is attacked
 * @param {*} spells The spells to filter
 */
function spellsByUseCase(use_case, spells) {
    let filtered_spells = [];
    spells.forEach(spell => {
        if (new_spells[spell].use_cases.includes(use_case)) {
            filtered_spells = filtered_spells.concat(spell);
        }
    })
    return filtered_spells;
}





let uncastable_scrolls = [
    'traveloptics:despair',
    'traveloptics:void_eruption'
]

ItemEvents.rightClicked('irons_spellbooks:scroll', event => {
    let nbt = event.item.nbt
    let spell = []
    let level = 1
    let boolean = false
    uncastable_scrolls.forEach(scroll => {
        if (nbt.toString().includes(scroll)) {
            boolean = true
            // spell is the scroll name
            spell = spell.concat(scroll)
            // get the level of the scroll. 
            level = nbt.toString().split('level:')[1].split(',locked')[0]
        }
    })
    if (!boolean) return
    playerCast(event.player, spell, level)
    if (event.player.creative) return
    event.item.count -= 1
})
