

/**
 * ItemEvents.rightClicked(event => {
    let box = AABB.of(event.player.x+10, event.player.y+10, event.player.z+10, event.player.x-10, event.player.y-10, event.player.z-10)
    let entities = event.level.getEntitiesWithin(box)
    entities.forEach(entity => {
        if (entity.type.toString().includes('minecells')) {
            Utils.server.tell(`Found entity: ${entity.type.toString()}`)
        }
    })
})
 * 
 * 
 * 
 */


EntityEvents.spawned('minecells:undead_archer', event => {
    if (!event.entity.nbt.toString().includes('isElite:1')) return
    let box = AABB.of(event.entity.x+3, event.entity.y+1, event.entity.z+3, event.entity.x-3, event.entity.y-1, event.entity.z-3)
    let entities = event.level.getEntitiesWithin(box).filter(entity => entity.type.toString().includes('elite_obelisk'))
    if (entities.length == 0) return
    let bishop = event.level.createEntity('fathomless:bishop')
    bishop.x = event.entity.x
    bishop.y = event.entity.y
    bishop.z = event.entity.z
    bishop.spawn()
    bishop.tags.add('elite_obelisk')
    event.cancel()
})



EntityEvents.death('fathomless:bishop', event => {
    if (!event.entity.tags.contains('elite_obelisk')) return
    let entityX = event.entity.x
    let entityY = event.entity.y
    let entityZ = event.entity.z
    for (let x = -20; x <= 20; x++) {
        for (let y = -5; y <= 5; y++) {
            for (let z = -20; z <= 20; z++) {

                let blockPosX = parseInt(entityX + x)
                let blockPosY = parseInt(entityY + y)
                let blockPosZ = parseInt(entityZ + z)
                let block = event.level.getBlock(parseInt(blockPosX), parseInt(blockPosY), parseInt(blockPosZ))
                if (block.id.includes('runic_vine_plant')) {
                    let x = block.x
                    let y = block.y
                    let z = block.z
                    let num = 0
                    // loop 15 times
                    for (let i = 0; i < 25; i++) {
                        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run setblock ${blockPosX} ${blockPosY+num} ${blockPosZ} minecraft:scaffolding replace`)
                        num++
                    }
                    return
                }
            }
        }
    }
})
        

let minecells_spellcasting = {
    'minecells:leaping_zombie':{
        atk_spells: ['poison_splash'],
    },
    'minecells:grenadier':{
        atk_spells: ['magic_missile'],
    },
    'minecells:undead_archer':{
        atk_spells: ['arrow_volley'],
    },
    'minecells:shocker':{
        atk_spells: ['chain_lightning'],
    },
    'minecells:sweeper':{
        atk_spells: ['heat_surge'],
    },
}

// Entity attack spell
EntityEvents.hurt(event => {
    if (!event.source.player) return
    let monster = event.entity
    if (!monster.isMonster()) return
    // Check if the entity is in the minecells_spellcasting object
    let spellcasting = minecells_spellcasting[monster.type]
    if (!spellcasting) return

    let player = event.source.player
    monster.lookAt("eyes", new Vec3d(player.x, player.y + 1, player.z))

    // 10% chance to cast an attack spell
    let chance = Math.random()
    if (chance > 0.05) return

    // Select a random attack spell from the entity's defined spells
    let spell = spellcasting.atk_spells[Math.floor(Math.random() * spellcasting.atk_spells.length)]
    let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${monster.uuid} ${spell}`)
})


let alt_entities = [
    'minecells:leaping_zombie',
    'minecells:grenadier',
    'minecells:undead_archer',
    'minecells:shocker',
    'minecells:sweeper',
]

EntityEvents.spawned('minecells:shieldbearer', event => {
    let randomEntity = alt_entities[Math.floor(Math.random() * alt_entities.length)]
    let entity = event.level.createEntity(randomEntity)
    entity.x = event.entity.x
    entity.y = event.entity.y
    entity.z = event.entity.z
    entity.spawn()
    event.cancel()
})

