let gameplay_modifiers = [
    'beastriders', // Monsters spawn on mounts (Mounts are Grizzly Bears, Komodo Dragons, Tarantula Hawks, Soul Vultures, Ampitheres, Cockatrises, Stymphalian Birds, and Hippogryphs) //
    'arcane_ascension',  // Monsters always spawn as spellcasters and a 2x higher chance to cast spells //
    'ironclad', // Gives mobs better weapons and armor
    'arachnophobia', // Spiders spawn small and fast cave spiders on death // 
    'monstrosities', // Mutants spawn with more life and potion effects //
    'undead_feast', // Zombies spawn with life steal //
    'ravenous_horde', // Hitting a zombie empowers all nearby zombies
    'icebound', // Strays have a high chance to freeze you //
    'death_snare', // Arrows shot by skeletons pull you towards them on hit and apply slow //
    'piglin_rage', // Nearby Zombified Piglins gain a speed buff when you attack one of them //
    'brute_force', // Piglin Brutes deal more damage and knock you back further //
    'tempestborn', // All Creeper types spawn charged //
    'vexsplosion', // Vexs drop lit tnt on death //
    'shroudwalkers', // Endermen give you darkness when they hit you, strength when you hit them, and teleport around you more frequently //
    'corrupted_kin', // Mutants spawn in place of their normal counterparts 50% of the time //
    'veiled_broodlings', // Cave spiders spawn with invisibility. It is removed upon attacking a player //
    'deep_abyss', // Drowned spawn with Tridents. Tridents pull you towards them on hit //
    'mob_menagerie', // Monster spawns are randomized and include a much wider variety of mobs, including ones from other dimensions
    'eyes_within_the_stone', // mining too much will spawn a cave dweller nearby //
    'screeching_shadows', // phantoms are smaller, faster, and multiply on hit //
    'event_horizon', // When a mob dies, it has a 10% chance to leave behind a blackhole that is alive for 3 seconds (shrink the black holes) //
    'weeping_fate', // Ghasts have a chance to teleport away when hit, taking no damage //
    'unending_horde', // All monsters have a high chance to cast a summon spell when they are low health//
    'critical_mass', // When a creeper dies, there is a 0.1% chance it will spawn a nuke //
    'bone_brigade', // Skeletons have a chance to not spawn and instead spawn 5 'special' skeletons instead. 
    'blood_moon', // At night, monsters spawn with Speed, Strength, and Regeneration. // 
    'glass_bones', // Fall damage is increased by 3x // 
    'pyromania', // You are ignited when you are hit for 3 seconds // 
]


let vanilla_pillagers = [
    'minecraft:pillager',
    'minecraft:vindicator',
    'minecraft:evoker',
    'minecraft:illusioner',
]

let pillager_extra_spawn = [

]



EntityEvents.spawned(event => {
    if (event.server.persistentData.mob_menagerie != true) return
    if (vanilla_pillagers.some(type => event.entity.type.toString().includes(type))) {
        if (event.entity.tags.contains('duped_pillager')) return // Don't spawn extra pillagers if the entity is already a duplicate
        let chance = Math.random()
        if (chance > 0.80) return // 20% chance to not add
        event.entity.tags.add('duped_pillager') // Add a tag to the entity to indicate it's a duplicate
        let extra_spawn = pillager_extra_spawn[Math.floor(Math.random() * pillager_extra_spawn.length)]
        let x = event.entity.x
        let y = event.entity.y
        let z = event.entity.z
        let new_entity = event.level.createEntity(extra_spawn)
        new_entity.x = x
        new_entity.y = y
        new_entity.z = z
        new_entity.spawn()
    }
})






const VOTE_DURATION_TICKS = 600
const VOTE_COOLDOWN_MS = 5 * 60 * 1000 // 5 minute lockout between attempts

let gameplay_modifier_votes = {}

function getVoteState(modifier) {
    if (!gameplay_modifier_votes[modifier]) {
        gameplay_modifier_votes[modifier] = {
            yes: 0,
            no: 0,
            cooldownUntil: 0,
            requiredMajority: 0,
        }
    }
    return gameplay_modifier_votes[modifier]
}

function resetVoteCounters(modifier) {
    let state = getVoteState(modifier)
    state.yes = 0
    state.no = 0
}

function resetPlayerVoteFlags(server, modifier) {
    server.players.forEach(player => {
        player.persistentData[`${modifier}_voted`] = false
    })
}

function markVoteCooldown(modifier) {
    let state = getVoteState(modifier)
    state.cooldownUntil = Date.now() + VOTE_COOLDOWN_MS
}

function concludeVote(server, modifier) {
    server.persistentData[`${modifier}_vote_running`] = false
    server.persistentData.putBoolean('any_vote_running', false)
    resetVoteCounters(modifier)
    resetPlayerVoteFlags(server, modifier)
    markVoteCooldown(modifier)
}
gameplay_modifiers.forEach(modifier => {
    ItemEvents.rightClicked(`kubejs:${modifier}`, event => {
        if (event.server.persistentData['any_vote_running'] == true) {
            event.player.tell(`A\u0015cAnother vote is currently running. Please wait until it finishes.`)
            return
        }
        if (event.server.persistentData[`${modifier}_vote_running`] == true) {
            event.player.tell(`§cThere is already a vote running for this modifier!`)
            return
        }
        let server = event.server
        let player = event.player
        let playercount = server.playerCount
        if (playercount <= 1) {
            if (event.server.persistentData['any_vote_running'] == true) {
                event.player.tell(`A\u0015cAnother vote is currently running. Please wait until it finishes.`)
                return
            }
            modifierSwitch(server, modifier)
            return
        }
        let state = getVoteState(modifier)
        let currentTime = Date.now()
        if (currentTime < state.cooldownUntil) {
            let remainingSeconds = Math.ceil((state.cooldownUntil - currentTime) / 1000)
            event.player.tell(`§cYou must wait ${remainingSeconds}s before starting another vote for this modifier.`)
            return
        }
        event.server.persistentData.putBoolean(`${modifier}_vote_running`, true)
        event.server.persistentData.putBoolean('any_vote_running', true)
        resetVoteCounters(modifier)
        resetPlayerVoteFlags(server, modifier)
        state.requiredMajority = Math.floor(event.server.playerCount / 2) + 1
        Utils.server.scheduleInTicks(VOTE_DURATION_TICKS, () => {
            if (event.server.persistentData[`${modifier}_vote_running`] != true) return
            event.server.players.forEach(player => {
                player.tell(`§cThe ${modifier.toString().replace(/_/g, ' ').toUpperCase()} vote has timed out!`)
            })
            concludeVote(event.server, modifier)
        })
        let modifier_name = `[${modifier.toString().replace(/_/g, ' ').toUpperCase()}]`
        let initial_activate_msg = Text.of([Text.of(`${player.username} would like to`).gray(), Text.of(` activate `).green(), Text.of(`the`).gray(), Text.of(` ${modifier_name} `).aqua(), Text.of(`modifier!`).gray()])
        let initial_deactivate_msg = Text.of([Text.of(`${player.username} would like to`).gray(), Text.of(` deactivate `).red(), Text.of(`the`).gray(), Text.of(` ${modifier_name} `).aqua(), Text.of(`modifier!`).gray()])


        if (event.server.persistentData[modifier] == true) {
            server.players.forEach(n_player => {
                n_player.tell(initial_deactivate_msg)
                let click_accept = Text.of([Text.of(`[ACCEPT]`).green()]).clickRunCommand(`/kjs custom_command ${modifier}_vote_accept`)
                    .hover(`§fClick if you want to turn the ${modifier_name} modifier §cOFF`)
                let click_decline = Text.of([Text.of(`[DECLINE]`).red()]).clickRunCommand(`/kjs custom_command ${modifier}_vote_decline`)
                    .hover(`§fClick if you want to keep the ${modifier_name} modifier §aON`)
                n_player.tell(click_accept)
                n_player.tell(click_decline)
            })
        } else {
            server.players.forEach(n_player => {
                n_player.tell(initial_activate_msg)
                let click_accept = Text.of([Text.of(`[ACCEPT]`).green()]).clickRunCommand(`/kjs custom_command ${modifier}_vote_accept`)
                    .hover(`§fClick if you want to turn the ${modifier_name} modifier §aON`)
                let click_decline = Text.of([Text.of(`[DECLINE]`).red()]).clickRunCommand(`/kjs custom_command ${modifier}_vote_decline`)
                    .hover(`§fClick if you want to keep the ${modifier_name} modifier §cOFF`)
                n_player.tell(click_accept)
                n_player.tell(click_decline)
            })
        }
    })

    ServerEvents.customCommand(`${modifier}_vote_accept`, event => {
        if (event.server.persistentData[`${modifier}_vote_running`] != true) return
        if (event.player.persistentData[`${modifier}_voted`] == true) return
        let state = getVoteState(modifier)
        state.yes += 1
        event.player.persistentData[`${modifier}_voted`] = true
        let majority = state.requiredMajority || (Math.floor(event.server.playerCount / 2) + 1)
        if (state.yes >= majority) {
            modifierSwitch(event.server, modifier)
            concludeVote(event.server, modifier)
        }
    })


    ServerEvents.customCommand(`${modifier}_vote_decline`, event => {
        let modifier_name = `[${modifier.toString().replace(/_/g, ' ').toUpperCase()}]`
        if (event.server.persistentData[`${modifier}_vote_running`] != true) return
        if (event.player.persistentData[`${modifier}_voted`] == true) return
        let state = getVoteState(modifier)
        state.no += 1
        event.player.persistentData[`${modifier}_voted`] = true
        let majority = state.requiredMajority || (Math.floor(event.server.playerCount / 2) + 1)
        if (state.no >= majority) {
            event.server.players.forEach(player => {
                player.tell(`§cThe ${modifier_name} vote has failed!`)
            })
            concludeVote(event.server, modifier)
        }
    })




})


function modifierSwitch(server, modifier) {
    let modifier_name = `[${modifier.toString().replace(/_/g, ' ').toUpperCase()}]`
    if (server.persistentData[modifier] == true) {
        server.persistentData.putBoolean(modifier, false)
        server.players.forEach(player => {
            player.tell(`§b${modifier_name} §7deactivated`)
        })
    } else {
        server.persistentData.putBoolean(modifier, true)
        server.players.forEach(player => {
            player.tell(`§b${modifier_name} §7activated`)
        })
    }
}


let mob_mounts = { // mob : mount
    mobs: [
        'minecraft:zombie', // Zombies
        'minecraft:skeleton',
        'minecraft:pillager', // Pillagers
        'minecraft:evoker', //
        'minecraft:vindicator', // Vindicators

    ],
    // Mounts
    mounts: [
        'alexsmobs:grizzly_bear', // Grizzly Bears
        'alexsmobs:komodo_dragon', // Komodo Dragons
        'alexsmobs:tarantula_hawk',
        'alexsmobs:elephant',
        //'alexsmobs:moose', // Tarantula Hawks        
        //'alexscaves:subterranodon'
        'alexscaves:vallumraptor',
        //'alexsmobs:soul_vulture'
        //"iceandfire:dread_scuttler",
        
    ]
}

/**
 * 
 * 
 * 
 */
mob_mounts.mobs.forEach(mob => {
    EntityEvents.spawned(mob, event => {
        if (event.entity.tags.contains('boss')) return // Don't mount bosses
        if (event.entity.tags.contains('mounted_mob')) return
        if (event.server.persistentData.beastriders != true) return
        event.entity.tags.add('mounted_mob') // Add a tag to the mob to indicate it's mounted
        let chance = Math.random()
        if (chance > 0.20) return // 20% chance to mount the
       Utils.server.scheduleInTicks(1, () => {
            let mountType = mob_mounts.mounts[Math.floor(Math.random() * mob_mounts.mounts.length)];
            let x = event.entity.x;
            let y = event.entity.y;
            let z = event.entity.z;
            let mount = event.level.createEntity(mountType); // Create a mount entity
            mount.health = event.entity.health; // Set the mount's health to the same as the mob
            mount.maxHealth = event.entity.maxHealth; // Set the mount's max health to the same as the mob
            mount.setPos(x, y, z); // Set the position of the mount to the same as the mob
            mount.mergeNbt({
                Owner: event.entity.uuid, // Set the owner of the mount to the mob
            })
            mount.spawn(); // Spawn the mount in the world
            specialMobTame(event.entity, mount)
            event.entity.startRiding(mount)
            
           // Utils.server.scheduleInTicks(3, () => {
                //event.entity.vehicle(mount)
                
            //})
            
            if (event.server.persistentData.arcane_ascension != true) return
            let school = pickRandomSchool()
            applySchool(mount, school, true)
        })
    })
})









EntityEvents.hurt('player', event => {
    if (event.source.actual == null) return; // Ensure the source is valid
    if (!event.source.actual.tags.contains('mounted_mob')) return
    if (!event.source.actual.rootVehicle) return
    event.source.actual.rootVehicle.setTarget(event.entity); // Set the mount's target to the player who was hurt
})




/**
 *     * Spiders and Cave Spiders: §aLevel 4
    *   - Spiders and cave spiders are 0.5x their normal size
    *  - Spiders and cave spiders have faster speed
    *  - When a spider dies, spawn 3 - 6 cave spiders
 * 
 */

// §aLevel 5
EntityEvents.spawned('minecraft:spider', event => {
    let uuid = event.entity.uuid
    if (event.server.persistentData.arachnophobia != true) return
    Utils.server.scheduleInTicks(2, () => {
        Utils.server.runCommandSilent(`/effect give ${uuid} minecraft:speed infinite 1 true`)
        change_size(event.entity, 0.4)
    })
})



EntityEvents.death(event => {
    let entity = event.entity
    if (event.server.persistentData.arachnophobia != true) return
    if (!entity.type.includes('spider')) return
    if (entity.type.includes('cave')) return
    // random number between 1 and 3
    let amount = Math.floor(Math.random() * 3) + 1
    entity.playSound('alexsmobs:fly_hurt')
    for (let i = 0; i < amount; i++) {
        let spider = event.level.createEntity(`minecraft:cave_spider`)
        spider.x = entity.x
        spider.y = entity.y
        spider.z = entity.z
        spider.spawn()
    }
})




EntityEvents.spawned('minecraft:cave_spider', event => {
    if (event.server.persistentData.arachnophobia != true) return
    let uuid = event.entity.uuid
    Utils.server.scheduleInTicks(1, () => {
        Utils.server.runCommandSilent(`/effect give ${uuid} minecraft:speed infinite 0 true`)
        change_size(event.entity, 0.4)
    })
})

EntityEvents.spawned('minecraft:cave_spider', event => {
    if (event.server.persistentData.veiled_broodlings != true) return
    let uuid = event.entity.uuid
    Utils.server.scheduleInTicks(1, () => {
        Utils.server.runCommandSilent(`/effect give ${uuid} irons_spellbooks:true_invisibility infinite 0 true`)
    })
})

EntityEvents.hurt('player', event => {
    if (!event.source) return; // Ensure the source is valid
    if (!event.source.actual) return; // Ensure the source is valid
    if (event.source.actual.type != 'minecraft:cave_spider') return; // Ensure the source is a cave spider
    if (event.server.persistentData.shroudwalkers == true) {
        event.entity.potionEffects.add('minecraft:blindness', 40, 0) // Give the player blindness for 3 seconds
    }
    let chance = 1
    if (event.server.persistentData.veiled_broodlings == true) {
        chance = 0.50
    }
    if (Math.random() > chance) return; // 50% chance to remove invisibility
    Utils.server.runCommandSilent(`/effect clear ${event.entity.uuid} irons_spellbooks:true_invisibility`) 


})




EntityEvents.spawned('mutantmonsters:mutant_zombie', event => {
    let uuid = event.entity.uuid
    change_size(event.entity, 1.5)
})




EntityEvents.hurt(event => {
    if (event.server.persistentData.monstrosities != true) return
    if (event.source.actual == null) return
    if (event.source.actual.type != 'mutantmonsters:mutant_zombie') return
    if (!event.entity.player) return
    let player = event.entity
    player.potionEffects.add('alexscaves:stunned', (5*parseInt(event.server.persistentData.power_level)), 1, true, true)
})


//___________________________________________________________________________________________________________________________

EntityEvents.spawned('mutantmonsters:mutant_skeleton', event => {
    let uuid = event.entity.uuid
    change_size(event.entity, 1.5)
})


// Teleport the player to the skeleton when they get hit and give them blindness
EntityEvents.hurt(event => {
    if (!event.source || !event.source.actual) return
    if (event.server.persistentData.monstrosities != true) return
    if (!event.source.indirect) return
    if (event.source.actual.type != 'mutantmonsters:mutant_skeleton') return
    if (!event.entity.player) return
    let skeleton = event.source.causingEntity
    let x = skeleton.x
    let y = skeleton.y
    let z = skeleton.z
    //event.entity.teleportTo(event.entity.level.dimension, x, y, z, event.entity.yaw, event.entity.pitch)
    Utils.server.runCommandSilent(`/execute in ${skeleton.level.dimension} run tp ${event.entity.uuid} ${x-2} ${y} ${z} facing entity ${skeleton.uuid}`)
    event.entity.potionEffects.add('minecraft:blindness', (15*parseInt(event.server.persistentData.power_level)), 0)
})


// Undead Feast
// Give zombies a soulsteal effect when they spawn
EntityEvents.spawned(event => {
    if (event.server.persistentData.undead_feast != true) return
    let type = event.entity.type.toString()

    // Deep Abyss check and Drowned check
    let deep_abyss = event.server.persistentData.deep_abyss
    if (deep_abyss && type.includes('drowned')) {
        let uuid = event.entity.uuid
        Utils.server.scheduleInTicks(1, () => {
            Utils.server.runCommandSilent(`/effect give ${uuid} alexsmobs:soulsteal infinite ${parseInt(event.server.persistentData.power_level)} true`)
        })
    }

    // Monstrosities check
    let monstrosities = event.server.persistentData.monstrosities

    if (!type.includes('zombie')) return
    if (!monstrosities && type.includes('mutant')) return
    let uuid = event.entity.uuid
    Utils.server.scheduleInTicks(1, () => {
        Utils.server.runCommandSilent(`/effect give ${uuid} alexsmobs:soulsteal infinite ${parseInt(event.server.persistentData.power_level)} true`)
    })
})






//Ravenous Horde
// When a player hurts a zombie, give all zombie types within 10 blocks special effects
EntityEvents.hurt(event => {
    if (event.server.persistentData.ravenous_horde != true) return
    if (!event.source.player) return
    let type = event.entity.type.toString()
    if (!type.includes('zombie')) return
    let x = event.entity.x
    let y = event.entity.y
    let z = event.entity.z
    let box = AABB.of(x+10, y+10, z+10, x-10, y-10, z-10)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    let types = ['zombie']
    if (event.server.persistentData.deep_abyss == true) {
        types.push('drowned')
    }
    entitiesWithin.forEach(ent => {
        if (types.some(type => ent.type.includes(type))) {
            Utils.server.runCommandSilent(`/effect give ${ent.uuid} minecraft:speed 3 2 true`)
            Utils.server.runCommandSilent(`/effect give ${ent.uuid} minecraft:haste 3 2 true`)
            Utils.server.runCommandSilent(`/effect give ${ent.uuid} minecraft:strength 3 2 true`)
        }
    })
})


// Strays have a 20% chance to freeze the player for 1.5 seconds when they are hit
EntityEvents.hurt('player', event => {
    if (event.server.persistentData.icebound != true) return
    if (!event.source || !event.source.actual) return
    if (event.source.immediate == null) return
    if (!event.source.indirect) return
    if (!event.source.immediate.type.toString().includes('arrow')) return
    let chance = Math.random()
    if (event.server.persistentData.death_snare == true) {
        if (chance > 0.30) return
        event.entity.potionEffects.add('mowziesmobs:frozen', 30, 0)
    } else {
        if (event.source.actual.type != 'minecraft:stray') return
        if (chance > 0.20) return
        event.entity.potionEffects.add('mowziesmobs:frozen', 30, 0)
    }
    
})






//_______________________________________________________________________________________________________________________________
// Death Snare Mechanics
// When a player is hit by a Skeletons arrow, give them 2 seconds of slowness
EntityEvents.hurt('player', event => {
    if (event.server.persistentData.death_snare != true) return
    if (!event.source || !event.source.actual) return

    if (!event.source.actual.isMonster()) return
    if (!event.source.indirect) return

    let type = event.source.actual.type.toString()
    if (!type.includes('skeleton')) return

    let monstrosities = event.server.persistentData.monstrosities
    if (!monstrosities && type.includes('mutant')) return

    if (!event.source.immediate.type.includes('arrow')) return
    let player = event.entity
    let time = 40
    if (event.server.persistentData.icebound == true) {
        time = time + 30
    }
    player.potionEffects.add('minecraft:slowness', time, 2)
})



// Pull the player toward the entity that shot the arrow
EntityEvents.hurt('player', event => {
    if (event.server.persistentData.death_snare != true) return
    if (!event.source || !event.source.actual) return

    if (!event.source.actual.isMonster()) return

    let type = event.source.actual.type.toString()

    let monstrosities = event.server.persistentData.monstrosities
    if (!monstrosities && type.includes('mutant')) return

    let player = event.entity
    if (!event.source.indirect) return
    // Check if its an arrow
    if (!event.source.immediate.type.includes('arrow')) return
    let entity = event.source.causingEntity
    let dir = {
        x: player.getX() - entity.getX(),
        z: player.getZ() - entity.getZ()
    };
    let dirLength = Math.sqrt(dir.x * dir.x + dir.z * dir.z);
    if (dirLength > 0) {
        player.addMotion((dir.x / dirLength) * -3, 0.3, (dir.z / dirLength) * -3);
    }  
})


// §aLevel 2
EntityEvents.hurt('minecraft:zombified_piglin', event => {
    if (event.server.persistentData.piglin_rage != true) return
    if (!event.source.player) return
    let x = event.entity.x
    let y = event.entity.y
    let z = event.entity.z
    let box = AABB.of(x+40, y+10, z+40, x-40, y-10, z-40)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    let type = ['minecraft:zombified_piglin']
    if (event.server.persistentData.brute_force == true) {
        type = ['piglin']
    }
    entitiesWithin.forEach(ent => {
        if (type.some(type => ent.type.includes(type))) {
            Utils.server.runCommandSilent(`/effect give ${ent.uuid} minecraft:speed ${1*event.server.persistentData.power_level} 3 true`)
        }
    })
})




// §aLevel 4
EntityEvents.spawned(event => {
    if (event.server.persistentData.brute_force != true) return
    let type = ['minecraft:piglin_brute']
    if (event.server.persistentData.piglin_rage == true) {
        type = ['piglin']
    }
    if (!type.some(type => event.entity.type.includes(type))) return
    let uuid = event.entity.uuid
    Utils.server.scheduleInTicks(1, () => {
        Utils.server.runCommandSilent(`/attribute ${uuid} minecraft:generic.attack_knockback base set `+event.server.persistentData.power_level)
        Utils.server.runCommandSilent(`/attribute ${uuid} minecraft:generic.attack_knockback base set 2`)
        change_size(event.entity, 1.3)

    })
})


EntityEvents.spawned(event => {
    if (event.server.persistentData.tempestborn != true) return; // 
    if (!event.entity.type.toString().includes('creeper')) return
    //if ( event.server.persistentData.nightmare_activated != true) return
    event.entity.mergeNbt({
        powered: true
    })

})



// Vexes explode when they die
EntityEvents.death(event => {
    if (event.server.persistentData.vexsplosion != true) return;
    if (!event.entity.type.toString().includes('vex')) return
    let entity = null
    if (event.server.persistentData.tempestborn == true) {
        entity = event.level.createEntity('minecraft:creeper');
        entity.mergeNbt({
            Fuse: 10,
            powered: true,
            ignited: true,

        })
    } else {
        entity = event.level.createEntity('minecraft:tnt');
        entity.mergeNbt({Fuse: 15})
    }
    
    
    entity.setPos(event.entity.x, event.entity.y, event.entity.z);
    entity.spawn();
})







///______________________________________________________________________________________________________________________________________________________________
// Shroudwalker


// When a player is hit by an enderman, give them darkness
EntityEvents.hurt('player', event => {
    if (event.server.persistentData.shroudwalkers != true) return; // Ensure the shroudwalker modifier is active
    if (event.source == null) return
    if (event.source.actual == null) return

    let type = event.source.actual.type.toString()
    let monstrosities = event.server.persistentData.monstrosities

    if (!type.includes('enderman')) return
    if (!monstrosities && type.includes('mutant')) return

    let player = event.entity
    player.potionEffects.add('minecraft:blindness', 60, 0)
    event.source.actual.potionEffects.add('minecraft:invisibility', 60, 0); // Make the enderman invisible for a short time
    event.source.actual.potionEffects.add('minecraft:strength', 60, 1); // Give the enderman a strength boost for a short time
})

EntityEvents.hurt(event => {
    if (event.server.persistentData.shroudwalkers != true) return; // Ensure the shroudwalker modifier is active
    if (!event.source.player) return; // Ensure the source is a player
    let type = event.entity.type.toString()
    let monstrosities = event.server.persistentData.monstrosities
    let allowed = ['enderman']
    let unallowed = ['mutant']
    if (monstrosities) {
        allowed.push('mutant')
        unallowed = unallowed.filter(item => item !== 'mutant')
    }
    
    let screeching_shadows = event.server.persistentData.screeching_shadows
    if (screeching_shadows) {
        allowed.push('minecraft:phantom')
    }


    if (!allowed.some(type => event.entity.type.includes(type))) return // Check if the entity is in the allowed list

    let chance = Math.random();
    if (chance > 0.50) return
    let spells = []
    // choose a number between 1 and 3
    let num = Math.floor(Math.random() * 3) + 1; // 1 to 3
    // loop 
    for (let i = 0; i < num; i++) {
        spells.push('blood_step') // add blood_step to the list
    }
    spells.push('gust') // add shadow_step to the list

    newCast(event.entity, spells, event.source.player, 1, 'shroudwalker')
})




function tell(message) {
    if (global.debug_mode != true) return
    Utils.server.tell(String(message))
}


//______________________________________________________________________________________________________________________________________________________________
// Pull the player toward the drowned that hit them with a trident
EntityEvents.hurt(event => {
    if (event.server.persistentData.deep_abyss != true) return; // Ensure the deep abyss modifier is active
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.entity.player) return
    if (!event.source.actual.isMonster()) return
    if (event.source.actual.type != 'minecraft:drowned') return
    if (event.source == null) return
    if (event.source.immediate == null) return
    let player = event.entity
    if (!event.source.indirect) return
    // Check if its an arrow
    if (!event.source.immediate.type.includes('trident')) return
    let entity = event.source.causingEntity
    let dir = {
        x: player.getX() - entity.getX(),
        z: player.getZ() - entity.getZ()
    };
    let dirLength = Math.sqrt(dir.x * dir.x + dir.z * dir.z);
    if (dirLength > 0) {
        player.addMotion((dir.x / dirLength) * -2, 0.3, (dir.z / dirLength) * -2); // Pull the player towards the drowned
    }  
})



//'corrupted_kin', // Mutants spawn in place of their normal counterparts 50% of the time

let mutant_spawns = {
    'minecraft:zombie': 'mutantmonsters:mutant_zombie', // Mutant Zombies
    'minecraft:skeleton': 'mutantmonsters:mutant_skeleton', // Mutant Skeletons
    'minecraft:creeper': 'mutantmonsters:mutant_creeper', // Mutant Creepers (if you have the addon)
    'minecraft:enderman': 'mutantmonsters:mutant_enderman', // Mutant Endermen (if you have the addon)
}

EntityEvents.spawned(event => {
    if (event.server.persistentData.corrupted_kin != true) return; // Ensure the corrupted_kin modifier is active
    let originalType = event.entity.type.toString();
    if (!mutant_spawns[originalType]) return; // Check if the entity type has a mutant spawn mapping

    let mutantType = mutant_spawns[originalType];
    if (!mutantType) return;

    let chance = Math.random(); // Determine if we should spawn a mutant variant
    let spawn_chance = 0.50
    if (event.server.persistentData.monstrosities == true) {
        spawn_chance = 0.75
    }
    if (chance > spawn_chance) return // 50% chance to spawn a mutant variant, can be adjusted as needed
    // Spawn the mutant variant instead
    let mutantEntity = event.level.createEntity(mutantType);
    mutantEntity.setPos(event.entity.x, event.entity.y, event.entity.z); // Set the position of the new entity
    mutantEntity.spawn(); // Spawn the new entity

    event.cancel()
})



// Screeching shadows
EntityEvents.hurt(event => {
    if (!event.entity.player) return
    if (event.server.persistentData.screeching_shadows != true) return
    if (event.source == null) return
    if (event.source.directEntity == null) return
    if (event.source.directEntity.type != 'minecraft:phantom') return
    // 10% chance to spawn a phantom
    let chance = Math.random()
    if (chance > 0.5) return
    let phantom = event.level.createEntity('minecraft:phantom')
    phantom.setPosition(event.source.directEntity.x, event.source.directEntity.y, event.source.directEntity.z)
    phantom.spawn()
    phantom.tags.add('screeching_phantom')
})

EntityEvents.spawned('minecraft:phantom', event => {
    if (event.server.persistentData.screeching_shadows != true) return
    Utils.server.scheduleInTicks(1, () => {
        let uuid = event.entity.uuid
        Utils.server.runCommandSilent(`/effect give ${uuid} minecraft:speed infinite 1 true`)
        event.entity.maxHealth = 10
        event.entity.health = 10
        change_size(event.entity, 0.5)
    })
})


EntityEvents.death('phantom', event => {
    if (event.entity.tags.contains('screeching_phantom')) {
        Utils.server.runCommandSilent(`/kill @e[type=item,nbt={Item:{id:'minecraft:phantom_membrane'}}]`)
    }
})

//_________________________________________________________________________________________________________________________________________________________________
// Pyromania

// When a player is hit by an enderman, give them darkness
EntityEvents.hurt('player', event => {
    if (event.server.persistentData.pyromania != true) return; // Ensure the shroudwalker modifier is active
    if (event.source == null) return
    if (event.source.actual == null) return
    let player = event.entity
    player.setRemainingFireTicks(60)
})



//_________________________________________________________________________________________________________________________________________________________________
// Bloodmoon
// At night, monsters spawn with special effects

EntityEvents.spawned(event => {
    if (event.server.persistentData.blood_moon != true) return
    if (!event.entity.isMonster()) return; // Only apply to monsters
    Utils.server.scheduleInTicks(1, () => {
        let uuid = event.entity.uuid
        Utils.server.runCommandSilent(`/effect give ${uuid} minecraft:speed infinite 1 true`)
        Utils.server.runCommandSilent(`/effect give ${uuid} minecraft:strength infinite 1 true`)
        Utils.server.runCommandSilent(`/effect give ${uuid} minecraft:regeneration infinite 1 true`)
    })
})






// _________________________________________________________________________________________________________________________________________________________________
// Event Horizon
EntityEvents.death(event => {
    if (event.source == null) return
    if (!event.entity.isMonster()) return
    if (event.server.persistentData.event_horizon != true) return
    // 5% chance to spawn a black hole
    let chance = Math.random()
    if (chance > 0.05) return
    let black_hole = event.level.createEntity('irons_spellbooks:black_hole')
    black_hole.x = event.entity.x
    black_hole.y = event.entity.y-3
    black_hole.z = event.entity.z
    black_hole.spawn()
    Utils.server.scheduleInTicks(200, () => {
        black_hole.kill()
    })
})

// _________________________________________________________________________________________________________________________________________________________________
// Critical Mass
EntityEvents.death(event => {
    if (event.source == null) return
    if (!event.entity.type.toString().includes('creeper')) return
    if (!event.entity.isMonster()) return
    if (event.server.persistentData.critical_mass != true) return
    // 0.5% chance to spawn a black hole
    let chance = Math.random()
    if (chance > 0.001) return
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run summon alexscaves:nuclear_bomb ${event.entity.x} ${event.entity.y} ${event.entity.z}`)
})



// Eyes within the stone
// When a player mines too much, spawn a cave dweller nearby

let eyes_within_the_stone = new WeakMap()
BlockEvents.broken(event => {
    if (event.server.persistentData.eyes_within_the_stone != true) return
    if (event.player.persistentData.dweller_trigger == true) return
    let commonMinedBlocks = [
        'minecraft:stone',
        'minecraft:deepslate',
        'minecraft:cobblestone',
        'minecraft:andesite',
        'minecraft:diorite',
        'minecraft:granite',
        'minecraft:tuff',
        'minecraft:calcite',
        'minecraft:dripstone_block',
        'minecraft:mossy_cobblestone',
        'minecraft:sculk',
        'minecraft:gravel',
        'minecraft:sand'
      ];
    if (!commonMinedBlocks.some(block => event.block.id.includes(block))) return
    if (eyes_within_the_stone[event.player.username] == undefined) {
        eyes_within_the_stone[event.player.username] = 1
    } else {
        eyes_within_the_stone[event.player.username] += 1
    }

    if (eyes_within_the_stone[event.player.username] >= 100) {
        eyes_within_the_stone[event.player.username] = 0
        event.player.persistentData.putBoolean('dweller_trigger', true)

        let box = AABB.of(event.block.x+50, event.block.y+2, event.block.z+50, event.block.x-50, event.block.y-2, event.block.z-50)
        let entities = event.level.getEntitiesWithin(box).filter(entity => !entity.player)
        entities.forEach(entity => {
            let dweller = event.level.createEntity('cave_dweller:cave_dweller')
            dweller.x = entity.x
            dweller.y = entity.y
            dweller.z = entity.z
            dweller.spawn()
            entity.kill()
            dweller.setTarget(event.player)
        })


    }
})



EntityEvents.hurt('player', (event) => {
    if (event.server.persistentData.glass_bones != true) return
    if (!event.source.toString().includes('fall')) return
    let damage = event.damage
    Utils.server.runCommandSilent(`/damage ${event.entity.uuid} ${damage*5} minecraft:fall`)
    event.cancel()
})



EntityEvents.hurt(event => {
    if (!event.source.player) return; // Ensure the source is a player
    if (!event.entity.isMonster()) return; // Ensure the entity is a monster
    if (event.entity.tags.contains('boss')) return; // Ensure the entity is not a boss
    if (event.server.persistentData.unending_horde != true) return; // Ensure the unending_horde modifier is active
    if (event.entity.health <= event.entity.maxHealth * 0.25) return; 
    let spell_options = ['raise_dead', 'summon_vex', 'cursed_revenants', 'nocturnal_swarm']
    let spell = spell_options[Math.floor(Math.random() * spell_options.length)]
    let spells = []
    spells.push(spell)
    // choose a number between 1 and 3
    let num = Math.floor(Math.random() * 3) + 1; // 1 to 3
    if (event.server.persistentData.arcane_ascension == true) {
        let arcane_num = Math.floor(Math.random() * 2) + 1; // 1 to 2
        for (let i = 0; i < arcane_num; i++) {
            let new_spell = spell_options[Math.floor(Math.random() * spell_options.length)]
            spells.push(new_spell)
        }
    }
    newCast(event.entity, spells, event.source.player, num, 'unending_horde')

})


EntityEvents.hurt('minecraft:ghast', event => {
    if (!event.source.player) return; // Ensure the source is a player
    if (event.server.persistentData.weeping_fate != true) return; // Ensure the weeping_fate modifier is active
    let chance = Math.random()
    if (chance > 0.25) return; // 25% chance to cast blood_step
    let spells = ['blood_step']
    // choose a number between 1 and 3
    let num = Math.floor(Math.random() * 3) + 1; // 1 to 3
    // loop
    for (let i = 0; i < num; i++) {
        spells.push('blood_step') // add blood_step to the list
    }
    newCast(event.entity, spells, event.source.player, 1, 'weeping_fate_ghast')
    event.cancel() // Cancel the event to prevent the ghast from taking damage

})


