// Late game golems

/**
 * Limits:
 * - 2x gems. 
 *  -> 1: 50%, 
 *  -> roll 25% after the 50% chance for a second gem.
 * - 30% for 1x upgrade
 * - 25% chance of a special weapon, 25% chance of a heavy special weapon
 * -> If a special weapon is chosen, 50% chance to get a second one. Does not apply to heavy special weapons.
 * - 30% chance for 1x weapon
 * 
const late_game_golems = {
    gems: ['lategamegolems:lgg_gem_regen', 'lategamegolems:lgg_gem_speed', 'lategamegolems:lgg_gem_swim_speed', 'lategamegolems:lgg_gem_strength', 'lategamegolems:lgg_gem_fire_resistance'],
    upgrades: ['lategamegolems:lgg_upgrade_iron', 'lategamegolems:lgg_upgrade_emerald', 'lategamegolems:lgg_upgrade_diamond', 'lategamegolems:lgg_upgrade_netherite', 'lategamegolems:lgg_upgrade_heavy_iron', 'lategamegolems:lgg_upgrade_heavy_emerald', 'lategamegolems:lgg_upgrade_heavy_diamond', 'lategamegolems:lgg_upgrade_heavy_netherite', 'lategamegolems:lgg_upgrade_engineer', 'lategamegolems:lgg_upgrade_firefighter', 'lategamegolems:lgg_upgrade_waterfighter', 'lategamegolems:lgg_upgrade_xp', 'lategamegolems:lgg_upgrade_res_gold', 'lategamegolems:lgg_upgrade_res_emerald'],
    special_weapons: ['lategamegolems:lgg_flamer', 'lategamegolems:lgg_laser', 'lategamegolems:lgg_flamer_magic'],
    heavy_special_weapons: ['lategamegolems:lgg_plasma_cannon', 'lategamegolems:lgg_minigun', 'lategamegolems:lgg_shield', 'lategamegolems:lgg_thorn_shield', 'lategamegolems:lgg_heavy_shield'],
    weapons: ['lategamegolems:lgg_axe_iron', 'lategamegolems:lgg_axe_emerald', 'lategamegolems:lgg_axe_diamond', 'lategamegolems:lgg_axe_netherite', 'lategamegolems:lgg_mace_iron', 'lategamegolems:lgg_mace_emerald', 'lategamegolems:lgg_mace_diamond', 'lategamegolems:lgg_mace_netherite', 'lategamegolems:lgg_spear_emerald', 'lategamegolems:lgg_spear_netherite', 'lategamegolems:lgg_spear_iron', 'lategamegolems:lgg_sword_netherite', 'lategamegolems:lgg_sword_diamond', 'lategamegolems:lgg_sword_emerald', 'lategamegolems:lgg_sword_iron']
}

function getRandom(arr) {
    return arr[Math.floor(Math.random() * arr.length)]
}

function roll(chance) {
    return Math.random() < chance
}

EntityEvents.spawned('minecraft:iron_golem', event => {
    const golem = event.level.createEntity('lategamegolems:lgg_entity')
    golem.x = event.entity.x
    golem.y = event.entity.y
    golem.z = event.entity.z

    let inventory = []
    const usedSlots = {}

    // Slot 2: Special or Heavy Special Weapon
    if (roll(0.15)) {
        inventory.push({ Count: 1, Slot: 2, id: getRandom(late_game_golems.special_weapons) })
        usedSlots[2] = true

        // 50% chance for second special weapon — skip if slot 2 is taken
        if (roll(0.20) && !usedSlots[2]) {
            inventory.push({ Count: 1, Slot: 2, id: getRandom(late_game_golems.special_weapons) })
            usedSlots[2] = true
        }
    } else if (roll(0.15)) {
        inventory.push({ Count: 1, Slot: 2, id: getRandom(late_game_golems.heavy_special_weapons) })
        usedSlots[2] = true
    }

    // Slot 4: Gem(s)
    if (roll(0.25)) {
        inventory.push({ Count: 1, Slot: 4, id: getRandom(late_game_golems.gems) })
        usedSlots[4] = true

        if (roll(0.125) && !usedSlots[4]) {
            inventory.push({ Count: 1, Slot: 4, id: getRandom(late_game_golems.gems) })
            usedSlots[4] = true
        }
    }

    // Slot 6: Upgrade
    if (roll(0.15)) {
        inventory.push({ Count: 1, Slot: 6, id: getRandom(late_game_golems.upgrades) })
        usedSlots[6] = true
    }

    // Slot 7: Weapon
    if (roll(0.15)) {
        let weapon = getRandom(late_game_golems.weapons)
        let item = { Count: 1, Slot: 7, id: weapon }

        // Example: Add NBT for sword-type weapons
        if (weapon.includes('sword')) {
            item.tag = { reinforce_level: 0, reinforce_max: 10 }
            item.ForgeCaps = {
                "undermod:capability_item_life_leech": { power: 1 }
            }
        }

        inventory.push(item)
        usedSlots[7] = true
    }

    golem.mergeNbt({
        Inventory: {
            Items: inventory,
        }
    })


    golem.spawn()
    event.cancel()
})
 * 
 * 
 * 
 * 
 */

