

/**
 * 
 * EntityEvents.hurt(event => {
    if (!event.source.player) return;
    // Both the actual and immediate source must be a player
    if (!event.source.actual || !event.source.immediate) return; 
    let player = event.source.player;
    let damage = event.damage;
    if (!player.persistentData.get('hit_counter')) {
        player.persistentData.putInt('hit_counter', 1);
    } else {
        player.persistentData['hit_counter'] += 1;
    }

    if (!player.persistentData.get('damage_counter')) {
        player.persistentData.putFloat('damage_counter', damage);
    } else {
        player.persistentData['damage_counter'] += damage;
    }

    //tell(`Hit Counter: ${player.persistentData['hit_counter']}, Damage Counter: ${player.persistentData['damage_counter']}`, player);

    if (player.persistentData['hit_counter'] >= 10) {
        let averageDamage = player.persistentData['damage_counter'] / player.persistentData['hit_counter'];
        //tell(`Average Damage: ${averageDamage}`)
        player.persistentData.putFloat('average_damage', averageDamage);
        player.persistentData.putInt('hit_counter', 0);
        player.persistentData.putFloat('damage_counter', 0);
    }
})



ServerEvents.tick(event => {
    if (event.server.tickCount % 300 !== 0) return; // Run every 30 seconds
    let players = event.server.players
    let playerCount = players.length;
    if (playerCount === 0) return;
    let total_damage = 0;
    players.forEach(player => {
        if (player.persistentData.get('average_damage')) {
            total_damage += player.persistentData['average_damage'];
        }
    });
    let averageDamage = total_damage / playerCount;
    if (isNaN(averageDamage)) {
        averageDamage = 1; // Fallback to 1 if no valid average damage is found
    }
    averageDamage = averageDamage * (0.75 + ((playerCount-1) * 0.10))
    event.server.persistentData.putFloat('global_average_hit_damage', averageDamage.toFixed(2));
    let average_kill_hits = averageDamage * 3
    let health_mult = average_kill_hits / 20
    if (health_mult < 1) {
        health_mult = 1;
    }
    health_mult = 1 //// Temporary fix to disable health scaling
    event.server.persistentData.putFloat('global_health_multiplier', health_mult.toFixed(2));
    //tell(`Global Average Hit Damage: ${averageDamage.toFixed(2)}, Global Health Multiplier: ${health_mult.toFixed(2)}`)
})

 * 
 * 
 * 
 */

