// Cave dweller only spawns 10% of the tim


EntityEvents.hurt(event => {
    if (!event.entity.player) return
    if (event.source == null) return
    if (event.source.directEntity == null) return
    if (event.source.directEntity.type != 'cave_dweller:cave_dweller') return
    // add darkness
    let player = event.entity
    player.potionEffects.add('darkness', 100, 0)
    if (player.potionEffects.isActive('minecraft:night_vision')) {
        Utils.server.runCommandSilent(`effect clear ${player.username} night_vision`)
    }
    if (player.mainHandItem.id.includes('torch')) {
        player.setMainHandItem(Item.of('minecraft:air'))
    }
    if (player.offHandItem.id.includes('torch')) {
        player.setOffHandItem(Item.of('minecraft:air'))
    }
})

// Cave dweller deletes a random item from your inventory when you die

EntityEvents.death(event => {
    if (!event.entity.player) return
    if (event.source == null) return
    if (event.source.directEntity == null) return
    if (event.source.directEntity.type != 'cave_dweller:cave_dweller') return
    let player = event.entity
    let nonEmptyStacks = []
    for (let i = 0; i <= player.inventory.slots; i++) {
        let item = player.getSlot(i).get()
        if(!item.isEmpty()) {
            nonEmptyStacks.push(i)
        }
    }
    if(nonEmptyStacks.length === 0) return;
    let selectedStack = nonEmptyStacks[Math.floor(Math.random()*nonEmptyStacks.length)]
    player.inventory.setStackInSlot(selectedStack,Item.of('minecraft:air'))
})






EntityEvents.spawned('cave_dweller:cave_dweller', event => {
    let random = Math.random() 
    let special_conditions = true
    let players = event.server.players
    players.forEach(player => {
        let p = event.server.getPlayer(player.username)
        if (p.persistentData.dweller_trigger) {
            special_conditions = false
        }
    })
    if (special_conditions) {
        if (random > 0.1) {
            event.cancel()
        }
        if (event.level.day) {
            event.cancel()
        }
    }

    
    Utils.server.scheduleInTicks(5, e => {
        event.entity.playSound('cave_dweller:cavenoise_1', 10, 1)
    })
    console.log('Cave Dweller spawned')
    let target_player = event.level.getNearestPlayer(event.entity, 100)
    target_player.persistentData.dweller_trigger = false
    applyEffect(event.entity, 'minecraft:strength', 'infinite', 1, 'cave_dweller_strength')
    applyEffect(event.entity, 'minecraft:speed', 'infinite', 1, 'cave_dweller_speed')
    let entity = event.entity
    let level = event.level
    /**
     *     Utils.server.scheduleInTicks(5, e => {
        if (entity.alive) {
            e.repeating = true
            let entityX = entity.x
            let entityY = entity.y
            let entityZ = entity.z
            let nearest_player = level.getNearestPlayer(event.entity, 100)
            event.entity.setTarget(nearest_player)
            for (let x = -15; x <= 15; x++) {
                for (let y = -5; y <= 5; y++) {
                    for (let z = -15; z <= 15; z++) {

                        let blockPosX = entityX + x
                        let blockPosY = entityY + y
                        let blockPosZ = entityZ + z
                        let block = level.getBlock(parseInt(blockPosX), parseInt(blockPosY), parseInt(blockPosZ))
                        if (block.id.includes('torch')) {
                            block.set('minecraft:air')
                        }
                        if (block.id.includes('crying_obsidian')) {
                            block.set('minecraft:obsidian')

                        }
                    }
                }
            }

        } else {
            e.repeating = false
        }
    })
     * 
     */

})


// Cave dweller has a chance to cast blackout on the player
EntityEvents.hurt('cave_dweller:cave_dweller', event => {
    if (!event.source.player) return
    // 5% chance to cast blackout
    let random = Math.random()
    if (random > 0.05) return
    newCast(event.entity, 'blackout', event.source.player, 1, 'cave_dweller_blackout')
})


// Cave Dweller has a chance to cast bloodstep on the player
EntityEvents.hurt('cave_dweller:cave_dweller', event => {
    if (!event.source.player) return
    // 5% chance to cast bloodstep
    let random = Math.random()
    if (random > 0.15) return
    newCast(event.entity, 'blood_step', event.source.player, 1, 'cave_dweller_bloodstep')
})