BlockEvents.rightClicked('cataclysm:boss_respawner', event => {
    if (!event.block.entityData.toString().includes('scylla')) return;
    if (!event.player.mainHandItem.id.includes('cataclysm:abyssal_egg')) return;
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound cataclysm:abyss_blast ambient @a ${event.block.x} ${event.block.y} ${event.block.z} 2 2`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run time set night`);
    let entityX = event.block.x
    let entityY = event.block.y
    let entityZ = event.block.z
    for (let x = -40; x <= 40; x++) {
        for (let y = -5; y <= 60; y++) {
            for (let z = -40; z <= 40; z++) {
                let blockPosX = parseInt(entityX + x)
                let blockPosY = parseInt(entityY + y)
                let blockPosZ = parseInt(entityZ + z)
                let block = event.level.getBlock(parseInt(blockPosX), parseInt(blockPosY), parseInt(blockPosZ))
                if (block.id.includes('sea_lantern')) {
                    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run setblock ${blockPosX} ${blockPosY} ${blockPosZ} minecraft:crying_obsidian replace`)
                }
            }
        }
    }
    Utils.server.scheduleInTicks(40, () => {
        let entity = event.level.createEntity('traveloptics:the_nightwarden');
        entity.setPos(event.block.x, event.block.y+1, event.block.z);
        entity.spawn();
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound cataclysm:abyss_blast_only_shoot ambient @a ${event.block.x} ${event.block.y} ${event.block.z} 2 2`)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound cataclysm:portal_abyss_blast ambient @a ${event.block.x} ${event.block.y} ${event.block.z} 2 0.75`)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:unstable_ender ${entity.x} ${entity.y} ${entity.z} 0.05 1 0.05 0.50 50000 force @a`);
    })
})



PlayerEvents.tick(event => {
    if (event.server.tickCount % 100 != 0) return
    let entities = event.level.entities.filter(e => e.type == 'traveloptics:the_nightwarden' && event.player.distanceToEntity(e) < 50)
    if (entities.length == 0) return
    event.player.potionEffects.add('minecraft:darkness', 200, 0, true, true);
})
