EntityEvents.hurt(event => {
        if (event.source == null) return
        if (event.source.actual == null) return
        if (event.source.actual.type != 'mowziesmobs:ferrous_wroughtnaut') return
        if (!event.entity.player) return
        let player = event.entity
        // add darkness
        player.potionEffects.add('minecraft:slowness', 20, 1)
    })



let ferrous_wroughtnaut_attack_spells = [
    'stomp', 'blood_step', 'despair',
]

let ferrous_wroughtnaut_defensive_spells = [
    'fang_ward', 'haste'
]

EntityEvents.hurt('mowziesmobs:ferrous_wroughtnaut', event => {
    if (!event.source.player) return
    event.entity.attack(event.damage)
    if (!event.entity.potionEffects.isActive('minecraft:speed') || !event.entity.potionEffects.isActive('minecraft:haste')) {
        Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} minecraft:speed infinite 6 false`)
        Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} minecraft:haste infinite 1 false`)
    }
    // 5% chance to cast a spell
    let chance = Math.random()
    if (chance > 0.075) return
    event.entity.lookAt("eyes",new Vec3d(event.source.player.x, event.source.player.y, event.source.player.z))
    let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.entity.uuid} ${ferrous_wroughtnaut_defensive_spells[Math.floor(Math.random()*ferrous_wroughtnaut_defensive_spells.length)]}`)
})


EntityEvents.hurt(event => {
    if (!event.entity.player) return
    if (event.source == null) return
    if (event.source.actual == null) return
    if (event.source.actual.type != 'mowziesmobs:ferrous_wroughtnaut') return
    let chance = Math.random()
    if (chance > 0.50) return
    //loop 5 times 
    for (let i = 0; i < 15; i++) {
        event.source.actual.push(event.entity)
    }
    Utils.server.scheduleInTicks(10, () => {
        let randomSpell = ferrous_wroughtnaut_attack_spells[Math.floor(Math.random() * ferrous_wroughtnaut_attack_spells.length)]
        let spells = []
        spells.push(randomSpell)
        newCast(event.source.actual, spells, event.entity, 1, `ferrous_wroughtnaut_${randomSpell}`)
    })

})



EntityEvents.spawned('mowziesmobs:ferrous_wroughtnaut', event => {
    Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} minecraft:speed infinite 1 false`)
    Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} minecraft:haste infinite 1 false`)
    
})

