
/**
 * ServerEvents.loaded(event => {
    if (event.server.persistentData.get('sand_warrior')) return
    event.server.persistentData.putInt('sand_warrior', 0)
})


EntityEvents.hurt(event => {
    if (!event.entity.player) return
    if (event.source == null) return
    if (event.source.immediate == null) return
    let player = event.entity
    let entity_name = event.source.actual.type
    let entity = event.source.actual
    if (entity_name != 'hs_bosses:sand_warrior') return
    let dir = {
        x: player.getX() - entity.getX(),
        z: player.getZ() - entity.getZ()
      };
    let dirLength = Math.sqrt(dir.x * dir.x + dir.z * dir.z);
    if (dirLength > 0) {
        player.addMotion((dir.x / dirLength) * -5, 3, (dir.z / dirLength) * -5);
      }  
})
 * 
 */


/**
 * 
 * let sand_warrior_attack_spells = [
    'traveloptics:death_laser',
    'traveloptics:stele_cascade',
]

let sand_warrior_defensive_spells = [
    'divine_smite',
    'gust',
]

EntityEvents.hurt('hs_bosses:sand_warrior', event => {
    if (!event.source.player) return
    // 5% chance to cast a spell
    let chance = Math.random()
    if (chance > 0.05) return
    event.entity.lookAt("eyes",new Vec3d(event.source.player.x, event.source.player.y-1, event.source.player.z))
    let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.entity.uuid} ${sand_warrior_defensive_spells[Math.floor(Math.random()*sand_warrior_defensive_spells.length)]}`)
    
    
})


EntityEvents.spawned('hs_bosses:sand_warrior', event => {
    // timer between 10 seconds and 30 seconds
    let timer = Math.floor(Math.random() * 20) + 10
    Utils.server.scheduleInTicks(timer * 20, e => {
        if (!event.entity.alive) {
            e.repeating = false
            return
        } else {
            e.repeating = true
            let target = event.level.getNearestPlayer(event.entity, 80)
            if (target == null) return
            event.entity.lookAt("eyes",new Vec3d(target.x, target.y+1, target.z))
            // 40% chance to cast a spell
            let chance = Math.random()
            if (chance > 0.4) {
                let dim = event.level.dimension
                Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.entity.uuid} ${sand_warrior_attack_spells[Math.floor(Math.random()*sand_warrior_attack_spells.length)]}`)
            }
            
        }
    })
})
EntityEvents.spawned('hs_bosses:sand_warrior', event => {
    let entity = event.entity
    Utils.server.scheduleInTicks(100, ev => {
        if (!entity.alive) return
        let box = AABB.of(entity.x+20, entity.y+3, entity.z+20, entity.x-20, entity.y-3, entity.z-20)
        let dim = event.level
        let entitiesWithin = dim.getEntitiesWithin(box)
        if (entitiesWithin.length == 0) {
            ev.repeating = false
        } else {
            ev.repeating = true
        }
        entitiesWithin.forEach(ent => {
            if (!ent.player && !ent.tags.contains('tamed_beast')) return
            let strike = event.level.createEntity('mowziesmobs:sunstrike')
            strike.setPosition(ent.x, ent.y, ent.z)
            strike.spawn()
            Utils.server.scheduleInTicks(50, () => {
                strike.kill()
            })
            Utils.server.scheduleInTicks(1, e => {
                if (strike.alive) {
                    e.repeating = true
                    strike.teleportTo(ent.x, ent.y, ent.z)
                }
            })
        })
    })
})

 * 
 * 
 * 
 */


