
/**
 * New Warden Fight:
 *  - Throw echoing void at the warden to make it vulnerable (give it the glowing effect to show when it is vulnerable)
 *  - You then have to right click on a sculk catalyst to recharge the echoing void
 *  - When you right click the sculk catalyst it will remove the block and teleport the warden to where the block was
 *  - You need to remove 4 sculk catalysts to recharge the echoing void once
 */


/**
 * 
 * EntityEvents.hurt('minecraft:warden', event => {
    if (event.source == null) return
    if (event.source.immediate == null) return
    if (event.source.immediate.tags.toString().includes('echoing_void') || event.source.immediate.type('kubejs:entity.echoing_void')) {
        event.entity.attack(event.entity.maxHealth * 0.15)
        let box = AABB.of(event.entity.x+40, event.entity.y+15, event.entity.z+40, event.entity.x-40, event.entity.y-15, event.entity.z-40)
        let entitiesWithin = event.level.getEntitiesWithin(box).filter(entity => entity.type == 'minecraft:player')
        entitiesWithin.forEach(player => {
            if (player.inventory.count('kubejs:echoing_void') >= 1) {
                player.cooldowns.removeCooldown('kubejs:echoing_void')
                player.cooldowns.addCooldown('kubejs:echoing_void', 999999)
                player.persistentData.wardenhorn_charge = 0
            }
        })
    } else {
        event.cancel()
    }
})

EntityEvents.spawned('minecraft:warden', event => {
    if (event.level.dimension != 'minecraft:overworld') return
    event.server.scheduleRepeatingInTicks(400, e => {
        if (!event.entity.alive) {
            e.clear()
        } else {
            let box = AABB.of(event.entity.x+40, event.entity.y+15, event.entity.z+40, event.entity.x-40, event.entity.y-15, event.entity.z-40)
            let entitiesWithin = event.level.getEntitiesWithin(box).filter(entity => entity.type == 'minecraft:player')
            let hunters = event.level.getEntitiesWithin(box).filter(entity => entity.type == 'deep_dark_regrowth:hunter')
            if (entitiesWithin.length >= 1) {
                let player = entitiesWithin[0]
                let username = player.username
                //get number between 2 and 5
                let random = Math.floor(Math.random() * 5) + 2
                Utils.server.runCommandSilent(`/tp ${event.entity.uuid} ${player.x + random} ${player.y} ${player.z + random}`)
                Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:end_rod ${event.entity.x} ${event.entity.y} ${event.entity.z} 1 1 1 0.5 100`)
            }
            if (hunters.length > 10) return 
            let x = event.entity.x
            let y = event.entity.y
            let z = event.entity.z
            let hunter = event.level.createEntity('deep_dark_regrowth:hunter')
            hunter.setPosition(x, y, z)
            hunter.spawn()
            let hunter2 = event.level.createEntity('deep_dark_regrowth:hunter')
            hunter2.setPosition(x, y, z)
            hunter2.spawn()
            let hunter3 = event.level.createEntity('deep_dark_regrowth:hunter')
            hunter3.setPosition(x, y, z)    
            hunter3.spawn()
            let hunter4 = event.level.createEntity('deep_dark_regrowth:hunter')
            hunter4.setPosition(x, y, z)
            hunter4.spawn()
            let hunter5 = event.level.createEntity('deep_dark_regrowth:hunter')
            hunter5.setPosition(x, y, z)
            hunter5.spawn()
        }
    })
})
 * 
 * 
 */


/**
 * 
 * 
 */


EntityEvents.spawned('minecraft:warden', event => {
    if (event.level.dimension != 'minecraft:overworld') {
        event.cancel()
    } else {
        event.entity.tags.add('warden_invuln')
    }
})

EntityEvents.hurt('warden', event => {
    if (event.source == null) return
    if (event.source.immediate == null) return
    //tell(event.source.immediate)
    if (event.entity.tags.contains('warden_invuln')) {
        if (event.source.immediate.type.toString().includes('entity.echoing_void') || event.source.immediate.tags.contains('echoing_void')) {
            event.server.players.forEach(server_player => {
                let player = event.server.getPlayer(server_player.username)
                player.cooldowns.addCooldown('kubejs:echoing_void', 999999999)
            })
            event.entity.tags.remove('warden_invuln')
            applyEffect(event.entity, 'minecraft:glowing', 400, 1)
            applyEffect(event.entity, 'minecraft:weakness', 400, 1)
            Utils.server.scheduleInTicks(400, () => {
                event.entity.tags.add('warden_invuln')
            })
        } else {
            let players = event.level.players.filter(player => player.distanceToEntity(event.entity) < 50)
            players.forEach(player => {
                player.tell('§8Read your guidebook to learn about this fight§7')
            })
            event.cancel()

        }
    } else {

    }
})

BlockEvents.rightClicked('minecraft:sculk_sensor', event => {
    if (event.player.mainHandItem.id != 'kubejs:echoing_void') return
    let player = event.player
    let x = event.block.x
    let y = event.block.y
    let z = event.block.z
    let box = AABB.of(x+30, y+10, z+30, x-100, y-10, z-30)
    let vultures_within = event.level.getEntitiesWithin(box).filter(entity => entity.type == 'alexsmobs:soul_vulture')
    vultures_within.forEach(vulture => {
        vulture.setTarget(player)
        vulture.setAgressive(true)
        Utils.server.runCommandSilent(`/effect give ${vulture.uuid} minecraft:speed infinite 1 true`)
    })
    Utils.server.runCommandSilent(`execute as ${player.username} run playsound graveyard:block.bone.ambient ambient @s ${x} ${y} ${z} 10 1`)
    Utils.server.runCommandSilent(`execute as ${player.username} run playsound alexscaves:forsaken_screech ambient @s ${x} ${y} ${z} 10 1`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle cataclysm:soul_lava ${x} ${y} ${z} 0.5 0.5 0.5 4 40`)
    Utils.server.runCommandSilent(`/setblock ${x} ${y} ${z} minecraft:air replace`)
    event.server.persistentData.sculk_catalyst_charge++
    let entitiesWithin = event.level.getEntitiesWithin(box).filter(entity => entity.type == 'minecraft:warden')
    let counter = 0
    entitiesWithin.forEach(warden => {
        if (counter > 0) return
        counter++
        Utils.server.scheduleInTicks(20, () => {
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run tp ${warden.uuid} ${x} ${y} ${z}`)
        })
        
    })
    // Loop 4 times
    for (let i = 0; i < 2; i++) {
        let soul_vulture = event.level.createEntity('alexsmobs:soul_vulture')
        soul_vulture.setPosition(x, y, z)
        soul_vulture.spawn()
        soul_vulture.addMotion(0, 0.5, 0)
    }
    if (event.server.persistentData.sculk_catalyst_charge < 5) return
    Utils.server.runCommandSilent(`execute as ${player.username} run playsound graveyard:block.bone.placed ambient @s ${player.x} ${player.y} ${player.z} 10 1`)
    event.server.persistentData.sculk_catalyst_charge = 0
    let players = event.server.players
    players.forEach(server_player => {
        let p = event.server.getPlayer(server_player.username)
        p.cooldowns.removeCooldown('kubejs:echoing_void')
    })
})

ItemEvents.pickedUp('kubejs:echoing_void', event => {
    event.server.persistentData.putInt('sculk_catalyst_charge', 0)
})



EntityEvents.hurt('player', event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (event.source.actual.type != 'alexsmobs:soul_vulture') return
    if (event.source.actual.tags.contains('tamed_beast')) return
    Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} minecraft:weakness 5 1 false`)
})

EntityEvents.death('alexsmobs:soul_vulture', event => {
    if (event.entity.tags.contains('tamed_beast')) return
    if (!event.source.player) return
    let player = event.source.player
    Utils.server.runCommandSilent(`/effect give ${player.uuid} minecraft:strength 5 1 false`)
})