let minecraft_bossfight_spells = {
    'minecraft:elder_guardian': {
        attack: [
            'chain_lightning',
            'traveloptics:tidal_grasp',
        ],
        defensive: [
            'gust',
            'traveloptics:bubble_spray',
        ]
    },
    'minecraft:ender_dragon': {
        attack: [
            'traveloptics:abyssal_blast',
            'traveloptics:blood_howl',
        ],
        defensive: [
            'traveloptics:cursed_minefield',
        ]
    } 
}

Object.entries(minecraft_bossfight_spells).forEach(([entity, spells]) => {
    EntityEvents.hurt(entity, event => {
        let chance = Math.random()
        if (chance > 0.05) return
        let target = event.level.getNearestPlayer(event.entity, 80)
        event.entity.lookAt("eyes",new Vec3d(target.x, target.y, target.z))
        let dim = event.level.dimension
        Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.entity.uuid} ${spells.defensive[Math.floor(Math.random()*spells.defensive.length)]}`)
    })
    
    EntityEvents.spawned(entity, event => {
        let timer = Math.floor(Math.random() * 10) + 10
        Utils.server.scheduleInTicks(timer * 20, e => {
            if (!event.entity.alive) {
                e.repeating = false
                return
            } else {
                e.repeating = true
                let target = event.level.getNearestPlayer(event.entity, 80)
                if (target == null) return
                let dim = event.level.dimension
                //choose a number between 1 and 4
                let number = Math.floor(Math.random() * 4) + 1
                //loop through the number of times
                for (let i = 0; i < number; i++) {
                    Utils.server.scheduleInTicks(i * 8, () => {
                    event.entity.lookAt("eyes",new Vec3d(target.x, target.y+1, target.z))
                    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.entity.uuid} ${spells.attack[Math.floor(Math.random()*spells.attack.length)]} ${number}`)

                    })
                }
            }
        })
    })
})