let minecells_spells = {
    'minecells:concierge': {
        attack: [
            'fireball',
            'fire_breath',
        ],
        defensive: [
            'scorch',
        ]
    },
    'minecells:conjunctivius': {
        attack: [
            'traveloptics:void_eruption',
            'starfall',
        ],
        defensive: [
            'traveloptics:shadowed_miasma',
            'traveloptics:cursed_minefield'
        ]
    },
}


Object.entries(minecells_spells).forEach(([entity, spells]) => {
    EntityEvents.hurt(entity, event => {
        let chance = Math.random()
        if (chance > 0.20) return
        let target = event.level.getNearestPlayer(event.entity, 80)
        event.entity.lookAt("eyes",new Vec3d(target.x, target.y, target.z))
        let dim = event.level.dimension
        Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.entity.uuid} ${spells.defensive[Math.floor(Math.random()*spells.defensive.length)]}`)
    })
    
    EntityEvents.spawned(entity, event => {
        let timer = Math.floor(Math.random() * 10) + 10
        Utils.server.scheduleInTicks(timer * 20, e => {
            if (!event.entity.alive) {
                e.repeating = false
                return
            } else {
                e.repeating = true
                let target = event.level.getNearestPlayer(event.entity, 80)
                if (target == null) return
                event.entity.lookAt("eyes",new Vec3d(target.x, target.y+1, target.z))
                let dim = event.level.dimension
                Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.entity.uuid} ${spells.attack[Math.floor(Math.random()*spells.attack.length)]}`)
            }
        })
    })
})