

// The concierge cannot be hurt unless all of his minions are dead
EntityEvents.hurt('minecells:concierge', event => {
    let box = AABB.of(event.entity.x+30, event.entity.y+10, event.entity.z+30, event.entity.x-30, event.entity.y-10, event.entity.z-30)
    let entitiesWithin = event.level.getEntitiesWithin(box).filter(entity => entity.type == 'minecells:shocker' || entity.type == 'minecells:runner')
    if (entitiesWithin.length == 0) return
    event.cancel()
})


// The dead king will spawn with a regen potion effect and will spawn minions every 20 seconds
EntityEvents.spawned('minecells:concierge', event => {
    event.server.scheduleInTicks(400, e => {
        if (!event.entity.alive) {
            e.repeating = false
        } else {
            e.repeating = true
            let shocker = event.level.createEntity('minecells:shocker')
            let runner = event.level.createEntity('minecells:runner')
            shocker.setPosition(event.entity.x+1, event.entity.y, event.entity.z)
            runner.setPosition(event.entity.x-1, event.entity.y, event.entity.z)
            shocker.spawn()
            runner.spawn()
        }
    })
})
