

let minions = [
    'irons_spellbooks:summoned_skeleton',
    'irons_spellbooks:summoned_zombie',
]
// Hitting the summoned minions will heal the dead king unless the player is wearing the cursed necklace
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        if (event.entity.tags.contains('tamed_beast')) return
        let isMinion = false
        minions.forEach(minion => {
            if (event.entity.type == minion) {
                isMinion = true
            }
        })
        if (!isMinion) return
        let player = event.source.player
        let playerbox = AABB.of(event.entity.x+30, event.entity.y+10, event.entity.z+30, event.entity.x-30, event.entity.y-10, event.entity.z-30)
        let playersWithin = event.level.getEntitiesWithin(playerbox).filter(entity => entity.isPlayer())
        let banished_immortal = false
        playersWithin.forEach(p => {
            if (detectCurios(p, 'kubejs:banished_immortal') == true) {
                banished_immortal = true
            }
        })
        if (banished_immortal) return
        let box = AABB.of(event.entity.x+30, event.entity.y+10, event.entity.z+30, event.entity.x-30, event.entity.y-10, event.entity.z-30)
        let entitiesWithin = event.level.getEntitiesWithin(box).filter(entity => entity.type == 'irons_spellbooks:dead_king')
        if (entitiesWithin.length == 0) return
        let dead_king = entitiesWithin[0]
        dead_king.health += dead_king.maxHealth * 0.05

})

// The dead king cannot be hurt unless all of his minions are dead
EntityEvents.hurt('irons_spellbooks:dead_king', event => {
    let box = AABB.of(event.entity.x+30, event.entity.y+10, event.entity.z+30, event.entity.x-30, event.entity.y-10, event.entity.z-30)
    let entitiesWithin = event.level.getEntitiesWithin(box).filter(entity => entity.type == 'irons_spellbooks:summoned_skeleton' || entity.type == 'irons_spellbooks:summoned_zombie')
    if (entitiesWithin.length == 0) return
    entitiesWithin.forEach(minion => {
        if (minion.tags.contains('tamed_beast')) return
        event.cancel()
    })
})


// The dead king will spawn with a regen potion effect and will spawn minions every 20 seconds
EntityEvents.spawned('irons_spellbooks:dead_king', event => {
    let uuid = event.entity.uuid
    applyEffect(event.entity, 'minecraft:regeneration', 'infinite', 1, 'dead_king_regeneration')
    event.server.scheduleInTicks(10, () => {
        Utils.server.runCommandSilent(`cast ${uuid} raise_dead 2`)
    })
    event.server.scheduleRepeatingInTicks(600, e => {
        if (!event.entity.alive) {
            e.clear()
        } else {
            let players_online = parseInt(event.server.playerCount)
            let dim = event.level.dimension
            Utils.server.runCommandSilent(`/execute in ${dim} run cast ${uuid} raise_dead ${players_online}`)
        }
    })
})
