BlockEvents.leftClicked('skyarena:altar_battle', event => {
    if (event.item.id != 'eeeabsmobs:guardian_core') return
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run setblock ${event.block.x} ${event.block.y} ${event.block.z} minecraft:air replace`)
    Utils.server.scheduleInTicks(1, () => {
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run setblock ${event.block.x} ${event.block.y} ${event.block.z} summoningrituals:indestructible_altar replace`)
    })
    let players = event.level.getPlayers().filter(player => event.player.distanceToEntity(player) < 50)
    players.forEach(player => {
        Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete 139260DA1983A8C4`)
    })
    event.server.persistentData.putInt('immortal_x', event.block.x)
    event.server.persistentData.putInt('immortal_y', event.block.y)
    event.server.persistentData.putInt('immortal_z', event.block.z)
    event.server.persistentData.putString('immortal_dim', event.level.dimension.toString())
})


SummoningRituals.start(event => {
    if (event.recipe.id.toString() != 'kubejs:immortal_summon') return
    let player = event.player
    let server = player.server
    let x = server.persistentData.getInt('immortal_x')
    let y = server.persistentData.getInt('immortal_y')
    let z = server.persistentData.getInt('immortal_z')
    if (x == null || y == null || z == null) {
        event.cancel()
        return
    }
    let dim = server.persistentData.getString('immortal_dim')
    let box = AABB.of(x + 25, y + 25, z + 25, x - 25, y - 25, z - 25)
    let entitiesWithin = player.level.getEntitiesWithin(box).filter(entity => entity == player)
    if (entitiesWithin.length < 1) {
        event.cancel()
    }

})
