let corpse_warlock = {
    'eeeabsmobs:crimson_ray': 'cofh_core:wrenched',
    'eeeabsmobs:blood_ball':'runiclib:bleeding',
    'eeeabsmobs:crimson_crack':'minecraft:slowness',
    'eeeabsmobs:corpse_warlock': 'cofh_core:sundered'
}

EntityEvents.hurt('player', event => {
    Object.entries(corpse_warlock).forEach(([corpse, effect]) => {
        if (event.source.actual == null) return
        if (!event.source.actual.type.toString().includes(corpse) && !event.source.immediate.type.toString().includes(corpse)) return
        let player = event.entity
        player.potionEffects.add(effect, 40, 0, true, true)
    })
})


EntityEvents.spawned('eeeabsmobs:corpse_warlock', event => {
    event.server.persistentData.putInt('corpse_warlock:hurt', 0)
    event.entity.playSound('graveyard:block.bone.ambient', 10, 1)
    Utils.server.scheduleInTicks(360, e => {
        if (event.entity.alive) {
            event.entity.playSound('graveyard:block.bone.ambient', 10, 1)
            e.repeating = true
        } else {
            e.repeating = false
        }
    })
})

EntityEvents.hurt('eeeabsmobs:corpse_warlock', event => {
    if (event.entity.tags.contains('corpse_warlock:levitating')) return
    if (event.entity.health < event.entity.maxHealth/2) {
        event.entity.playSound('graveyard:entity.lich.levitation')
        event.entity.tags.add('corpse_warlock:levitating')
    }
})




/**
 * let dart_counter =new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('kubejs_class:shinobi')) return
    if (dart_counter[event.player.username] == undefined) {
        dart_counter[event.player.username] = 30
    } else {
        dart_counter[event.player.username] -= 1
    }

    let player = event.player
    if (player.blockStateOn.block != 'Block{minecraft:air}') return



    if (dart_counter[event.player.username] > 0) return
    if (!event.player.shiftKeyDown) return;
    dart_counter[event.player.username] = 30
    // Create an arrow entity
   
});
 * 
 * 
 */

ItemEvents.firstLeftClicked('kubejs:corrupted_shard', event => {
    let player = event.player;
    if (player.cooldowns.isOnCooldown('kubejs:corrupted_shard')) {
        player.tell('Only Corpses may charge the shard')
    } else {
        let arrow = event.level.createEntity('kubejs:entity.corrupted_shard');
        arrow.tags.add(`Owner:${event.player.username}`);
        
        // Set the arrow's initial position to be at the player's location
        arrow.setPosition(event.player.x, event.player.y + 1, event.player.z);
        let x_rad = event.player.pitch * JavaMath.PI / 180;
        let y_rad = event.player.yaw * JavaMath.PI / 180;
    
        let dirV = {
            x: -Math.sin(y_rad) * Math.cos(x_rad),
            y: -Math.sin(x_rad),
            z: Math.cos(y_rad) * Math.cos(x_rad)
        }
        arrow.addMotion(dirV.x * 8, dirV.y * 8, dirV.z * 8)
    
        // Spawn the arrow in the world
        arrow.spawn();
        arrow.playSound('alexscaves:extinction_spear_throw', 1, 2)
        arrow.playSound('graveyard:block.bone.ambient', 1, 1)
        player.cooldowns.addCooldown('kubejs:corrupted_shard', 999999)
    }

})

let shard_charging_entites = [
    'eeeabsmobs:corpse',
    'eeeabsmobs:corpse_to_player',
    'eeeabsmobs:corpse_villager',

]

ItemEvents.pickedUp('kubejs:corrupted_shard', event => {
    event.server.persistentData.putInt('shard_consumed', 0)
})



shard_charging_entites.forEach(entity => {
    EntityEvents.death(entity, event => {
        if (!event.source.player) return
        let player = event.source.player
        //Utils.server.tell(player.inventory.count('kubejs:corrupted_shard'))
        if (!player.inventory.count('kubejs:corrupted_shard') > 0) return
        if (!player.cooldowns.isOnCooldown('kubejs:corrupted_shard')) return
        event.server.persistentData.shard_consumed += event.entity.maxHealth
        if (event.server.persistentData.shard_consumed < 60) return
        event.server.persistentData.shard_consumed = 0
        player.cooldowns.removeCooldown('kubejs:corrupted_shard')
        event.entity.playSound('alexscaves:amber_monolith_place')
        Utils.server.runCommand(`/photon fx photon:corrupted_shard_indicator entity ${player.username}`)
    })
})


EntityEvents.hurt('eeeabsmobs:corpse_warlock', event => {
    let dam = event.server.persistentData.getInt(`corpse_warlock:hurt`)
    dam += event.damage
    if (dam < 100) return
    let box = AABB.of(event.entity.x+30, event.entity.y+30, event.entity.z+30, event.entity.x-30, event.entity.y-30, event.entity.z-30)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(entity => entity.player)
    entitiesWithin.forEach(entity => {
        // loop 30 times
        for (let i = 0; i < 30; i++) {
            event.entity.push(entity)
        }
    })

})



EntityEvents.hurt('eeeabsmobs:corpse_warlock', event => {
    let box = AABB.of(event.entity.x+5, event.entity.y+3, event.entity.z+5, event.entity.x-5, event.entity.y-3, event.entity.z-5)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    let player = null
    if (event.source.player) {
        player = event.source.player
    }
    // use a filter to see if theres a corrupted shard entity
    let corrupted_shard = entitiesWithin.filter(entity => entity.type == 'kubejs:entity.corrupted_shard')
    if (corrupted_shard.length == 0) {
        player.tell('Corruption is not present.')
        player.tell('§8Read your guidebook to learn about this fight§7')
        applyEffect(event.entity, 'minecraft:strength', 200, 0)
        applyEffect(event.entity, 'minecraft:haste', 200, 0)
        event.cancel()
    } else {
        Utils.server.runCommandSilent(`/effect clear ${event.entity.uuid} minecraft:strength`)
        Utils.server.runCommandSilent(`/effect clear ${event.entity.uuid} minecraft:haste`)
        return
    }
})



EntityEvents.spawned('kubejs:entity.corrupted_shard', event => {
    Utils.server.scheduleInTicks(10, e => {
        if (event.entity.alive) {
            let box = AABB.of(event.entity.x+30, event.entity.y+30, event.entity.z+30, event.entity.x-30, event.entity.y-30, event.entity.z-30)
            let dim = event.level
            let entitiesWithin = dim.getEntitiesWithin(box)
            entitiesWithin.forEach(ent => {
                if (ent.type == 'eeeabsmobs:corpse_warlock') {
                    if (ent.alive) {
                        ent.teleportTo(event.entity.x, event.entity.y, event.entity.z)
                        e.repeating = true
                    } else {
                        e.repeating = false
                    }
                } else if (ent.type == 'kubejs:entity.corrupted_shard') {
                    if (ent == event.entity) return
                    ent.kill()
                } else {
                    return
                }
            })
        } else {
            e.repeating = false
        }
    })
    Utils.server.scheduleInTicks(10, () => {
        Utils.server.runCommand(`/photon fx photon:corrupted_shard_aura entity ${event.entity.uuid}`)
    })
    event.server.scheduleInTicks(400, () => { // 400 ticks = 20 seconds
        event.entity.playSound('minecraft:block.large_amethyst_bud.place', 1, 1)
        event.entity.kill()

    })
})

