/** Nether Gauntlet Fight
 *  - You will gain a levitation effect if you are not crouching and you are hit by the gauntlet
 *  - However, if you are crouching, you will not be able to damage the gauntlet
 * 
 */

EntityEvents.hurt('player', event => {
    if (event.source.actual == null) return
    if (!event.source.actual.type.toString().includes('bosses_of_mass_destruction:gauntlet')) return
    //Utils.server.tell(event.source.immediate.type)
    let player = event.entity
    if (player.crouching) return
    player.potionEffects.add('minecraft:levitation', 5, 40)
})

EntityEvents.hurt('bosses_of_mass_destruction:gauntlet', event => {
    if (!event.source.player) return
    let player = event.source.player
    if (player.crouching) {
        event.cancel()
    }
})


EntityEvents.hurt('bosses_of_mass_destruction:gauntlet', event => {
    if (!event.source.player) return
    // 5% chance to cast a spell
    let chance = Math.random()
    if (chance > 0.05) return
    event.entity.lookAt("eyes",new Vec3d(event.source.player.x, event.source.player.y, event.source.player.z))
    let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.entity.uuid} heat_surge`)  
})





EntityEvents.spawned('bosses_of_mass_destruction:gauntlet', event => {
    Utils.server.scheduleInTicks(200, e => {
        if (!event.entity.alive) {
            e.repeating = false
            return
        } else {
            e.repeating = true
            let target = event.level.getNearestPlayer(event.entity, 80)
            if (target == null) return
            event.entity.lookAt("eyes",new Vec3d(target.x, target.y+1, target.z))
            let barrage_chance = Math.random()
            // 20% chance to cast root
            if (barrage_chance > 0.5) return
            let spells = [
                'blaze_storm',
                'fireball',
                'scorch'

            ]
            let spell = []
            spell.push(spells[Math.floor(Math.random()*spells.length)])
            newCast(event.entity, spell, target, 2, `gauntlet_${spell[0]}`)
        }
    })
})