const boss_variants_obj = global.boss_data




let var_mods = {
    // Add schools
    'iceandfire:fire_dragon_blood': {
        effect: 'add_school',
        value: 1,
        power_mod: 0.1
    },
    'iceandfire:fire_dragon_heart': {
        effect: 'add_school',
        value: 3,
        power_mod: 0.2
    },
    'iceandfire:ice_dragon_blood': {
        effect: 'add_school',
        value: 6,
        power_mod: 0.4
    },
    'iceandfire:lightning_dragon_blood': {
        effect: 'add_school',
        value: 9,
        power_mod: 0.6
    },
    // Boost Spellcaster
    'iceandfire:ice_dragon_heart': {
        effect: 'boost_spellcaster',
        value: 'superior',
        power_mod: 0.75
    },
    'iceandfire:lightning_dragon_heart': {
        effect: 'boost_spellcaster',
        value: 'exalted',
        power_mod: 1
    },
    //_____________________________________________________________________________________
    // Ciphers
    'kubejs:sunstrike': {
        effect: 'cipher',
        potion_effect: 'traveloptics:sunstrike',
        power_mod: 0.2
    },
    'kubejs:echoing_strike': {
        effect: 'cipher',
        potion_effect: 'irons_spellbooks:echoing_strikes',
        power_mod: 0.15
    },
    'kubejs:berserk': {
        effect: 'cipher',
        potion_effect: 'runiclib:berserk',
        power_mod: 0.3
    },
    'kubejs:blazing': {
        effect: 'cipher',
        potion_effect: 'runiclib:trail_blazing',
        power_mod: 0.2
    },
    'kubejs:thorns': {
        effect: 'cipher',
        potion_effect: 'runiclib:burning_thorns',
        power_mod: 0.25
    },
    'kubejs:adrenaline': {
        effect: 'cipher',
        potion_effect: 'runiclib:adrenaline',
        power_mod: 0.4
    },
    'kubejs:glacial_grasp': {
        effect: 'cipher',
        potion_effect: 'kubejs:glacial_grasp',
        power_mod: 1.2
    },
    'kubejs:gusting': {
        effect: 'cipher',
        potion_effect: 'alexsmobsinteraction:gusting',
        power_mod: 0.3
    },
    'kubejs:soulsteal': {
        effect: 'cipher',
        potion_effect: 'alexsmobs:soulsteal',
        power_mod: 0.5
    },
    'kubejs:thunderstorm': {
        effect: 'cipher',
        potion_effect: 'irons_spellbooks:thunderstorm',
        power_mod: 0.25
    },
    'kubejs:strength': {
        effect: 'cipher',
        potion_effect: 'minecraft:strength',
        power_mod: 0.5
    },
    'kubejs:resistance': {
        effect: 'cipher',
        potion_effect: 'minecraft:resistance',
        power_mod: 0.65
    },
    'kubejs:charged': {
        effect: 'cipher',
        potion_effect: 'irons_spellbooks:charged',
        power_mod: 0.30
    },

    // Grimoires
    'kubejs:armored1': {
        effect: 'grimoire',
        attribute: 'minecraft:generic.armor',
        value: 8,
        operation: 'add',
        power_mod: 0.15
    },
    'kubejs:armored2': {
        effect: 'grimoire',
        attribute: 'minecraft:generic.armor',
        value: 16,
        operation: 'add',
        power_mod: 0.3
    },
    'kubejs:demonic1': {
        effect: 'grimoire',
        attribute: 'attributeslib:crit_chance',
        value: 1.15,
        operation: 'multiply_base',
        power_mod: 0.5
    },
    'kubejs:demonic2': {
        effect: 'grimoire',
        attribute: 'attributeslib:crit_chance',
        value: 1.30,
        operation: 'multiply_base',
        power_mod: 0.75
    },
    'kubejs:blessed1': {
        effect: 'grimoire',
        attribute: 'attributeslib:dodge_chance',
        value: 0.10,
        operation: 'addition',
        power_mod: 0.25
    },
    'kubejs:blessed2': {
        effect: 'grimoire',
        attribute: 'attributeslib:dodge_chance',
        value: 0.20,
        operation: 'addition',
        power_mod: 0.5
    },
    'kubejs:focused1': {
        effect: 'grimoire',
        attribute: 'attributeslib:crit_damage',
        value: 1.25,
        operation: 'multiply_base',
        power_mod: 0.50
    },
    'kubejs:focused2': {
        effect: 'grimoire',
        attribute: 'attributeslib:crit_damage',
        value: 1.50,
        operation: 'multiply_base',
        power_mod: 0.75
    },
    'kubejs:gifted1': {
        effect: 'grimoire',
        attribute: 'irons_spellbooks:spell_power',
        value: 1.15,
        operation: 'multiply_base',
        power_mod: 0.25
    },
    'kubejs:gifted2': {
        effect: 'grimoire',
        attribute: 'irons_spellbooks:spell_power',
        value: 1.30,
        operation: 'multiply_base',
        power_mod: 0.5
    },
    'kubejs:swift1': {
        effect: 'grimoire',
        attribute: 'minecraft:generic.movement_speed',
        value: 1.25,
        operation: 'multiply_base',
        power_mod: 0.5
    },
    'kubejs:swift2': {
        effect: 'grimoire',
        attribute: 'minecraft:generic.movement_speed',
        value: 1.50,
        operation: 'multiply_base',
        power_mod: 0.75
    },
}

    
// Recipe for Boss Effigy 
ServerEvents.recipes(event => {
    event.recipes.summoningrituals.altar('kubejs:boss_effigy')
        .itemOutput('kubejs:effigy_dust');
});

// Scroll through boss effigy
ItemEvents.rightClicked('kubejs:boss_effigy', event => {
    if (!event.player.shiftKeyDown) return;

    // Retrieve defeated bosses
    let defeatedBosses = [];
    Object.entries(global.boss_data).forEach(([entity, data]) => {
        if (event.server.persistentData.get(data.id+'_dead') == true && data.summoning_stone == true) {
            //tell(entity)
            defeatedBosses.push(entity);
        }
        
    });
    //tell(defeatedBosses)

    if (defeatedBosses.length === 0) {
        event.player.tell("You haven't killed any bosses yet!");
        return;
    }

    let current = event.server.persistentData.current_boss ?? -1;
    current = (current + 1) % defeatedBosses.length;

    let selectedBoss = defeatedBosses[current];

    // get entity id

    // Update server persistent data
    event.server.persistentData.current_boss = current;

    // Capitalize the first letter of each word after splitting the string by underscores
    let formattedBossName = selectedBoss
        .split('_')
        .map(word => word.charAt(0).toUpperCase() + word.slice(1))
        .join(' ');

    // Update player's persistent data with the selected boss
        event.player.persistentData.selected_boss = selectedBoss;
        let boss_id = boss_variants_obj[selectedBoss].id
        //Update player's persistent data with the selected boss
        event.player.persistentData.putString('chosen_boss', boss_id);
        event.player.tell(`Selected Boss: §r§b${formattedBossName}`);
});


SummoningRituals.start(event => {
    // Check if the ritual catalyst is the boss effigy
    if (!event.recipe.catalyst.itemIds.toString().includes('kubejs:boss_effigy')) return;
    let ritual_id = Math.random().toString()
    let player = event.player;
    let ritualPos = event.pos;
    // Initialize total difficulty
    player.persistentData.putInt('boss_difficulty', 0)
    // Modifier Logic: Scan for Dropped Spell Items on the Ground
    let total_mods_difficulty = 0
    //Get the chosen boss
    let chosenBoss = player.persistentData.selected_boss;
    let boss_id = boss_variants_obj[chosenBoss].id
    // Get the boss tier    
    let base_difficulty = Number(boss_variants_obj[chosenBoss].tier)
    //Utils.server.tell(`Base Difficulty: ${base_difficulty}`)
    let added_difficulty = 0

    let total_mods = 0


    let itemBox = AABB.of(
        ritualPos.x - 15, ritualPos.y - 3, ritualPos.z - 15,
        ritualPos.x + 15, ritualPos.y + 3, ritualPos.z + 15
    );
    let dim = event.level
    let items = dim.getEntitiesWithin(itemBox)
    let school_counter = new WeakMap()
    items.forEach(item => {
        if (!item.pickable) {
            if (item.item != null) {
                if (var_mods[item.item.id]) {
                    //Utils.server.tell('Found a valid item')
                    let itemID = item.item.id
                    let mod = var_mods[itemID]
                    let effect = mod.effect
                    let value = mod.value
                    let power_mod = mod.power_mod
                    // Check if the item adds a school
                    if (effect == 'add_school') {
                        if (school_counter[ritual_id] == undefined) {
                            school_counter[ritual_id] = value
                        } else {
                            school_counter[ritual_id] += value
                        }
                        
                    // Check if the item boosts spellcaster
                    } else if (effect == 'boost_spellcaster') {
                        player.tags.add(`${value}_spellcaster`)
                    } else if (effect == 'cipher') {
                        if (!player.persistentData.get(`${itemID}_cipher_power`)) {
                            player.persistentData.putInt(`${itemID}_cipher_power`, 0)
                        } else {
                            player.persistentData[`${itemID}_cipher_power`] += 1
                        }
                    }
                    item.playSound('minecraft:entity.wither.ambient', 0.5, 0.5);
                    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle alexscaves:bio_pop ${item.x} ${item.y} ${item.z} 0.1 1 0.1 0.01 20`)
                    item.kill()
                    added_difficulty += base_difficulty * power_mod
                    total_mods += 1
                }
            }

        }
    })
    
    // Grimoire Logic: Check if the player is holding a grimoire in the offhand
    let offhandItem = player.offhandItem;
    if (var_mods[offhandItem.id]) {
        let attribute = var_mods[offhandItem.id].attribute
        let power_mod = var_mods[offhandItem.id].power_mod
        //Utils.server.tell(`power mod: ${power_mod}`)
        //Utils.server.tell(`Attribute: ${attribute}`)
        player.persistentData.putString('grimoire_attribute', attribute)
        player.tags.add('added_grimoire')
        player.persistentData.putString('offhand_item', offhandItem.id)
        added_difficulty += base_difficulty * 1 + Number(power_mod)
        total_mods += 1
        //Utils.server.tell(`total_mods: ${total_mods}`)
        //Utils.server.tell(`added_difficulty: ${added_difficulty}`)
    }
    
    if (total_mods > 0) {
        total_mods_difficulty = base_difficulty + (total_mods * 0.10)
    }
    //Utils.server.tell(`Total Mods Difficulty: ${total_mods_difficulty}  Base Difficulty: ${base_difficulty}  Added Difficulty: ${added_difficulty}`)
    let total_difficulty = total_mods_difficulty+base_difficulty + added_difficulty
    //Utils.server.tell(`Total Difficulty: ${total_difficulty}`)
    player.persistentData.putInt('boss_difficulty', total_difficulty)

    if (school_counter[ritual_id] != undefined) {
        player.persistentData.putInt('boss_schools', school_counter[ritual_id])
    }
})



SummoningRituals.complete(event => {
    // Check if the ritual catalyst is the boss effigy
    if (!event.recipe.catalyst.itemIds.toString().includes('kubejs:boss_effigy')) return; // Replaced includes with indexOf
    let player = event.player;
    let ritualPos = event.pos;
    let level = event.level;
    // Create the boss entity
    let bossEntity = level.createEntity(player.persistentData.chosen_boss); // Replace 'kubejs:boss' with your actual boss entity ID
    bossEntity.setPosition(ritualPos.x, ritualPos.y, ritualPos.z);
    let boss_name = ''
    let tier = 0
    // Loop through the boss variants to find the id that matches the chosen boss and set the tier
    Object.entries(boss_variants_obj).forEach(([boss_name, data]) => {
        if (data.id == player.persistentData.chosen_boss) {
            boss_name = boss_name
            tier = data.tier
        }
    })
    //player.tell(`Tier: ${tier}`)  
    // Set the total difficulty as persistent data on the boss
   // player.persistentData.boss_difficulty += tier
    
    bossEntity.mergeNbt({
       Tags: ['boss_variant']
    })

    // Spawn the boss into the world
    bossEntity.spawn();
    bossEntity.tags.add('boss_variant')

    // Boss School Logic
    if (player.persistentData.get('boss_schools')) {
        let total_schools = player.persistentData.getInt('boss_schools')
        player.persistentData.remove('boss_schools')

        let picked_schools = []
        // Loop equivalent to the total number of schools
        for (let i = 0; i < total_schools; i++) {
            let school = pickRandomSchool(picked_schools)
            //Utils.server.tell(`Picked School: ${school}`)
            picked_schools.push(school)
            applySchool(bossEntity, school)
        }
    }

    // Spellcaster boost logic
    if (player.tags.contains('exalted_spellcaster')) {
        player.tags.remove('exalted_spellcaster');
        exaltedMage(bossEntity)
    } else if (player.tags.contains('superior_spellcaster')) {
        player.tags.remove('superior_spellcaster');
        superiorMage(bossEntity)
    }


    // Grimoire Logic
    if (player.tags.contains('added_grimoire')) {
        let attribute = player.persistentData.getString('grimoire_attribute')
       // Utils.server.tell(`Attribute: ${attribute}`)
        let value = var_mods[player.persistentData.getString('offhand_item')].value
        let operation = var_mods[player.persistentData.getString('offhand_item')].operation
        let modifierName = generateRandomString(16);
        let uuid = generateUUID();
        Utils.server.scheduleInTicks(3, () => {
            Utils.server.runCommandSilent(`/attribute ${bossEntity.uuid} ${attribute} modifier add ${uuid} ${modifierName} ${value} ${operation}`);
            // Remove the tag from the player
            player.persistentData.remove('grimoire_attribute')
            player.persistentData.remove('offhand_item')
            player.tags.remove('added_grimoire')

        });
    }


    // Cipher Logic
    let cipher_items = Object.keys(player.persistentData).filter(key => key.endsWith('_cipher_power'))
    cipher_items.forEach(item => {
        // remove the _cipher_power suffix
        let itemID = item.split('_cipher_power')[0]
        let power = player.persistentData.getInt(item)
        let power_mod = var_mods[itemID].power_mod
        player.persistentData.boss_difficulty += Number(power_mod)
        let potion_effect = var_mods[itemID].potion_effect
        Utils.server.scheduleInTicks(3, () => {
            Utils.server.runCommandSilent(`/effect give ${bossEntity.uuid} ${potion_effect} infinite ${power} true`)
            player.persistentData.remove(item)
        })
        //Utils.server.tell(`Power: ${power} Power Mod: ${power_mod} Potion Effect: ${potion_effect}`)
    })
    bossEntity.persistentData.putInt('boss_difficulty', player.persistentData.getInt('boss_difficulty'))
    adjustBossHealth(bossEntity)

    player.tell(`§7Boss Difficulty:§a ${tier} §f→ §4${bossEntity.persistentData.getInt('boss_difficulty')}§7`)
    player.persistentData.remove('boss_difficulty')


})















// Boss Effigy Drop
EntityEvents.death(event => {
    if (!event.entity.isMonster()) return
    if (!event.source.player) return
    if (isAlly(event.source.player, event.entity)) return
    if (Number(event.entity.maxHealth) < 20.0) return
    if (event.entity.tags.contains('boss')) return
    let chance = Math.random()
    // Actual Chance is 1% + 1% per 2 health above 20
    let mod = Math.floor((event.entity.maxHealth-20)/2)
    let actual_chance = 0.01 + 0.01*mod
    //Utils.server.tell(actual_chance)
    //Utils.server.tell(chance)
    if (chance > actual_chance) return
    Utils.server.runCommandSilent(`/execute at ${event.entity.uuid} run loot spawn ${event.entity.x} ${event.entity.y+1} ${event.entity.z} loot minecraft:loot_boxes/boss_effigy`)
})

let allCiphers = ['kubejs:sunstrike', 'kubejs:echoing_strike', 'kubejs:berserk', 'kubejs:blazing', 'kubejs:thorns', 'kubejs:adrenaline', 'kubejs:glacial_grasp', 'kubejs:gusting', 'kubejs:soulsteal', 'kubejs:thunderstorm', 'kubejs:strength', 'kubejs:resistance', 'kubejs:charged']
let allGrimoires = ['kubejs:armored1', 'kubejs:armored2', 'kubejs:demonic1', 'kubejs:demonic2', 'kubejs:blessed1', 'kubejs:blessed2', 'kubejs:focused1', 'kubejs:focused2', 'kubejs:gifted1', 'kubejs:gifted2', 'kubejs:swift1', 'kubejs:swift2']
const allLootboxes = [
    'common_helmet',
    'common_chestplate',
    'common_leggings',
    'common_boots',

    'rare_helmet',
    'rare_chestplate',
    'rare_leggings',
    'rare_boots',

    'mythical_helmet',
    'mythical_chestplate',
    'mythical_leggings',
    'mythical_boots',

    'create_parts',
    'create_gears',
    'create_switches',
    'create_machines',

    'food',
    'bookshelf',
]




EntityEvents.death(event => {
    let entity = event.entity
    if (!entity.tags.contains('boss_variant')) return

    let boss_difficulty = entity.persistentData.boss_difficulty
    // Legendary Gun Crates

        // divine blueprint
    let box = AABB.of(
        entity.x - 50, entity.y - 50, entity.z - 50,
        entity.x + 50, entity.y + 50, entity.z + 50
    );
    let playerswithin = entity.level.getEntitiesWithin(box).filter(entity => entity.isPlayer())
    let arcane_luck_count = 0
    playerswithin.forEach(player => {
        if (player.potionEffects.isActive('kubejs:arcane_luck')) {
            arcane_luck_count += 1
        }
    })

    // loop 1+arcane_luck_count times
    for (let i = 0; i < 1+arcane_luck_count; i++) {
        let orb_of_exaltation_roll = Math.random()
        let orb_of_exaltation_chance = 0.005*entity.persistentData.boss_difficulty
        if (orb_of_exaltation_roll > orb_of_exaltation_chance) {
            spawnItem('kubejs:orb_of_exaltation', 1, entity)
        }

        // Apotheosis Drops
        Object.entries(apoth_drops).forEach(([item, data]) => {
            let chance = Math.random()
            let tier_multiplier = data.tier_multiplier
            let base_chance = data.chance
            let actual_chance = (boss_difficulty * tier_multiplier) * base_chance
            if (chance < actual_chance) {
                spawnItem(item, data.quantity, entity)
            }
        })

        let allLootboxChance = Number(entity.persistentData.boss_difficulty) * 0.01
        if (allLootboxChance >= Math.random()) {
            let prefix = 'kubejs:'
            let suffix = '_loot_box'
            let random_lootbox1 = allLootboxes[Math.floor(Math.random() * allLootboxes.length)]
            let random_lootbox2 = allLootboxes[Math.floor(Math.random() * allLootboxes.length)]
            random_lootbox1 = prefix+random_lootbox1+suffix
            random_lootbox2 = prefix+random_lootbox2+suffix
            //Utils.server.tell(random_lootbox1)
            //Utils.server.tell(random_lootbox2)
            spawnItem(random_lootbox1, 1, entity)
            spawnItem(random_lootbox2, 1, entity)
        }


        if (boss_difficulty > 15) {
            let affinityGemChance = 0.01*Number(entity.persistentData.boss_difficulty)
            if (affinityGemChance >= Math.random()) {
                let prefix = 'kubejs:'
                if (boss_difficulty > 30 && boss_difficulty < 50) {
                    prefix = 'kubejs:superior_'
                }
                if (boss_difficulty > 50) {
                    prefix = 'kubejs:exalted_'
                }
                let random_affinity_gem = allAffinityGems[Math.floor(Math.random() * allAffinityGems.length)]
                let droppedGem = prefix+random_affinity_gem
                spawnItem(droppedGem, 1, entity)
            }
        }



        let cipherChance = 0.05*Number(entity.persistentData.boss_difficulty)
        if (cipherChance >= Math.random()) {
            let random_cipher = allCiphers[Math.floor(Math.random() * allCiphers.length)]
            spawnItem(random_cipher, 1, entity)
        }

        let grimoireChance = 0.05*Number(entity.persistentData.boss_difficulty)
        if (grimoireChance >= Math.random()) {
            let random_grimoire = allGrimoires[Math.floor(Math.random() * allGrimoires.length)]
            spawnItem(random_grimoire, 1, entity)
        }

        let inventory_upgrade_chance = 0.001*Number(entity.persistentData.boss_difficulty)
        if (inventory_upgrade_chance >= Math.random()) {
            spawnItem('kubejs:inventory_upgrade', 1, entity)
        }

        let starlitOrbChance = 0.08*Number(entity.persistentData.boss_difficulty)
        if (starlitOrbChance >= Math.random()) {
            spawnItem('kubejs:starlit_orb', 1, entity)
        }

        let num = Number(entity.persistentData.boss_difficulty) / 30
        rollOrbsAndTotemsDrop(entity, 0.25 + num)
        rollOrbsAndTotemsDrop(entity, 0.25 + num)
        rollOrbsAndTotemsDrop(entity, 0.25 + num)
        rollOrbsAndTotemsDrop(entity, 0.25 + num)
    }
})


let allAffinityGems = [
        'blood_affinity_gem',
        'ender_affinity_gem',
        'fire_affinity_gem',
        'ice_affinity_gem',
        'lightning_affinity_gem',
        'nature_affinity_gem',
        'holy_affinity_gem',
        'evocation_affinity_gem',
        'aqua_affinity_gem',
        'geo_affinity_gem',
    ]



let apoth_drops = {
    'apotheosis:gem_fused_slate': {
        chance: 0.10,
        tier_multiplier: 1.15,
        quantity: 3
    },
    'apotheosis:prismatic_web': {
        chance: 0.05,
        tier_multiplier: 1.10,
        quantity: 5
    },
    'apotheosis:common_material': {
        chance: 0.10,
        tier_multiplier: 1.05,
        quantity: 5
    },
    'apotheosis:uncommon_material': {
        chance: 0.075,
        tier_multiplier: 1.10,
        quantity: 4
    },
    'apotheosis:rare_material': {
        chance: 0.05,
        tier_multiplier: 1.05,
        quantity: 3
    },
    'apotheosis:epic_material': {
        chance: 0.03,
        tier_multiplier: 1.10,
        quantity: 2
    },
    'apotheosis:mythic_material': {
        chance: 0.0075,
        tier_multiplier: 1.01,
        quantity: 1
    }

}


EntityEvents.spawned(event => {
    Utils.server.scheduleInTicks(20, () => {
        if (!event.entity.tags.contains('boss_variant')) return;
        if (!event.entity.tags.contains('boss_spellcaster')) return;
        let exclude = []
        let school = pickRandomSchool(exclude)
        applySchool(event.entity, school)
        exaltedMage(event.entity)
    })
})