
// loop through the drops object, the first parameter is the entity id, the second is the object containing the drop and chance

// Object.entries(boss_drops_two).forEach(([entity, data]) => {
//     ServerEvents.entityLootTables(event => {
//         event.modifyEntity(entity, table => {
//             table.addPool(pool => {
//                 pool.addItem(data.drop).randomChance(data.chance)
//             })
//         })
//     })
// })

// Object.entries(boss_drops).forEach(([entity, data]) => {
//     ServerEvents.entityLootTables(event => {
//         event.modifyEntity(entity, table => {
//             table.addPool(pool => {
//                 pool.addItem(data.drop).randomChance(data.chance)
//             })
//         })
//     })
// })


// Object.entries(boss_drops_three).forEach(([entity, data]) => {
//     ServerEvents.entityLootTables(event => {
//         event.modifyEntity(entity, table => {
//             table.addPool(pool => {
//                 pool.addItem(data.drop).randomChance(data.chance)
//             })
//         })
//     })
// })



/**


let boss_drops = {
    //________________________________________________________________
    // Tutorial
    'irons_spellbooks:archevoker': {
        drop: 'kubejs:earth_talisman_wand',
        chance: 0.1
    },
    'call_of_yucutan:ah_puch': {
        drop: 'kubejs:chunky_cheese_token_tl',
        chance: 1
    },
    'call_of_yucutan:kukulkan': {
        drop: 'kubejs:chunky_cheese_token_tr',
        chance: 1
    },

    'iceandfire:cyclops': {
        drop: 'kubejs:chunky_cheese_token_br',
        chance: 1
    },


    'mowziesmobs:ferrous_wroughtnaut': {
        drop: 'minecells:vine_rune',
        chance: 1
    },
    //________________________________________________________________
    // Chapter 1


    'alexscaves:magnetron': {
        drop: 'kubejs:aethereal_gemstone',
        chance: 0.1
    },
    'rats:ratlantean_automaton': {
        drop: 'kubejs:sufficiently_advanced_technology',
        chance: 0.1
    },

    //________________________________________________________________
    // Chapter 2

    'twilightforest:naga': {
        drop: 'kubejs:remains_of_the_elderwood',
        chance: 1
    },

    'minecraft:wither': {
        drop: 'kubejs:withered_crystal',
        chance: 0.1
    },
    'bosses_of_mass_destruction:gauntlet': {
        drop: 'kubejs:mysterious_gauntlet',
        chance: 0.1
    },
    'cataclysm:the_harbinger': {
        drop: 'cataclysm:laser_gatling',
        chance: 1
    },
    //________________________________________________________________
    // Chapter 3



    /**
     *     'blue_skies:starlit_crusher': {
        drop: 'kubejs:elderwood_sap',
        chance: 0.1
    },



    //________________________________________________________________
    // Chapter 4


    'graveyard:lich': {
        drop: 'kubejs:echoing_void',
        chance: 1
    },

    'bosses_of_mass_destruction:obsidilith': {
        drop: 'kubejs:pulsating_artifact',
        chance: 0.1
    },

    'cataclysm:ignis': {
        drop: 'kubejs:burning_souls',
        chance: 0.1
    },
    //________________________________________________________________
    // Chapter 5

    'irons_spellbooks:dead_king': {
        drop: 'kubejs:tears_of_creation',
        chance: 1
    },
    'galosphere:berserker': {
        drop: 'kubejs:specters_tablet',
        chance: 1
    },
    'eeeabsmobs:nameless_guardian': {
        drop: 'kubejs:heart_of_the_guardian',
        chance: 1
    },
    'blue_skies:arachnarch': {
        drop: 'kubejs:rough_moonstone',
        chance: 1
    },
    'blue_skies:alchemist': {
        drop: 'kubejs:charged_crystal',
        chance: 1
    },
    'cataclysm:netherite_monstrosity': {
        drop: 'kubejs:pure_corruption',
        chance: 1
    },
    //________________________________________________________________
    // Chapter 6
    'cataclysm:the_leviathan': {
        drop: 'kubejs:void_bucket',
        chance: 1
    },
    //________________________________________________________________
    // Misc
    'minecells:conjunctivius': {
        drop:'kubejs:dust_of_fallen_kingdoms',
        chance: 1
    },
    'rats:neo_ratlantean': {
        drop: 'cataclysm:necklace_of_the_desert',
        chance: 1
    },

    'rats:dutchrat': {
        drop: 'rats:gem_of_ratlantis',
        chance: 1
    },
    'cataclysm:the_prowler': {
        drop: 'kubejs:prowler_dust',
        chance: 1
    },
    'cataclysm:the_watcher': {
        drop: 'kubejs:watcher_dust',
        chance: 1
    },
    'block_factorys_bosses:sandworm': {
        drop: 'kubejs:living_stone',
        chance: 1
    },
    'aquamirae:eel': {
        drop: 'kubejs:eel_excrement',
        chance: 1
    },
    'aquamirae:maw': {
        drop: 'kubejs:maw_sludge',
        chance: 1
    },
    'illageandspillage:magispeller': {
        drop: 'kubejs:blightpowder',
        chance: 1
    },
    'eeeabsmobs:guling_sentinel_heavy': {
        drop: '7x blue_skies:turquoise_stonebrick',
        chance: 1
    },
    'bosses_of_mass_destruction:lich': {
        drop: 'kubejs:dark_winds',
        chance: 1
    },

    'mowziesmobs:sculptor': {
        drop: 'graveyard:middle_bone_staff',
        chance: 1
    },
    'illageandspillage:spiritcaller': {
        drop: 'graveyard:upper_bone_staff',
        chance: 1
    },





    'illageandspillage:ragno': {
        drop: 'kubejs:obsidilith_dust',
        chance: 1
    },

    'iceandfire:gorgon': {
        drop: 'kubejs:gorgon_dust',
        chance: 1
    },
    'alexscaves:luxtructosaurus': {
        drop: 'kubejs:eternal_flame',
        chance: 0.1
    },
    'cataclysm:deepling_warlock': {
        drop: 'kubejs:dust_of_deepsea_warlocks',
        chance: 1
    },
    'minecraft:warden': {
        drop: 'kubejs:parasitic_slime',
        chance: 1
    },
    'block_factorys_bosses:yeti': {
        drop: 'kubejs:lost_stone',
        chance: 1
    },
     'iceandfire:hydra': {
        drop:'kubejs:serpents_tears',
        chance: 0.1
    },
 * 
 *     'minecells:concierge': {
        drop: 'kubejs:firewyrm_flask',
        chance: 0.11
    },
    'bosses_of_mass_destruction:void_blossom': {
        drop: 'kubejs:moonlit_mist',
        chance: 0.11
    },


    'soulsweapons:night_shade': {
        drop: 'kubejs:shade_effigy',
        chance: 1
    },
    'soulsweapons:draugr_boss': {
        drop: '3x soulsweapons:lost_soul',
        chance: 1
    },
    'soulsweapons:chaos_monarch': {
        drop: 'kubejs:ritual_dagger',
        chance: 1
    },
    'cataclysm:ender_guardian': {
        drop: 'kubejs:empyrean_scarab',
        chance: 0.1
    },
}

let boss_drops_two = {
    'bosses_of_mass_destruction:lich': {
        drop: 'kubejs:forlorn_wayfinder',
        chance: 1
    },
    'minecraft:wither': {
        drop: 'kubejs:withered_dust',
        chance: 1
    },
    'irons_spellbooks:archevoker': {
        drop: 'kubejs:murky_potion',
        chance: 1
    },
    'cataclysm:ender_golem': {
        drop: 'kubejs:corrupted_shard',
        chance: 1
    },
    'bosses_of_mass_destruction:void_blossom': {
        drop: 'graveyard:lower_bone_staff',
        chance: 1
    },
    'twilightforest:snow_queen': {
        drop: 'kubejs:hardened_void',
        chance: 1
    },
    'rats:dutchrat': {
        drop: 'rats:marbled_cheese_rat_head',
        chance: 1
    },

    'iceandfire:cyclops': {
        drop: 'kubejs:magnetic_wayfinder',
        chance: 1
    },
     'hs_bosses:sand_warrior': {
        drop: 'kubejs:molten_sands',
        chance: 0.1
    },
    'bosses_of_mass_destruction:obsidilith': {
        drop: 'kubejs:stormheart_lullaby',
        chance: 0.1
    },
    'bosses_of_mass_destruction:obsidilith': {
        drop: 'kubejs:primordial_wayfinder',
        chance: 1
    },
    'minecells:conjunctivius': {
        drop:'minecells:tentacle',
        chance: 0.5
    },

    'mowziesmobs:umvuthi': {
        drop: 'kubejs:toxic_wayfinder',
        chance: 1
    },
    'alexscaves:magnetron': {
        drop: 'kubejs:chunky_cheese_token_bl',
        chance: 1
    },
    'block_factorys_bosses:sandworm': {
        drop: 'kubejs:purification_totem',
        chance: 1
    },

    'eeeabsmobs:immortal_executioner': {
        drop: '2x eeeabsmobs:immortal_ingot',
        chance: 1
    },
    'eeeabsmobs:immortal': {
        drop: 'blue_skies:zeal_lighter',
        chance: 1
    },
    'eeeabsmobs:guling_sentinel_heavy': {
        drop: '14x blue_skies:lunar_stonebrick',
        chance: 1
    },
    'minecells:concierge': {
        drop: 'kubejs:phalanx_ring',
        chance: 1
    },
    'minecraft:warden': {
        drop: 'kubejs:indistinguishable_magic',
        chance: 1
    },
    'mowziesmobs:sculptor': {
        drop: 'kubejs:bloodstone_artifact',
        chance: 1
    },
    'twilightforest:ur_ghast': {
        drop: 'kubejs:contained_void',
        chance: 1
    },
    'eeeabsmobs:corpse_warlock': {
        drop: 'kubejs:enslavement_elixir',
        chance: 0.1
    },
    'alexscaves:forsaken': {
        drop: 'kubejs:vial_of_evil',
        chance: 1
    },
    'blue_skies:summoner': {
        drop: 'kubejs:blaze_core',
        chance: 0.1
    },
    'aquamirae:captain_cornelia': {
        drop: 'kubejs:captains_elixir',
        chance: 0.1
    },

    'rats:rat_king': {
        drop: 'kubejs:twisted_rot',
        chance: 1
    },
    'cataclysm:ignis': {
        drop: 'cataclysm:the_incinerator',
        chance: 0.1
    },
    'mowziesmobs:ferrous_wroughtnaut': {
        drop: 'kubejs:cursed_necklace',
        chance: 1
    },
    'alexscaves:luxtructosaurus': {
        drop: 'cataclysm:burning_ashes',
        chance: 1
    },
    'soulsweapons:accursed_lord_boss': {
        drop: 'soulsweapons:essence_of_eventide',
        chance: 1
    },
    'fromtheshadows:nehemoth': {
        drop: 'minecraft:totem_of_undying',
        chance: 1
    },
    'iceandfire:gorgon': {
        drop: 'kubejs:earth_talisman_gem',
        chance: 1
    },
    'fromtheshadows:bulldrogioth': {
        drop: '3x fromtheshadows:crimson_shell',
        chance: 1
    }

}


const boss_drops_three = {
    'mowziesmobs:sculptor': {
        drop: 'mowziesmobs:earthrend_gauntlet',
        chance: 1
    },
    'minecraft:wither': {
        drop: 'minecraft:nether_star',
        chance: 1
    },
    'iceandfire:cyclops': {
        drop: 'iceandfire:cyclops_eye',
        chance: 1
    },
    'block_factorys_bosses:sandworm': {
        drop: 'graveyard:bone_dagger',
        chance: 1
    },
}

 * 
 */




// Consolidated single-entry unified_drops used below
const unified_drops = {
  // Single merged entry per entity
  'mutantmonsters:mutant_enderman': {
    'kubejs:mutant_enderman_heart': 1,
    'minecraft:chorus_fruit': 0.5
  },
  'minecraft:enderman': {
    'minecraft:chorus_fruit': 0.05
  },
  'irons_spellbooks:archevoker': {
    'kubejs:earth_talisman_wand': 0.1,
    'kubejs:murky_potion': 1
  },
  'call_of_yucutan:ah_puch': {
    'kubejs:chunky_cheese_token_tl': 1
  },
  'call_of_yucutan:kukulkan': {
    'kubejs:chunky_cheese_token_tr': 1
  },
  'iceandfire:cyclops': {
    'kubejs:chunky_cheese_token_br': 1,
    'kubejs:magnetic_wayfinder': 1,
    'iceandfire:cyclops_eye': 1
  },
  'mowziesmobs:ferrous_wroughtnaut': {
    'minecells:vine_rune': 1,
    'kubejs:cursed_necklace': 1
  },
  'alexscaves:magnetron': {
    'kubejs:aethereal_gemstone': 0.1,
    'kubejs:chunky_cheese_token_bl': 1
  },
  'rats:ratlantean_automaton': {
    'kubejs:sufficiently_advanced_technology': 0.1,
    'endrem:rogue_eye': 1
  },
  'twilightforest:naga': {
    'kubejs:remains_of_the_elderwood': 1
  },
  'minecraft:wither': {
    'kubejs:withered_crystal': 0.1,
    'kubejs:withered_dust': 1,
    'minecraft:nether_star': 1
  },
  'bosses_of_mass_destruction:gauntlet': {
    'kubejs:mysterious_gauntlet': 0.1
  },
  'cataclysm:the_harbinger': {
    'cataclysm:laser_gatling': 1,
    'endrem:wither_eye': 1
  },
  'graveyard:lich': {
    'kubejs:echoing_void': 1,
    'endrem:corrupted_eye': 1
  },
  'bosses_of_mass_destruction:obsidilith': {
    'kubejs:pulsating_artifact': 0.1,
    'kubejs:primordial_wayfinder': 1
  },
  'cataclysm:ignis': {
    'kubejs:burning_souls': 1,
    'cataclysm:the_incinerator': 0.1,
    'endrem:nether_eye': 1
  },
  'irons_spellbooks:dead_king': {
    'kubejs:tears_of_creation': 1
  },
  'galosphere:berserker': {
    'kubejs:specters_tablet': 1
  },
  'eeeabsmobs:nameless_guardian': {
    'kubejs:heart_of_the_guardian': 1
  },
  'blue_skies:arachnarch': {
    'kubejs:rough_moonstone': 1
  },
  'blue_skies:alchemist': {
    'kubejs:charged_crystal': 1
  },
  'cataclysm:netherite_monstrosity': {
    'kubejs:pure_corruption': 1,
    'endrem:lost_eye': 1,
    'fdbosses:eye_of_malkuth': 1
  },
  'cataclysm:the_leviathan': {
    'kubejs:void_bucket': 1,
    'endrem:witch_eye': 1
  },
  'minecells:conjunctivius': {
    'minecells:tentacle': 0.5,
    'kubejs:corrupted_dust': 1
  },
  'rats:neo_ratlantean': {
    'cataclysm:necklace_of_the_desert': 1,
    'endrem:exotic_eye': 1
  },
  'rats:dutchrat': {
    'rats:gem_of_ratlantis': 1,
    'rats:marbled_cheese_rat_head': 1
  },
  'cataclysm:the_prowler': {
    'kubejs:prowler_dust': 1
  },
  'cataclysm:the_watcher': {
    'kubejs:watcher_dust': 1
  },
  'block_factorys_bosses:sandworm': {
    'kubejs:living_stone': 1,
    'kubejs:purification_totem': 1,
    'graveyard:bone_dagger': 1
  },
  'aquamirae:eel': {
    'kubejs:eel_excrement': 1
  },
  'aquamirae:maw': {
    'kubejs:maw_sludge': 1
  },
  'illageandspillage:magispeller': {
    'kubejs:blightpowder': 1
  },
  'eeeabsmobs:guling_sentinel_heavy': {
    '14x blue_skies:turquoise_stonebrick': 1,
  },
  'mowziesmobs:sculptor': {
    'graveyard:middle_bone_staff': 1,
    'kubejs:bloodstone_artifact': 1,
    'mowziesmobs:earthrend_gauntlet': 1
  },
  'illageandspillage:spiritcaller': {
    'graveyard:upper_bone_staff': 1
  },
  'illageandspillage:ragno': {
    'kubejs:obsidilith_dust': 1
  },
  'iceandfire:gorgon': {
    'kubejs:gorgon_dust': 1,
    'kubejs:earth_talisman_gem': 1
  },
  'alexscaves:luxtructosaurus': {
    'kubejs:eternal_flame': 0.1,
    'fdbosses:eye_of_chesed': 1
  },
  'cataclysm:deepling_warlock': {
    'kubejs:doomsday_dust': 1
  },
  'minecraft:warden': {
    'kubejs:parasitic_slime': 1,
    'kubejs:indistinguishable_magic': 1
  },
  'block_factorys_bosses:yeti': {
    'kubejs:lost_stone': 1
  },
  'soulsweapons:night_shade': {
    'kubejs:shade_effigy': 1
  },
  'soulsweapons:draugr_boss': {
    '3x soulsweapons:lost_soul': 1
  },
  'soulsweapons:chaos_monarch': {
    'kubejs:ritual_dagger': 1
  },
  'cataclysm:ender_guardian': {
    'kubejs:empyrean_scarab': 0.1,
    'endrem:magical_eye': 1
  },
  'bosses_of_mass_destruction:lich': {
    'kubejs:forlorn_wayfinder': 1
  },
  'cataclysm:ender_golem': {
    'kubejs:corrupted_shard': 1,
    'endrem:evil_eye': 1
  },
  'bosses_of_mass_destruction:void_blossom': {
    'graveyard:lower_bone_staff': 1
  },
  'twilightforest:snow_queen': {
    'kubejs:hardened_void': 1
  },
  'born_in_chaos_v1:nightmare_stalker': {
    'kubejs:toxic_wayfinder': 1
  },
  'eeeabsmobs:immortal_executioner': {
    '2x eeeabsmobs:immortal_debris': 1
  },
  'eeeabsmobs:immortal': {
    'blue_skies:zeal_lighter': 1
  },
  'minecells:concierge': {
    'kubejs:phalanx_ring': 1
  },
  'twilightforest:ur_ghast': {
    'kubejs:contained_void': 1
  },
  'eeeabsmobs:corpse_warlock': {
    'kubejs:enslavement_elixir': 0.1
  },
  'alexscaves:forsaken': {
    'kubejs:vial_of_evil': 1,
    'endrem:cryptic_eye': 1
  },
  'blue_skies:summoner': {
    'kubejs:blaze_core': 0.1
  },
  'rats:rat_king': {
    'kubejs:twisted_rot': 1
  },
  'soulsweapons:accursed_lord_boss': {
    'soulsweapons:essence_of_eventide': 1
  },
  'fromtheshadows:nehemoth': {
    'minecraft:totem_of_undying': 1
  },
  'fromtheshadows:bulldrogioth': {
    '3x fromtheshadows:crimson_shell': 1
  },
  'minecraft:elder_guardian': {
    'endrem:guardian_eye': 1
  },
  'cataclysm:ancient_remnant': {
    'endrem:old_eye': 1
  },
  'aquamirae:captain_cornelia': {
    'endrem:black_eye': 1
  },
  'mowziesmobs:frostmaw': {
    'endrem:cold_eye': 1
  },
  'traveloptics:the_nightwarden': {
    'endrem:cursed_eye': 1
  },
  'cataclysm:maledictus': {
    'endrem:undead_eye': 1
  },
  'born_in_chaos_v1:missioner': {
    'born_in_chaos_v1:missionary_hat_helmet': 1
  },
  'born_in_chaos_v1:lord_pumpkinhead_head': {
    'kubejs:demonic_runestone': 1
  },
  'born_in_chaos_v1:supreme_bonescaller': {
    'born_in_chaos_v1:orbofthe_summoner': 1
  },
  'eeeabsmobs:guling_sentinel': {
    'eeeabsmobs:ancient_drive_crystal': 0.5
  },
  'cataclysm:amethyst_crab': {
    'aquamirae:shell_horn': 1,
    'kubejs:wildweave_tonic': 1
  },
  'cataclysm:coral_golem': {
    'cataclysm:abyssal_sacrifice': 1
  },
  'fdbosses:malkuth': {
    'cataclysm:strange_key': 1
  },
  'fdbosses:chesed': {
    'cataclysm:burning_ashes': 1
  },
  'fathomless:bishop': {
    'kubejs:abyssal_wayfinder': 1
  },
  'alexscaves:hullbreaker': {
    'kubejs:dust_of_fallen_kingdoms': 1
  },
  'fathomless:undaunted': {
    'alexscaves:immortal_embryo': 1
  },
  'fathomless:archbishop': {
    '20x blue_skies:lunar_stonebrick': 1
  },
  'cataclysm:kobolediator': {
    '3x cataclysm:ancient_metal_nugget': 1
  },
  'cataclysm:wadjet': {
    '3x cataclysm:ancient_metal_nugget': 1
  },
  'iceandfire:hydra': {
    'iceandfire:hydra_fang': 1
  },


}

ServerEvents.entityLootTables(event => {
  Object.entries(unified_drops).forEach(([entityId, drops]) => {
    event.modifyEntity(entityId, table => {

      Object.entries(drops).forEach(([itemId, chance]) => {
        table.addPool(pool => {
          // One roll per pool so each item is checked independently
          pool.rolls = 1
          pool.addItem(itemId).randomChance(chance)
        })
      })

    })
  })
})
