
let tut_bosses = [
    'irons_spellbooks:archevoker',
]



// Helper function to spawn loot
function spawnLoot(lootTable, event) {
    Utils.server.runCommandSilent(
        `/execute in ${event.level.dimension} run loot spawn ${event.entity.x} ${event.entity.y} ${event.entity.z} loot ${lootTable}`
    );
}
let grims = [
    'kubejs:armored1',
    'kubejs:armored2',
    'kubejs:demonic1',
    'kubejs:demonic2',
    'kubejs:blessed1',
    'kubejs:blessed2',
    'kubejs:focused1',
    'kubejs:focused2',
    'kubejs:gifted1',
    'kubejs:gifted2',
    'kubejs:swift1',
    'kubejs:swift2',
]



PlayerEvents.respawned(event => {
    let bosses = event.level.entities.filter(e => e.tags.contains('boss'))
    bosses.forEach(boss => {
        if (boss.health == null || boss.maxHealth == null) {
            adjustBossHealth(boss)
        }
    })
})

PlayerEvents.loggedIn(event => {
    let bosses = event.level.entities.filter(e => e.tags.contains('boss'))
    bosses.forEach(boss => {
        if (boss.health == null || boss.maxHealth == null) {
            adjustBossHealth(boss)
        }
    })
})

const glob_boss_data = global.boss_data

function adjustBossHealth(boss) {
    // Find the boss data from the global object by looping through the keys and matching the id property to the boss type
    let bossData = null;
    for (let key in glob_boss_data) {
        if (glob_boss_data[key].id === boss.type.toString()) {
            bossData = glob_boss_data[key];
            break;
        }
    }
    //tell(`Adjusting health for boss: `+boss.type.toString())
    if (!bossData) return;
    //tell(`Found boss data for: `+boss.type.toString())
    let tier = bossData.tier || 1;
    let bossesKilled = Number(boss.server.persistentData.bosses_killed) || 0;
    //tell(bossesKilled)
    //tell(bossesKilled)
    let boss_health = Number(bossData.health) || 100;
    //tell(boss_health)
    let power_level = Number(boss.server.persistentData.power_level)
    //tell(power_level)
    //tell(`Power Level is: `+power_level)
    if (!power_level) {
        let pl = calculatePowerLevel(boss.server)
        //tell(`Calculated Power Level is: `+pl)
        power_level = pl
    }
    // Health formula: health property + 3% for every boss killed + 100 for every tier
    let health = Number(boss_health * (tier + (1 + bossesKilled * 0.03)) + (power_level * 20));
    if (boss.tags.contains('boss_variant')) {
        let healthAdd = Number(boss.persistentData.boss_difficulty) * 10
        health = Number(health) + Number(healthAdd)
    }
    //tell(health)
    // Adjust the boss's health
    boss.setAbsorptionAmount(0);
    boss.setMaxHealth(Number(health));
    boss.setHealth(Number(health));
    
}




let affix_orb_quests = {
    'orb_of_infusion': '291FCA909BE917D2',
    'orb_of_imbuement': '1D416A491E4105EE',
    'orb_of_socketing': '1E2AF8C0E3C458E2',
}

let totem_orb_quests = {
    'orb_of_knowledge': '2083FCDC7D2A5D87',
    'orb_of_discovery': '61B672EF2B04B3EB',
}

function syncOrbProgress(player) {
    Object.entries(affix_orb_quests).forEach(([persistentData, quest], index) => {
        Utils.server.scheduleInTicks(index * 10, () => {
            if (player.persistentData.getBoolean(persistentData) == true) {
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} reset ${quest}`)
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete ${quest}`)
            }
        })
    })
    Object.entries(totem_orb_quests).forEach(([persistentData, quest], index) => {
        Utils.server.scheduleInTicks(index * 10, () => {
            if (player.persistentData.getBoolean(persistentData) == true) {
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} reset ${quest}`)
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete ${quest}`)
            }
        })
    })
}

ItemEvents.rightClicked('kubejs:progression_sync', event => {
    event.item.count -= 1
    syncQuestProgress(event.server)
    let player = event.player
    syncOrbProgress(player)
    player.tell(`§7Syncing Quest Progress...`)
    //Utils.server.runCommandSilent(`/tell ${player.username} Syncing Quest Progress...`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound sdmshoprework:buy_sound ambient ${player.username} ${player.x} ${player.y} ${player.z} 2 1.1`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexscaves:hazmat_breathe ${player.x} ${player.y+1} ${player.z} 0.5 0.5 0.5 0.5 150 force`)


})






function syncQuestProgress(server) {
    let players = server.getPlayers()
    Object.entries(global.boss_data).forEach(([entity, data]) => {
        if (server.persistentData.get(data.id+'_dead') == true) {
            players.forEach(player => {
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} reset ${data.quest_before}`)
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} reset ${data.quest}`)
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete ${data.quest_before}`)
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete ${data.quest}`)
            })

        }
    })
}


Object.entries(global.boss_data).forEach(([entity, data]) => {



    EntityEvents.death(data.id, event => {
        let tier = data.tier
        let chance = 0.05 * tier
        if (Math.random() > chance) return
        // choose a random grim
        let grim = grims[Math.floor(Math.random() * grims.length)]
        spawnItem(grim, 1, event.entity)
        
    })

/**
 * 
 * 
 */
    EntityEvents.spawned(data.id, event => {
        //tell(event.entity.getAbsorptionAmount())
        event.entity.tags.add('boss')
        // Attribute damage increases by 2% for every boss killed
        let bossesKilled = event.server.persistentData.bosses_killed || 0;
        let value = Number(bossesKilled * 0.03)

        event.entity.modifyAttribute('minecraft:generic.attack_damage', generateRandomString(16), value, 'multiply_base')
       Utils.server.scheduleInTicks(1, () => {
        if (!event.entity.tags.contains('boss_variant')) {
            adjustBossHealth(event.entity)
        }
       })

        let size = data.size_multiplier
        let uuid = event.entity.uuid
        let spellcasting = data.spellcasting
        
        if (spellcasting) {
            // the school is the first key of the spellcasting object
            let school = data.spellcasting.school
            // the quality is the second key of the spellcasting object
            let quality = data.spellcasting.quality
            Utils.server.scheduleInTicks(1, () => {
                applySchool(event.entity, school)
                if (quality == 'superior') {
                    superiorMage(event.entity)
                } else if (quality == 'exalted') {
                    exaltedMage(event.entity)
                }
            })
        }
        change_size(event.entity, size)
    })


    // register the summoning stone loot table
    ServerEvents.genericLootTables((event) => {
        event.addGeneric(`loot_boxes/${entity}`, (table) => {
            table.addPool(pool => {
                pool.addItem(`kubejs:${entity}`)
            })
        })
    })


const totem_orbs = global.validSkillTotemOrbs
let valid_Affix_Orbs = global.validAffixOrbs


    EntityEvents.death(data.id, event => {
        if (!event.entity.tags.contains('tracking_modified')) return
        if (event.server.persistentData.getBoolean(data.id+'_dead') != true) {
            event.server.persistentData.putBoolean(data.id+'_dead', true)
            event.server.persistentData.putInt('bosses_killed', Number(event.server.persistentData.bosses_killed) + 1)
            let random_affix_orb = valid_Affix_Orbs[Math.floor(Math.random() * valid_Affix_Orbs.length)]
            let random_skill_orb = totem_orbs[Math.floor(Math.random() * totem_orbs.length)]
            spawnItem(random_affix_orb, 1, event.entity)
            spawnItem(random_skill_orb, 1, event.entity)
            
            //Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run loot spawn ${event.entity.x} ${event.entity.y} ${event.entity.z} loot minecraft:loot_boxes/godforged_pearl`)
            if (!event.entity.type.toString().includes('iceandfire:dread_lich')) {
                spawnItem(`bonfires:coiled_sword`, 1, event.entity)
            }
            // Cache players once and reuse for nearby reward + global broadcast
            let playersAll = event.level.getPlayers()
            let nearbyPlayers = playersAll.filter(player => player.distanceToEntity(event.entity) < 50)
            nearbyPlayers.forEach(player => {
                Utils.server.runCommandSilent(`/execute as ${player.username} run apoth gem random`)
            })
        }
        let playersAll = event.level.getPlayers()
        playersAll.forEach(player => {
            //Utils.server.runCommandSilent(`/immersivemessages sendcustom ${player.username} {font:'immersivemessages:norse',size:5, y:-45,anchor:'CENTER_CENTER', wrap:1, obfuscate:1, shake:1, color:'#ff0000'} 6 BOSS DEFEATED`)
            Utils.server.runCommandSilent(`/immersivemessages sendcustom ${player.username} {size:4, y:-45,anchor:'CENTER_CENTER', wrap:1, obfuscate:1, shake:1, color:'#ff0000'} 6 BOSS DEFEATED`)
            Utils.server.runCommandSilent(`/execute as ${player.username} run playsound graveyard:block.bone.placed player ${player.username} ${player.x} ${player.y} ${player.z} 0.5 0.2`)
            Utils.server.scheduleInTicks(3, () => {
                
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} reset ${data.quest}`)
                Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete ${data.quest}`)
                
            })
        })

    })


    FTBQuestsEvents.completed(data.quest_before, event => {
        console.log(`Completing ${data.quest_before}... ${data.id} is now vulnerable`)
        event.server.persistentData.putBoolean(`${data.id}_vulnerable`, true)
    })


    let non_invuln_entities = [
        'iceandfire:dread_lich',
        //'queen_bee:queen_bee',
        'fromtheshadows:bulldrogioth',
        'fromtheshadows:nehemoth',
        'rats:rat_king',
        'aquamirae:maze_mother',
        'iceandfire:cyclops'
    ]



    EntityEvents.hurt(data.id, event => {
        
        if (!event.source.player) return
        
        //if (event.server.persistentData.get(`${data.id}_vulnerable`)) return
        if (!event.entity.tags.contains('tracking_modified')) {
            event.entity.modifyAttribute('minecraft:generic.follow_range', generateRandomString(16), 3.0, 'multiply_base')
            event.entity.tags.add('tracking_modified')
        }
        //if (data.summoning_stone) return
        if (non_invuln_entities.includes(event.entity.type.toString())) return
        //if (event.source.player.creative) return
        //event.source.player.tell('§fThis Boss is §cINVULNERABLE §funtil you progress further in the Questline.')
        //event.cancel()
        event.source.player.sendData('biomebeats_boss_hit', {})
    })

    // If the boss dies add the persistent data
})





/**
 * EntityEvents.spawned(event => {
    if (event.server.persistentData.nightmare_activated != true) return
    if (boss_spawn_cooldown[event.server.id] == 1) return
    if (!event.entity.isMonster()) return
    if (event.entity.tags.contains('boss')) return

    // chance is 1 in 1000
    let chance = Math.random()
    if (chance > 0.001) return

    // loop through bosses
    let valid_bosses = []
    Object.entries(boss_stones_init).forEach(([entity, data]) => {
        if (event.server.persistentData.get(entity+'_dead')) {
            // summoning stone must be true
            if (data.summoning_stone) {
                valid_bosses.push(data.id)
            }
        }
    })
    // choose a random boss
    let boss = valid_bosses[Math.floor(Math.random() * valid_bosses.length)]
    // spawn the boss
    let boss_entity = event.level.createEntity(boss)
    boss_entity.x = event.entity.x
    boss_entity.y = event.entity.y
    boss_entity.z = event.entity.z
    boss_entity.spawn()
    event.cancel()
    
    if (boss_spawn_cooldown[event.server.id] == undefined) {
        boss_spawn_cooldown[event.server.id] = 1
    } else {
        boss_spawn_cooldown[event.server.id] = 1
    }

})
 * 
 * 
 */


/**
 * ServerEvents.tick(event => {
    if (boss_spawn_cooldown[event.server.id] == undefined) return
    if (boss_spawn_cooldown[event.server.id] == 0) return
    boss_spawn_cooldown[event.server.id] += 1
    if (boss_spawn_cooldown[event.server.id] > 6000) {
        boss_spawn_cooldown[event.server.id] = 0
    }
})
 * 
 * 
 */









EntityEvents.spawned('eeeabsmobs:corpse_warlock', event => {
    Utils.server.scheduleInTicks(3, e => {
        //Utils.server.runCommandSilent(`/photon fx photon:corpse_summoner entity ${event.entity.uuid}`)
    })
})




ItemEvents.entityInteracted('kubejs:admin_sword', event => {
    event.target.kill()
})






/**
 * EntityEvents.hurt(event => {
    if (!event.entity.tags.contains('boss')) return
    if (!event.source.player) return
    Utils.server.runCommandSilent(`/execute as ${event.source.player.username} run stp`)
})



 * 
 * 
 * 
 */


EntityEvents.hurt('player', event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.source.actual.tags.contains('boss')) return
    let player = event.server.getPlayer(event.entity.username)
    player.sendData('biomebeats_boss_hit', {})
})


EntityEvents.hurt(event => {
    if (!event.source.player) return
    //event.source.player.tell(event.entity.type)
})