



function swapEffects(entity, effect1, effect2) {
    let amp = entity.potionEffects.getActive(effect1).amplifier;
    let duration = entity.potionEffects.getActive(effect1).duration
    duration = Math.floor(duration / 20); // Convert ticks to seconds
    Utils.server.runCommandSilent(`/effect clear ${entity.uuid} ${effect1}`);
    Utils.server.runCommandSilent(`/effect give ${entity.uuid} ${effect2} ${duration} ${amp} false`);
}

function cleanEffectKey(rawString) {
    // Extract the key part from something like "translation{key='effect.attributeslib.bleeding', args=[]}"
    let match = rawString.match(/key='effect\.(.+?)'/);
    if (!match) return null;

    let fullKey = match[1]; // "attributeslib.bleeding"
    let cleaned = fullKey.replace('.', ':'); // "minecells:bleeding"
    return cleaned;
}
 




EntityEvents.hurt(event => {
    if (event.entity.potionEffects.isActive('minecells:bleeding')) return;
    if (!event.entity.potionEffects.map.toString().includes('bleed')) return;
    let effects = []
    event.entity.potionEffects.map.forEach(effect => {
        if (effect.displayName.toString().includes('bleed')) {
            let id = cleanEffectKey(effect.displayName.toString());
            effects.push(id)
        }
    })
    effects.forEach(effect => {
        swapEffects(event.entity, effect, 'minecells:bleeding');
    })

})



EntityEvents.hurt(event => {
    //if (event.entity.potionEffects.isActive('runiclib:venom')) return;
    if (!event.entity.potionEffects.isActive('minecraft:poison')) return;
    swapEffects(event.entity, 'minecraft:poison', 'runiclib:venom');
})

EntityEvents.hurt(event => {
    //if (event.entity.potionEffects.isActive('runiclib:venom')) return;
    if (!event.entity.potionEffects.isActive('alexsmobs:ender_flu')) return;
    swapEffects(event.entity, 'alexsmobs:ender_flu', 'runiclib:venom');
})

// Chilled

EntityEvents.hurt(event => {
    if (!event.entity.potionEffects.isActive('irons_spellbooks:chilled')) return;
    swapEffects(event.entity, 'irons_spellbooks:chilled', 'cofh_core:chilled');
})




PlayerEvents.tick(event => {
    if (event.server.tickCount % 60 !== 0) return; // Run every 3 seconds
    if (!event.player.potionEffects.isActive('miapi:stun')) return;
    Utils.server.runCommandSilent(`/effect clear ${event.player.username} miapi:stun`);
})



