// Spark color presets (0..1 RGB)
const SPARK_COLORS = {
  white:        [1.0, 1.0, 1.0],
  light_gray:   [0.8, 0.8, 0.8],
  gray:         [0.6, 0.6, 0.6],
  dark_gray:    [0.3, 0.3, 0.3],
  black:        [0.05, 0.05, 0.05],

  light_blue:   [0.3, 0.7, 1.0],
  sky_blue:     [0.2, 0.6, 1.0],
  cyan:         [0.0, 0.8, 1.0],
  teal:         [0.0, 0.6, 0.6],
  deep_blue:    [0.0, 0.3, 0.8],
  arcane_blue:  [0.5, 0.4, 1.0],

  lavender:     [0.7, 0.5, 1.0],
  purple:       [0.6, 0.2, 1.0],
  violet:       [0.5, 0.0, 0.8],
  magenta:      [1.0, 0.0, 0.8],
  void:         [0.2, 0.0, 0.3],

  light_red:    [1.0, 0.4, 0.4],
  red:          [1.0, 0.0, 0.0],
  dark_red:     [0.6, 0.0, 0.0],
  crimson:      [0.7, 0.1, 0.2],
  blood:        [0.5, 0.0, 0.1],

  light_orange: [1.0, 0.6, 0.2],
  orange:       [1.0, 0.4, 0.0],
  dark_orange:  [0.8, 0.3, 0.0],
  ember:        [1.0, 0.2, 0.0],

  yellow:       [1.0, 1.0, 0.0],
  gold:         [1.0, 0.8, 0.2],
  lightning:    [0.9, 0.9, 0.4],
  holy:         [1.0, 0.95, 0.6],

  light_green:  [0.5, 1.0, 0.5],
  green:        [0.0, 1.0, 0.0],
  dark_green:   [0.0, 0.5, 0.0],
  poison:       [0.4, 0.9, 0.0],
  acid:         [0.3, 1.0, 0.2],

  frost:        [0.6, 0.9, 1.0],
  shadow:       [0.15, 0.05, 0.2],
  chaos:        [0.9, 0.1, 0.9],
  lifeforce:    [0.2, 1.0, 0.4],
}

/**
 * 
 * @param {*} event event
 * @param {*} pos OBJECT: e.g. {x:0, y:0, z:0}
 * @param {*} colorName STRING: e.g. 'yellow', 'arcane_blue'
 * @param {*} count NUMBER: e.g. 20
 * @param {*} speed NUMBER: e.g. 0.25
 * @param {*} spread OBJECT: e.g. {x:0.5, y:0.5, z:0.5}
 */
function spawnSpark(event, pos, colorName, count, speed, spread, center) {
  
  if (center === undefined) center = false

  let dim = event.player ? event.player.level.dimension : event.level.dimension

  if (count == null) count = 50
  if (speed == null) speed = 0.50
  if (!spread) spread = { x: 0.5, y: 0.5, z: 0.5 }

  let dx = Number(spread.x ?? 0.5)
  let dy = Number(spread.y ?? 0.5)
  let dz = Number(spread.z ?? 0.5)

  let rgb = SPARK_COLORS[String(colorName || '').toLowerCase()] || SPARK_COLORS.white
  let r = rgb[0], g = rgb[1], b = rgb[2]

  // If you're feeding block coords, center it.
  let x = Number(pos?.x ?? 0) + (center ? 0.5 : 0.0)
  let y = Number(pos?.y ?? 0) // you usually control this explicitly
  let z = Number(pos?.z ?? 0) + (center ? 0.5 : 0.0)

  // Don't toFixed unless you really want to; particle accepts normal decimals fine.
  Utils.server.runCommandSilent(
    `/execute in ${dim} run particle irons_spellbooks:spark `
    + `${r} ${g} ${b} `
    + `${x} ${y} ${z} `
    + `${dx} ${dy} ${dz} `
    + `${speed} ${count}`
  )
}
