function putInMainhand(player, item) {
    if (!player || !item || item.empty) return
  
    let inventory = player.inventory
  
    // If main hand is empty, move item there
    if (player.mainHandItem.empty) {
      let slot = inventory.findSlotMatchingItem(item)
      if (slot === -1) {
        player.tell(Text.red("Could not locate the item in inventory to extract."))
        return
      }
  
      player.setMainHandItem(item)
      inventory.extractItem(slot, 1, false)
      return
    }
  
    // Main hand is not empty, try to swap
    let itemSlot = inventory.findSlotMatchingItem(item)
    let handSlot = inventory.findSlotMatchingItem(player.mainHandItem)
  
    if (itemSlot === -1 || handSlot === -1) {
      player.tell(Text.red("Could not locate both items in inventory to swap."))
      return
    }
  
    let handItem = player.mainHandItem
    inventory.setStackInSlot(handSlot, item)
    inventory.setStackInSlot(itemSlot, handItem)
  }
  