

let pet_spells = {
    attack: [
        'firewyrm_flask',
        'frostfire_dew',
        'stormheart_lullaby',
        'psionic_volley',
        'molten_sands',
    ],
    attack_projectile: [
        'raging_tempest',
        'elderwood_sap',
        'moonlit_mist',
    ],
    defend: [
        'captains_elixir',
        'dark_winds',
        'psionic_volley',
        'serpents_tears',
        'moonlit_mist',
        'valkyries_blood',
        'forgotten_divinity',
        'beckoning_shadows',
        //'savior'
    ]
}


/**
 * @param {*} player The player being referenced
 * @param {*} type Type of spell. Either 'attack' or 'defend'




/**
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
// Tamed beast attacking an entity
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    // if the source is not a tamed beast, return
    if (!event.source.actual.tags.contains('tamed_beast')) return
    let owner_username = event.source.actual.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    let player = event.server.getPlayer(owner_username)
    beastCast(event, player, 'attack', event.entity)
})


// Player attacking an entity
EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    let p = physicalProjectileCheck(event.source)
    if (p) {
        beastCast(event, player, 'attack_projectile', event.entity)
    } else {
        beastCast(event, player, 'attack', event.entity)
    }
})


// Player being attacked
EntityEvents.hurt('player', event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    let player = event.entity
    beastCast(event, player, 'defend', event.source.actual)
})


 // Pet being attacked
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.entity.tags.contains('tamed_beast')) return
    let owner_username = event.entity.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    let player = event.server.getPlayer(owner_username)
    beastCast(event, player, 'defend', event.source.actual)
})
 * 
 * 
 * 

function beastCast (event, player, type, target) {
    if (player == null) return
    if (!player.persistentData.get('beastly_sorcery')) return
    let ally = isAlly(player, target)
    if (ally) return
    if (player.cooldowns.isOnCooldown('beastly_sorcery_cooldown')) return
    let choosen_pets = choosePet(player, player.persistentData.beastly_sorcery)
    let count = player.persistentData.beastly_sorcery
    choosen_pets.forEach(pet => {
        if (count < 1) return
        count--
        let possible_spells = []
        if (type == 'attack') {
            pet_spells.attack.forEach(spell => {
                if (player.persistentData.get(spell)) {
                    possible_spells.push(spell)
                }
            })
        } else if (type == 'defend') {
            pet_spells.defend.forEach(spell => {
                if (player.persistentData.get(spell)) {
                    possible_spells.push(spell)
                }
            })
        } else if (type == 'attack_projectile') {
            pet_spells.attack_projectile.forEach(spell => {
                if (player.persistentData.get(spell)) {
                    possible_spells.push(spell)
                }
            })
        }
        //choose a random spell
        //Utils.server.tell(possible_spells)
        let spell = possible_spells[Math.floor(Math.random()*possible_spells.length)]
        //Utils.server.tell(spell)
        if (spell == 'molten_sands') {
            molten_sands(player, pet, target)
        } else if (spell == 'firewyrm_flask') {
            firewyrm_flask(player, pet, target)
        } else if (spell == 'raging_tempest') {
            raging_tempest(player, pet, target, event.source)
        } else if (spell == 'dark_winds') {
            dark_winds(player, pet)
        } else if (spell == 'elderwood_sap') {
            elderwood_sap(player, pet, target)
        } else if (spell == 'frostfire_dew') {
            frostfire_dew(player, pet, target)
        } else if (spell == 'psionic_volley') {
            psionic_volley(player, pet, target)
        } else if (spell == 'serpents_tears') {
            serpents_tears(player, pet, target)
        } else if (spell == 'stormheart_lullaby') {
            stormheart_lullaby(player, pet, target)
        } else if (spell == 'moonlit_mist') {
            moonlit_mist(player, pet, target, event.source)
        } else if (spell == 'captains_elixir') {
            captains_elixir(player, pet, target)
        } else if (spell == 'valkyries_blood') {
            valkyries_blood(player, pet)
        } else if (spell == 'forgotten_divinity') {
            forgotten_divinity(player, pet)
        } else if (spell == 'beckoning_shadows') {
            beckoning_shadows(player, pet, target)
        } else if (spell == 'savior') {
            savior(player, pet, target)
        }
        //Utils.server.tell(`Triggered ${spell} for ${[pet]}`)
    })
    let mod = 0
    if (player.persistentData.get('beastly_sorcery_cooldown')) {
        mod = 200*player.persistentData.beastly_sorcery_cooldown
    }
    player.cooldowns.addCooldown('beastly_sorcery_cooldown', 3600-mod)
    //Utils.server.tell(`setting cooldown for ${player.username} to ${3600-mod}`)
}

function choosePet (player, level) {
    let box = AABB.of(player.x+20, player.y+20, player.z+20, player.x-20, player.y-20, player.z-20)
    //let dim = player.level
    let entitiesWithin = player.level.getEntitiesWithin(box)
    let pets = []
    entitiesWithin.forEach(ent => {
        if (ent.tags.contains('tamed_beast')) {
            let owner_username = ent.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
            if (owner_username == player.username) {
                pets.push(ent)
            }
        }
    })
    return pets
}


/**
 * 
 * @param {*} player The player being referenced
 * @param {*} caster The pet that is casting the spell
 * @param {*} target The entity attacking the Pet
 * @returns 
 * 
 * §aLevel 1: Casts Frostwave - Frostwave power increases with Skill Level
 * §aLevel 2: Increases Frostwave Power
 * §aLevel 3: Casts Frostwave and freezes the attacker for 3 seconds. Freeze duration increases with Skill Level
 * §aLevel 4: Increases Frostwave and Freeze Power
 * §aLevel 5: Casts Frostwave, freezes the attacker, then casts Ice Block. Ice Block power increases with Skill Level
 * 
function captains_elixir (player, caster, target) {
    let level = player.persistentData.captains_elixir
    let spells = []
    if (level < 3) {
        spells.push('frostwave')
    } else if (level >= 3) {
        spells.push('frostwave')
        spells.push('ice_block')
        Utils.server.scheduleInTicks(25, () => {
            target.potionEffects.add('mowziesmobs:frozen', 20*level, 0)
        })
    }
    newCast(caster, spells, target, level)
}





/**
 * 
 * @param {*} source Source of the Attack (needed to verify if the attack is a projectile)
 * @param {*} target The target of the attack
 * @param {*} player The player being referenced
 * @param {*} caster The spell caster
 * @returns 
 * 
 * Molten Sands: Casts consecutive Fireballs at the attacking entity. Fireball count and power increases with Skill Level
 * §aLevel 1: Casts one §aLevel 1 Fireball
 * §aLevel 2: Casts two §aLevel 2 Fireballs
 * §aLevel 3: Casts three §aLevel 3 Fireballs
 * 

function molten_sands (player, caster, target) {
    let level = player.persistentData.molten_sands
    let spells = []
    // loop through level
    for (let i = 0; i < level; i++) {
        spells.push('fireball')
    }
    newCast(caster, spells, target, level)
}






/**
 * 
 * @param {*} source Source of the attack (needed to verify if the attack is a projectile)
 * @param {*} target The target of the attack
 * @param {*} player The player being referenced 
 * @param {*} pet The pet casting the spell
 * @returns 
 * 
 * Firewyrm Flask
 * §aLevel 1: Cast fire breath at the attacking entity
 * §aLevel 2: Increase the power of Fire Breath
 * §aLevel 3: Cast root then fire breath at the attacking entity


function firewyrm_flask (player, caster, target) {
    let level = player.persistentData.firewyrm_flask
    let spells = []
    if (player.persistentData.firewyrm_flask != 3) {
        spells.push('fire_breath')
    } else {
        spells.push('root')
        spells.push('fire_breath')
    }
    newCast(caster, spells, target, level)

}

/**
 * 
 * @param {*} source Needed to verify if the attack is a projectile
 * @param {*} target The target of the attack
 * @param {*} player The player being referenced
 * @param {*} caster The caster of the spell
 * @returns 
 * 
 * Raging Tempest: Casts Chain Lightning at the attacking entity. Chain Lightning casts and power increases with Skill Level
 * §aLevel 1: Casts one §aLevel 1 Chain Lightning
 * §aLevel 2: Casts two §aLevel 2 Chain Lightnings
 * §aLevel 3: Casts three §aLevel 3 Chain Lightnings
 * §aLevel 4: Casts four §aLevel 4 Chain Lightnings
 * §aLevel 5: Casts five §aLevel 5 Chain Lightnings
function raging_tempest (player, caster, target, source) {
    let proj = physicalProjectileCheck(source)
    if (!proj) return
    let level = player.persistentData.raging_tempest
    let spells = []
    for (let i = 0; i < level; i++) {
        spells.push('chain_lightning')
    }
    newCast(caster, spells, target, level)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:electricity ${caster.x} ${caster.y+1} ${caster.z} 0.5 0.5 0.5 1 50 force @a`)
}

 * 
 * @param {*} source Source of the attack (needed to verify if the attack is a projectile)
 * @param {*} player The player being referenced
 * @param {*} pet The pet casting the spell
 * @returns 
 * 
 * Dark Winds: Casts Gust at all entities within 5 blocks of the player. Per level increases: Range, Gust power, and effect durations
 * §aLevel 1: Casts Gust at all entities within 5 blocks
 * §aLevel 2: Enemies hit with Gust get the Blindness effect
 * §aLevel 3: Enemies hit with Gust get the Wither effect
 * §aLevel 4: Enemies hit with Gust get the Enigma effect
 * §aLevel 5: Casts Cursed Minefield

function dark_winds (player, caster) {
    let level = player.persistentData.dark_winds
    let box = AABB.of(player.x+3*level, player.y+1, player.z+3*level, player.x-3*level, player.y-1, player.z-3*level)
    let dim = player.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    let count = entitiesWithin.length
    let num = 0
    entitiesWithin.forEach(e => {
        if (e != caster) {
        //let allycheck = isAlly(player, e)
        //if (!allycheck) {
            num++
            Utils.server.scheduleInTicks(16*num, () => {
                newCast(caster, ['gust'], e, level)
                Utils.server.scheduleInTicks(17, () => {
                    if (level < 2) return
                    e.potionEffects.add('minecraft:blindness', 20*level, 0)
                    if (level < 3) return
                    e.potionEffects.add('minecraft:wither', 20*level, level)
                    if (level < 4) return
                    e.potionEffects.add('irons_spellbooks:true_invisibility', 20*level, level)
                })
            })
       // }
        }

    })
    if (level < 5) return
    Utils.server.scheduleInTicks(16*count+2, () => {
        newCast(caster, ['cursed_minefield'], player, level)

    })
}


/**
 * 
 * @param {*} player The player being referenced 
 * @param {*} caster The pet casting the spell
 * @param {*} target The target of the attack
 * 
 * Elderwood Sap:
 * §aLevel 1: Casts Slow at the attacking entity
 * §aLevel 2: Increases the power of slow
 * §aLevel 3: Casts Firefly Swarm at the attacking entity
 * §aLevel 4: Increases the power of Firefly Swarm
 * §aLevel 5: Casts Poison Splash at the attacking entity

function elderwood_sap (player, caster, target) {
    let level = player.persistentData.elderwood_sap
    let spells = []
    if (level >= 1) {
        spells.push('slow')
    } 
    if (level >= 3) {
        spells.push('firefly_swarm')
    } 
    if (level >= 5) {
        spells.push('poison_splash')
    }
    newCast(caster, spells, target, level)
}

/**
 * 
 * @param {*} player The player being referenced
 * @param {*} caster The pet casting the spell
 * @param {*} target The target of the attack
 * 
 * Frostfire Dew:
 * §aLevel 1: Casts Scorch at the attacking entity
 * §aLevel 2: Casts 2 Frost Rays at the attacking entity
 * §aLevel 3: Casts 3 Frost Rays 
 * §aLevel 4: Casts 4 Frost Rays
 * §aLevel 5: Casts Nullflare

function frostfire_dew (player, caster, target) {
    let level = player.persistentData.frostfire_dew
    let spells = []
    if (level >= 1) {
        spells.push('scorch')
    } 
    if (level >= 2) {
        // loop per level
        for (let i = 0; i < level; i++) {
            spells.push('ray_of_frost')
        }
    } 
    if (level >= 5) {
        spells.push('nullflare')
    }
    newCast(caster, spells, target, level)

}


/**
 * 
 * @param {*} target The target of the attack 
 * @param {*} player The player being referenced
 * @param {*} pet The pet casting the spell
 * @returns 
 * 
 * Psionic Volley: Casts starfall at the attacking entity. Starfall power increases with Skill Level
 * §aLevel 1: Casts Starfall at the attacking entity
 * §aLevel 2: Starfall power increases
 * §aLevel 3: Casts Slow, then Starfall at the attacking entity
 * 

function psionic_volley (player, caster, target) {
    let level = player.persistentData.psionic_volley
    let spells = []
    if (level < 3) {
        spells.push('starfall')
    } else {
        spells.push('slow')
        spells.push('starfall')
    }
    newCast(caster, spells, target, level)
}


/**
 * 
 * @param {*} target 
 * @param {*} player 
 * @param {*} pet 
 * @returns 
 * 
 * Serpents Tears: Casts Poison Arrow at the attacking entity.
 *  - §aLevel 1: Casts Poison Arrow at the attacking entity
 *  - §aLevel 2: Casts 2 Poison Arrows at the attacking entity and gives the attacking entity the venom effect
 *  - §aLevel 3: Casts 3 Poison Arrows. Killing venom entities will make other entities around them get the venom effect

function serpents_tears (player, caster, target) {
    let level = player.persistentData.serpents_tears
    let spells = []
    for (let i = 0; i < level; i++) {
        spells.push('poison_arrow')
    }
    newCast(caster, spells, target, level)
    target.tags.add(`serpents_level:${level}`)
    target.tags.add(`serpents_owner:${player.username}`)
    if (level < 3) return
    target.tags.add('serpents_tears')
}


// Handles giving the venom effect to the enemy hit by the poison arrow. 
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (!event.entity.tags.toString().includes('serpents_level')) return
    if (!event.source.immediate.type.includes(`poison_arrow`)) return
    let level = event.entity.tags.find(tag => tag.startsWith('serpents_level')).split(':')[1]
    event.entity.potionEffects.add('runiclib:venom', 80*level, 1)
    if (level < 3) return
    event.entity.tags.add('serpents_tears')
})



EntityEvents.death(event => {
    if (event.source.actual == null) return
    if (!event.entity.potionEffects.isActive('runiclib:venom')) return
    if (!event.source.player) return
    let serpents_owner = event.entity.tags.find(tag => tag.startsWith('serpents_owner')).split(':')[1]
    if (serpents_owner != event.source.player.username) return
    let level = event.source.player.persistentData.serpents_tears
    let box = AABB.of(event.source.actual.x+15*level, event.source.actual.y+15*level, event.source.actual.z+15*level, event.source.actual.x-15*level, event.source.actual.y-15*level, event.source.actual.z-15*level)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        let ally = isAlly(ent)
        if (!ally) {
            ent.potionEffects.add('runiclib:venom', 100*player.persistentData.serpents_tears, player.persistentData.serpents_tears, true, true)
        }
    })
})


/**
 * 
 * @param {*} player The player being referenced
 * @param {*} caster The pet casting the spell
 * @param {*} target The target of the spell
 * @returns 
 * 
 * Stormheart Lullaby: Casts Lightning Lance at the attacking entity. Lightning Lance power increases with Skill Level
 * §aLevel 1: Casts Lightning Lance at the attacking entity
 * §aLevel 2: Increases Lightning Lance Power
 * §aLevel 3: Casts Thunderstorm and then casts Lightning Lance at the attacking entity
 * §aLevel 4: Increases power of Thunderstorm and Lightning Lance
 * §aLevel 5: Increases power of Thunderstorm and Lightning Lance


function stormheart_lullaby (player, caster, target) {
    let level = player.persistentData.stormheart_lullaby
    let spells = []
    spells.push('lightning_lance')
    if (level >= 3) {
        caster.potionEffects.add('irons_spellbooks:thunderstorm', 100*level, level)
    }
    newCast(caster, spells, target, level)
}
/**
 * @param {*} source source of the attack (needed to verify if the attack is a projectile)
 * @param {*} target The target of the spell
 * @param {*} player The player being referenced
 * @param {*} pet The pet casting the spell
 * @returns 
 * 
 * Moonlit mist: Casts Firefly Swarm at the attacking entity. Firefly Swarm power increases with Skill Level
 * §aLevel 1: Casts Firefly Swarm at the attacking entity
 * §aLevel 2: Increases the power of Firefly Swarm
 * §aLevel 3: Gives the attacking entity the Blindness effect
 * §aLevel 4: Increases the power of Firefly Swarm
 * §aLevel 5: Casts slow at the attacking entity



function moonlit_mist (player, caster, target, source) {
    let proj = physicalProjectileCheck(source)
    if (!proj) return
    let level = player.persistentData.moonlit_mist
    let spells = []
    spells.push('firefly_swarm')
    if (level >= 3) {
        target.potionEffects.add('minecraft:blindness', 140*level, 0)
    }
    if (level >= 5) {
        spells.push('slow')
    }
    newCast(caster, spells, target, level)
}


/**
 * 
 * @param {*} player The player being healed
 * @param {*} caster The entity healing the player
 * @returns 
 * 
 * Valkyries Blood:
 * §aLevel 1: Casts Healing Circle at the player when they are below 20% health
 * §aLevel 2: Increases the power of Healing Circle
 * §aLevel 3: Increases the power of Healing Circle
 * §aLevel 4: Increases the power of Healing Circle
 * §aLevel 5: Casts Blessing of Life at the player

function valkyries_blood (player, caster) {
    let level = player.persistentData.valkyries_blood
    if (player.health > player.maxHealth/5) return
    let spells = []
    if (player.persistentData.valkyries_blood < 5) {
        spells.push('healing_circle')
    } else {
        spells.push('healing_circle')
        spells.push('blessing_of_life')
    }
    newCast(caster, spells, player, level)
}



/**
 * 
 * @param {*} player The player being referenced 
 * @param {*} caster The pet casting the spell
 * 
 * Forgotten Divinity: Casts Shockwave at the attacking entity. Shockwave power increases with Skill Level
 * §aLevel 1: Casts Shockwave at the attacking entity
 * §aLevel 2: Casts a max of 10 lightning bolts at all entities within a short range of the player
 * §aLevel 3: Casts a max of 15 lightning bolts at all entities within a moderate range of the player.
 * §aLevel 4: Casts a max of 20 lightning bolts at all entities within a large range of the player.
 * §aLevel 5: Casts a max of 25 lightning bolts at all entities within a insane range of the player.

function forgotten_divinity (player, caster) {
    let level = player.persistentData.forgotten_divinity
    newCast(caster, ['shockwave'], player, level)
    if (level < 2) return
    Utils.server.scheduleInTicks(22, () => {
        let box = AABB.of(player.x+3*level, player.y+1, player.z+3*level, player.x-3*level, player.y-1, player.z-3*level)
        let dim = player.level
        let entitiesWithin = dim.getEntitiesWithin(box)
        let num = 0
        let max = 5*level
        entitiesWithin.forEach(e => {
            if (e != caster) {
                let allycheck = isAlly(player, e)
                if (!allycheck) {
                    if (num >= max) return
                    num++
                    Utils.server.scheduleInTicks(5*num, () => {
                        newCast(caster, ['lightning_bolt'], e, level)
                    })
                }
            }
        })
    })
}

/**
 * 
 * @param {*} player The player being referenced
 * @param {*} caster The pet casting the spell
 * @param {*} target The target of the attack
 * @returns 
 * 
 * Beckoning Shadows - Casts Blood Step at the attacking entity. Blood Step power increases with Skill Level
 * §aLevel 1: Casts Blood Step at the attacking entity
 * §aLevel 2: Gives the enemy the Blindness effect
 * §aLevel 3: Increases the duration of the Blindness effect
 * §aLevel 4: Gives your pet the Charged Effect
 * §aLevel 5: Your pet casts Vortex Punch at the attacking entity

function beckoning_shadows (player, caster, target) {
    let level = player.persistentData.beckoning_shadows
    let spells = []
    spells.push('blood_step')
    if (level >= 2) {
        target.potionEffects.add('minecraft:blindness', 60*level, 0)
    }
    if (level >= 4) {
        caster.potionEffects.add('minecraft:strength', 60*level, level-4)
    }
    if (level >= 5) {
        spells.push('vortex_punch')
    }
    newCast(caster, spells, target, level)
}



function savior (player, caster, target) {
    let level = player.persistentData.savior
    let dim = player.level.dimension
    //let chance = Math.random()
    //if (chance > 0.1) return
    //newCast(player, ['portal'], caster, level)
    Utils.server.scheduleInTicks(10, () => {
        let x = caster.x
        let y = caster.y
        let z = caster.z
        let yaw = caster.yaw
        //caster.teleportTo(dim, x, y, z, yaw, -90)
        Utils.server.runCommandSilent(`/execute in ${dim} run cast ${caster.uuid} portal`)
    })
}



 * 
 * EntityEvents.death('player', event => {
    if (event.source.actual == null) return
    if (event.source.actual.tags.contains('boss')) return
    let p = event.entity
    let username = p.username
    let player = event.server.getPlayer(username)
    if (!player.persistentData.get('annihilation')) return
    let box = AABB.of(player.x+20, player.y+3, player.z+20, player.x-20, player.y-2, player.z-20)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent.tags.contains('tamed_beast')) {
            let owner_username = ent.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
            if (owner_username != player.username) return
            if (player.persistentData.annihilation == 1) {
                let spells = {
                    1: {
                        spell: 'root',
                        cast_time: 40
                    },
                    2: {
                        spell: 'traveloptics:annihilation',
                        cast_time: 100
                    }
                }
                castMultipleDifferent(ent, spells, event.source.actual, player.persistentData.annihilation)
            } 
        }
    })
})
 * 
 * 




 * 
 * 
 */











