function createParticleTrail(entity, particle, duration) {
    if (!entity || !entity.level) return
    if (!entity.uuid) return

    let dim = entity.level.dimension
    if (!dim) return

    // use a tag to ensure the trail only runs once per entity
    let trailTag = 'particle_trail_active'
    if (entity.tags && entity.tags.contains(trailTag)) return
    if (entity.tags) entity.tags.add(trailTag)

    let lastX = entity.x
    let lastY = entity.y
    let lastZ = entity.z

    let interval = 2
    let maxTicks = Math.max(1, duration)
    let elapsed = 0

    Utils.server.scheduleRepeatingInTicks(interval, task => {
        elapsed += interval
        if (!entity || !entity.alive) {
            task.repeating = false
            if (entity && entity.tags) entity.tags.remove(trailTag)
            return
        }

        // check movement
        let dx = entity.x - lastX
        let dy = entity.y - lastY
        let dz = entity.z - lastZ
        let moved = (dx * dx + dy * dy + dz * dz) > 0.0001

        if (!moved || elapsed >= maxTicks) {
            task.repeating = false
            if (entity.tags) entity.tags.remove(trailTag)
            return
        }

        lastX = entity.x
        lastY = entity.y
        lastZ = entity.z

        Utils.server.runCommandSilent(`/execute in ${dim} run particle ${particle} ${entity.x} ${entity.y + 0.1} ${entity.z} 0 0 0 0 1 force`)
    })
}

