function createParticleRing(location, particle, radius, duration) {
    if (!location) return
    let dim = location.level ? location.level.dimension : location.dimension
    if (!dim) return

    let cx = Number(location.x) + 0.5
    let cy = Number(location.y)
    let cz = Number(location.z) + 0.5
    let r = Number(radius)
    if (!isFinite(r) || r <= 0) return

    let points = Math.max(12, Math.floor(r * 10))
    let angleStep = (Math.PI * 2) / points

    let interval = 5
    let repeats = Math.max(1, Math.floor(duration / interval))
    let runCount = 0

    Utils.server.scheduleRepeatingInTicks(interval, task => {
        if (runCount++ >= repeats) { task.repeating = false; return }
        for (let i = 0; i < points; i++) {
            let angle = angleStep * i
            let px = Math.round((cx + Math.cos(angle) * r) * 100) / 100
            let pz = Math.round((cz + Math.sin(angle) * r) * 100) / 100
            Utils.server.scheduleInTicks(i, () => {
                Utils.server.runCommandSilent(`/execute in ${dim} run particle ${particle} ${px} ${cy} ${pz} 0 0 0 0 1 force`)
            })
        }
    })
}