

function fixItem(player, item) {
    if (!item || item.empty) return false

    item.nbt = item.nbt || {}

    let damage = 0
    try {
        damage = item.nbt.Damage != null ? Number(item.nbt.Damage) : 0
    } catch (e) {
        damage = 0
    }

    let broken = 0
    try {
        broken = item.nbt.isBroken != null ? Number(item.nbt.isBroken) : 0
    } catch (e2) {
        broken = 0
    }

    if ((damage == null || damage <= 0) && (broken == null || broken <= 0)) return false

    if (typeof item.nbt.merge === 'function') {
        item.nbt.merge({
            Damage: 0,
            isBroken: 0
        })
    } else {
        item.nbt.Damage = 0
        item.nbt.isBroken = 0
    }
    player.tell(Text.of([
        Text.of('§aItem repaired')
    ]))
    return true
}
