/**
 * 
 *       if (modifyItem(player, hoveredItem, mouseItem)) {
        player.level.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:spark 0.05 0.5 1 ${player.x} ${player.y+1.5} ${player.z} 0.5 0.5 0.5 0.25 150 force ${player.username}`)
        player.level.runCommandSilent(`/execute in ${player.level.dimension} run playsound irons_spellbooks:spell.divine_smite.windup ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1`)
        mouseItem.count -= 1
      } else {
          if (['kubejs:orb_of_corruption','kubejs:orb_of_repentance'].includes(mouseItem.id)) {
            let dim = player.level.dimension
            player.level.runCommandSilent(`/execute in ${player.level.dimension} run particle fathomless:crimson_aura ${player.x} ${player.y+1} ${player.z} 0.3 0.5 0.3 1 100 force ${player.username}`)
            player.level.runCommandSilent(`/execute in ${dim} run playsound minecraft:entity.wither.spawn ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
        }
      }
 * 
 * 
 */

const rarityCapsAndLevels = {
  'apotheosis:common': {
    maxAffixes: 1,
    maxAffixValue: 0.10,
    maxSpells: 1,
  },
  'apotheosis:uncommon': {
    maxAffixes: 2,
    maxAffixValue: 0.30,
    maxSpells: 1,
  },
  'apotheosis:rare': {
    maxAffixes: 3,
    maxAffixValue: 0.50,
    maxSpells: 1,
  },
  'apotheosis:epic': {
    maxAffixes: 4,
    maxAffixValue: 0.70,
    maxSpells: 1,
  },
  'apotheosis:mythic': {
    maxAffixes: 5,
    maxAffixValue: 0.90,
    maxSpells: 2,
  },
  'apotheosis:ancient': {
    maxAffixes: 6,
    maxAffixValue: 1.00,
    maxSpells: 3,
  },
}


//__________________________________________________________________________________________________________________________________________________________________________

global.allOrbs = {
  totem: [
    'kubejs:orb_of_knowledge',
    'kubejs:orb_of_revelation',
    'kubejs:orb_of_divinity',
    'kubejs:orb_of_discovery',
    'kubejs:orb_of_rebirth',
    'kubejs:orb_of_fate',
    'kubejs:orb_of_entropy',
    'kubejs:orb_of_corruption',
    'kubejs:orb_of_repentance'
  ],
  affix: [
    'kubejs:orb_of_infusion',
    'kubejs:orb_of_reforging',
    'kubejs:orb_of_exaltation',
    'kubejs:orb_of_sorcery',
    'kubejs:orb_of_ascension',
    'kubejs:orb_of_imbuement',
    'kubejs:orb_of_socketing',
    'kubejs:orb_of_fracturing',
    'kubejs:orb_of_dissonance',
    'kubejs:orb_of_binding',
    'kubejs:orb_of_corruption',
    'kubejs:orb_of_severing',
    'kubejs:orb_of_repentance'
  ],
}





// One place to add/edit orb behavior
global.orbHandlers = {
  // ---------- AFFIX ORBS ----------
  'kubejs:orb_of_infusion':   { affix: (player, item) => applyRandomAffix(player, item) },
  'kubejs:orb_of_reforging':  { affix: (player, item) => swapRandomAffixes(player, item) },
  'kubejs:orb_of_exaltation': { affix: (player, item) => upgradeItemRarity(player, item) },
  'kubejs:orb_of_sorcery':    { affix: (player, item) => upgradeImbuedSpell(player, item) },
  'kubejs:orb_of_ascension':  { affix: (player, item) => upgradeRandomAffix(player, item) },
  'kubejs:orb_of_imbuement':  { affix: (player, item) => imbueItem(player, item) },
  'kubejs:orb_of_socketing':  { affix: (player, item) => modifySockets(player, item, 1, false) },
  'kubejs:orb_of_fracturing': { affix: (player, item) => lockAffix(player, item) },
  'kubejs:orb_of_dissonance': { affix: (player, item) => swapSpell(player, item) },
  'kubejs:orb_of_binding':    { affix: (player, item) => lockImbuedSpell(player, item) },
  'kubejs:orb_of_severing':   { affix: (player, item) => removeRandomSpell(player, item) },

  // ---------- MISC ORBS ----------
  'kubejs:orb_of_renewal': { misc: (player, item) => fixItem(player, item) },

  // Shared IDs but different behavior by target type:
  'kubejs:orb_of_corruption': {
    affix: function (player, item) { return useCorruptionOrb(player, item) },
    totem: function (player, totemItem) { return corruptTotem(player, totemItem) },

  },
  'kubejs:orb_of_repentance': {
    affix: function (player, item) { return cleanseCorruption(player, item) },
    totem: function (player, totemItem) { return cleanseCorruption(player, totemItem) },
  },

  // ---------- TOTEM ORBS ----------
  'kubejs:orb_of_knowledge':  { totem: (player, totemItem, orbId, itemSlot) => upgradeTotemRarity(player, totemItem, orbId, itemSlot) },
  'kubejs:orb_of_revelation': { totem: (player, totemItem, orbId, itemSlot) => upgradeTotemRarity(player, totemItem, orbId, itemSlot) },
  'kubejs:orb_of_divinity':   { totem: (player, totemItem, orbId, itemSlot) => upgradeTotemRarity(player, totemItem, orbId, itemSlot) },

  'kubejs:orb_of_discovery': { totem: (player, totemItem) => infuseSkillTotem(player, totemItem, 'random', false) },
  'kubejs:orb_of_rebirth':   { totem: (player, totemItem) => removeAllTotemSkills(player, totemItem) },
  'kubejs:orb_of_fate':      { totem: (player, totemItem) => lockTotemSkill(player, totemItem) },
  'kubejs:orb_of_entropy':   { totem: (player, totemItem) => swapTotemSkill(player, totemItem) },


}

/**
 * 
 * @param {*} modificationType Either 'affix' or 'totem'
 * @param {*} orbId 
 * @returns 
 */
function isValidOrbFor(modificationType, orbId) {
  if (!global.orbHandlers) return false
  let entry = global.orbHandlers[orbId]
  if (!entry) return false
  return !!entry[modificationType] // has an affix/totem handler
}



function runOrb(orbId, orbType, itemSlot, player) {
  let targetItem = player.inventory.getItem(itemSlot)
  if (global.canOrbModifyItem && !global.canOrbModifyItem(player, targetItem, orbId)) return false
  let entry = global.orbHandlers[orbId]
  if (!entry) return false

  let fn = entry[orbType]
  if (!fn) return false
  // Pass a small context object for things like slotIndex, orbId, etc.
  return fn(player, targetItem, orbId, itemSlot)
}


NetworkEvents.dataReceived('kubejs:modify_item', event => {
    let player = event.player
    let data = event.data
    let orbId = data.mouseItem.id
    if (!orbId) return
    if (runOrb(orbId, data.orbType, data.itemSlot, player)) {
      player.mouseItem.count -= 1
      Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:spark 1 1 0.1 ${player.x} ${player.y+1.5} ${player.z} 0.5 0.5 0.5 0.25 150 force ${player.username}`)
      Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound irons_spellbooks:spell.divine_smite.windup ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.1`)
    }

})





