/**
 * Modified chance: (probability, increment, power_level)
 *  
 * 
 * - PROBABILITY: What I want the chance to be: Use an INTEGER. So for 25%, use 25
 * - INCREMENT: How much the chance increases per power level: Use an INTEGER. So for 10%, use 10
 * 
 * - If nightmare mode is activated, the chance is multiplied by 3
 * 
 * - If the chance is greater than the probability, return true
 * - Otherwise, return false
 * 
 * 
 */
function modifiedChance(probability, increment, power_level) {
    
   // Utils.server.tell(`______________________________`)
    
    // Convert the variables:
    probability = probability/100

    increment = increment/100
        /**
     * Probability Floor: 
     * - 1 - probability because the probability is the chance of the event happening. 
     * - So if the probability is 25%, you need to do 100 - 25 = 75.
     * - Since you need to be higher than 75 it means that the probability is 25%
     * 
     *  */ 
    let probability_floor = 1 - probability
    let chance = Math.random()
   // Utils.server.tell(`Modified Probability: ${probability}`)
    // Chance is increased by the increment * power level
    chance = chance + (increment * parseInt(power_level))
    
        // If the chance is greater than the probability floor, return true
    if (chance > probability_floor) {
       // Utils.server.tell(`Chance: True`)
        return true
    } else {
        //Utils.server.tell(`Chance: False`)
        return false
    }
}


/**
 *  Power Level Probability: (base, increment, power_level)
 *  - Get the probability of an event happening based on the power level and return the value
 * 
 */
function power_level_probability(base, increment, power_level) {
    let probability = Number(base + (increment * Number(power_level)))
    return probability
}