/**
 * 
 * @param {*} entity Entity to make into a mage
 * @param {*} schools MUST BE AN ARRAY: Gives the mage its schools of magic
 * @param {*} mageLevel Level of Mage. 'base', 'superior', 'exalted' 
 */
function applySpellcasting(entity, schools, mageLevel, hideParticles) {
    if (entity == null) return
    if (!hideParticles) hideParticles = false
    schools.forEach(school => {
        applySchool(entity, school, hideParticles);
    });
    if (mageLevel == 'base') return
    if (mageLevel == 'superior') {
        superiorMage(entity);
    } else if (mageLevel == 'exalted') {
        exaltedMage(entity);
    }
}



/**
 * 
 * @param {*} event Event
 * @param {*} spawnCoords Coordinates to spawn the entity at. Must be an object with x, y, z properties 
 * @param {*} entityID ID of the entity to spawn. example: 'minecraft:zombie'
 * @param {*} schools Array of schools to apply to the mage. Example: ['fire', 'holy']
 * @param {*} mageLevel Level of the mage. Can be 'base', 'superior', or 'exalted' 
 * @returns 
 */

function createSpellcastingMob(event, spawnCoords, entityID, schools, mageLevel) {
    let level = event.level;
    let entity = level.createEntity(entityID)
    entity.setPos(spawnCoords.x, spawnCoords.y, spawnCoords.z);
    entity.spawn()
    applySpellcasting(entity, schools, mageLevel);
    return entity;
}